/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui;

import com.archivas.clienttools.arcmover.gui.CopyJobDialog;
import com.archivas.clienttools.arcmover.gui.DeleteJobDialog;
import com.archivas.clienttools.arcmover.gui.ExportResultsDialog;
import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcmover.gui.JobAlreadyOpenException;
import com.archivas.clienttools.arcmover.gui.MetadataJobDialog;
import com.archivas.clienttools.arcmover.gui.panels.FixedHeightPanel;
import com.archivas.clienttools.arcmover.gui.panels.InitialImportFilePanel;
import com.archivas.clienttools.arcmover.gui.panels.InitialSelectedItemsPanel;
import com.archivas.clienttools.arcmover.gui.panels.ItemsPanel;
import com.archivas.clienttools.arcmover.gui.panels.JobProgressPanel;
import com.archivas.clienttools.arcmover.gui.panels.LoadSchedulePanel;
import com.archivas.clienttools.arcmover.gui.util.BoldFontLabel;
import com.archivas.clienttools.arcmover.gui.util.DialogDimensionProperties;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthButton;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthGroup;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcmover.gui.util.PlainFontLabel;
import com.archivas.clienttools.arcmover.gui.util.SelfDestructiveDialog;
import com.archivas.clienttools.arcutils.api.ArcMoverEngine;
import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.JobNotFoundException;
import com.archivas.clienttools.arcutils.api.JobStatus;
import com.archivas.clienttools.arcutils.api.ManagedJobStats;
import com.archivas.clienttools.arcutils.api.jobs.CopyJob;
import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.api.jobs.SetMetadataJob;
import com.archivas.clienttools.arcutils.impl.adapter.ConnectionTestException;
import com.archivas.clienttools.arcutils.impl.jobs.CopyJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.DeleteJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.SetMetadataJobImpl;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.Hcp3AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;

public abstract class JobDialog
extends JFrame {
    public static final String CLASS_FULL_NAME = JobDialog.class.getName();
    public static final Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private static ArcMoverEngine engine = ArcMoverFactory.getInstance();
    private DialogDimensionProperties dialogProperties = new DialogDimensionProperties(CLASS_FULL_NAME, 750, 765);
    private static final String RERUN_TEXT = "Rerun";
    private static final String RUN_TEXT = "Run";
    private static final String PAUSE_TEXT = "Pause";
    private static final String RESUME_TEXT = "Resume";
    private static final String SAVE_TEXT = "Save";
    private static final String CANCEL_TEXT = "Cancel";
    private static final String CLOSE_TEXT = "Close";
    private static final String PROGRESS_TAB_TITLE = "Progress";
    private static final String ITEMS_TAB_TITLE = "Items";
    public static final String LOAD_SCHEDULE_TAB_TITLE = "Load Schedule";
    public static final String LOGGING_SETTINGS_TAB_TITLE = "Logging Settings";
    private static int MAX_TAB_HEIGHT = 65535;
    private static final Dimension TAB_SIZE = new Dimension(Integer.MAX_VALUE, MAX_TAB_HEIGHT);
    private static final Dimension MIN_SIZE = new Dimension(680, 655);
    private static JobDialog openJob = null;
    private static Font fileFont;
    private JLabel sourceProfileValue = new PlainFontLabel("");
    private JLabel destProfileValue = new PlainFontLabel("");
    private JLabel sourcePathValue = new PlainFontLabel("");
    private JLabel destPathValue = new PlainFontLabel("");
    private JPanel statePanel;
    private JLabel stateValue = new JLabel("");
    private JLabel errorLabel = new BoldFontLabel("Error:");
    private JLabel errorValue = new JLabel("");
    private JTabbedPane tabbedPane;
    private JobProgressPanel progressPanel;
    private ItemsPanel itemsPanel;
    private LoadSchedulePanel loadSchedulePanel;
    private JButton exportButton = new FixedWidthButton("Export Results", 150);
    private JButton saveButton = new FixedWidthButton("Save", 100);
    private JButton runPauseResumeButton = new FixedWidthButton("Run", 100);
    private JButton cancelButton = new FixedWidthButton("Cancel", 100);
    private ManagedJob job;
    private ManagedJobImpl jobImpl;
    private JobId jobId;
    private String userDefinedJobName;
    private volatile ProgressTracker progressTrackerThread;
    private boolean progressErrorDisplayed = false;
    private boolean fieldChanged = false;
    private boolean isTransitionInProgress;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void openExistingJob(JobId jobId, ManagedJob.Type type) throws JobException {
        if (jobId == null) {
            throw new IllegalArgumentException("Null jobId");
        }
        if (openJob != null) {
            if (jobId.equals(JobDialog.openJob.jobId)) return;
            throw new JobAlreadyOpenException();
        }
        try {
            ManagedJobImpl jobImpl = engine.loadManagedJob(jobId, type);
            if (jobImpl == null) {
                throw new JobException("Job not found");
            }
            switch (jobImpl.getJob().getJobType()) {
                case COPY: {
                    openJob = new CopyJobDialog((CopyJobImpl)jobImpl);
                    return;
                }
                case DELETE: {
                    openJob = new DeleteJobDialog((DeleteJobImpl)jobImpl);
                    return;
                }
                case SET_METADATA: {
                    openJob = new MetadataJobDialog((SetMetadataJobImpl)jobImpl);
                    return;
                }
                default: {
                    throw new JobException("Unsupported Job type");
                }
            }
        }
        catch (JobException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JobException(e.getMessage(), (Throwable)e);
        }
        finally {
            HCPDataMigrator.getInstance().updateLockable();
            JobDialog.showJob();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void openNewJob(ManagedJob job) throws JobException {
        if (openJob != null) {
            throw new JobAlreadyOpenException();
        }
        try {
            switch (job.getJobType()) {
                case COPY: {
                    openJob = new CopyJobDialog((CopyJob)job);
                    return;
                }
                case DELETE: {
                    openJob = new DeleteJobDialog((DeleteJob)job);
                    return;
                }
                case SET_METADATA: {
                    openJob = new MetadataJobDialog((SetMetadataJob)job);
                    return;
                }
                default: {
                    throw new JobException("Unsupported Job type");
                }
            }
        }
        catch (JobException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JobException(e.getMessage(), (Throwable)e);
        }
        finally {
            HCPDataMigrator.getInstance().updateLockable();
            JobDialog.showJob();
        }
    }

    public static synchronized void setFileFont(Font font) {
        fileFont = font;
        if (openJob != null) {
            openJob.setFontForFiles();
        }
    }

    private void setFontForFiles() {
        this.progressPanel.setFileFont(fileFont);
        this.itemsPanel.setFileFont(fileFont);
    }

    protected JobDialog(ManagedJobImpl jobImpl) throws DatabaseException, JobException {
        this.jobImpl = jobImpl;
        this.job = jobImpl.getJob();
        this.jobId = jobImpl.getJobId();
        this.userDefinedJobName = this.job.getUserDefinedJobName();
        this.initDialog(this.job, jobImpl.getStatus());
    }

    protected JobDialog(ManagedJob job) throws DatabaseException, JobException {
        this.job = job;
        this.initDialog(job, JobStatus.NOT_STARTED);
    }

    public void fieldChanged() {
        this.fieldChanged = true;
    }

    private void clearFieldChanged() {
        this.fieldChanged = false;
    }

    private void initDialog(ManagedJob managedJob, JobStatus status) throws DatabaseException, JobException {
        this.setIconImage(HCPDataMigrator.appImageIcon.getImage());
        this.layoutGuiComponents(managedJob, status);
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.setupListeners();
        this.initializeState(managedJob, status);
        this.setSize(new Dimension(this.dialogProperties.width, this.dialogProperties.height));
        this.setMinimumSize(MIN_SIZE);
        this.setLocationRelativeTo(this.getOwner());
        this.progressPanel.resizeTables();
        this.clearFieldChanged();
        this.setFontForFiles();
    }

    private void layoutGuiComponents(ManagedJob managedJob, JobStatus status) throws DatabaseException, JobException {
        FixedWidthGroup labelGroup = new FixedWidthGroup();
        FixedHeightPanel dataSourcePanel = new FixedHeightPanel();
        dataSourcePanel.setLayout(new BoxLayout(dataSourcePanel, 1));
        dataSourcePanel.add(GUIHelper.createNameValuePairPanel(new BoldFontLabel("Source Profile:       "), (Component)this.sourceProfileValue, labelGroup, true));
        dataSourcePanel.add(Box.createVerticalStrut(5));
        dataSourcePanel.add(GUIHelper.createNameValuePairPanel(new BoldFontLabel("Source Directory:       "), (Component)this.sourcePathValue, labelGroup, true));
        dataSourcePanel.add(Box.createVerticalStrut(12));
        if (this.hasTargetProfile()) {
            dataSourcePanel.add(GUIHelper.createNameValuePairPanel(new BoldFontLabel("Destination Profile:"), (Component)this.destProfileValue, labelGroup, true));
            dataSourcePanel.add(Box.createVerticalStrut(5));
            dataSourcePanel.add(GUIHelper.createNameValuePairPanel(new BoldFontLabel("Destination Directory:"), (Component)this.destPathValue, labelGroup, true));
            dataSourcePanel.add(Box.createVerticalStrut(12));
        }
        this.statePanel = GUIHelper.createNameValuePairPanel(new BoldFontLabel("State:"), (Component)this.stateValue, labelGroup, true);
        this.statePanel.setBackground(Color.WHITE);
        dataSourcePanel.add(this.statePanel);
        dataSourcePanel.add(Box.createVerticalStrut(5));
        dataSourcePanel.add(GUIHelper.createNameValuePairPanel(this.errorLabel, (Component)this.errorValue, labelGroup, true));
        this.errorLabel.setForeground(Color.RED);
        this.errorValue.setForeground(Color.RED);
        this.errorLabel.setVisible(false);
        this.errorValue.setVisible(false);
        this.tabbedPane = new JTabbedPane();
        this.initTabs(this.tabbedPane, managedJob, status);
        this.tabbedPane.setPreferredSize(TAB_SIZE);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.exportButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.saveButton);
        buttonPanel.add(Box.createHorizontalStrut(12));
        buttonPanel.add(this.runPauseResumeButton);
        buttonPanel.add(Box.createHorizontalStrut(12));
        buttonPanel.add(this.cancelButton);
        JPanel p = new JPanel();
        p.setBorder(new EmptyBorder(25, 25, 25, 25));
        p.setLayout(new BoxLayout(p, 1));
        p.add(dataSourcePanel);
        p.add(Box.createVerticalStrut(25));
        p.add(this.tabbedPane);
        p.add(Box.createVerticalStrut(25));
        p.add(buttonPanel);
        this.getContentPane().add(p);
    }

    private void initTabs(JTabbedPane tabbedPane, ManagedJob managedJob, JobStatus status) throws DatabaseException, JobException {
        this.progressPanel = new JobProgressPanel(status, managedJob.getJobType());
        tabbedPane.addTab(PROGRESS_TAB_TITLE, this.progressPanel);
        File listFile = managedJob.getListFile();
        if (listFile == null) {
            this.itemsPanel = new InitialSelectedItemsPanel(managedJob);
            tabbedPane.addTab(ITEMS_TAB_TITLE, this.itemsPanel);
        } else {
            this.itemsPanel = new InitialImportFilePanel(managedJob);
            tabbedPane.addTab(ITEMS_TAB_TITLE, this.itemsPanel);
        }
        this.addJobSpecificTabs(tabbedPane, managedJob);
        this.loadSchedulePanel = new LoadSchedulePanel(this, managedJob.getLoadSchedule(), false);
        tabbedPane.add(LOAD_SCHEDULE_TAB_TITLE, this.loadSchedulePanel);
    }

    private void setupListeners() {
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JobDialog.this.setCursor(HCPDataMigrator.waitCursor);
                    JobDialog.this.onSave();
                }
                finally {
                    JobDialog.this.setCursor(null);
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JobDialog.this.setCursor(HCPDataMigrator.waitCursor);
                    JobDialog.this.onCancel();
                }
                finally {
                    JobDialog.this.setCursor(null);
                }
            }
        });
        this.runPauseResumeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JobDialog.this.setCursor(HCPDataMigrator.waitCursor);
                    JobDialog.this.onRunPauseResume();
                }
                finally {
                    JobDialog.this.setCursor(null);
                }
            }
        });
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JobDialog.this.setCursor(HCPDataMigrator.waitCursor);
                    ExportResultsDialog d = new ExportResultsDialog(JobDialog.this.jobImpl);
                    d.setLocationRelativeTo(JobDialog.this);
                    d.setVisible(true);
                }
                finally {
                    JobDialog.this.setCursor(null);
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JobDialog.showJob();
                try {
                    JobDialog.this.setCursor(HCPDataMigrator.waitCursor);
                    JobDialog.this.onCancel();
                }
                finally {
                    JobDialog.this.setCursor(null);
                }
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                JobDialog.this.toFront();
                JobDialog.this.requestFocus();
            }
        });
    }

    private void setTitle() {
        if (this.userDefinedJobName != null) {
            this.setTitle(this.getTitlePrefix() + " Job " + this.userDefinedJobName + " Details");
        } else {
            this.setTitle(this.getTitlePrefix() + " Job Details");
        }
    }

    private void initializeState(ManagedJob managedJob, JobStatus status) {
        this.setTitle();
        AbstractProfileBase sourceProfile = managedJob.getSourceProfile();
        this.sourceProfileValue.setText(sourceProfile.getName());
        this.sourceProfileValue.setToolTipText(sourceProfile.getName());
        String sourcePath = sourceProfile.decode(managedJob.getSourcePath());
        this.sourcePathValue.setText(sourcePath);
        this.sourcePathValue.setToolTipText(sourcePath);
        AbstractProfileBase destProfile = managedJob.getTargetProfile();
        if (destProfile != null) {
            this.destProfileValue.setText(destProfile.getName());
            this.destProfileValue.setToolTipText(destProfile.getName());
            String destPath = destProfile.decode(managedJob.getTargetPath());
            this.destPathValue.setText(destPath);
            this.destPathValue.setToolTipText(destPath);
        }
        if (this.loadSchedulePanel != null) {
            this.loadSchedulePanel.setLoadSchedule(managedJob.getLoadSchedule());
        }
        ManagedJobImpl.JobDetails details = null;
        try {
            if (this.jobImpl != null) {
                details = engine.getManagedJobDetails(this.jobImpl, true);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "An error occurred getting job stats and details for job " + managedJob.getJobName(), e);
        }
        this.updateState(status, details);
        if (status.hasNeverBeenRun()) {
            this.tabbedPane.setSelectedComponent(this.itemsPanel);
        } else {
            this.tabbedPane.setSelectedComponent(this.progressPanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackJobProgress() {
        JobDialog jobDialog = this;
        synchronized (jobDialog) {
            if (this.progressTrackerThread == null) {
                this.progressTrackerThread = new ProgressTracker();
                this.progressTrackerThread.start();
            }
        }
    }

    private void setStateTransitionInProgress(boolean inProgress) {
        assert (SwingUtilities.isEventDispatchThread());
        this.isTransitionInProgress = inProgress;
    }

    private boolean isStateTransitionInProgress() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.isTransitionInProgress;
    }

    private void onCancel() {
        final JobStatus jobStatus = this.getJobStatus();
        boolean stopCurrentRun = false;
        boolean removeJob = false;
        boolean saveExistingJob = false;
        boolean closeDialog = false;
        boolean areErrors = false;
        try {
            areErrors = this.areErrors(jobStatus);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.userDefinedJobName == null) {
            if (jobStatus.hasNeverBeenRun() || !areErrors && (jobStatus.isRunning() || jobStatus.isPaused())) {
                int response = JOptionPane.showConfirmDialog(this, "Are you sure you want to permanently cancel this job?", "Cancel Job", 0, 2);
                if (response == 0) {
                    if (jobStatus.hasNeverBeenRun()) {
                        closeDialog = true;
                    } else {
                        stopCurrentRun = true;
                        removeJob = true;
                        closeDialog = true;
                    }
                }
            } else if (jobStatus.isRunning() || jobStatus.isPaused()) {
                int response = JOptionPane.showConfirmDialog(this, "You are about to permanently cancel this job.  Errors occurred while running the job.  \nWould you like to save the job information?", "Cancel Job", 1, 2);
                switch (response) {
                    case 0: {
                        if (!this.nameJob()) break;
                        if (this.fieldChanged) {
                            saveExistingJob = true;
                        }
                        stopCurrentRun = true;
                        closeDialog = true;
                        break;
                    }
                    case 1: {
                        stopCurrentRun = true;
                        removeJob = true;
                        closeDialog = true;
                        break;
                    }
                }
            } else if (areErrors) {
                int response = JOptionPane.showConfirmDialog(this, "Errors occurred while running the job.  Would you like to save the job information?", "Close Job", 1, 2);
                switch (response) {
                    case 0: {
                        if (!this.nameJob()) break;
                        if (this.fieldChanged) {
                            saveExistingJob = true;
                        }
                        closeDialog = true;
                        break;
                    }
                    case 1: {
                        removeJob = true;
                        closeDialog = true;
                        break;
                    }
                }
            } else {
                removeJob = true;
                closeDialog = true;
            }
        } else if (jobStatus.hasNeverBeenRun() || jobStatus.isPaused() || jobStatus.isFinished() && areErrors) {
            if (this.fieldChanged) {
                int response = JOptionPane.showConfirmDialog(this, "Would you like to save changes to the job?", "Close Job", 1, 3);
                switch (response) {
                    case 0: {
                        saveExistingJob = true;
                        closeDialog = true;
                        break;
                    }
                    case 1: {
                        closeDialog = true;
                        break;
                    }
                }
            } else {
                closeDialog = true;
            }
        } else if (jobStatus.isRunning()) {
            int response = JOptionPane.showConfirmDialog(this, "Are you sure you want to cancel the job?", "Cancel Job", 0, 2);
            if (response == 0) {
                stopCurrentRun = true;
                closeDialog = true;
            }
        } else {
            closeDialog = true;
        }
        if (stopCurrentRun || removeJob || saveExistingJob) {
            final boolean fStopCurrentRun = stopCurrentRun;
            final boolean fRemoveJob = removeJob;
            final boolean fSaveExistingJob = saveExistingJob;
            final boolean fCloseDialog = closeDialog;
            this.disableComponents();
            final Component glassPane = this.getGlassPane();
            glassPane.setCursor(HCPDataMigrator.waitCursor);
            glassPane.setVisible(true);
            this.setStateTransitionInProgress(true);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                public Object doInBackground() {
                    if (fStopCurrentRun) {
                        JobDialog.this.stopCurrentRun(jobStatus);
                    }
                    if (fRemoveJob) {
                        JobDialog.this.removeJob();
                    } else if (fSaveExistingJob) {
                        if (jobStatus.hasNeverBeenRun()) {
                            JobDialog.this.saveExistingJob();
                        } else {
                            JobDialog.this.saveLoadSchedule();
                        }
                    }
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        JobDialog.this.setStateTransitionInProgress(false);
                        glassPane.setCursor(null);
                        glassPane.setVisible(false);
                        if (fCloseDialog) {
                            JobDialog.this.closeDialog();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            worker.execute();
        } else if (closeDialog) {
            this.closeDialog();
        }
    }

    private void stopCurrentRun(JobStatus jobStatus) {
        if (jobStatus.isRunning()) {
            try {
                engine.stopManagedJob(this.jobImpl);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "An error occurred cancelling job " + this.jobImpl.getJob().getJobName() + ": " + ex.toString(), ex);
            }
        }
    }

    private void removeJob() {
        if (this.jobId != null) {
            try {
                engine.removeManagedJob(this.jobId, this.job.getJobType());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "An error occurred removing job " + this.jobImpl.getJob().getJobName() + ": " + e.getMessage(), e);
            }
            finally {
                this.jobId = null;
                this.jobImpl = null;
            }
        }
    }

    private void saveNewJob() {
        try {
            String name = this.promptForJobName();
            if (name != null) {
                this.updateJobSpec(name);
                this.job.setUserDefinedJobName(name);
                this.jobImpl = engine.createManagedJob(this.job);
                this.clearFieldChanged();
                this.jobId = this.jobImpl.getJobId();
                this.job = this.jobImpl.getJob();
                this.userDefinedJobName = this.job.getUserDefinedJobName();
                this.setTitle();
            }
        }
        catch (Exception e) {
            String msg = "An error occurred saving job: " + e.getMessage();
            LOG.log(Level.SEVERE, msg, e);
            this.displayError(msg, "Error Saving Job");
        }
    }

    private boolean nameJob() {
        String name = this.promptForJobName();
        if (name == null) {
            return false;
        }
        try {
            this.job.setUserDefinedJobName(name);
            engine.modifyManagedJobName(this.jobId, name);
            this.userDefinedJobName = this.job.getUserDefinedJobName();
            this.setTitle();
        }
        catch (Exception e) {
            String msg = "An error occurred saving the job: " + e.getMessage();
            LOG.log(Level.SEVERE, msg, e);
            this.displayError(msg, "Error Saving Job");
        }
        return true;
    }

    private boolean saveLoadSchedule() {
        try {
            LoadSchedule loadSchedule = this.loadSchedulePanel.getLoadSchedule();
            this.job.setLoadSchedule(loadSchedule);
            engine.modifyManagedJobLoadSchedule(this.jobId, loadSchedule);
            this.clearFieldChanged();
            return true;
        }
        catch (Exception e) {
            String msg = "An error occurred saving the load schedule:\n" + e.toString();
            LOG.log(Level.SEVERE, msg, e);
            this.displayError(msg, "Error Saving Job");
            return false;
        }
    }

    private String promptForJobName() {
        return JOptionPane.showInputDialog(this, "Save Job with Name", "Save Job", -1);
    }

    private void saveExistingJob() {
        try {
            this.updateJobSpec(this.userDefinedJobName);
            engine.modifyManagedJob(this.jobId, this.job);
            this.clearFieldChanged();
        }
        catch (Exception e) {
            String msg = "An error occurred saving the job: " + e.toString();
            LOG.log(Level.SEVERE, msg, e);
            this.displayError(msg, "Error Saving Job");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDialog() {
        Dimension dimension = this.getSize();
        this.dialogProperties.width = dimension.width;
        this.dialogProperties.height = dimension.height;
        this.dialogProperties.persist();
        Object object = this;
        synchronized (object) {
            this.progressTrackerThread = null;
        }
        object = JobDialog.class;
        synchronized (JobDialog.class) {
            if (openJob == this) {
                openJob = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HCPDataMigrator.showMigratorInstance();
                }
            });
            AbstractProfileBase profile = this.job.getTargetProfile() != null ? this.job.getTargetProfile() : this.job.getSourceProfile();
            HCPDataMigrator.getInstance().refreshProfilePanel(profile);
            this.dispose();
            return;
        }
    }

    private boolean areErrors(JobStatus jobStatus) throws JobException {
        boolean ret = false;
        if (!jobStatus.hasNeverBeenRun() && this.jobImpl != null) {
            ManagedJobStats jobStats = engine.getManagedJobStats(this.jobImpl);
            ret = jobStats.areErrors();
        }
        return ret;
    }

    private void onSave() {
        try {
            this.setCursor(HCPDataMigrator.waitCursor);
            JobStatus jobStatus = this.getJobStatus();
            if (jobStatus.hasNeverBeenRun()) {
                if (this.userDefinedJobName == null) {
                    this.saveNewJob();
                } else {
                    this.saveExistingJob();
                }
            } else if (this.userDefinedJobName == null) {
                if (this.nameJob()) {
                    this.saveLoadSchedule();
                }
            } else {
                this.saveLoadSchedule();
            }
            this.updateState(this.getJobStatus(), this.getJobDetails(true));
        }
        finally {
            this.setCursor(null);
        }
    }

    private void onRunPauseResume() {
        this.disableComponents();
        final Component glassPane = this.getGlassPane();
        glassPane.setCursor(HCPDataMigrator.waitCursor);
        glassPane.setVisible(true);
        this.setStateTransitionInProgress(true);
        SwingWorker<Boolean, Object> worker = new SwingWorker<Boolean, Object>(){

            @Override
            public Boolean doInBackground() {
                boolean success = true;
                String buttonText = JobDialog.this.runPauseResumeButton.getText();
                if (JobDialog.RUN_TEXT.equals(buttonText)) {
                    success = JobDialog.this.runNewJob();
                } else if (JobDialog.PAUSE_TEXT.equals(buttonText)) {
                    JobDialog.this.pauseJob();
                } else if (JobDialog.RESUME_TEXT.equals(buttonText) || JobDialog.RERUN_TEXT.equals(buttonText)) {
                    JobDialog.this.resumeJob();
                } else {
                    throw new RuntimeException("Unrecognized operation: " + buttonText);
                }
                return success;
            }

            @Override
            protected void done() {
                try {
                    JobDialog.this.setStateTransitionInProgress(false);
                    JobDialog.this.updateState(JobDialog.this.getJobStatus(), JobDialog.this.getJobDetails(true));
                    if (((Boolean)this.get()).booleanValue()) {
                        JobDialog.this.tabbedPane.setSelectedComponent(JobDialog.this.progressPanel);
                    }
                    glassPane.setCursor(null);
                    glassPane.setVisible(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        worker.execute();
    }

    private void disableComponents() {
        this.exportButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.runPauseResumeButton.setEnabled(false);
        this.progressPanel.disableAll();
        this.cancelButton.setEnabled(false);
    }

    private boolean runNewJob() {
        try {
            int response;
            this.testConnection();
            this.updateJobSpec(this.userDefinedJobName);
            if (this.jobId == null) {
                this.jobImpl = engine.createManagedJob(this.job);
                this.jobId = this.jobImpl.getJobId();
                this.job = this.jobImpl.getJob();
            } else {
                engine.modifyManagedJob(this.jobId, this.job);
            }
            this.clearFieldChanged();
            if (this.job.getJobType() == ManagedJob.Type.COPY && this.job.getSourceProfile().getType().isLesserApiVersion(this.job.getTargetProfile().getType()) && (response = JOptionPane.showConfirmDialog(this, "Copying objects to an earlier release of HCP results in loss of metadata that is not supported by the earlier release. Do you want to continue?", "Continue Job", 0, 2)) != 0) {
                throw new Exception("The job has been canceled by the user.");
            }
            engine.startManagedJob(this.jobImpl);
            this.trackJobProgress();
            return true;
        }
        catch (Exception e) {
            String msg = "An error occurred starting the job: " + e.getMessage();
            this.displayError(msg, "Error Starting Job");
            LOG.log(Level.SEVERE, msg, e);
            return false;
        }
    }

    private void testConnection() throws ConnectionTestException {
        AbstractProfileBase profile = this.job.getSourceProfile();
        if (profile != null && !engine.testConnection(profile)) {
            if (profile.getType().isAuthNamespace()) {
                Hcp3AuthNamespaceProfile authProfile = (Hcp3AuthNamespaceProfile)profile;
                throw new ConnectionTestException(authProfile.getNamespace(), profile.getName());
            }
            throw new ConnectionTestException(null, profile.getName());
        }
        profile = this.job.getTargetProfile();
        if (profile != null && !engine.testConnection(profile)) {
            if (profile.getType().isAuthNamespace()) {
                Hcp3AuthNamespaceProfile authProfile = (Hcp3AuthNamespaceProfile)profile;
                throw new ConnectionTestException(authProfile.getNamespace(), profile.getName());
            }
            throw new ConnectionTestException(null, profile.getName());
        }
    }

    private void pauseJob() {
        try {
            if (this.jobImpl != null) {
                engine.stopManagedJob(this.jobImpl);
            }
        }
        catch (Exception e) {
            String msg = "An error occurred pausing the job: " + e.getMessage();
            this.displayError(msg, "Error Pausing Job");
            LOG.log(Level.SEVERE, msg, e);
        }
    }

    private void resumeJob() {
        try {
            this.jobImpl = engine.loadManagedJob(this.jobImpl.getJobId(), this.jobImpl.getJob().getJobType());
            this.job = this.jobImpl.getJob();
            if (this.saveLoadSchedule()) {
                engine.startManagedJob(this.jobImpl);
                this.trackJobProgress();
            }
        }
        catch (Exception e) {
            String msg = "An error occurred resuming the job: " + e.getMessage();
            this.displayError(msg, "Error Resuming Job");
            LOG.log(Level.SEVERE, msg, e);
        }
    }

    private JobStatus getJobStatus() {
        return this.jobImpl == null ? JobStatus.NOT_STARTED : this.jobImpl.getStatus();
    }

    private ManagedJobImpl.JobDetails getJobDetails(boolean includeLists) {
        ManagedJobImpl.JobDetails jobDetails = null;
        try {
            if (this.jobImpl != null) {
                jobDetails = engine.getManagedJobDetails(this.jobImpl, includeLists);
            }
        }
        catch (JobNotFoundException jobNotFoundException) {
            // empty catch block
        }
        return jobDetails;
    }

    private void updateState(JobStatus jobStatus, ManagedJobImpl.JobDetails jobDetails) {
        this.updateStateValue(jobStatus);
        this.updateErrorValue(jobStatus, jobDetails);
        if (this.userDefinedJobName == null) {
            if (jobStatus.hasNeverBeenRun()) {
                this.exportButton.setEnabled(false);
                this.saveButton.setEnabled(true);
                this.runPauseResumeButton.setEnabled(true);
                this.runPauseResumeButton.setText(RUN_TEXT);
                this.cancelButton.setEnabled(true);
                this.cancelButton.setText(CANCEL_TEXT);
            } else if (jobStatus.isRunning()) {
                this.exportButton.setEnabled(false);
                this.saveButton.setEnabled(false);
                this.runPauseResumeButton.setEnabled(true);
                this.runPauseResumeButton.setText(PAUSE_TEXT);
                this.cancelButton.setEnabled(true);
                this.cancelButton.setText(CANCEL_TEXT);
            } else if (jobStatus.isPaused()) {
                this.exportButton.setEnabled(true);
                this.saveButton.setEnabled(true);
                this.runPauseResumeButton.setEnabled(true);
                this.runPauseResumeButton.setText(RESUME_TEXT);
                this.cancelButton.setEnabled(true);
                this.cancelButton.setText(CANCEL_TEXT);
            } else {
                this.exportButton.setEnabled(true);
                this.saveButton.setEnabled(true);
                this.runPauseResumeButton.setEnabled(!this.jobCompletedWithoutError(jobStatus, jobDetails));
                this.runPauseResumeButton.setText(RERUN_TEXT);
                this.cancelButton.setEnabled(true);
                this.cancelButton.setText(CLOSE_TEXT);
            }
        } else if (jobStatus.hasNeverBeenRun()) {
            this.exportButton.setEnabled(false);
            this.saveButton.setEnabled(true);
            this.runPauseResumeButton.setEnabled(true);
            this.runPauseResumeButton.setText(RUN_TEXT);
            this.cancelButton.setEnabled(true);
            this.cancelButton.setText(CLOSE_TEXT);
        } else if (jobStatus.isRunning()) {
            this.exportButton.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.runPauseResumeButton.setEnabled(true);
            this.runPauseResumeButton.setText(PAUSE_TEXT);
            this.cancelButton.setEnabled(true);
            this.cancelButton.setText(CANCEL_TEXT);
        } else if (jobStatus.isPaused()) {
            this.exportButton.setEnabled(true);
            this.saveButton.setEnabled(true);
            this.runPauseResumeButton.setEnabled(true);
            this.runPauseResumeButton.setText(RESUME_TEXT);
            this.cancelButton.setEnabled(true);
            this.cancelButton.setText(CLOSE_TEXT);
        } else {
            this.exportButton.setEnabled(true);
            this.saveButton.setEnabled(true);
            this.runPauseResumeButton.setText(RERUN_TEXT);
            this.runPauseResumeButton.setEnabled(!this.jobCompletedWithoutError(jobStatus, jobDetails));
            this.cancelButton.setEnabled(true);
            this.cancelButton.setText(CLOSE_TEXT);
        }
        boolean neverRun = jobStatus.hasNeverBeenRun();
        this.updateJobSpecificTabsState(neverRun);
        if (this.progressPanel != null) {
            this.progressPanel.updateProgress(jobDetails);
        }
        this.loadSchedulePanel.enablePanel(neverRun || jobStatus.isPaused() || jobStatus.isFinished() && !this.jobCompletedWithoutError(jobStatus, jobDetails));
    }

    private boolean jobCompletedWithoutError(JobStatus jobStatus, ManagedJobImpl.JobDetails jobDetails) {
        return jobStatus != null && jobStatus == JobStatus.COMPLETED && jobDetails != null && !jobDetails.getJobStats().areErrors();
    }

    private void updateStateValue(JobStatus jobStatus) {
        Color bgColor;
        this.stateValue.setText(jobStatus.toString());
        Color fgColor = Color.BLACK;
        switch (jobStatus) {
            default: {
                bgColor = Color.WHITE;
                break;
            }
            case CANCELLED: 
            case FAILED: {
                bgColor = new Color(178, 34, 34);
                fgColor = Color.WHITE;
                break;
            }
            case COMPLETED: {
                bgColor = new Color(136, 238, 136);
            }
        }
        this.statePanel.setBackground(bgColor);
        this.stateValue.setForeground(fgColor);
    }

    private void updateErrorValue(JobStatus jobStatus, ManagedJobImpl.JobDetails jobDetails) {
        Throwable th = null;
        if (jobDetails != null) {
            th = jobDetails.getJobStats().getJobException();
        }
        if (th != null) {
            boolean wasError;
            String msg = th.getMessage();
            if (msg == null || msg.trim().length() == 0) {
                msg = th.toString();
            }
            String oldErrMsg = (wasError = this.errorValue.isVisible()) ? this.errorValue.getText() : "";
            this.errorLabel.setVisible(true);
            this.errorValue.setText(msg);
            this.errorValue.setToolTipText(msg);
            this.errorValue.setVisible(true);
            if (JobStatus.FAILED == jobStatus && !oldErrMsg.equals(msg)) {
                String errMsg = "A fatal error occurred running the job: " + msg;
                GUIHelper.showMessageDialog(this, errMsg, "Job Failed", 0);
            }
        } else {
            this.errorLabel.setVisible(false);
            this.errorValue.setVisible(false);
        }
    }

    private void updateJobSpec(String userDefinedJobName) throws DatabaseException, JobException {
        this.job.setUserDefinedJobName(userDefinedJobName);
        this.updateJobSpecForSpecificJob();
        if (this.loadSchedulePanel != null) {
            this.job.setLoadSchedule(this.loadSchedulePanel.getLoadSchedule());
        }
    }

    private void displayError(final String errMsg, final String title) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    JobDialog.this.displayErrorEDT(errMsg, title);
                }
            };
            boolean success = GUIHelper.invokeAndWait(runner, "display error message in GUI");
            if (!success) {
                LOG.log(Level.WARNING, errMsg);
            }
        } else {
            this.displayErrorEDT(errMsg, title);
        }
    }

    private void displayErrorEDT(String errMsg, String title) {
        assert (SwingUtilities.isEventDispatchThread());
        GUIHelper.showMessageDialog(this, errMsg, title, 0);
    }

    public static void showJob() {
        if (openJob != null) {
            openJob.setVisible(true);
            if (openJob.getState() == 1) {
                openJob.setState(0);
            }
            openJob.toFront();
            openJob.requestFocus();
            SelfDestructiveDialog.invoke(openJob);
        }
    }

    public static boolean isOpen() {
        return openJob != null;
    }

    protected abstract boolean hasTargetProfile();

    protected abstract void addJobSpecificTabs(JTabbedPane var1, ManagedJob var2) throws DatabaseException, JobException;

    protected abstract void updateJobSpecificTabsState(boolean var1);

    protected abstract void updateJobSpecForSpecificJob() throws DatabaseException, JobException;

    protected abstract String getTitlePrefix();

    private class ProgressTracker
    extends Thread {
        private ProgressTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean inProgress = true;
            boolean forceIncludeLists = true;
            long cnt = 0L;
            while (inProgress) {
                try {
                    ProgressTracker.sleep(1000L);
                    final JobStatus jobStatus = JobDialog.this.getJobStatus();
                    boolean includeLists = forceIncludeLists || jobStatus.isFinished() || cnt++ % 10L == 0L;
                    final ManagedJobImpl.JobDetails jobDetails = JobDialog.this.getJobDetails(includeLists);
                    forceIncludeLists = includeLists && (jobDetails == null || jobDetails.getObjectsCompleted() == null || jobDetails.getObjectsCompleted().size() == 0);
                    Runnable runner = new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    if (!JobDialog.this.isStateTransitionInProgress()) {
                                        JobDialog.this.updateState(jobStatus, jobDetails);
                                    }
                                }
                                catch (Exception e) {
                                    if (JobDialog.this.progressErrorDisplayed) break block3;
                                    String msg = "An error occurred updating progress: " + e.toString();
                                    JobDialog.this.displayError(msg, "Error Updating Progress");
                                    LOG.log(Level.WARNING, msg, e);
                                    JobDialog.this.progressErrorDisplayed = true;
                                }
                            }
                        }
                    };
                    GUIHelper.invokeAndWait(runner, "update progress");
                    JobDialog jobDialog = JobDialog.this;
                    synchronized (jobDialog) {
                        inProgress = !jobStatus.isFinished() && JobDialog.this.progressTrackerThread == this;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            JobDialog jobDialog = JobDialog.this;
            synchronized (jobDialog) {
                if (JobDialog.this.progressTrackerThread == this) {
                    JobDialog.this.progressTrackerThread = null;
                }
            }
        }
    }
}

