/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui;

import com.archivas.clienttools.arcmover.gui.CopyJobDialog;
import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.archivas.clienttools.arcmover.gui.panels.ACLPanel;
import com.archivas.clienttools.arcmover.gui.panels.CustomMetadataPanel;
import com.archivas.clienttools.arcmover.gui.panels.OwnerPanel;
import com.archivas.clienttools.arcmover.gui.panels.PoliciesPanel;
import com.archivas.clienttools.arcmover.gui.settings.DefaultNamespaceSettingsForm;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJobWithMetadata;
import com.archivas.clienttools.arcutils.api.jobs.SetMetadataJob;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.clienttools.arcutils.model.ACLMetadata;
import com.archivas.clienttools.arcutils.model.CustomMetadata;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.StructuredMetadata;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.XMLValidator;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;

public class MetadataJobDialog
extends JobDialog {
    public static Logger LOG = Logger.getLogger(CopyJobDialog.class.getName());
    public static final String POLICIES_TAB_TITLE = "Policies";
    private static final String CUSTOM_MD_TAB_TITLE = "Custom Metadata";
    public static final String POSIX_TAB_TITLE = "POSIX Metadata";
    public static final String OWNER_TAB_TITLE = "Owner";
    private static final String ACL_TAB_TITLE = "ACL";
    private PoliciesPanel policiesPanel;
    private DefaultNamespaceSettingsForm posixPanel;
    private CustomMetadataPanel customMetadataPanel;
    private OwnerPanel ownerPanel;
    private ACLPanel aclPanel;
    private ManagedJobWithMetadata metadataJob;

    protected MetadataJobDialog(ManagedJobImpl jobImpl) throws DatabaseException, JobException {
        super(jobImpl);
        this.metadataJob = (ManagedJobWithMetadata)jobImpl.getJob();
    }

    protected MetadataJobDialog(ManagedJobWithMetadata job) throws DatabaseException, JobException {
        super(job);
        this.metadataJob = job;
    }

    protected boolean includeMetadataPanels() {
        return true;
    }

    protected boolean supportsOwner() {
        AbstractProfileBase profile = this.metadataJob.getSourceProfile();
        return profile.supportsOwner() && !profile.isAnonymousAccess();
    }

    protected boolean supportsPosixSettings() {
        return false;
    }

    protected boolean indexSettingsEnabled() {
        return this.metadataJob.getSourceProfile().supportsIndexingSettings();
    }

    protected boolean supportsRetentionClasses() {
        return this.metadataJob.getSourceProfile().supportsRetentionClasses();
    }

    protected boolean supportsACLs() {
        return this.metadataJob.getSourceProfile().supportsACLs();
    }

    protected boolean validateCustomMetadata() {
        return this.metadataJob.getSourceProfile().isValidateCustomMetadata();
    }

    protected boolean isIngestJob() {
        return false;
    }

    @Override
    protected void addJobSpecificTabs(JTabbedPane tabbedPane, ManagedJob managedJob) throws DatabaseException, JobException {
        this.metadataJob = (ManagedJobWithMetadata)managedJob;
        if (this.includeMetadataPanels()) {
            this.policiesPanel = new PoliciesPanel(this, this.metadataJob.getIngestionMetadata(), this.indexSettingsEnabled(), this.supportsRetentionClasses(), this.isIngestJob());
            tabbedPane.addTab(POLICIES_TAB_TITLE, this.policiesPanel);
            if (this.supportsOwner()) {
                this.ownerPanel = new OwnerPanel(this, this.metadataJob, this.isIngestJob());
                tabbedPane.addTab(OWNER_TAB_TITLE, this.ownerPanel);
            }
            if (this.supportsPosixSettings()) {
                FileMetadata md = this.metadataJob.getIngestionMetadata();
                this.posixPanel = new DefaultNamespaceSettingsForm(this, md.hasUid() ? "" + md.getUid() : "", md.hasGid() ? "" + md.getGid() : "", md.hasFileMode() ? md.getFileMode() : -1, md.hasDirMode() ? md.getDirMode() : -1);
                tabbedPane.addTab(POSIX_TAB_TITLE, this.posixPanel);
            }
            this.customMetadataPanel = new CustomMetadataPanel(this, this.isIngestJob());
            tabbedPane.add(CUSTOM_MD_TAB_TITLE, this.customMetadataPanel);
            if (this.metadataJob.hasCustomMetadata()) {
                this.customMetadataPanel.setCustomMetadata(this.metadataJob.getCustomMetadata());
            }
            if (this.supportsACLs()) {
                this.aclPanel = new ACLPanel(this, this.isIngestJob());
                tabbedPane.add(ACL_TAB_TITLE, this.aclPanel);
                if (this.metadataJob.hasACL()) {
                    this.aclPanel.setACL(this.metadataJob.getACL());
                }
            }
        }
    }

    @Override
    protected String getTitlePrefix() {
        return "Metadata";
    }

    @Override
    protected void updateJobSpecificTabsState(boolean neverRun) {
        if (this.policiesPanel != null) {
            this.policiesPanel.enablePanel(neverRun);
        }
        if (this.posixPanel != null) {
            this.posixPanel.enablePanel(neverRun);
        }
        if (this.customMetadataPanel != null) {
            this.customMetadataPanel.enablePanel(neverRun);
        }
        if (this.ownerPanel != null) {
            this.ownerPanel.enablePanel(neverRun);
        }
        if (this.aclPanel != null) {
            this.aclPanel.enablePanel(neverRun);
        }
    }

    @Override
    protected void updateJobSpecForSpecificJob() throws DatabaseException, JobException {
        String metadataText;
        if (this.policiesPanel != null) {
            this.metadataJob.setShred(this.policiesPanel.getShred());
            this.metadataJob.setIndex(this.policiesPanel.getIndex());
            this.metadataJob.setRetentionHold(this.policiesPanel.getHold());
            this.metadataJob.setRetention(this.policiesPanel.getRetention());
        }
        if (this.customMetadataPanel != null) {
            CustomMetadata customMetadata = this.customMetadataPanel.getCustomMetadata();
            if (customMetadata != null && customMetadata.getForm() == StructuredMetadata.Form.STRING) {
                metadataText = customMetadata.getValue();
                if (metadataText.length() > 32672) {
                    throw new JobException("Custom metadata XML string too long");
                }
                if (metadataText.length() > 0 && this.validateCustomMetadata() && !XMLValidator.isValid(metadataText)) {
                    throw new JobException("Invalid custom metadata XML");
                }
            }
            this.metadataJob.setCustomMetadata(customMetadata);
        }
        if (this.posixPanel != null) {
            if (this.posixPanel.hasUid()) {
                this.metadataJob.setUid(this.posixPanel.getUid());
            } else {
                this.metadataJob.setUid(null);
            }
            if (this.posixPanel.hasGid()) {
                this.metadataJob.setGid(this.posixPanel.getGid());
            } else {
                this.metadataJob.setGid(null);
            }
            if (this.posixPanel.hasFileMode()) {
                this.metadataJob.setFilePermissions(this.posixPanel.getFileMode());
            } else {
                this.metadataJob.setFilePermissions(null);
            }
            if (this.posixPanel.hasDirMode()) {
                this.metadataJob.setDirPermissions(this.posixPanel.getDirMode());
            } else {
                this.metadataJob.setDirPermissions(null);
            }
        }
        if (this.ownerPanel != null) {
            this.metadataJob.setOwner(this.ownerPanel.getOwner());
        }
        if (this.aclPanel != null) {
            ACLMetadata acl = this.aclPanel.getACL();
            if (acl != null && acl.getForm() == StructuredMetadata.Form.STRING) {
                metadataText = acl.getValue();
                if (metadataText.length() > 32672) {
                    throw new JobException("ACL XML string too long");
                }
                if (metadataText.length() > 0 && !XMLValidator.isValid(metadataText)) {
                    throw new JobException("Invalid ACL XML");
                }
            }
            this.metadataJob.setACL(acl);
        }
    }

    @Override
    protected boolean hasTargetProfile() {
        return false;
    }

    public static void main(String[] args) {
        SetMetadataJob job = new SetMetadataJob(null, (File)null);
        try {
            JobDialog.openNewJob(job);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

