/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.archivas.clienttools.arcmover.gui.panels.ProfilePanel;
import com.archivas.clienttools.arcmover.gui.util.FileListTable;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.jobs.CopyJob;
import com.archivas.clienttools.arcutils.model.ArcCopyFile;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.FileSystemProfile;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.gui.ArrayListTransferrable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class MoverTransferHandler
extends TransferHandler {
    private static final Logger LOG = Logger.getLogger(MoverTransferHandler.class.getName());
    private ProfilePanel profilePanel = null;
    DataFlavor arrayListDataFlavor = null;
    boolean dropEnabled = false;

    public MoverTransferHandler(ProfilePanel profilePanel) {
        this.profilePanel = profilePanel;
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setDropEnabled(boolean dropEnabled) {
        this.dropEnabled = dropEnabled;
    }

    public boolean isSrcComponentSameAsTargetComponent(TransferHandler.TransferSupport info) throws UnsupportedFlavorException, IOException {
        Transferable t;
        ArrayList arrayList;
        ArcMoverFile fileBeingMoved;
        String fileBeingMovedDir;
        boolean result = false;
        String myPanelDir = this.profilePanel.getCurrentDirectory().getPath();
        if (info.isDataFlavorSupported(ArrayListTransferrable.flavor) && myPanelDir.equals(fileBeingMovedDir = (fileBeingMoved = (ArcMoverFile)(arrayList = (ArrayList)(t = info.getTransferable()).getTransferData(ArrayListTransferrable.flavor)).get(2)).getParent().getPath())) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        if (!this.dropEnabled) {
            return false;
        }
        try {
            if (!info.isDataFlavorSupported(DataFlavor.stringFlavor) && !info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            if (this.isSrcComponentSameAsTargetComponent(info)) {
                return false;
            }
            JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
            if (dl.getRow() == -1) {
                return false;
            }
            info.setShowDropLocation(true);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unexpected Exception determining if TransferSupport can be imported.  TransferHandler.TransferSupport info=" + info, e);
            return false;
        }
    }

    private boolean importFileList(String fileListString) {
        String[] entries = fileListString.split("\r\n");
        AbstractProfileBase srcProfile = ProfileManager.getProfileByName(FileSystemProfile.LOCAL_FILESYSTEM_PROFILE.getName());
        AbstractProfileBase destProfile = this.profilePanel.getSelectedProfile();
        String sourcePath = null;
        String targetPath = this.profilePanel.getCurrentDirectory().getPath();
        ArrayList<ArcCopyFile> fileList = new ArrayList<ArcCopyFile>();
        for (String escapedEntry : entries) {
            String entry = URLDecoder.decode(escapedEntry.replace("+", "%2B"));
            try {
                URL url = new URL(entry);
                String pathname = url.getPath();
                if (url.getQuery() != null) {
                    pathname = pathname + "?" + url.getQuery();
                }
                if (url.getRef() != null) {
                    pathname = pathname + "#" + url.getRef();
                }
                File sourceFile = new File(pathname);
                String filename = sourceFile.getName();
                if (sourcePath == null) {
                    sourcePath = sourceFile.getParent() + File.separatorChar;
                }
                FileMetadata fileMetaData = new FileMetadata();
                if (sourceFile.isDirectory()) {
                    fileMetaData.setFileType(FileType.DIRECTORY);
                    pathname = pathname + File.separatorChar;
                }
                ArcMoverFile moverFile = ArcMoverFile.getFileInstance(srcProfile, pathname, fileMetaData);
                ArcCopyFile arcCopyFile = new ArcCopyFile(moverFile, destProfile, targetPath + filename);
                fileList.add(arcCopyFile);
            }
            catch (MalformedURLException urlEx) {
                LOG.log(Level.WARNING, "Unexpected exception attempting to drag and drop fileListString=" + fileListString, urlEx);
                this.displayDropLocation("Error when trying to handle " + entry);
                return false;
            }
        }
        return this.runCopyJob(srcProfile, sourcePath, destProfile, targetPath, fileList);
    }

    private boolean runCopyJob(AbstractProfileBase srcProfile, String sourcePath, AbstractProfileBase destProfile, String targetPath, List<ArcCopyFile> fileList) {
        try {
            CopyJob copyJob = new CopyJob(srcProfile, destProfile, fileList);
            copyJob.setSourcePath(sourcePath);
            copyJob.setTargetPath(targetPath);
            JobDialog.openNewJob(copyJob);
            this.profilePanel.refreshPathAndFileList();
        }
        catch (JobException jobEx) {
            LOG.log(Level.WARNING, "Unexpected job exception attempting to drag and drop fileList", jobEx);
            this.displayDropLocation("An error occurred when trying to drop files: " + jobEx.getMessage());
            return false;
        }
        catch (DatabaseException dbEx) {
            LOG.log(Level.WARNING, "Unexpected database exception attempting to drag and drop fileList=" + fileList, dbEx);
            this.displayDropLocation("A database error occurred when trying to drop files.");
            return false;
        }
        return true;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        try {
            if (!info.isDrop()) {
                return false;
            }
            if (!this.dropEnabled) {
                return false;
            }
            if (this.isSrcComponentSameAsTargetComponent(info)) {
                return false;
            }
            if (info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String importPath = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
                return this.importFileList(importPath);
            }
            if (info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return this.importJFileList(info);
            }
            if (info.isDataFlavorSupported(ArrayListTransferrable.flavor)) {
                return this.importMoverFiles(info);
            }
            this.displayDropLocation("List doesn't accept a drop of this type.");
            return false;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unexpected Exception Attempting to drag and drop  TransferHandler.TransferSupport info=" + info, e);
            this.displayDropLocation("Unable to drop requested files.");
            return false;
        }
    }

    public boolean importMoverFiles(TransferHandler.TransferSupport info) throws DatabaseException {
        ArcMoverFile targetFile;
        ArrayList arrayList;
        if (!info.isDataFlavorSupported(ArrayListTransferrable.flavor)) {
            this.displayDropLocation("List doesn't accept a drop of this type.");
            return false;
        }
        JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
        Transferable t = info.getTransferable();
        try {
            arrayList = (ArrayList)t.getTransferData(ArrayListTransferrable.flavor);
        }
        catch (Exception e) {
            return false;
        }
        String targetPath = null;
        targetPath = dl.isInsertRow() ? this.profilePanel.getCurrentDirectory().getPath() : ((targetFile = this.profilePanel.getFileAt(dl.getRow())) instanceof ArcMoverDirectory ? targetFile.getPath() : this.profilePanel.getCurrentDirectory().getPath());
        AbstractProfileBase sourceProfile = (AbstractProfileBase)arrayList.remove(0);
        AbstractProfileBase targetProfile = this.profilePanel.getSelectedProfile();
        ArrayList fileList = new ArrayList();
        fileList.addAll(arrayList);
        FileMetadata metadata = new FileMetadata();
        ArrayList<ArcCopyFile> copyList = new ArrayList<ArcCopyFile>();
        for (ArcMoverFile file : fileList) {
            ArcCopyFile copyFile = new ArcCopyFile(file, targetProfile, FileUtil.resolvePath(targetPath, file.getFileName(), targetProfile.getPathSeparator()), metadata);
            copyList.add(copyFile);
        }
        HCPDataMigrator.getInstance().copyFiles(sourceProfile, this.profilePanel, copyList);
        return false;
    }

    public boolean importJFileList(TransferHandler.TransferSupport info) {
        File parentDir = null;
        List rawFileList = null;
        try {
            if (!info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                this.displayDropLocation("List doesn't accept a drop of this type.");
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                rawFileList = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException e) {
                LOG.log(Level.WARNING, "Unsupported Data flavor.  Expected DataFlavor.javaFileListFlavor", e);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unexpected IO Exception parsing transfer data", e);
            }
            LOG.info("Files passed to transfer handler=" + rawFileList);
            if (rawFileList == null || rawFileList.size() < 1) {
                LOG.log(Level.WARNING, "No files were passed to the transfer handler.");
                return false;
            }
            parentDir = ((File)rawFileList.get(0)).getParentFile();
            if (parentDir == null || parentDir.toURI() == null || parentDir.toURI().toURL() == null) {
                LOG.log(Level.WARNING, "Trying to copy files from an invalid parentDir: " + parentDir + ".  First file in list is " + rawFileList.get(0));
                return false;
            }
            LOG.finer("Transfer parent directory = " + parentDir);
            for (File f : rawFileList) {
                if (!f.getParentFile().equals(parentDir)) {
                    this.displayDropLocation("Can't drop files from multiple source directories.");
                    return false;
                }
                LOG.finer("File for Transfer: " + f);
            }
            ArrayList<ArcCopyFile> fileList = new ArrayList<ArcCopyFile>();
            AbstractProfileBase srcProfile = ProfileManager.getProfileByName(FileSystemProfile.LOCAL_FILESYSTEM_PROFILE.getName());
            AbstractProfileBase destProfile = this.profilePanel.getSelectedProfile();
            String targetPath = this.profilePanel.getCurrentDirectory().getPath();
            String sourcePath = parentDir.getPath();
            for (File f : rawFileList) {
                String pathname = f.getPath();
                String filename = f.getName();
                FileMetadata fileMetaData = new FileMetadata();
                if (f.isDirectory()) {
                    fileMetaData.setFileType(FileType.DIRECTORY);
                    pathname = pathname + File.separatorChar;
                }
                ArcMoverFile moverFile = ArcMoverFile.getFileInstance(srcProfile, pathname, fileMetaData);
                ArcCopyFile arcCopyFile = new ArcCopyFile(moverFile, destProfile, targetPath + filename);
                fileList.add(arcCopyFile);
            }
            return this.runCopyJob(srcProfile, sourcePath, destProfile, targetPath, fileList);
        }
        catch (Exception e) {
            String errorMsg = "Error transferring files from " + parentDir;
            LOG.log(Level.WARNING, errorMsg, e);
            GUIHelper.showMessageDialog(this.profilePanel.getParent(), errorMsg, "File Transfer Error", 0);
            return false;
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        FileListTable table = (FileListTable)c;
        int[] rows = table.getSelectedRows();
        arrayList.add(this.profilePanel.getName());
        arrayList.add(this.profilePanel.getSelectedProfile());
        for (int i = 0; i < rows.length; ++i) {
            ArcMoverFile file = table.getModel().getFileAt(rows[i]);
            if (file == null) continue;
            arrayList.add(file);
        }
        return new ArrayListTransferrable(arrayList);
    }

    private void displayDropLocation(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, string);
            }
        });
    }
}

