/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcmover.gui.JobAlreadyOpenException;
import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.archivas.clienttools.arcmover.gui.panels.FixedHeightPanel;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthButton;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthPanel;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.api.JobNotFoundException;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJobSummary;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class SavedJobsDialog
extends JDialog {
    public static Logger LOG = Logger.getLogger(SavedJobsDialog.class.getName());
    private JButton openJobButton = new FixedWidthButton("Open", 100);
    private JButton removeJobButton = new FixedWidthButton("Delete", 100);
    private JButton closeDialogButton = new FixedWidthButton("Close", 100);
    private JobsTableModel jobsTableModel = new JobsTableModel();
    private JTable jobsTable = new JTable(this.jobsTableModel);
    private static SavedJobsDialog instance;
    private boolean isBackgroundTaskInProgress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openSavedJobsDialog() throws DatabaseException {
        Class<SavedJobsDialog> clazz = SavedJobsDialog.class;
        synchronized (SavedJobsDialog.class) {
            if (instance == null) {
                instance = new SavedJobsDialog();
            }
            instance.setModal(true);
            instance.setVisible(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private SavedJobsDialog() throws DatabaseException {
        super(HCPDataMigrator.getInstance());
        this.createComponents();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!SavedJobsDialog.this.isBackgroundTaskInProgress()) {
                    SavedJobsDialog.this.dialogClosing();
                }
            }
        });
        this.removeJobButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavedJobsDialog.this.removeJobs();
            }
        });
        this.openJobButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SavedJobsDialog.this.setCursor(HCPDataMigrator.waitCursor);
                    SavedJobsDialog.this.viewJob();
                }
                finally {
                    SavedJobsDialog.this.setCursor(null);
                }
            }
        });
        this.closeDialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavedJobsDialog.this.dialogClosing();
            }
        });
        this.jobsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SavedJobsDialog.this.setButtonStates();
            }
        });
        this.setMinimumSize(new Dimension(650, 350));
        this.populateJobsList();
        this.setButtonStates();
        this.pack();
        GUIHelper.autoResizeColWidth(this.jobsTable);
        this.setLocationRelativeTo(HCPDataMigrator.getInstance());
    }

    private void createComponents() {
        this.setTitle("Saved Jobs");
        FixedWidthPanel jobButtonsPanel = new FixedWidthPanel();
        jobButtonsPanel.setLayout(new BoxLayout(jobButtonsPanel, 1));
        jobButtonsPanel.add(this.openJobButton);
        jobButtonsPanel.add(Box.createVerticalStrut(12));
        jobButtonsPanel.add(this.removeJobButton);
        jobButtonsPanel.add(Box.createVerticalGlue());
        this.jobsTable.setRowSelectionAllowed(true);
        this.jobsTable.setFillsViewportHeight(true);
        this.jobsTable.setAutoCreateRowSorter(true);
        JScrollPane jobsListScrollPane = new JScrollPane(this.jobsTable);
        jobsListScrollPane.setPreferredSize(new Dimension(300, 200));
        JPanel jobsPanel = new JPanel();
        jobsPanel.setLayout(new BoxLayout(jobsPanel, 0));
        jobsPanel.add(jobsListScrollPane);
        jobsPanel.add(Box.createHorizontalStrut(12));
        jobsPanel.add(jobButtonsPanel);
        FixedHeightPanel bottomButtonPanel = new FixedHeightPanel();
        bottomButtonPanel.setLayout(new BoxLayout(bottomButtonPanel, 0));
        bottomButtonPanel.add(Box.createHorizontalGlue());
        bottomButtonPanel.add(this.closeDialogButton);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(jobsPanel);
        p.add(Box.createVerticalStrut(25));
        p.add(bottomButtonPanel);
        p.setBorder(new EmptyBorder(12, 12, 17, 12));
        this.getContentPane().add(p);
        p.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavedJobsDialog.this.dialogClosing();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void setButtonStates() {
        if (!this.isBackgroundTaskInProgress()) {
            int[] selectedRows = this.jobsTable.getSelectedRows();
            this.openJobButton.setEnabled(selectedRows.length == 1);
            this.removeJobButton.setEnabled(selectedRows.length > 0);
        }
    }

    private void populateJobsList() throws DatabaseException {
        this.jobsTableModel.setJobs(ArcMoverFactory.getInstance().getAllManagedJobs());
    }

    private ManagedJobSummary getSelectedJob() {
        return this.jobsTableModel.getJob(this.jobsTable.convertRowIndexToModel(this.jobsTable.getSelectedRow()));
    }

    private void setBackgroundTaskInProgress(boolean inProgress) {
        assert (SwingUtilities.isEventDispatchThread());
        this.isBackgroundTaskInProgress = inProgress;
        Component glassPane = this.getGlassPane();
        if (inProgress) {
            glassPane.setCursor(HCPDataMigrator.waitCursor);
            glassPane.setVisible(true);
            this.openJobButton.setEnabled(false);
            this.removeJobButton.setEnabled(false);
            this.closeDialogButton.setEnabled(false);
            this.jobsTable.setEnabled(false);
        } else {
            glassPane.setCursor(null);
            glassPane.setVisible(false);
            this.closeDialogButton.setEnabled(true);
            this.jobsTable.setEnabled(true);
        }
    }

    private boolean isBackgroundTaskInProgress() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.isBackgroundTaskInProgress;
    }

    private void viewJob() {
        try {
            ManagedJobSummary selectedJob = this.getSelectedJob();
            JobDialog.openExistingJob(selectedJob.getJobId(), selectedJob.getJobType());
            this.dialogClosing();
            JobDialog.showJob();
        }
        catch (JobAlreadyOpenException jaoe) {
            JOptionPane.showMessageDialog(this, "Another job is already open.\nOnly one job may be open at a time.", "Error", 0);
            JobDialog.showJob();
        }
        catch (JobNotFoundException jnfe) {
            JOptionPane.showMessageDialog(this, "Job does not exist", "Error Opening Job", 0);
            try {
                this.populateJobsList();
            }
            catch (Exception exc) {
                String errMsg = DBUtils.getErrorMessage("An error occurred retrieving the list of jobs", exc);
                LOG.log(Level.SEVERE, errMsg, exc);
                GUIHelper.showMessageDialog(this, errMsg, "Error", 0);
            }
        }
        catch (Exception e) {
            String msg = DBUtils.getErrorMessage("An error occurred opening job", e);
            GUIHelper.showMessageDialog(this, msg, "Error Opening Job", 0);
            LOG.log(Level.SEVERE, msg, e);
        }
    }

    private void removeJobs() {
        int[] indexes = this.jobsTable.getSelectedRows();
        final ManagedJobSummary[] selectedJobs = new ManagedJobSummary[indexes.length];
        int cnt = 0;
        for (int selectedIndex : indexes) {
            selectedJobs[cnt++] = this.jobsTableModel.getJob(this.jobsTable.convertRowIndexToModel(selectedIndex));
        }
        int jobCount = selectedJobs.length;
        if (jobCount > 0) {
            String confirmationMessage = null;
            if (jobCount == 1) {
                confirmationMessage = "Are you sure you want to delete the selected job?";
            } else if (jobCount > 1) {
                confirmationMessage = String.format("Are you sure you want to delete the %d selected jobs?", jobCount);
            }
            int confirmation = JOptionPane.showConfirmDialog(this, confirmationMessage, "Delete Jobs", 0, 2);
            if (confirmation == 0) {
                this.setBackgroundTaskInProgress(true);
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){
                    String errMsg;
                    String errMsg2;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object doInBackground() {
                        ManagedJobSummary job = null;
                        try {
                            ManagedJobSummary[] managedJobSummaryArray = selectedJobs;
                            int n = managedJobSummaryArray.length;
                            for (int i = 0; i < n; ++i) {
                                ManagedJobSummary selectedJob;
                                job = selectedJob = managedJobSummaryArray[i];
                                ArcMoverFactory.getInstance().removeManagedJob(job.getJobId(), job.getJobType());
                            }
                        }
                        catch (JobNotFoundException exc) {}
                        catch (Exception e) {
                            this.errMsg = "An error occurred removing job";
                            if (job != null) {
                                this.errMsg = this.errMsg + " " + job.getJobName();
                            }
                            this.errMsg = DBUtils.getErrorMessage(this.errMsg, e);
                            LOG.log(Level.SEVERE, this.errMsg, e);
                        }
                        finally {
                            try {
                                SavedJobsDialog.this.populateJobsList();
                            }
                            catch (Exception exc) {
                                this.errMsg2 = DBUtils.getErrorMessage("An error occurred retrieving the list of jobs", exc);
                                LOG.log(Level.SEVERE, this.errMsg2, exc);
                            }
                            return null;
                        }
                    }

                    @Override
                    protected void done() {
                        try {
                            if (this.errMsg != null && this.errMsg.trim().length() > 0) {
                                GUIHelper.showMessageDialog(SavedJobsDialog.this, this.errMsg.trim(), "Error Removing Job", 0);
                            }
                            if (this.errMsg2 != null && this.errMsg2.trim().length() > 0) {
                                GUIHelper.showMessageDialog(SavedJobsDialog.this, this.errMsg2.trim(), "Error", 0);
                            }
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            SavedJobsDialog.this.setBackgroundTaskInProgress(false);
                        }
                    }
                };
                worker.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dialogClosing() {
        Class<SavedJobsDialog> clazz = SavedJobsDialog.class;
        synchronized (SavedJobsDialog.class) {
            this.setVisible(false);
            if (instance == this) {
                instance = null;
            }
            this.dispose();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static class JobsTableModel
    extends AbstractTableModel {
        private static final JobColumn[] jobColumns = new JobColumn[]{JobColumn.NAME, JobColumn.TYPE, JobColumn.STATE};
        private List<ManagedJobSummary> jobs = new ArrayList<ManagedJobSummary>();

        public ManagedJobSummary getJob(int row) {
            return this.jobs.get(row);
        }

        public void setJobs(List<ManagedJobSummary> jobs) {
            if (jobs == null) {
                throw new IllegalArgumentException("Null jobs");
            }
            this.jobs = jobs;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            if (column >= 0 && column < jobColumns.length) {
                return jobColumns[column].uiValue;
            }
            throw new IllegalArgumentException("Unsupported column index " + column);
        }

        @Override
        public int getRowCount() {
            return this.jobs.size();
        }

        @Override
        public int getColumnCount() {
            return jobColumns.length;
        }

        @Override
        public Object getValueAt(int row, int column) {
            ManagedJobSummary job = this.jobs.get(row);
            return this.getValue(job, column);
        }

        public String getValue(ManagedJobSummary job, int column) {
            if (column >= 0 && column < jobColumns.length) {
                switch (jobColumns[column]) {
                    case NAME: {
                        return job.getJobName();
                    }
                    case TYPE: {
                        return job.getJobType().getUiName();
                    }
                    case STATE: {
                        return job.getJobStatus().toString();
                    }
                    case ID: {
                        return String.format("%d", job.getJobId().getId());
                    }
                }
            }
            throw new IllegalArgumentException("Unsupported column index " + column);
        }

        private static enum JobColumn {
            NAME("Name"),
            TYPE("Job Type"),
            STATE("State"),
            ID("Job ID");

            private String uiValue;

            private JobColumn(String uiValue) {
                this.uiValue = uiValue;
            }
        }
    }
}

