/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.namespacewizard;

import com.archivas.clienttools.arcmover.gui.namespacewizard.NamespaceWizardStep;
import com.archivas.clienttools.arcmover.gui.namespacewizard.WizardUtils;
import com.archivas.clienttools.arcutils.profile.Hcp3AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.utils.DomainValidator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.pietschy.wizard.InvalidStateException;

public class AuthNamespaceSettings
extends NamespaceWizardStep {
    public static final String EMPTYSTR = "";
    private JTextField tenantTextField;
    private JTextField namespaceTextField;
    private JTextField usernameTextField;
    private JPasswordField passwordField;
    private JCheckBox validateCustomMetadatCombo;

    public AuthNamespaceSettings() {
        super("Namespace Access Configuration", EMPTYSTR);
        this.tenantTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AuthNamespaceSettings.this.model.setTenant(AuthNamespaceSettings.this.getTenant());
            }
        });
        this.namespaceTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AuthNamespaceSettings.this.model.setNamespace(AuthNamespaceSettings.this.getNamespace());
            }
        });
        this.usernameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AuthNamespaceSettings.this.model.setUsername(AuthNamespaceSettings.this.getUsername());
            }
        });
        this.passwordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AuthNamespaceSettings.this.model.setPassword(AuthNamespaceSettings.this.getPassword());
            }
        });
        this.validateCustomMetadatCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthNamespaceSettings.this.model.setValidateCustomMetadata(AuthNamespaceSettings.this.isValidateCustomMetadata());
            }
        });
    }

    @Override
    public JTextField[] getTextFields() {
        JTextField[] textFields = new JTextField[]{this.tenantTextField, this.namespaceTextField, this.usernameTextField, this.passwordField};
        return textFields;
    }

    @Override
    public boolean isComplete() {
        return !this.model.isAuthNamespace() || !this.trimValue(this.tenantTextField).isEmpty() && !this.trimValue(this.namespaceTextField).isEmpty() && (!this.trimValue(this.usernameTextField).isEmpty() && !this.trimValue(this.passwordField).isEmpty() || this.model.isAnonymousAccess());
    }

    @Override
    public void prepareFields() {
        if (this.model.isAuthNamespace()) {
            JTextField tmp = new JTextField();
            this.tenantTextField.setEnabled(true);
            this.tenantTextField.setBackground(tmp.getBackground());
            this.namespaceTextField.setEnabled(true);
            this.namespaceTextField.setBackground(tmp.getBackground());
            this.usernameTextField.setEnabled(true);
            this.usernameTextField.setBackground(tmp.getBackground());
            this.passwordField.setEnabled(true);
            this.passwordField.setBackground(tmp.getBackground());
        } else {
            this.tenantTextField.setEnabled(false);
            this.tenantTextField.setBackground(this.content.getBackground());
            this.namespaceTextField.setEnabled(false);
            this.namespaceTextField.setBackground(this.content.getBackground());
            this.usernameTextField.setEnabled(false);
            this.usernameTextField.setBackground(this.content.getBackground());
            this.passwordField.setEnabled(false);
            this.passwordField.setBackground(this.content.getBackground());
        }
        this.tenantTextField.setText(this.model.getTenant());
        this.namespaceTextField.setText(this.model.getNamespace());
        if (this.model.isAnonymousAccess()) {
            this.usernameTextField.setText(EMPTYSTR);
            this.usernameTextField.setEnabled(false);
            this.usernameTextField.setBackground(this.content.getBackground());
            this.passwordField.setText(EMPTYSTR);
            this.passwordField.setEnabled(false);
            this.passwordField.setBackground(this.content.getBackground());
        } else {
            this.usernameTextField.setText(this.model.getUsername());
            this.passwordField.setText(this.model.getPassword());
        }
        this.validateCustomMetadatCombo.setSelected(this.model.isValidateCustomMetadata());
        this.updateComplete();
        this.tenantTextField.requestFocusInWindow();
    }

    public void applyState() throws InvalidStateException {
        String errorMsg = this.validate();
        if (errorMsg != null) {
            throw new InvalidStateException(errorMsg);
        }
        this.model.setTenant(this.getTenant());
        this.model.setNamespace(this.getNamespace());
        this.model.setUsername(this.getUsername());
        this.model.setPassword(this.getPassword());
        this.model.setValidateCustomMetadata(this.isValidateCustomMetadata());
    }

    private String validate() {
        String errorMsg = null;
        if (this.model.isAuthNamespace() && (errorMsg = this.validateTenant()) == null) {
            errorMsg = this.validateNamespace();
        }
        return errorMsg;
    }

    private String validateTenant() {
        String tenant = this.getTenant();
        String errorMsg = tenant.contains(".") ? "must not contain \".\"" : DomainValidator.validateLabel(tenant);
        if (errorMsg != null) {
            errorMsg = "Invalid tenant name, " + errorMsg;
        }
        return errorMsg;
    }

    private String validateNamespace() {
        String namespace = this.getNamespace();
        String errorMsg = namespace.contains(".") ? "Invalid namespace name, must not contain \".\"" : DomainValidator.validateLabel(namespace);
        if (errorMsg != null) {
            errorMsg = "Invalid namespace name, " + errorMsg;
        }
        return errorMsg;
    }

    private String trimValue(JTextField textField) {
        String str = EMPTYSTR;
        if (textField.getText() != null && textField.getText().trim().length() > 0) {
            str = textField.getText().trim();
        }
        return str;
    }

    private String getTenant() {
        return this.trimValue(this.tenantTextField);
    }

    private String getNamespace() {
        return this.trimValue(this.namespaceTextField);
    }

    private String getUsername() {
        return this.trimValue(this.usernameTextField);
    }

    private String getPassword() {
        if (this.passwordField.getText() != null && !this.passwordField.getText().equals(this.model.getPassword())) {
            return Hcp3AuthNamespaceProfile.getMD5Password(this.passwordField.getPassword());
        }
        return this.model.getPassword();
    }

    private boolean isValidateCustomMetadata() {
        return this.validateCustomMetadatCombo.isSelected();
    }

    @Override
    protected void setupUI() {
        WizardUtils.Wrapper wrapper = WizardUtils.createWrapper();
        this.content = wrapper.getPanel();
        Box center = wrapper.getBox();
        JPanel form = new JPanel();
        GroupLayout layout = new GroupLayout(form);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        form.setLayout(layout);
        center.add(form);
        center.add(WizardUtils.createSpacer());
        GroupLayout.ParallelGroup labels = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup values = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(labels).addGroup(values));
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        layout.setVerticalGroup(vGroup);
        JLabel label = new JLabel("Tenant");
        form.add(label);
        labels.addComponent(label);
        this.tenantTextField = new JTextField();
        this.tenantTextField.setToolTipText("Enter the tenant name");
        form.add(this.tenantTextField);
        values.addComponent(this.tenantTextField);
        vGroup.addGroup(layout.createParallelGroup().addComponent(label).addComponent(this.tenantTextField));
        label = new JLabel("Namespace");
        form.add(label);
        labels.addComponent(label);
        this.namespaceTextField = new JTextField();
        this.namespaceTextField.setToolTipText("Enter the namespace name");
        form.add(this.namespaceTextField);
        values.addComponent(this.namespaceTextField);
        vGroup.addGroup(layout.createParallelGroup().addComponent(label).addComponent(this.namespaceTextField));
        label = new JLabel("Username");
        form.add(label);
        labels.addComponent(label);
        this.usernameTextField = new JTextField();
        this.usernameTextField.setToolTipText("Enter a username");
        form.add(this.usernameTextField);
        values.addComponent(this.usernameTextField);
        vGroup.addGroup(layout.createParallelGroup().addComponent(label).addComponent(this.usernameTextField));
        label = new JLabel("Password");
        form.add(label);
        labels.addComponent(label);
        this.passwordField = new JPasswordField();
        this.passwordField.setToolTipText("Enter a password");
        form.add(this.passwordField);
        values.addComponent(this.passwordField);
        vGroup.addGroup(layout.createParallelGroup().addComponent(label).addComponent(this.passwordField));
        label = new JLabel("Check custom metadata XML");
        form.add(label);
        labels.addComponent(label);
        this.validateCustomMetadatCombo = new JCheckBox();
        this.validateCustomMetadatCombo.setToolTipText("Enable/disable checking of custom metadata XML in HCP-DM");
        form.add(this.validateCustomMetadatCombo);
        values.addComponent(this.validateCustomMetadatCombo);
        vGroup.addGroup(layout.createParallelGroup().addComponent(label).addComponent(this.validateCustomMetadatCombo));
    }
}

