/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.namespacewizard;

import com.archivas.clienttools.arcmover.gui.namespacewizard.NamespaceWizardStep;
import com.archivas.clienttools.arcmover.gui.namespacewizard.WizardUtils;
import com.archivas.clienttools.arcutils.utils.DomainValidator;
import com.archivas.clienttools.arcutils.utils.StringUtils;
import com.archivas.clienttools.arcutils.utils.net.NetUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.pietschy.wizard.InvalidStateException;

public class ConnectionSettings
extends NamespaceWizardStep {
    private static final Logger LOG = Logger.getLogger(ConnectionSettings.class.getName());
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String EMPTYSTR = "";
    private static final String DOMAIN_NAME_TOOLTIP = "Enter the domain name for the system";
    private static final String PORT_TOOLTIP = "Enter the port for connecting to the system";
    private JRadioButton connectViaDNSNameRadioButton;
    private JRadioButton connectViaIPAddressRadioButton;
    private JTextField domainNameTextField;
    private JTextField ipAddressTextField;
    private JTextField portTextField;
    private JCheckBox isSSLRequired;
    private JCheckBox isAnonymousAccess;

    public ConnectionSettings() {
        super("Connection", "The connection can be made either by domain name or by IP address(es).");
        this.connectViaDNSNameRadioButton.addItemListener(WizardUtils.createCompletionItemListener(this));
        this.connectViaIPAddressRadioButton.addItemListener(WizardUtils.createCompletionItemListener(this));
        this.connectViaDNSNameRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                try {
                    LOG.log(Level.FINE, "connectViaDNSNameRadioButton itemStateChanged.  Event=" + event);
                    if (1 == event.getStateChange()) {
                        ConnectionSettings.this.onChangeMode();
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Unexpected Exception", e);
                }
            }
        });
        this.connectViaIPAddressRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                try {
                    LOG.log(Level.FINE, "connectViaIPAddressRadioButton itemStateChanged.  Event=" + event);
                    if (1 == event.getStateChange()) {
                        ConnectionSettings.this.onChangeMode();
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Unexpected Exception", e);
                }
            }
        });
        this.isSSLRequired.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionSettings.this.portTextField.setText(ConnectionSettings.EMPTYSTR);
            }
        });
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionSettings.this.model.setConnectByDns(ConnectionSettings.this.isConnectByDns());
            }
        };
        this.connectViaDNSNameRadioButton.addActionListener(l);
        this.connectViaIPAddressRadioButton.addActionListener(l);
        this.domainNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ConnectionSettings.this.model.setHostname(ConnectionSettings.this.getHostname());
            }
        });
        this.ipAddressTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ConnectionSettings.this.model.setIpAddressList(ConnectionSettings.this.getIpAddressList());
            }
        });
        this.portTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ConnectionSettings.this.model.setPort(ConnectionSettings.this.getPort());
            }
        });
        this.isSSLRequired.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionSettings.this.model.setSSLRequired(ConnectionSettings.this.isSSLRequired());
            }
        });
        this.isAnonymousAccess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionSettings.this.model.setAnonymousAccess(ConnectionSettings.this.isAnonymousAccess());
            }
        });
    }

    @Override
    protected JTextField[] getTextFields() {
        JTextField[] textFields = new JTextField[]{this.domainNameTextField, this.ipAddressTextField, this.portTextField};
        return textFields;
    }

    @Override
    public boolean isComplete() {
        boolean isComplete = true;
        if (this.domainNameTextField.isEditable()) {
            if (this.getHostname().isEmpty()) {
                isComplete = false;
            } else if (this.model.validateIpString(this.getHostname()) == null) {
                isComplete = false;
            }
        }
        if (this.ipAddressTextField.isEditable() && (this.getIpAddress().isEmpty() || this.model.validateIpString(this.getIpAddress()) != null)) {
            isComplete = false;
        }
        return isComplete;
    }

    private void onChangeMode() {
        if (this.isConnectByDns()) {
            this.ipAddressTextField.setEditable(false);
            this.domainNameTextField.setEditable(true);
            this.domainNameTextField.requestFocusInWindow();
        } else {
            this.ipAddressTextField.setEditable(true);
            if (!this.model.getProfileType().isAuthNamespace()) {
                this.domainNameTextField.setEditable(false);
                this.ipAddressTextField.requestFocusInWindow();
            } else {
                this.domainNameTextField.setEditable(true);
                this.domainNameTextField.requestFocusInWindow();
            }
        }
        this.updateComplete();
    }

    @Override
    public void prepareFields() {
        this.domainNameTextField.setText(this.model.getHostname());
        if (this.model.isConnectByDns()) {
            this.connectViaDNSNameRadioButton.setSelected(true);
            this.domainNameTextField.requestFocusInWindow();
            this.connectViaIPAddressRadioButton.setSelected(false);
            this.ipAddressTextField.setText(EMPTYSTR);
        } else {
            this.connectViaIPAddressRadioButton.setSelected(true);
            if (this.model.isAuthNamespace()) {
                this.domainNameTextField.requestFocusInWindow();
            } else {
                this.ipAddressTextField.requestFocusInWindow();
                this.domainNameTextField.setText(EMPTYSTR);
            }
            this.connectViaDNSNameRadioButton.setSelected(false);
            this.ipAddressTextField.setText(StringUtils.createCSV(this.model.getIpAddressList()));
        }
        this.isSSLRequired.setSelected(this.model.isSSLRequired());
        if (!this.model.showAnonymousOption()) {
            this.isAnonymousAccess.setVisible(false);
        } else {
            this.isAnonymousAccess.setVisible(true);
            this.isAnonymousAccess.setSelected(this.model.isAnonymousAccess());
        }
        Integer port = this.model.getPort();
        this.portTextField.setText(port == null ? EMPTYSTR : EMPTYSTR + port);
        this.onChangeMode();
        this.updateComplete();
    }

    public void applyState() throws InvalidStateException {
        String errorMsg = this.validate();
        if (errorMsg != null) {
            throw new InvalidStateException(errorMsg);
        }
        this.model.setConnectByDns(this.isConnectByDns());
        this.model.setHostname(this.getHostname());
        this.model.setIpAddressList(this.getIpAddressList());
        this.model.setSSLRequired(this.isSSLRequired());
        this.model.setPort(this.getPort());
        this.model.setAnonymousAccess(this.isAnonymousAccess());
    }

    private String validate() {
        String errorMsg = null;
        if (this.domainNameTextField.isEditable()) {
            errorMsg = DomainValidator.validate(this.getHostname());
        }
        return errorMsg;
    }

    private boolean isSSLRequired() {
        return this.isSSLRequired.isSelected();
    }

    private boolean isConnectByDns() {
        return this.connectViaDNSNameRadioButton.isSelected();
    }

    private boolean isAnonymousAccess() {
        return this.isAnonymousAccess.isSelected();
    }

    private String trimValue(JTextField textField) {
        String str = EMPTYSTR;
        if (textField.getText() != null && textField.getText().trim().length() > 0) {
            str = textField.getText().trim();
        }
        return str;
    }

    private String getIpAddress() {
        return this.trimValue(this.ipAddressTextField);
    }

    private String getHostname() {
        return this.trimValue(this.domainNameTextField);
    }

    private Integer getPort() {
        String value = this.trimValue(this.portTextField);
        Integer port = null;
        if (value.length() > 0) {
            try {
                port = Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return port;
    }

    private List<String> getIpAddressList() {
        return NetUtils.parseIpCsv(this.trimValue(this.ipAddressTextField));
    }

    @Override
    protected void setupUI() {
        WizardUtils.Wrapper wrapper = WizardUtils.createWrapper();
        this.content = wrapper.getPanel();
        Box center = wrapper.getBox();
        Box buttonWrapperBox = Box.createHorizontalBox();
        Box buttonBox = Box.createVerticalBox();
        center.add(buttonWrapperBox);
        buttonWrapperBox.add(buttonBox);
        buttonWrapperBox.add(Box.createGlue());
        ButtonGroup radioButtons = new ButtonGroup();
        this.connectViaDNSNameRadioButton = new JRadioButton();
        this.connectViaDNSNameRadioButton.setText("Connect by domain name");
        this.connectViaDNSNameRadioButton.setToolTipText("Connect by domain name");
        this.connectViaDNSNameRadioButton.setAlignmentX(0.0f);
        radioButtons.add(this.connectViaDNSNameRadioButton);
        this.connectViaIPAddressRadioButton = new JRadioButton();
        this.connectViaIPAddressRadioButton.setText("Connect by IP address");
        this.connectViaIPAddressRadioButton.setToolTipText("Connect by IP address");
        this.connectViaIPAddressRadioButton.setAlignmentX(0.0f);
        radioButtons.add(this.connectViaIPAddressRadioButton);
        buttonBox.add(this.connectViaDNSNameRadioButton);
        buttonBox.add(WizardUtils.createVerticalStrut(this.connectViaDNSNameRadioButton, this.connectViaIPAddressRadioButton, center));
        buttonBox.add(this.connectViaIPAddressRadioButton);
        JPanel form = new JPanel();
        GroupLayout layout = new GroupLayout(form);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        form.setLayout(layout);
        center.add(form);
        center.add(WizardUtils.createSpacer());
        GroupLayout.ParallelGroup labels = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup values = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(labels).addGroup(values));
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        layout.setVerticalGroup(vGroup);
        JLabel label = new JLabel("Domain Name");
        form.add(label);
        labels.addComponent(label);
        this.domainNameTextField = new JTextField();
        this.domainNameTextField.setToolTipText(DOMAIN_NAME_TOOLTIP);
        form.add(this.domainNameTextField);
        values.addComponent(this.domainNameTextField);
        vGroup.addGroup(layout.createParallelGroup().addComponent(label).addComponent(this.domainNameTextField));
        label = new JLabel("Example: hcp.example.com");
        Font infoFont = new Font(label.getFont().getName(), 2, label.getFont().getSize() - 2);
        ((Component)label).setFont(infoFont);
        form.add(label);
        values.addComponent(label);
        vGroup.addComponent(label);
        label = new JLabel("IP Addresses");
        form.add(label);
        labels.addComponent(label);
        this.ipAddressTextField = new JTextField();
        this.ipAddressTextField.setText(EMPTYSTR);
        this.ipAddressTextField.setToolTipText("Enter a comma-separated list of IP addresses");
        form.add(this.ipAddressTextField);
        values.addComponent(this.ipAddressTextField);
        vGroup.addGroup(layout.createParallelGroup().addComponent(label).addComponent(this.ipAddressTextField));
        label = new JLabel("Comma-separated List of IP Addresses");
        ((Component)label).setFont(infoFont);
        form.add(label);
        values.addComponent(label);
        vGroup.addComponent(label);
        this.isSSLRequired = new JCheckBox("Use SSL for connection");
        this.isSSLRequired.setToolTipText("Enable SSL to connect");
        form.add(this.isSSLRequired);
        values.addComponent(this.isSSLRequired);
        vGroup.addComponent(this.isSSLRequired);
        this.isAnonymousAccess = new JCheckBox("Connect anonymously");
        this.isAnonymousAccess.setToolTipText("Connect using anonymous credentials");
        form.add(this.isAnonymousAccess);
        values.addComponent(this.isAnonymousAccess);
        vGroup.addComponent(this.isAnonymousAccess);
        this.portTextField = new JTextField();
        this.portTextField.setText(EMPTYSTR);
        this.portTextField.setToolTipText(PORT_TOOLTIP);
        if (Boolean.getBoolean("portChoice")) {
            label = new JLabel("Port");
            form.add(label);
            labels.addComponent(label);
            form.add(this.portTextField);
            values.addComponent(this.portTextField);
            vGroup.addGroup(layout.createParallelGroup().addComponent(label).addComponent(this.portTextField));
        }
    }
}

