/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.namespacewizard;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcmover.gui.namespacewizard.WizardModel;
import com.archivas.clienttools.arcmover.gui.namespacewizard.WizardUtils;
import com.archivas.clienttools.arcmover.gui.panels.FixedHeightPanel;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthButton;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthPanel;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.HCAPProfile;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.pietschy.wizard.Wizard;
import org.pietschy.wizard.WizardEvent;
import org.pietschy.wizard.WizardListener;

public class NamespaceProfileMgrDialog
extends JDialog {
    public static Logger LOG = Logger.getLogger(NamespaceProfileMgrDialog.class.getName());
    private JButton createButton = new FixedWidthButton("Create", 100);
    private JButton editButton = new FixedWidthButton("Edit", 100);
    private JButton deleteButton = new FixedWidthButton("Delete", 100);
    private JButton closeDialogButton = new FixedWidthButton("Close", 100);
    private ProfilesTableModel profilesTableModel = new ProfilesTableModel();
    private JTable profilesTable = new JTable(this.profilesTableModel);
    private static final String WIZARD_TITLE = "Namespace Profile Manager Wizard";
    private JPanel mainPanel;
    private Wizard wizard;

    public NamespaceProfileMgrDialog() {
        super(HCPDataMigrator.getInstance());
        this.setModal(true);
        this.initGuiComponents();
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceProfileMgrDialog.this.createProfile();
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceProfileMgrDialog.this.editProfile();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceProfileMgrDialog.this.deleteProfiles();
            }
        });
        this.closeDialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceProfileMgrDialog.this.dialogClosing();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NamespaceProfileMgrDialog.this.dialogClosing();
            }
        });
        this.mainPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceProfileMgrDialog.this.dialogClosing();
            }
        }, WizardUtils.getEscapeKeystroke(), 1);
        this.profilesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                NamespaceProfileMgrDialog.this.setButtonStates();
            }
        });
        this.setMinimumSize(new Dimension(450, 350));
        this.populateProfilesList();
        this.setButtonStates();
        this.pack();
        this.setLocationRelativeTo(HCPDataMigrator.getInstance());
    }

    private void initGuiComponents() {
        this.setTitle("Namespace Profile Manager");
        FixedWidthPanel profileButtonsPanel = new FixedWidthPanel();
        profileButtonsPanel.setLayout(new BoxLayout(profileButtonsPanel, 1));
        profileButtonsPanel.add(this.createButton);
        profileButtonsPanel.add(Box.createVerticalStrut(12));
        profileButtonsPanel.add(this.editButton);
        profileButtonsPanel.add(Box.createVerticalStrut(12));
        profileButtonsPanel.add(this.deleteButton);
        profileButtonsPanel.add(Box.createVerticalGlue());
        this.profilesTable.setRowSelectionAllowed(true);
        this.profilesTable.setFillsViewportHeight(true);
        this.profilesTable.setAutoCreateRowSorter(true);
        JScrollPane profilesListScrollPane = new JScrollPane(this.profilesTable);
        profilesListScrollPane.setPreferredSize(new Dimension(300, 200));
        JPanel profilesPanel = new JPanel();
        profilesPanel.setLayout(new BoxLayout(profilesPanel, 0));
        profilesPanel.add(profilesListScrollPane);
        profilesPanel.add(Box.createHorizontalStrut(12));
        profilesPanel.add(profileButtonsPanel);
        FixedHeightPanel bottomButtonPanel = new FixedHeightPanel();
        bottomButtonPanel.setLayout(new BoxLayout(bottomButtonPanel, 0));
        bottomButtonPanel.add(Box.createHorizontalGlue());
        bottomButtonPanel.add(this.closeDialogButton);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.add(profilesPanel);
        this.mainPanel.add(Box.createVerticalStrut(25));
        this.mainPanel.add(bottomButtonPanel);
        this.mainPanel.setBorder(new EmptyBorder(12, 12, 17, 12));
        this.getContentPane().add(this.mainPanel);
    }

    private void setButtonStates() {
        int[] selectedRows = this.profilesTable.getSelectedRows();
        this.editButton.setEnabled(selectedRows.length == 1);
        this.deleteButton.setEnabled(selectedRows.length > 0);
    }

    private void populateProfilesList() {
        this.profilesTableModel.setProfiles(ProfileManager.getProfiles());
    }

    private AbstractProfileBase getSelectedProfile() {
        return this.profilesTableModel.getProfile(this.profilesTable.convertRowIndexToModel(this.profilesTable.getSelectedRow()));
    }

    private Wizard prepareWizard(WizardModel model) {
        Wizard wizard = new Wizard((org.pietschy.wizard.WizardModel)model);
        wizard.setDefaultExitMode(2);
        final NamespaceProfileMgrDialog parent = model.parent;
        wizard.addWizardListener(new WizardListener(){

            public void wizardClosed(WizardEvent e) {
                parent.setButtonStates();
            }

            public void wizardCancelled(WizardEvent e) {
                parent.setButtonStates();
            }
        });
        return wizard;
    }

    private void createProfile() {
        try {
            WizardModel model = new WizardModel(this);
            this.wizard = this.prepareWizard(model);
            this.wizard.showInDialog(WIZARD_TITLE, (Component)this, true);
            if (model.getFinalErrorMessage() != null) {
                throw new Exception(model.getFinalErrorMessage());
            }
        }
        catch (Exception e) {
            String msg = DBUtils.getErrorMessage("Unexpected error creating namespace profile", e);
            LOG.log(Level.WARNING, msg, e);
            GUIHelper.showMessageDialog(this.getContentPane(), msg, "Error Creating Namespace Profile", 0);
        }
    }

    private void editProfile() {
        try {
            AbstractProfileBase profile = this.getSelectedProfile();
            if (profile != null) {
                WizardModel model = new WizardModel(profile, this);
                this.wizard = this.prepareWizard(model);
                this.wizard.showInDialog(WIZARD_TITLE, (Component)this, true);
                if (model.getFinalErrorMessage() != null) {
                    throw new Exception(model.getFinalErrorMessage());
                }
            }
        }
        catch (Exception e) {
            String msg = DBUtils.getErrorMessage("Unexpected error editing namespace profile", e);
            LOG.log(Level.WARNING, msg, e);
            GUIHelper.showMessageDialog(this.getContentPane(), msg, "Error Editing Namespace Profile", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProfiles() {
        int[] selectedProfiles = this.profilesTable.getSelectedRows();
        AbstractProfileBase profile = null;
        try {
            if (this.confirmDeleteProfiles(selectedProfiles)) {
                for (int selectedProfile : selectedProfiles) {
                    profile = this.profilesTableModel.getProfile(this.profilesTable.convertRowIndexToModel(selectedProfile));
                    ProfileManager.deleteProfile(profile, true);
                }
            }
        }
        catch (Exception e) {
            String msg = "An error occurred deleting namespace profile";
            if (profile != null) {
                msg = msg + " '" + profile.getName() + "'";
            }
            msg = DBUtils.getErrorMessage(msg, e);
            LOG.log(Level.SEVERE, msg, e);
            GUIHelper.showMessageDialog(this, msg, "Error Deleting Namespace Profile(s)", 0);
        }
        finally {
            this.populateProfilesList();
        }
    }

    private boolean confirmDeleteProfiles(int[] selectedProfiles) {
        String confirmMsg;
        if (selectedProfiles.length == 0) {
            return false;
        }
        if (selectedProfiles.length == 1) {
            AbstractProfileBase profile = this.profilesTableModel.getProfile(this.profilesTable.convertRowIndexToModel(selectedProfiles[0]));
            confirmMsg = "Delete namespace profile " + profile.getName() + "?";
        } else {
            confirmMsg = "Delete all selected namespace profiles?";
        }
        int choice = JOptionPane.showConfirmDialog(this, confirmMsg, "Confirm Delete", 0);
        return choice == 0;
    }

    private void dialogClosing() {
        try {
            HCPDataMigrator.getInstance().refreshProfiles();
        }
        catch (Exception e1) {
            String msg = DBUtils.getErrorMessage("Error refreshing file lists", e1);
            LOG.log(Level.WARNING, msg, e1);
            GUIHelper.showMessageDialog(this.getContentPane(), msg, "Error", 0);
        }
        finally {
            this.dispose();
        }
    }

    public void refresh() {
        this.populateProfilesList();
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    private static class ProfilesTableModel
    extends AbstractTableModel {
        private List<AbstractProfileBase> profiles = new ArrayList<AbstractProfileBase>();

        public AbstractProfileBase getProfile(int row) {
            return this.profiles.get(row);
        }

        public void setProfiles(List<AbstractProfileBase> profiles) {
            if (profiles == null) {
                throw new IllegalArgumentException("Null jobs");
            }
            this.profiles = profiles;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Namespace Profile";
                }
                case 1: {
                    return "Type";
                }
                case 2: {
                    return "Domain Name";
                }
            }
            throw new IllegalArgumentException("Unsupported column index " + column);
        }

        @Override
        public int getRowCount() {
            return this.profiles.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            AbstractProfileBase profile = this.profiles.get(row);
            switch (column) {
                case 0: {
                    return profile.getName();
                }
                case 1: {
                    return profile.getType().getDisplayString();
                }
                case 2: {
                    if (profile instanceof HCAPProfile) {
                        return ((HCAPProfile)profile).getHostname();
                    }
                    return "";
                }
            }
            throw new IllegalArgumentException("Unsupported column index " + column);
        }
    }
}

