/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.namespacewizard;

import com.archivas.clienttools.arcmover.gui.namespacewizard.NamespaceWizardStep;
import com.archivas.clienttools.arcmover.gui.namespacewizard.WizardUtils;
import com.archivas.clienttools.arcutils.profile.ProfileType;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import org.pietschy.wizard.InvalidStateException;

public class NamespaceType
extends NamespaceWizardStep {
    private static final Logger LOG = Logger.getLogger(NamespaceType.class.getName());
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String EMPTYSTR = "";
    private JRadioButton hcap2;
    private JRadioButton hcp3Default;
    private JRadioButton hcp3Auth;
    private JRadioButton hcp5Auth;
    private JRadioButton hcp6Auth;

    public NamespaceType() {
        super("Namespace Type", EMPTYSTR);
        this.hcap2.addItemListener(WizardUtils.createCompletionItemListener(this));
        this.hcp3Default.addItemListener(WizardUtils.createCompletionItemListener(this));
        this.hcp3Auth.addItemListener(WizardUtils.createCompletionItemListener(this));
        this.hcp5Auth.addItemListener(WizardUtils.createCompletionItemListener(this));
        this.hcp6Auth.addItemListener(WizardUtils.createCompletionItemListener(this));
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NamespaceType.this.model.setProfileType(NamespaceType.this.getProfileType());
            }
        };
        this.hcp6Auth.addActionListener(l);
        this.hcp5Auth.addActionListener(l);
        this.hcp3Auth.addActionListener(l);
        this.hcp3Default.addActionListener(l);
        this.hcap2.addActionListener(l);
    }

    @Override
    public boolean isComplete() {
        try {
            return this.hcap2.isSelected() || this.hcp3Default.isSelected() || this.hcp3Auth.isSelected() || this.hcp5Auth.isSelected() || this.hcp6Auth.isSelected();
        }
        catch (Exception e) {
            String msg = "Unexpected Error";
            LOG.log(Level.WARNING, msg, e);
            JOptionPane.showMessageDialog(this.getContentPane(), msg, "Error", 0);
            return false;
        }
    }

    @Override
    protected void prepareFields() {
        ProfileType profileType = this.model.getProfileType();
        if (profileType != null) {
            this.setProfileType(profileType);
        } else {
            this.setProfileType(ProfileType.HCP60);
        }
        this.updateComplete();
    }

    public void applyState() throws InvalidStateException {
        if (!this.isComplete()) {
            throw new InvalidStateException("Profile type must be selected");
        }
        this.model.setProfileType(this.getProfileType());
        if (!this.getProfileType().isAuthNamespace()) {
            this.model.setTenant(EMPTYSTR);
            this.model.setNamespace(EMPTYSTR);
            this.model.setUsername(EMPTYSTR);
            this.model.setPassword(EMPTYSTR);
        }
        this.model.setShowAnonymousOption(this.getProfileType().supportsAnonymousAccess());
    }

    public ProfileType getProfileType() {
        if (this.hcap2.isSelected()) {
            return ProfileType.HCAP2;
        }
        if (this.hcp3Default.isSelected()) {
            return ProfileType.HCP_DEFAULT;
        }
        if (this.hcp3Auth.isSelected()) {
            return ProfileType.HCP;
        }
        if (this.hcp5Auth.isSelected()) {
            return ProfileType.HCP50;
        }
        if (this.hcp6Auth.isSelected()) {
            return ProfileType.HCP60;
        }
        return null;
    }

    private void setProfileType(ProfileType profileType) {
        this.hcap2.setSelected(false);
        this.hcp3Default.setSelected(false);
        this.hcp3Auth.setSelected(false);
        this.hcp5Auth.setSelected(false);
        this.hcp6Auth.setSelected(false);
        this.hcp6Auth.requestFocusInWindow();
        if (profileType == null) {
            return;
        }
        switch (profileType) {
            case HCAP2: {
                this.hcap2.setSelected(true);
                this.hcap2.requestFocusInWindow();
                break;
            }
            case HCP_DEFAULT: {
                this.hcp3Default.setSelected(true);
                this.hcp3Default.requestFocusInWindow();
                break;
            }
            case HCP: {
                this.hcp3Auth.setSelected(true);
                this.hcp3Auth.requestFocusInWindow();
                break;
            }
            case HCP50: {
                this.hcp5Auth.setSelected(true);
                this.hcp5Auth.requestFocusInWindow();
                break;
            }
            case HCP60: {
                this.hcp6Auth.setSelected(true);
                this.hcp6Auth.requestFocusInWindow();
            }
        }
    }

    @Override
    protected void setupUI() {
        WizardUtils.Wrapper wrapper = WizardUtils.createWrapper();
        this.content = wrapper.getPanel();
        Box center = wrapper.getBox();
        this.hcp6Auth = new JRadioButton();
        this.hcp6Auth.setText("HCP namespace - 6.0 or later");
        this.hcp6Auth.setToolTipText("HCP namespace - 6.0 or later");
        center.add(this.hcp6Auth);
        this.hcp5Auth = new JRadioButton();
        this.hcp5Auth.setText("HCP namespace - 5.0");
        this.hcp5Auth.setToolTipText("HCP namespace - 5.0");
        center.add(this.hcp5Auth);
        this.hcp3Auth = new JRadioButton();
        this.hcp3Auth.setText("HCP namespace - 3.x or 4.x");
        this.hcp3Auth.setToolTipText("HCP namespace - 3.x or 4.x");
        center.add(this.hcp3Auth);
        this.hcp3Default = new JRadioButton();
        this.hcp3Default.setText("Default namespace");
        this.hcp3Default.setToolTipText("Default namespace");
        center.add(this.hcp3Default);
        this.hcap2 = new JRadioButton();
        this.hcap2.setText("HCAP archive - 2.x");
        this.hcap2.setToolTipText("HCAP archive - 2.x");
        center.add(this.hcap2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.hcap2);
        buttonGroup.add(this.hcp3Auth);
        buttonGroup.add(this.hcp3Default);
        buttonGroup.add(this.hcp5Auth);
        buttonGroup.add(this.hcp6Auth);
    }
}

