/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.namespacewizard;

import com.archivas.clienttools.arcmover.gui.namespacewizard.NamespaceWizardStep;
import com.archivas.clienttools.arcmover.gui.namespacewizard.WizardUtils;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.impl.adapter.ConnectionTestException;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.Hcp3AuthNamespaceProfile;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Summary
extends NamespaceWizardStep {
    private static final Logger LOG = Logger.getLogger(Summary.class.getName());
    private JLabel profileName;
    private JLabel profileType;
    private JLabel hostnameLabel;
    private JLabel hostname;
    private JLabel ipListLabel;
    private Box ipList;
    private List<Component> connStruts;
    private JLabel ssl;
    private JLabel tenantLabel;
    private JLabel namespaceLabel;
    private JLabel userLabel;
    private JLabel isValidateCustomMetadataLabel;
    private JLabel anonAccessLabel;
    private JLabel tenant;
    private JLabel namespace;
    private JLabel user;
    private JLabel isValidateCustomMetadata;
    private JLabel anonAccess;
    private List<Component> accessObjects;
    private JButton testButton;

    public Summary() {
        super("Summary", "Profile settings and test.");
    }

    public void applyState() {
        this.model.wizardComplete();
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public void prepareFields() {
        this.profileName.setText(this.model.getProfileName() + " ");
        this.profileType.setText(this.model.getProfileType().getDisplayString() + " ");
        this.hostname.setText(this.model.getHostname() + " ");
        if (this.model.isConnectByDns()) {
            this.hostnameLabel.setVisible(true);
            this.hostname.setVisible(true);
            for (Component component : this.connStruts) {
                component.setVisible(false);
            }
            this.ipListLabel.setVisible(false);
            this.ipList.setVisible(false);
        } else {
            this.ipListLabel.setVisible(true);
            this.ipList.setVisible(true);
            if (this.model.isAuthNamespace()) {
                this.hostnameLabel.setVisible(true);
                this.hostname.setVisible(true);
                for (Component component : this.connStruts) {
                    component.setVisible(true);
                }
            } else {
                this.hostnameLabel.setVisible(false);
                this.hostname.setVisible(false);
                for (Component component : this.connStruts) {
                    component.setVisible(false);
                }
            }
            List<String> ips = this.model.getIpAddressList();
            this.ipList.removeAll();
            for (String ip : ips) {
                this.ipList.add(new JLabel(ip));
            }
        }
        if (this.model.isSSLRequired()) {
            this.ssl.setText("Enabled ");
        } else {
            this.ssl.setText("Disabled ");
        }
        if (this.model.isAuthNamespace()) {
            for (Component component : this.accessObjects) {
                component.setVisible(true);
            }
            this.tenant.setText(this.model.getTenant() + " ");
            this.namespace.setText(this.model.getNamespace() + " ");
            if (this.model.isAnonymousAccess()) {
                this.anonAccess.setText(this.model.isAnonymousAccess() ? "Enabled " : "Disabled ");
                this.userLabel.setVisible(false);
                this.user.setVisible(false);
            } else {
                this.user.setText(this.model.getUsername() + " ");
                this.anonAccessLabel.setVisible(false);
            }
            this.isValidateCustomMetadata.setText(this.model.isValidateCustomMetadata() ? "Enabled " : "Disabled ");
        } else {
            for (Component component : this.accessObjects) {
                component.setVisible(false);
            }
        }
    }

    @Override
    protected void setupUI() {
        WizardUtils.Wrapper wrapper = WizardUtils.createWrapper();
        this.content = wrapper.getPanel();
        Box center = wrapper.getBox();
        JPanel form = new JPanel();
        GroupLayout layout = new GroupLayout(form);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        form.setLayout(layout);
        center.add(form);
        center.add(WizardUtils.createSpacer());
        Component spacer = Box.createHorizontalStrut(12);
        GroupLayout.ParallelGroup labels = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup values = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(labels).addComponent(spacer).addGroup(values));
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        layout.setVerticalGroup(vGroup);
        vGroup.addComponent(spacer);
        JLabel label = new JLabel("Profile Name");
        labels.addComponent(label);
        this.profileName = new JLabel();
        values.addComponent(this.profileName);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label).addComponent(this.profileName));
        label = new JLabel("Profile Type");
        labels.addComponent(label);
        this.profileType = new JLabel();
        values.addComponent(this.profileType);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label).addComponent(this.profileType));
        Box labelBox = Box.createVerticalBox();
        labels.addComponent(labelBox);
        Box valueBox = Box.createVerticalBox();
        values.addComponent(valueBox);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(labelBox).addComponent(valueBox));
        this.connStruts = new ArrayList<Component>();
        this.hostnameLabel = new JLabel("Domain Name");
        this.hostname = new JLabel();
        this.ipListLabel = new JLabel("IP Addresses");
        this.ipList = Box.createVerticalBox();
        labelBox.add(this.hostnameLabel);
        valueBox.add(this.hostname);
        Component strut = WizardUtils.createVerticalStrut(this.hostnameLabel, this.ipListLabel, this.content);
        this.connStruts.add(strut);
        labelBox.add(strut);
        strut = WizardUtils.createVerticalStrut(this.hostname, this.ipList, this.content);
        this.connStruts.add(strut);
        valueBox.add(strut);
        labelBox.add(this.ipListLabel);
        valueBox.add(this.ipList);
        label = new JLabel("SSL");
        labels.addComponent(label);
        this.ssl = new JLabel();
        values.addComponent(this.ssl);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label).addComponent(this.ssl));
        labelBox = Box.createVerticalBox();
        labels.addComponent(labelBox);
        valueBox = Box.createVerticalBox();
        values.addComponent(valueBox);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(labelBox).addComponent(valueBox));
        this.accessObjects = new ArrayList<Component>();
        this.tenantLabel = new JLabel("Tenant");
        this.tenant = new JLabel();
        this.namespaceLabel = new JLabel("Namespace");
        this.namespace = new JLabel();
        this.userLabel = new JLabel("Username");
        this.user = new JLabel();
        this.isValidateCustomMetadataLabel = new JLabel("Custom Metadata Validation");
        this.isValidateCustomMetadata = new JLabel();
        this.anonAccessLabel = new JLabel("Anonymous Access");
        this.anonAccess = new JLabel();
        this.testButton = new JButton();
        this.testButton.setText("Test");
        this.testButton.setToolTipText("Test connection settings");
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Summary.this.validate();
            }
        });
        labelBox.add(this.tenantLabel);
        this.accessObjects.add(this.tenantLabel);
        valueBox.add(this.tenant);
        this.accessObjects.add(this.tenant);
        strut = WizardUtils.createVerticalStrut(this.tenantLabel, this.namespaceLabel, this.content);
        this.accessObjects.add(strut);
        labelBox.add(strut);
        strut = WizardUtils.createVerticalStrut(this.tenant, this.namespace, this.content);
        this.accessObjects.add(strut);
        valueBox.add(strut);
        labelBox.add(this.namespaceLabel);
        this.accessObjects.add(this.namespaceLabel);
        valueBox.add(this.namespace);
        this.accessObjects.add(this.namespace);
        strut = WizardUtils.createVerticalStrut(this.namespaceLabel, this.userLabel, this.content);
        this.accessObjects.add(strut);
        labelBox.add(strut);
        strut = WizardUtils.createVerticalStrut(this.namespace, this.user, this.content);
        this.accessObjects.add(strut);
        valueBox.add(strut);
        labelBox.add(this.userLabel);
        this.accessObjects.add(this.userLabel);
        valueBox.add(this.user);
        this.accessObjects.add(this.user);
        strut = WizardUtils.createVerticalStrut(this.userLabel, this.isValidateCustomMetadataLabel, this.content);
        this.accessObjects.add(strut);
        labelBox.add(strut);
        strut = WizardUtils.createVerticalStrut(this.user, this.isValidateCustomMetadata, this.content);
        this.accessObjects.add(strut);
        valueBox.add(strut);
        labelBox.add(this.isValidateCustomMetadataLabel);
        this.accessObjects.add(this.isValidateCustomMetadataLabel);
        valueBox.add(this.isValidateCustomMetadata);
        this.accessObjects.add(this.isValidateCustomMetadata);
        strut = WizardUtils.createVerticalStrut(this.isValidateCustomMetadataLabel, this.anonAccessLabel, this.content);
        this.accessObjects.add(strut);
        labelBox.add(strut);
        strut = WizardUtils.createVerticalStrut(this.isValidateCustomMetadata, this.anonAccess, this.content);
        this.accessObjects.add(strut);
        valueBox.add(strut);
        labelBox.add(this.anonAccessLabel);
        this.accessObjects.add(this.anonAccessLabel);
        valueBox.add(this.anonAccess);
        this.accessObjects.add(this.anonAccess);
        strut = WizardUtils.createVerticalStrut(this.anonAccess, this.testButton, this.content);
        this.accessObjects.add(strut);
        valueBox.add(strut);
        valueBox.add(this.testButton);
        spacer = WizardUtils.createSpacer();
        values.addComponent(spacer);
        vGroup.addComponent(spacer);
    }

    private void validate() {
        this.content.setCursor(Cursor.getPredefinedCursor(3));
        String errorMsg = null;
        if (!this.model.isConnectByDns()) {
            errorMsg = this.validateIpAddressList();
        }
        if (errorMsg == null) {
            errorMsg = this.validateHostname();
        }
        if (errorMsg == null) {
            errorMsg = this.validatePort();
        }
        if (errorMsg == null) {
            errorMsg = this.validateConnection();
        }
        if (errorMsg != null) {
            LOG.log(Level.WARNING, errorMsg);
            GUIHelper.showMessageDialog(this.getContentPane(), errorMsg, "Error", 0);
        } else {
            JOptionPane.showMessageDialog(this.getContentPane(), "Connected successfully to the namespace", "Success", -1);
        }
        this.content.setCursor(Cursor.getDefaultCursor());
    }

    private String validateConnection() {
        String errorMsg = null;
        try {
            AbstractProfileBase profile = this.model.createProfileFromModel();
            boolean success = ArcMoverFactory.getInstance().testConnection(profile);
            if (!success) {
                if (this.model.isAuthNamespace()) {
                    Hcp3AuthNamespaceProfile authProfile = (Hcp3AuthNamespaceProfile)profile;
                    throw new ConnectionTestException(authProfile.getNamespace(), (String)null);
                }
                throw new ConnectionTestException();
            }
        }
        catch (ConnectionTestException e) {
            errorMsg = e.getMessage();
            LOG.log(Level.WARNING, errorMsg, e);
        }
        return errorMsg;
    }

    private String validateIpAddressList() {
        return this.model.validateIpList(this.model.getIpAddressList());
    }

    private String validateHostname() {
        StringBuilder domainBuilder = new StringBuilder();
        if (this.model.isAuthNamespace()) {
            domainBuilder.append(this.model.getNamespace());
            domainBuilder.append('.');
            domainBuilder.append(this.model.getTenant());
            domainBuilder.append('.');
        } else {
            domainBuilder.append("www.");
        }
        domainBuilder.append(this.model.getHostname());
        return this.model.validateHostname(domainBuilder.toString());
    }

    private String validatePort() {
        return this.model.validatePort(this.model.getPort());
    }
}

