/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.namespacewizard;

import com.archivas.clienttools.arcmover.gui.namespacewizard.AuthNamespaceSettings;
import com.archivas.clienttools.arcmover.gui.namespacewizard.ConnectionSettings;
import com.archivas.clienttools.arcmover.gui.namespacewizard.NamespaceProfileMgrDialog;
import com.archivas.clienttools.arcmover.gui.namespacewizard.NamespaceType;
import com.archivas.clienttools.arcmover.gui.namespacewizard.NamespaceWizardStep;
import com.archivas.clienttools.arcmover.gui.namespacewizard.ProfileName;
import com.archivas.clienttools.arcmover.gui.namespacewizard.Summary;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.HCAPProfile;
import com.archivas.clienttools.arcutils.profile.Hcp3AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.Hcp5AuthNamespaceProfile;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import com.archivas.clienttools.arcutils.profile.ProfileType;
import com.archivas.clienttools.arcutils.utils.DomainValidator;
import com.archivas.clienttools.arcutils.utils.database.ManagedJobsSchema;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.pietschy.wizard.OverviewProvider;
import org.pietschy.wizard.WizardStep;
import org.pietschy.wizard.models.Condition;
import org.pietschy.wizard.models.DynamicModel;

public class WizardModel
extends DynamicModel
implements OverviewProvider {
    private static final Logger LOG = Logger.getLogger(WizardModel.class.getName());
    public static final String NEWLINE = System.getProperty("line.separator");
    private Overview overview = null;
    private Map<WizardStep, Condition> conditionMap = new HashMap<WizardStep, Condition>();
    ProfileName profileNameForm = null;
    NamespaceType namespaceTypeForm = null;
    ConnectionSettings connectionSettingsForm = null;
    AuthNamespaceSettings authNamespaceSettingsForm = null;
    Summary summaryForm = null;
    AbstractProfileBase profile = null;
    NamespaceProfileMgrDialog parent = null;
    private boolean isCreateProfileAction;
    private String profileName = "";
    private String hostname = "";
    private Integer port = null;
    private List<String> ipAddressList = new ArrayList<String>();
    private boolean isSSLRequired = false;
    private String tenant = "";
    private String namespace = "";
    private String username = "";
    private String password = "";
    private ProfileType profileType = null;
    private boolean connectByDns = true;
    private boolean isAnonymousAccess = false;
    private boolean showAnonAccess = false;
    private boolean isValidateCustomMetadata = true;
    private String finalErrorMessage = null;
    private static Color BACKGROUND_GREY = new Color(240, 240, 240);

    public WizardModel(NamespaceProfileMgrDialog parent) {
        this.parent = parent;
        this.isCreateProfileAction = true;
        this.profileNameForm = new ProfileName();
        this.namespaceTypeForm = new NamespaceType();
        this.connectionSettingsForm = new ConnectionSettings();
        this.authNamespaceSettingsForm = new AuthNamespaceSettings();
        this.summaryForm = new Summary();
        this.add((WizardStep)this.profileNameForm);
        this.add((WizardStep)this.namespaceTypeForm);
        this.add((WizardStep)this.connectionSettingsForm);
        this.add((WizardStep)this.authNamespaceSettingsForm, new Condition(){

            public boolean evaluate(org.pietschy.wizard.WizardModel model) {
                return WizardModel.this.getProfileType() != null && WizardModel.this.getProfileType().isAuthNamespace();
            }
        });
        this.add((WizardStep)this.summaryForm);
    }

    public WizardModel(AbstractProfileBase profile, NamespaceProfileMgrDialog parent) {
        this(parent);
        this.profile = profile;
        this.isCreateProfileAction = false;
        this.setProfileName(profile.getName());
        this.setProfileType(profile.getType());
        if (profile instanceof HCAPProfile) {
            HCAPProfile hcapProfile = (HCAPProfile)profile;
            this.setConnectByDns(hcapProfile.isConnectByDns());
            this.setHostname(hcapProfile.getHostname());
            this.setIpAddressList(hcapProfile.getIpAddressList());
            this.setSSLRequired(hcapProfile.isSSLRequired());
            this.setPort(hcapProfile.getPort());
            this.setValidateCustomMetadata(hcapProfile.isValidateCustomMetadata());
        }
        if (profile instanceof Hcp3AuthNamespaceProfile) {
            Hcp3AuthNamespaceProfile authProfile = (Hcp3AuthNamespaceProfile)profile;
            this.tenant = authProfile.getTenant();
            this.namespace = authProfile.getNamespace();
            this.username = authProfile.getUsername();
            this.password = authProfile.getPassword();
            this.isAnonymousAccess = authProfile.isAnonymousAccess();
        }
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String validateProfileName(String newValue) {
        if (newValue == null || newValue.trim().length() < 1) {
            return "Profile name must have a value";
        }
        String errorMsg = null;
        newValue = newValue.trim();
        String currentProfileName = null;
        if (this.getProfile() != null) {
            currentProfileName = this.getProfile().getName();
        }
        if (this.doesProfileNameExist(newValue) && !newValue.equalsIgnoreCase(currentProfileName)) {
            errorMsg = "Profile already exists with name: " + newValue;
        } else if (newValue.length() > 100) {
            errorMsg = "Profile name must be no longer than 100 characters";
        }
        return errorMsg;
    }

    private boolean doesProfileNameExist(String profileName) {
        return ProfileManager.doesProfileNameExist(profileName);
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String validateHostname(String newValue) {
        newValue = newValue == null ? "" : newValue.trim();
        String errorMsg = null;
        if (this.isConnectByDns() || this.isAuthNamespace()) {
            errorMsg = newValue.isEmpty() ? "Domain name must have a value" : (this.validateIpString(newValue) == null ? "Domain name must not be an IP address" : DomainValidator.validate(newValue));
        }
        return errorMsg;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String validatePort(Integer newValue) {
        if (newValue != null && newValue < 0) {
            return "Port must not be negative";
        }
        return null;
    }

    public String validateIpList(List<String> ipList) {
        String errorMsg = null;
        if (ipList.size() < 1) {
            return "IP address must have a value";
        }
        for (String hostIP : ipList) {
            if (hostIP.matches("\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b")) continue;
            return "Invalid IP Address: " + hostIP;
        }
        return errorMsg;
    }

    public String validateIpString(String newValue) {
        if (newValue == null || newValue.trim().length() < 1) {
            return "IP address must have a value";
        }
        ArrayList<String> ipList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(newValue, ",");
        while (st.hasMoreTokens()) {
            ipList.add(st.nextToken().trim());
        }
        String errorMsg = this.validateIpList(ipList);
        if (errorMsg == null) {
            this.ipAddressList = ipList;
        }
        return errorMsg;
    }

    public List<String> getIpAddressList() {
        return this.ipAddressList;
    }

    public void setIpAddressList(List<String> ipAddressList) {
        this.ipAddressList = ipAddressList;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAuthNamespace() {
        return this.profileType != null && this.profileType.isAuthNamespace();
    }

    public ProfileType getProfileType() {
        return this.profileType;
    }

    public void setProfileType(ProfileType profileType) {
        if (this.isCreateProfileAction() && profileType != this.profileType) {
            if (profileType.isAuthNamespace()) {
                this.setSSLRequired(true);
            } else {
                this.setSSLRequired(false);
            }
        }
        this.profileType = profileType;
    }

    public boolean isSSLRequired() {
        return this.isSSLRequired;
    }

    public void setSSLRequired(boolean SSLRequired) {
        this.isSSLRequired = SSLRequired;
    }

    public boolean isConnectByDns() {
        return this.connectByDns;
    }

    public void setConnectByDns(boolean connectByDns) {
        this.connectByDns = connectByDns;
    }

    public boolean isCreateProfileAction() {
        return this.isCreateProfileAction;
    }

    public boolean isAnonymousAccess() {
        return this.isAnonymousAccess && this.showAnonAccess;
    }

    public void setAnonymousAccess(boolean isAnonymousAccess) {
        this.isAnonymousAccess = isAnonymousAccess;
    }

    public boolean showAnonymousOption() {
        return this.showAnonAccess;
    }

    public void setShowAnonymousOption(boolean showAnonymousOption) {
        this.showAnonAccess = showAnonymousOption;
    }

    public boolean isValidateCustomMetadata() {
        return this.isValidateCustomMetadata;
    }

    public void setValidateCustomMetadata(boolean validateCustomMetadata) {
        this.isValidateCustomMetadata = validateCustomMetadata;
    }

    public void wizardComplete() {
        AbstractProfileBase newProfile = null;
        try {
            if (!this.allStepsComplete()) {
                return;
            }
            newProfile = this.createProfileFromModel();
            try {
                ProfileManager.saveProfile(newProfile);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error updating/saving profile '" + newProfile + "'", e);
                this.finalErrorMessage = "An unexpected error occurred saving the profile.";
                return;
            }
            try {
                if (this.profile != null && !this.profile.getName().equals(newProfile.getName())) {
                    ManagedJobsSchema.getInstance().changeProfileName(this.profile.getName(), newProfile.getName());
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error changing profile name in saved jobs", e);
                this.finalErrorMessage = "An unexpected error occurred updating the profile name in saved jobs";
                return;
            }
            try {
                if (this.profile != null) {
                    ProfileManager.deleteProfile(this.profile, false);
                }
                this.profile = newProfile;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error deleting old Profile: " + this.profile, e);
                this.finalErrorMessage = "An unexpected error occurred deleting the old version of the profile.";
            }
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Error updating/saving new Profile: " + newProfile, e);
            throw e;
        }
        this.parent.refresh();
    }

    public AbstractProfileBase createProfileFromModel() {
        HCAPProfile newProfile = (HCAPProfile)ProfileManager.getInstance().createProfile(this.getProfileType());
        newProfile.setName(this.getProfileName());
        newProfile.setHostname(this.getHostname());
        newProfile.setConnectByDns(this.isConnectByDns());
        if (!this.isConnectByDns()) {
            newProfile.setIpAddressList(this.getIpAddressList());
        }
        newProfile.setSSLRequired(this.isSSLRequired());
        newProfile.setPort(this.getPort());
        newProfile.setValidateCustomMetadata(this.isValidateCustomMetadata());
        if (this.getProfileType().isAuthNamespace()) {
            Hcp3AuthNamespaceProfile authProfile = (Hcp3AuthNamespaceProfile)newProfile;
            authProfile.setTenant(this.getTenant());
            authProfile.setNamespace(this.getNamespace());
            authProfile.setUsername(this.getUsername());
            authProfile.setPassword(this.getPassword());
        }
        if (this.getProfileType().supportsAnonymousAccess()) {
            Hcp5AuthNamespaceProfile hcp5Profile = (Hcp5AuthNamespaceProfile)newProfile;
            hcp5Profile.setAnonymousAccess(this.isAnonymousAccess());
        }
        return newProfile;
    }

    public AbstractProfileBase getProfile() {
        return this.profile;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StaticProfileModel");
        sb.append("{profile=").append(this.profile);
        sb.append(", profileType=").append((Object)this.profileType);
        sb.append(", profileName='").append(this.profileName).append('\'');
        sb.append(", hostname='").append(this.hostname).append('\'');
        sb.append(", port='").append(this.port).append('\'');
        sb.append(", ipAddressList=").append(this.ipAddressList);
        sb.append(", isValidateCustomMetadata=").append(this.isValidateCustomMetadata);
        sb.append(", isSSLRequired=").append(this.isSSLRequired);
        sb.append(", tenant='").append(this.tenant).append('\'');
        sb.append(", namespace='").append(this.namespace).append('\'');
        sb.append(", username='").append(this.username).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public JComponent getOverviewComponent() {
        if (this.overview == null) {
            this.overview = new Overview(this);
        }
        return this.overview;
    }

    public void add(WizardStep step, Condition condition) {
        super.add(step, condition);
        if (condition != TRUE_CONDITION) {
            this.conditionMap.put(step, condition);
        }
    }

    public String getFinalErrorMessage() {
        return this.finalErrorMessage;
    }

    private class Overview
    extends JPanel {
        private WizardModel model;
        private HashMap<WizardStep, JLabel> labels = new HashMap();

        private void update(JLabel oldLabel, JLabel newLabel) {
            for (WizardStep step : this.model.conditionMap.keySet()) {
                Condition condition = (Condition)this.model.conditionMap.get(step);
                JLabel label = this.labels.get(step);
                label.setEnabled(condition.evaluate((org.pietschy.wizard.WizardModel)this.model));
            }
            if (oldLabel != null) {
                oldLabel.setBackground(Color.WHITE);
            }
            if (newLabel != null) {
                newLabel.setBackground(BACKGROUND_GREY);
            }
        }

        private Runnable getUpdateRunner(final JLabel oldLabel, final JLabel newLabel) {
            return new Runnable(){

                @Override
                public void run() {
                    Overview.this.update(oldLabel, newLabel);
                }
            };
        }

        public Overview(WizardModel wizardModel2) {
            this.model = wizardModel2;
            this.model.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("activeStep".equals(evt.getPropertyName())) {
                        JLabel oldLabel = evt.getOldValue() instanceof NamespaceWizardStep ? (JLabel)Overview.this.labels.get(evt.getOldValue()) : null;
                        JLabel newLabel = evt.getNewValue() instanceof NamespaceWizardStep ? (JLabel)Overview.this.labels.get(evt.getNewValue()) : null;
                        if (SwingUtilities.isEventDispatchThread()) {
                            Overview.this.update(oldLabel, newLabel);
                        } else {
                            GUIHelper.invokeAndWait(Overview.this.getUpdateRunner(oldLabel, newLabel), "update profile overview");
                        }
                    }
                }
            });
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.setLayout(new BoxLayout(this, 3));
            JLabel title = new JLabel("<html><b>Overview</b></html>");
            title.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
            this.add(title);
            int i = 1;
            Iterator stepIterator = this.model.stepIterator();
            while (stepIterator.hasNext()) {
                WizardStep step = (WizardStep)stepIterator.next();
                JLabel label = new JLabel(String.format("%d. %s", i++, step.getName()));
                label.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
                label.setBackground(Color.WHITE);
                label.setOpaque(true);
                this.add(label);
                this.labels.put(step, label);
            }
            this.add(Box.createGlue());
        }
    }
}

