/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.namespacewizard;

import com.archivas.clienttools.arcmover.gui.namespacewizard.NamespaceWizardStep;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WizardUtils {
    public static final Dimension MIN = new Dimension(0, 0);
    public static final Dimension MAX = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final int SPACER_SIZE = 12;
    private static final int MIN_HEIGHT = 432;

    public static Component createSpacer() {
        return new Box.Filler(MIN, MAX, MAX);
    }

    public static Wrapper createWrapper() {
        JPanel outer = new JPanel(new BorderLayout());
        outer.add((Component)new JLabel(" "), "North");
        Box inner = Box.createVerticalBox();
        outer.add((Component)inner, "Center");
        outer.setPreferredSize(new Dimension(0, 432));
        return new Wrapper(outer, inner);
    }

    public static KeyStroke getEscapeKeystroke() {
        return KeyStroke.getKeyStroke(27, 0);
    }

    public static DocumentListener createCompletionDocumentListener(final NamespaceWizardStep step) {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                step.updateComplete();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                step.updateComplete();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                step.updateComplete();
            }
        };
    }

    public static ItemListener createCompletionItemListener(final NamespaceWizardStep step) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                step.updateComplete();
            }
        };
    }

    public static Component createVerticalStrut(JComponent first, JComponent second, Container container) {
        int height = LayoutStyle.getInstance().getPreferredGap(first, second, LayoutStyle.ComponentPlacement.RELATED, 5, container);
        return Box.createVerticalStrut(height);
    }

    public static Component createHorizontalStrut(JComponent first, JComponent second, Container container) {
        int width = LayoutStyle.getInstance().getPreferredGap(first, second, LayoutStyle.ComponentPlacement.RELATED, 3, container);
        return Box.createHorizontalStrut(width);
    }

    public static class Wrapper {
        private JPanel panel;
        private Box box;

        public Wrapper(JPanel panel, Box box) {
            this.panel = panel;
            this.box = box;
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public Box getBox() {
            return this.box;
        }
    }
}

