/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.panels;

import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DeleteOptionsPanel
extends JPanel {
    private static final String DELETE_OPTION_TEXT = "Delete";
    private static final String PURGE_OPTION_TEXT = "Purge";
    private static final String PRIV_DELETE_OPTION_TEXT = "Privileged Delete";
    private static final String PRIV_PURGE_OPTION_TEXT = "Privileged Purge";
    private TitledBorder operationTitle = new TitledBorder("Operation");
    private TitledBorder reasonTitleBorder = new TitledBorder("Reason");
    private JRadioButton deleteRadio = new JRadioButton("Delete");
    private JRadioButton purgeRadio = new JRadioButton("Purge");
    private JRadioButton privDeleteRadio = new JRadioButton("Privileged Delete");
    private JRadioButton privPurgeRadio = new JRadioButton("Privileged Purge");
    private JTextArea reasonArea = new JTextArea();
    private JLabel reasonDescriptionLabel = new JLabel("For privileged operations, you must enter a reason (up to 1024 characters)");
    private JPanel reasonPanel;
    private JobDialog jobDialog;

    public DeleteOptionsPanel(JobDialog jobDialog, DeleteJob deleteJob) {
        this.jobDialog = jobDialog;
        this.layoutGuiComponents();
        this.initState(deleteJob.getOperation(), deleteJob.getReason());
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteOptionsPanel.this.onOperationChange();
                DeleteOptionsPanel.this.fieldChanged();
            }
        };
        this.deleteRadio.addActionListener(l);
        this.purgeRadio.addActionListener(l);
        this.privDeleteRadio.addActionListener(l);
        this.privPurgeRadio.addActionListener(l);
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DeleteOptionsPanel.this.fieldChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DeleteOptionsPanel.this.fieldChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DeleteOptionsPanel.this.fieldChanged();
            }
        };
        this.reasonArea.getDocument().addDocumentListener(docListener);
    }

    private void layoutGuiComponents() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.deleteRadio);
        buttonGroup.add(this.purgeRadio);
        buttonGroup.add(this.privDeleteRadio);
        buttonGroup.add(this.privPurgeRadio);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 1));
        radioPanel.setBorder(new CompoundBorder(this.operationTitle, new EmptyBorder(5, 5, 5, 5)));
        radioPanel.add(GUIHelper.createFixedHeightPanel(this.deleteRadio, true));
        radioPanel.add(GUIHelper.createFixedHeightPanel(this.purgeRadio, true));
        radioPanel.add(GUIHelper.createFixedHeightPanel(this.privDeleteRadio, true));
        radioPanel.add(GUIHelper.createFixedHeightPanel(this.privPurgeRadio, true));
        radioPanel.add(Box.createVerticalGlue());
        this.reasonPanel = new JPanel();
        this.reasonPanel.setLayout(new BoxLayout(this.reasonPanel, 1));
        this.reasonPanel.setBorder(new CompoundBorder(this.reasonTitleBorder, new EmptyBorder(5, 5, 5, 5)));
        this.reasonPanel.add(this.reasonArea);
        this.reasonPanel.add(Box.createVerticalStrut(17));
        this.reasonPanel.add(GUIHelper.createFixedHeightPanel(this.reasonDescriptionLabel, true));
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.add(radioPanel);
        this.add(Box.createVerticalStrut(25));
        this.add(this.reasonPanel);
        this.add(Box.createVerticalGlue());
    }

    private void fieldChanged() {
        if (this.jobDialog != null) {
            this.jobDialog.fieldChanged();
        }
    }

    public void enablePanel(boolean enabled) {
        this.deleteRadio.setEnabled(enabled);
        this.purgeRadio.setEnabled(enabled);
        this.privDeleteRadio.setEnabled(enabled);
        this.privPurgeRadio.setEnabled(enabled);
        this.enableReasonFields(enabled && this.getOperation().isPrivilegedOperation());
    }

    private void enableReasonFields(boolean enabled) {
        GUIHelper.enableComponent(this.reasonPanel, enabled);
        this.reasonTitleBorder.setTitleColor(enabled ? GUIHelper.ENABLED_TITLE_COLOR : GUIHelper.DISABLED_TITLE_COLOR);
    }

    private void initState(DeleteJob.Operation operation, String reason) {
        switch (operation) {
            default: {
                this.deleteRadio.setSelected(true);
                break;
            }
            case PURGE: {
                this.purgeRadio.setSelected(true);
                break;
            }
            case PRIVILEGED_DELETE: {
                this.privDeleteRadio.setSelected(true);
                break;
            }
            case PRIVILEGED_PURGE: {
                this.privPurgeRadio.setSelected(true);
            }
        }
        if (reason != null) {
            this.reasonArea.setText(reason.trim());
        }
        this.enableReasonFields(this.getOperation().isPrivilegedOperation());
    }

    private void onOperationChange() {
        this.enableReasonFields(this.getOperation().isPrivilegedOperation());
    }

    public String getReason() {
        if (this.privDeleteRadio.isSelected() || this.privPurgeRadio.isSelected()) {
            return this.reasonArea.getText().trim();
        }
        return null;
    }

    public DeleteJob.Operation getOperation() {
        if (this.deleteRadio.isSelected()) {
            return DeleteJob.Operation.DELETE;
        }
        if (this.purgeRadio.isSelected()) {
            return DeleteJob.Operation.PURGE;
        }
        if (this.privDeleteRadio.isSelected()) {
            return DeleteJob.Operation.PRIVILEGED_DELETE;
        }
        if (this.privPurgeRadio.isSelected()) {
            return DeleteJob.Operation.PRIVILEGED_PURGE;
        }
        return DeleteJob.Operation.DELETE;
    }

    public static void main(String[] args) {
        DeleteOptionsPanel p = new DeleteOptionsPanel(null, new DeleteJob());
        JFrame f = new JFrame();
        f.add(p);
        f.pack();
        f.setLocation(100, 800);
        f.setSize(new Dimension(700, 500));
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setVisible(true);
    }
}

