/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.panels;

import com.archivas.clienttools.arcmover.gui.panels.FixedHeightPanel;
import com.archivas.clienttools.arcmover.gui.panels.ItemsPanel;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcmover.gui.util.PlainFontLabel;
import com.archivas.clienttools.arcutils.api.jobs.CopyJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class InitialImportFilePanel
extends ItemsPanel {
    public static Logger LOG = Logger.getLogger(InitialImportFilePanel.class.getName());
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final int MAX_DISPLAY_LINES = 1000;
    private JTextArea displayArea;
    private JLabel importFileValue;

    public InitialImportFilePanel(ManagedJob managedJob) {
        this.layoutGuiComponents();
        this.setImportFile(managedJob.getListFile());
    }

    private void layoutGuiComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(25, 25, 25, 25));
        this.importFileValue = new PlainFontLabel();
        FixedHeightPanel labelPanel = new FixedHeightPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(new JLabel("File:"));
        labelPanel.add(Box.createHorizontalStrut(12));
        labelPanel.add(this.importFileValue);
        labelPanel.add(Box.createHorizontalGlue());
        this.displayArea = new JTextArea();
        this.displayArea.setEditable(false);
        this.displayArea.setForeground(Color.GRAY);
        JScrollPane scrollPane = new JScrollPane(this.displayArea);
        this.add(labelPanel);
        this.add(Box.createVerticalStrut(17));
        this.add(scrollPane);
    }

    private void setImportFile(File importFile) {
        this.importFileValue.setText(importFile.getAbsolutePath());
        try {
            this.displayFileContents(importFile);
        }
        catch (FileNotFoundException fnfe) {
            String msg = "file " + importFile.getAbsolutePath() + " could not be found";
            GUIHelper.showMessageDialog(this, msg, "Error reading file", 0);
        }
        catch (Exception e) {
            String msg = DBUtils.getErrorMessage("An error occurred reading file " + importFile.getAbsolutePath(), e);
            LOG.log(Level.WARNING, msg, e);
            GUIHelper.showMessageDialog(this, msg, "Error reading file", 0);
        }
    }

    private void displayFileContents(File importFile) throws IOException {
        this.displayArea.setText("");
        StringBuilder sb = new StringBuilder();
        BufferedReader in = new BufferedReader(new FileReader(importFile));
        String line = in.readLine();
        for (int i = 0; i < 1000 && line != null; ++i) {
            sb.append(line).append(NEWLINE);
            line = in.readLine();
        }
        this.displayArea.setText(sb.toString());
    }

    @Override
    public void setFileFont(Font f) {
        this.displayArea.setFont(f);
    }

    public static void main(String[] args) {
        CopyJob copyJob = new CopyJob();
        copyJob.setListFile(new File("/home/bioakimidis/ibm/readme.txt"));
        InitialImportFilePanel p = new InitialImportFilePanel(copyJob);
        JFrame f = new JFrame();
        f.add(p);
        f.pack();
        f.setLocation(100, 800);
        f.setSize(new Dimension(700, 500));
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setVisible(true);
    }
}

