/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.panels;

import com.archivas.clienttools.arcmover.gui.panels.ItemsPanel;
import com.archivas.clienttools.arcmover.gui.util.FileListCellRenderer;
import com.archivas.clienttools.arcutils.api.jobs.CopyJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class InitialSelectedItemsPanel
extends ItemsPanel {
    public static final int MAX_ITEMS = 1000;
    private JList itemsList;
    private List<ArcProcessFile> initialDiscoveryList;

    public InitialSelectedItemsPanel(ManagedJob managedJob) throws DatabaseException {
        this.layoutGuiComponents();
        this.setItems(managedJob.getInitialDiscoveryList());
    }

    private void layoutGuiComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.itemsList = new JList();
        this.itemsList.setCellRenderer(new FileListCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.itemsList);
        this.add(scrollPane);
    }

    private void setItems(List<ArcProcessFile> items) {
        if (items.size() > 1000) {
            throw new IllegalArgumentException(String.format("There are %d items in the list.  The maximum number is %d.", items.size(), 1000));
        }
        this.initialDiscoveryList = items;
        this.itemsList.setListData(items.toArray());
    }

    public List<ArcProcessFile> getItems() {
        return this.initialDiscoveryList;
    }

    @Override
    public void setFileFont(Font f) {
        this.itemsList.setFont(f);
    }

    public static void main(String[] args) throws DatabaseException {
        InitialSelectedItemsPanel p = new InitialSelectedItemsPanel(new CopyJob());
        JFrame f = new JFrame();
        f.add(p);
        f.pack();
        f.setLocation(100, 800);
        f.setSize(new Dimension(700, 500));
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setVisible(true);
    }
}

