/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.panels;

import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcmover.gui.util.PlainFontLabel;
import com.archivas.clienttools.arcutils.api.JobStatus;
import com.archivas.clienttools.arcutils.api.ManagedJobStats;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.impl.jobs.FileStats;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.clienttools.arcutils.utils.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class JobProgressPanel
extends JPanel {
    public static Logger LOG = Logger.getLogger(JobProgressPanel.class.getName());
    private static final String NAME_COL = "Name";
    private static final String SIZE_COL = "Size (KB)";
    private static final String ELAPSED_TIME_COL = "Elapsed Time";
    private static final String START_TIME_COL = "Start Time";
    private static final String END_TIME_COL = "End Time";
    private static final String REASON_COL = "Reason";
    private DateFormat dateFormat = DateFormat.getInstance();
    private DecimalFormat decimalFormat = new DecimalFormat("0.00");
    private JobStatus currentJobStatus;
    private PlainFontLabel discoveredObjectsValue = new PlainFontLabel("");
    private PlainFontLabel selectedObjectsValue = new PlainFontLabel("");
    private PlainFontLabel selectedSizeValue = new PlainFontLabel("");
    private PlainFontLabel startTimeValue = new PlainFontLabel("");
    private PlainFontLabel elapsedTimeValue = new PlainFontLabel("");
    private PlainFontLabel pendingValue = new PlainFontLabel("");
    private PlainFontLabel successValue = new PlainFontLabel("");
    private PlainFontLabel failValue = new PlainFontLabel("");
    private PlainFontLabel failDirValue = new PlainFontLabel("");
    private PlainFontLabel objectsPerSecValue = new PlainFontLabel("");
    private PlainFontLabel bytesPerSecValue = new PlainFontLabel("");
    private JProgressBar progressBar;
    private NumberFormat numberFormat;
    private JTable processingTable;
    private JTable completedTable;
    private JTable errorTable;
    private ProcessingTableModel processingModel;
    private CompletedTableModel completedModel;
    private ErrorTableModel errorModel;
    private static int MIN_TABLE_HEIGHT = 36;
    private static ManagedJob.Type jobType;

    public JobProgressPanel(JobStatus jobStatus, ManagedJob.Type jobType) {
        this.currentJobStatus = jobStatus;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(true);
        JobProgressPanel.jobType = jobType;
        this.processingModel = new ProcessingTableModel();
        this.completedModel = new CompletedTableModel();
        this.errorModel = new ErrorTableModel();
        this.initGuiComponents();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                JobProgressPanel.this.resizeTables();
            }
        });
    }

    public void resizeTables() {
        GUIHelper.autoResizeColWidth(this.processingTable);
        GUIHelper.autoResizeColWidth(this.completedTable);
        GUIHelper.autoResizeColWidth(this.errorTable);
    }

    private void initGuiComponents() {
        JPanel leftPanel = new JPanel();
        int rowCnt = jobType == ManagedJob.Type.COPY ? 5 : 4;
        leftPanel.setLayout(new GridLayout(rowCnt, 2));
        switch (jobType) {
            case COPY: {
                leftPanel.add(new JLabel("Total objects to copy:   "));
                leftPanel.add(this.selectedObjectsValue);
                leftPanel.add(new JLabel("Total data size to copy:   "));
                leftPanel.add(this.selectedSizeValue);
                leftPanel.add(new JLabel("Start or resume time:   "));
                leftPanel.add(this.startTimeValue);
                leftPanel.add(new JLabel("Run time:   "));
                leftPanel.add(this.elapsedTimeValue);
                leftPanel.add(new JLabel(""));
                leftPanel.add(new JLabel(""));
                break;
            }
            case DELETE: {
                leftPanel.add(new JLabel("Total objects to delete:   "));
                leftPanel.add(this.selectedObjectsValue);
                leftPanel.add(new JLabel("Start or resume time:   "));
                leftPanel.add(this.startTimeValue);
                leftPanel.add(new JLabel("Run time:   "));
                leftPanel.add(this.elapsedTimeValue);
                leftPanel.add(new JLabel(""));
                leftPanel.add(new JLabel(""));
                break;
            }
            case SET_METADATA: {
                leftPanel.add(new JLabel("Total objects to update:   "));
                leftPanel.add(this.selectedObjectsValue);
                leftPanel.add(new JLabel("Start or resume time:   "));
                leftPanel.add(this.startTimeValue);
                leftPanel.add(new JLabel("Run time:   "));
                leftPanel.add(this.elapsedTimeValue);
                leftPanel.add(new JLabel(""));
                leftPanel.add(new JLabel(""));
            }
        }
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new GridLayout(rowCnt, 2));
        rightPanel.add(new JLabel("Objects found:   "));
        rightPanel.add(this.discoveredObjectsValue);
        rightPanel.add(new JLabel("Objects pending:   "));
        rightPanel.add(this.pendingValue);
        rightPanel.add(new JLabel("Objects succeeded:   "));
        rightPanel.add(this.successValue);
        rightPanel.add(new JLabel("Objects failed:   "));
        rightPanel.add(this.failValue);
        if (jobType == ManagedJob.Type.COPY) {
            rightPanel.add(new JLabel("Directories failed:   "));
            rightPanel.add(this.failDirValue);
        }
        JPanel metricsPanel = new JPanel();
        metricsPanel.setLayout(new BoxLayout(metricsPanel, 0));
        metricsPanel.setBorder(new CompoundBorder(new TitledBorder("Metrics"), new EmptyBorder(12, 12, 12, 12)));
        metricsPanel.add(leftPanel);
        metricsPanel.add(Box.createHorizontalStrut(25));
        metricsPanel.add(rightPanel);
        JPanel transferRatePanel = new JPanel();
        transferRatePanel.setLayout(new BoxLayout(transferRatePanel, 0));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("Objects per second:"));
        p.add(Box.createHorizontalStrut(12));
        p.add(this.objectsPerSecValue);
        p.add(Box.createHorizontalGlue());
        transferRatePanel.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("Data transferred per second:"));
        p.add(Box.createHorizontalStrut(12));
        p.add(this.bytesPerSecValue);
        p.add(Box.createHorizontalGlue());
        transferRatePanel.add(p);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setToolTipText("Overall Job Progress");
        JPanel progressAndPerfPanel = new JPanel();
        progressAndPerfPanel.setLayout(new BoxLayout(progressAndPerfPanel, 1));
        progressAndPerfPanel.add(transferRatePanel);
        progressAndPerfPanel.add(Box.createVerticalStrut(5));
        progressAndPerfPanel.add(this.progressBar);
        progressAndPerfPanel.setBorder(new CompoundBorder(new TitledBorder("Progress and Performance"), new EmptyBorder(12, 12, 12, 12)));
        JTabbedPane tabbedPane = new JTabbedPane();
        Dimension scrollSize = new Dimension(Integer.MAX_VALUE, MIN_TABLE_HEIGHT);
        Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.processingTable = new JTable(this.processingModel);
        this.processingTable.setCellSelectionEnabled(false);
        this.processingTable.setFillsViewportHeight(true);
        this.processingTable.setMaximumSize(maxSize);
        this.processingTable.setAutoResizeMode(0);
        JPanel processingTab = new JPanel();
        processingTab.setLayout(new BoxLayout(processingTab, 1));
        JScrollPane processingScrollPane = new JScrollPane(this.processingTable);
        processingScrollPane.getViewport().setPreferredSize(scrollSize);
        processingScrollPane.getViewport().setMaximumSize(maxSize);
        processingTab.add(processingScrollPane);
        tabbedPane.addTab("Processing", null, processingTab, "File(s) still to be copied");
        this.completedTable = new JTable(this.completedModel);
        this.completedTable.setCellSelectionEnabled(false);
        this.completedTable.setFillsViewportHeight(true);
        this.completedTable.setMaximumSize(maxSize);
        this.completedTable.setAutoResizeMode(0);
        JPanel completedTab = new JPanel();
        completedTab.setLayout(new BoxLayout(completedTab, 1));
        JScrollPane completedScrollPane = new JScrollPane(this.completedTable);
        completedScrollPane.getViewport().setPreferredSize(scrollSize);
        completedScrollPane.getViewport().setMaximumSize(maxSize);
        completedTab.add(completedScrollPane);
        tabbedPane.addTab("Succeeded", null, completedTab, "File(s) transferred succesfully");
        this.errorTable = new JTable(this.errorModel);
        this.errorTable.setCellSelectionEnabled(false);
        this.errorTable.setFillsViewportHeight(true);
        this.errorTable.setMaximumSize(maxSize);
        this.errorTable.setAutoResizeMode(0);
        JPanel errorTab = new JPanel();
        errorTab.setLayout(new BoxLayout(errorTab, 1));
        JScrollPane errorScrollPane = new JScrollPane(this.errorTable);
        errorScrollPane.getViewport().setPreferredSize(scrollSize);
        errorScrollPane.getViewport().setMaximumSize(maxSize);
        errorTab.add(errorScrollPane);
        tabbedPane.addTab("Failed", null, errorTab, "Failed file(s)");
        JPanel detailedStatusPanel = new JPanel();
        detailedStatusPanel.setLayout(new BoxLayout(detailedStatusPanel, 1));
        detailedStatusPanel.setBorder(new CompoundBorder(new TitledBorder("Additional Details"), new EmptyBorder(12, 12, 12, 12)));
        detailedStatusPanel.setMaximumSize(maxSize);
        detailedStatusPanel.add(tabbedPane);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 1));
        subPanel.add(metricsPanel);
        subPanel.add(Box.createVerticalStrut(25));
        subPanel.add(progressAndPerfPanel);
        subPanel.add(Box.createVerticalStrut(25));
        subPanel.add(detailedStatusPanel);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setLayout(new ScrollPaneLayout());
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setViewportView(subPanel);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(25, 25, 25, 25));
        this.add(scrollPane);
    }

    public void disableAll() {
        if (this.progressBar.isIndeterminate()) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(0);
        }
    }

    public void updateProgress(ManagedJobImpl.JobDetails jobDetails) {
        JobStatus newStatus = this.currentJobStatus;
        if (jobDetails != null) {
            newStatus = jobDetails.getJobStats().getStatus();
        }
        this.updateStatus(this.currentJobStatus, newStatus, jobDetails);
        this.currentJobStatus = newStatus;
    }

    private void updateStatus(JobStatus oldStatus, JobStatus newStatus, ManagedJobImpl.JobDetails jobDetails) {
        ManagedJobStats jobStats = null;
        if (jobDetails != null) {
            jobStats = jobDetails.getJobStats();
        }
        this.updateProgressAndPerformanceArea(newStatus, jobStats);
        this.updateMetricsArea(newStatus, jobStats);
        this.processingModel.updateStatus(oldStatus, newStatus, jobDetails);
        this.completedModel.updateStatus(oldStatus, newStatus, jobDetails);
        this.errorModel.updateStatus(oldStatus, newStatus, jobDetails);
        this.resizeTables();
    }

    private void updateMetricsArea(JobStatus newStatus, ManagedJobStats jobStats) {
        if (!newStatus.hasNeverBeenRun() && jobStats != null) {
            this.selectedObjectsValue.setText(this.numberFormat.format(jobStats.getTotalObjectCount()));
            this.selectedObjectsValue.setEnabled(jobStats.isFindFinished());
            this.selectedSizeValue.setText(StringUtils.bytesToStringWithUnit(jobStats.getTotalBytes(), this.decimalFormat));
            this.selectedSizeValue.setEnabled(jobStats.isFindFinished());
            this.discoveredObjectsValue.setText(this.numberFormat.format(jobStats.getDiscoveredObjectCount()));
            this.discoveredObjectsValue.setEnabled(jobStats.isFindFinished());
            if (jobStats.getStartTime() != null) {
                this.startTimeValue.setText(this.dateFormat.format(jobStats.getStartTime()));
            }
            long totalCnt = jobStats.getTotalObjectCount();
            long totalSize = jobStats.getTotalBytes();
            long successCnt = jobStats.getCompletedObjectCount();
            long successSize = jobStats.getCompletedBytes();
            long failCnt = jobStats.getErroredObjectCount();
            long failDirCnt = jobStats.getErroredDirCount();
            long failSize = jobStats.getErroredBytes();
            long pendingCnt = Math.max(0L, totalCnt - (successCnt + failCnt));
            long pendingSize = Math.max(0L, totalSize - (successSize + failSize));
            String pendingCntStr = this.numberFormat.format(pendingCnt) + (jobType != ManagedJob.Type.COPY ? "" : " (" + StringUtils.bytesToStringWithUnit(pendingSize, this.decimalFormat) + ")");
            String sucessCntStr = this.numberFormat.format(successCnt) + (jobType != ManagedJob.Type.COPY ? "" : " (" + StringUtils.bytesToStringWithUnit(successSize, this.decimalFormat) + ")");
            String failCntStr = this.numberFormat.format(failCnt) + (jobType != ManagedJob.Type.COPY ? "" : " (" + StringUtils.bytesToStringWithUnit(failSize, this.decimalFormat) + ")");
            this.elapsedTimeValue.setText(StringUtils.secondsToStringWithUnits(JobProgressPanel.getElapsedSeconds(jobStats)));
            this.pendingValue.setText(pendingCntStr);
            this.pendingValue.setEnabled(jobStats.isFindFinished());
            this.successValue.setText(sucessCntStr);
            this.failValue.setText(failCntStr);
            this.failDirValue.setText(this.numberFormat.format(failDirCnt));
        }
    }

    private void updateProgressAndPerformanceArea(JobStatus jobStatus, ManagedJobStats jobStats) {
        if (jobStatus.hasNeverBeenRun()) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(0);
        } else if (jobStatus.isRunning()) {
            if (jobStats != null && jobStats.isFindFinished()) {
                int progressPercent = this.getProgressPercent(jobStats);
                if (progressPercent < 1) {
                    this.progressBar.setIndeterminate(true);
                } else {
                    this.progressBar.setIndeterminate(false);
                    this.progressBar.setValue(progressPercent);
                }
            } else {
                this.progressBar.setIndeterminate(true);
            }
            if (jobStats != null) {
                this.objectsPerSecValue.setText(this.decimalFormat.format(jobStats.getCurrentThroughputCnt()));
                this.bytesPerSecValue.setText(StringUtils.bytesToStringWithUnit((long)jobStats.getCurrentThroughputBytes(), this.decimalFormat));
            }
        } else if (jobStatus.isPaused()) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(this.getProgressPercent(jobStats));
            this.objectsPerSecValue.setText("");
            this.bytesPerSecValue.setText("");
        } else if (jobStatus.isFinished()) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(100);
            this.objectsPerSecValue.setText("");
            this.bytesPerSecValue.setText("");
        }
    }

    public void setFileFont(Font font) {
        this.setFileFont(this.processingTable, font);
        this.setFileFont(this.completedTable, font);
        this.setFileFont(this.errorTable, font);
    }

    private void setFileFont(JTable table, final Font font) {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                c.setFont(font);
                return c;
            }
        };
        table.getColumn(NAME_COL).setCellRenderer(renderer);
        this.repaint();
    }

    private int getProgressPercent(ManagedJobStats jobStats) {
        int ret = 0;
        if (jobStats != null) {
            double objectsProcessed = jobStats.getCompletedObjectCount() + jobStats.getErroredObjectCount();
            double bytesProcessed = jobStats.getCompletedBytes() + jobStats.getErroredBytes();
            double progress = bytesProcessed != 0.0 ? bytesProcessed / (double)jobStats.getTotalBytes() * 100.0 : objectsProcessed / (double)jobStats.getTotalObjectCount() * 100.0;
            ret = (int)progress;
        }
        return ret;
    }

    private static long getElapsedSeconds(ManagedJobStats jobStats) {
        return Math.max(1L, jobStats.getRunTimeMs() / 1000L);
    }

    private static boolean listChanged(List<FileStats> oldList, List<FileStats> newList) {
        if (newList == null && oldList != null || newList != null && oldList == null) {
            return true;
        }
        if (newList == null) {
            return false;
        }
        return oldList.size() != newList.size() || !oldList.isEmpty() && !oldList.get(oldList.size() - 1).equals(newList.get(newList.size() - 1));
    }

    private class ErrorTableModel
    extends AbstractTableModel {
        protected final String[] copyCols = new String[]{"Name", "Size (KB)", "Elapsed Time", "Start Time", "End Time", "Reason"};
        protected final String[] deleteCols = new String[]{"Name", "Elapsed Time", "Start Time", "End Time", "Reason"};
        protected String[] columnNameArray;
        private List<FileStats> fileStatsList = new ArrayList<FileStats>();

        public ErrorTableModel() {
            switch (jobType) {
                case COPY: {
                    this.columnNameArray = this.copyCols;
                    break;
                }
                case DELETE: 
                case SET_METADATA: {
                    this.columnNameArray = this.deleteCols;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported job type: " + (Object)((Object)jobType));
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNameArray.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNameArray[columnIndex];
        }

        @Override
        public int getRowCount() {
            int cnt = 0;
            if (this.fileStatsList != null) {
                cnt = this.fileStatsList.size();
            }
            return cnt;
        }

        @Override
        public Object getValueAt(int row, int col) {
            FileStats stats;
            try {
                stats = this.fileStatsList.get(row);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            if (stats == null) {
                return null;
            }
            String colName = this.columnNameArray[col];
            if (JobProgressPanel.NAME_COL.equals(colName)) {
                return stats.getDisplayUriRelativeToBasePath();
            }
            if (JobProgressPanel.SIZE_COL.equals(colName)) {
                return Math.max(1L, stats.getSize() / 1024L);
            }
            if (JobProgressPanel.ELAPSED_TIME_COL.equals(colName)) {
                return StringUtils.millsecondsToMinutesAndSeconds(stats.getRunTimeMs());
            }
            if (JobProgressPanel.START_TIME_COL.equals(colName)) {
                return stats.getStartTime();
            }
            if (JobProgressPanel.END_TIME_COL.equals(colName)) {
                return stats.getEndTime();
            }
            if (JobProgressPanel.REASON_COL.equals(colName)) {
                String reason = "";
                if (stats.getException() != null) {
                    reason = stats.getException().getMessage();
                }
                return reason;
            }
            throw new IllegalArgumentException("Unsupported column: " + colName);
        }

        public void updateStatus(JobStatus oldStatus, JobStatus newStatus, ManagedJobImpl.JobDetails copyJobDetails) {
            if (!newStatus.hasNeverBeenRun()) {
                if (newStatus.isRunning() || newStatus != oldStatus) {
                    List<FileStats> newFileStats;
                    if (copyJobDetails != null && (newFileStats = copyJobDetails.getObjectsFailed()) != null && JobProgressPanel.listChanged(this.fileStatsList, newFileStats)) {
                        this.fileStatsList = newFileStats;
                    }
                } else if (newStatus.isPaused() || newStatus.isFinished()) {
                    // empty if block
                }
            }
            this.fireTableDataChanged();
        }
    }

    private class CompletedTableModel
    extends AbstractTableModel {
        private final String[] copyCols = new String[]{"Name", "Size (KB)", "Elapsed Time"};
        private final String[] deleteCols = new String[]{"Name", "Elapsed Time"};
        protected String[] columnNameArray;
        private List<FileStats> fileStatsList = new ArrayList<FileStats>();

        public CompletedTableModel() {
            switch (jobType) {
                case COPY: {
                    this.columnNameArray = this.copyCols;
                    break;
                }
                case DELETE: 
                case SET_METADATA: {
                    this.columnNameArray = this.deleteCols;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported job type: " + (Object)((Object)jobType));
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNameArray.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNameArray[columnIndex];
        }

        @Override
        public int getRowCount() {
            int cnt = 0;
            if (this.fileStatsList != null) {
                cnt = this.fileStatsList.size();
            }
            return cnt;
        }

        @Override
        public Object getValueAt(int row, int col) {
            FileStats stats;
            try {
                stats = this.fileStatsList.get(row);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            if (stats == null) {
                return null;
            }
            String colName = this.columnNameArray[col];
            if (JobProgressPanel.NAME_COL.equals(colName)) {
                return stats.getDisplayUriRelativeToBasePath();
            }
            if (JobProgressPanel.SIZE_COL.equals(colName)) {
                return JobProgressPanel.this.numberFormat.format(Math.max(1L, stats.getSize() / 1024L));
            }
            if (JobProgressPanel.ELAPSED_TIME_COL.equals(colName)) {
                return StringUtils.millsecondsToMinutesAndSeconds(stats.getRunTimeMs());
            }
            throw new IllegalArgumentException("Unsupported column: " + colName);
        }

        public void updateStatus(JobStatus oldStatus, JobStatus newStatus, ManagedJobImpl.JobDetails copyJobDetails) {
            if (!newStatus.hasNeverBeenRun()) {
                if (newStatus.isRunning() || newStatus != oldStatus) {
                    List<FileStats> newFileStats;
                    if (copyJobDetails != null && (newFileStats = copyJobDetails.getObjectsCompleted()) != null && JobProgressPanel.listChanged(this.fileStatsList, newFileStats)) {
                        this.fileStatsList = newFileStats;
                    }
                } else if (newStatus.isPaused() || newStatus.isFinished()) {
                    // empty if block
                }
            }
            this.fireTableDataChanged();
        }
    }

    private class ProcessingTableModel
    extends AbstractTableModel {
        protected final String[] copyCols = new String[]{"Name", "Size (KB)"};
        protected final String[] deleteCols = new String[]{"Name"};
        protected String[] columnNameArray;
        private List<FileStats> fileStatsList = new ArrayList<FileStats>();

        public ProcessingTableModel() {
            switch (jobType) {
                case COPY: {
                    this.columnNameArray = this.copyCols;
                    break;
                }
                case DELETE: 
                case SET_METADATA: {
                    this.columnNameArray = this.deleteCols;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported job type: " + (Object)((Object)jobType));
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNameArray.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNameArray[columnIndex];
        }

        @Override
        public int getRowCount() {
            int cnt = 0;
            if (this.fileStatsList != null) {
                cnt = this.fileStatsList.size();
            }
            return cnt;
        }

        @Override
        public Object getValueAt(int row, int col) {
            FileStats stats;
            try {
                stats = this.fileStatsList.get(row);
            }
            catch (IndexOutOfBoundsException e) {
                LOG.log(Level.WARNING, "Unexpected Exception updating Processing table.", e);
                LOG.log(Level.WARNING, "FileListStats=", this.fileStatsList);
                return null;
            }
            if (stats == null) {
                return null;
            }
            String colName = this.columnNameArray[col];
            if (JobProgressPanel.NAME_COL.equals(colName)) {
                return stats.getDisplayUriRelativeToBasePath();
            }
            if (JobProgressPanel.SIZE_COL.equals(colName)) {
                return JobProgressPanel.this.numberFormat.format(Math.max(1L, stats.getSize() / 1024L));
            }
            throw new IllegalArgumentException("Unsupported column: " + colName);
        }

        public void updateStatus(JobStatus oldStatus, JobStatus newStatus, ManagedJobImpl.JobDetails copyJobDetails) {
            if (!newStatus.hasNeverBeenRun()) {
                if (newStatus.isRunning() || newStatus != oldStatus && !newStatus.isFinished()) {
                    if (copyJobDetails != null) {
                        this.fileStatsList = copyJobDetails.getObjectsProcessing();
                    }
                } else if (!newStatus.isPaused() && newStatus.isFinished()) {
                    this.fileStatsList.clear();
                }
            }
            this.fireTableDataChanged();
        }
    }
}

