/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.panels;

import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.archivas.clienttools.arcmover.gui.panels.FixedHeightPanel;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthGroup;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LoadSchedulePanel
extends JPanel {
    public static Logger LOG = Logger.getLogger(LoadSchedulePanel.class.getName());
    private static final String MAX_CONS_PER_SYSTEM_TEXT = "Maximum Operations per System";
    private static final String MAX_CONS_PER_NODE_TEXT = "Maximum Operations per Node";
    private JRadioButton normalLoadRadio = new JRadioButton("Use normal load schedule at all times");
    private JRadioButton lowLoadRadio = new JRadioButton("Use reduced load schedule during specified times and normal load schedule the rest of the time");
    private JTextField normalLoadConsPerSystemField = new JTextField(10);
    private JTextField normalLoadConsPerNodeField = new JTextField(10);
    private JTextField lowLoadConsPerSystemField = new JTextField(10);
    private JTextField lowLoadConsPerNodeField = new JTextField(10);
    private JSpinner lowLoadStartTimeSpinner = new JSpinner();
    private JSpinner lowLoadEndTimeSpinner = new JSpinner();
    private JPanel lowLoadPanel;
    private JPanel normalLoadPanel;
    private TitledBorder lowLoadTitle = new TitledBorder("Reduced Load");
    private TitledBorder normalLoadTitle = new TitledBorder("Normal Load");
    SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
    private boolean bothSchedulesEnabled;
    private JobDialog jobDialog;

    public LoadSchedulePanel(JobDialog jobDialog, LoadSchedule loadSchedule, boolean bothSchedulesEnabled) {
        this.jobDialog = jobDialog;
        this.bothSchedulesEnabled = bothSchedulesEnabled;
        this.layoutGuiComponents();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.lowLoadRadio);
        bg.add(this.normalLoadRadio);
        ActionListener radioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadSchedulePanel.this.enableLowLoadUIComponents(LoadSchedulePanel.this.lowLoadRadio.isSelected());
                LoadSchedulePanel.this.fieldChanged();
            }
        };
        this.lowLoadRadio.addActionListener(radioListener);
        this.normalLoadRadio.addActionListener(radioListener);
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LoadSchedulePanel.this.fieldChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LoadSchedulePanel.this.fieldChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LoadSchedulePanel.this.fieldChanged();
            }
        };
        this.normalLoadConsPerSystemField.getDocument().addDocumentListener(docListener);
        this.normalLoadConsPerNodeField.getDocument().addDocumentListener(docListener);
        this.lowLoadConsPerSystemField.getDocument().addDocumentListener(docListener);
        this.lowLoadConsPerNodeField.getDocument().addDocumentListener(docListener);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LoadSchedulePanel.this.fieldChanged();
            }
        };
        this.lowLoadStartTimeSpinner.addChangeListener(changeListener);
        this.lowLoadEndTimeSpinner.addChangeListener(changeListener);
        this.setLoadSchedule(loadSchedule);
    }

    private void fieldChanged() {
        if (this.jobDialog != null) {
            this.jobDialog.fieldChanged();
        }
    }

    private void layoutGuiComponents() {
        FixedHeightPanel radioPanel = new FixedHeightPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 1));
        FixedHeightPanel p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.normalLoadRadio);
        p.add(Box.createHorizontalGlue());
        radioPanel.add(p);
        p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.lowLoadRadio);
        p.add(Box.createHorizontalGlue());
        radioPanel.add(p);
        FixedWidthGroup labelGroup = new FixedWidthGroup();
        this.normalLoadPanel = new JPanel();
        this.normalLoadPanel.setLayout(new BoxLayout(this.normalLoadPanel, 1));
        this.normalLoadPanel.setBorder(new CompoundBorder(this.normalLoadTitle, new EmptyBorder(12, 12, 12, 12)));
        this.normalLoadPanel.add(GUIHelper.createNameValuePairPanel(MAX_CONS_PER_SYSTEM_TEXT, (Component)this.normalLoadConsPerSystemField, labelGroup, false));
        this.normalLoadPanel.add(GUIHelper.createNameValuePairPanel(MAX_CONS_PER_NODE_TEXT, (Component)this.normalLoadConsPerNodeField, labelGroup, false));
        this.normalLoadPanel.add(Box.createVerticalGlue());
        labelGroup = new FixedWidthGroup();
        this.lowLoadPanel = new JPanel();
        this.lowLoadPanel.setLayout(new BoxLayout(this.lowLoadPanel, 1));
        this.lowLoadPanel.setBorder(new CompoundBorder(this.lowLoadTitle, new EmptyBorder(12, 12, 12, 12)));
        this.lowLoadPanel.add(GUIHelper.createNameValuePairPanel(MAX_CONS_PER_SYSTEM_TEXT, (Component)this.lowLoadConsPerSystemField, labelGroup, false));
        this.lowLoadPanel.add(GUIHelper.createNameValuePairPanel(MAX_CONS_PER_NODE_TEXT, (Component)this.lowLoadConsPerNodeField, labelGroup, false));
        this.lowLoadPanel.add(GUIHelper.createNameValuePairPanel("Start Time", (Component)this.lowLoadStartTimeSpinner, labelGroup, false));
        this.lowLoadPanel.add(GUIHelper.createNameValuePairPanel("End Time", (Component)this.lowLoadEndTimeSpinner, labelGroup, false));
        this.lowLoadPanel.add(Box.createVerticalGlue());
        FixedHeightPanel loadPanel = new FixedHeightPanel();
        loadPanel.setLayout(new BoxLayout(loadPanel, 1));
        loadPanel.add(this.normalLoadPanel);
        loadPanel.add(Box.createVerticalStrut(25));
        loadPanel.add(this.lowLoadPanel);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(25, 25, 25, 25));
        this.add(radioPanel);
        this.add(Box.createVerticalStrut(25));
        this.add(loadPanel);
    }

    public LoadSchedule getLoadSchedule() {
        return new LoadSchedule(this.getNormalLoadMaxConn(), this.getNormalLoadMaxConnPerNode(), this.isLowLoadEnabled(), this.getLowLoadMaxConn(), this.getLowLoadMaxConnPerNode(), this.getLowLoadStartTime(), this.getLowLoadEndTime());
    }

    public void setLoadSchedule(LoadSchedule schedule) {
        if (schedule == null) {
            schedule = LoadSchedule.getDefaultLoadSchedule();
        }
        this.lowLoadRadio.setSelected(schedule.isLowLoadEnabled());
        this.normalLoadRadio.setSelected(!this.lowLoadRadio.isSelected());
        this.normalLoadConsPerSystemField.setText("" + schedule.getNormalLoadMaxConnCount());
        this.normalLoadConsPerNodeField.setText("" + schedule.getNormalLoadMaxConnPerNodeCount());
        this.lowLoadConsPerSystemField.setText("" + schedule.getLowLoadMaxConnCount());
        this.lowLoadConsPerNodeField.setText("" + schedule.getLowLoadMaxConnPerNodeCount());
        Date startTime = schedule.getLowLoadStartTime();
        SpinnerDateModel startModel = new SpinnerDateModel(startTime, null, null, 11);
        this.lowLoadStartTimeSpinner.setModel(startModel);
        this.lowLoadStartTimeSpinner.setEditor(new JSpinner.DateEditor(this.lowLoadStartTimeSpinner, "HH:mm"));
        Date endTime = schedule.getLowLoadEndTime();
        SpinnerDateModel endModel = new SpinnerDateModel(endTime, null, null, 11);
        this.lowLoadEndTimeSpinner.setModel(endModel);
        this.lowLoadEndTimeSpinner.setEditor(new JSpinner.DateEditor(this.lowLoadEndTimeSpinner, "HH:mm"));
        this.enableLowLoadUIComponents(this.lowLoadRadio.isSelected());
    }

    public int getNormalLoadMaxConn() throws IllegalArgumentException {
        return this.intFromField(this.normalLoadConsPerSystemField, LoadSchedule.NORMAL_LOAD_CONNECTIONS_PER_SYSTEM_NAME, LoadSchedule.MAX_CONS_PER_SYSTEM_INT);
    }

    public int getNormalLoadMaxConnPerNode() throws IllegalArgumentException {
        return this.intFromField(this.normalLoadConsPerNodeField, LoadSchedule.NORMAL_LOAD_CONNECTIONS_PER_NODE_NAME, LoadSchedule.MAX_CONS_PER_NODE_INT, LoadSchedule.NORMAL_LOAD_CONNECTIONS_PER_SYSTEM_NAME);
    }

    public int getLowLoadMaxConn() throws IllegalArgumentException {
        return this.intFromField(this.lowLoadConsPerSystemField, LoadSchedule.LOW_LOAD_CONNECTIONS_PER_SYSTEM_NAME, LoadSchedule.MAX_CONS_PER_SYSTEM_INT);
    }

    public int getLowLoadMaxConnPerNode() throws IllegalArgumentException {
        return this.intFromField(this.lowLoadConsPerNodeField, LoadSchedule.LOW_LOAD_CONNECTIONS_PER_NODE_NAME, LoadSchedule.MAX_CONS_PER_NODE_INT, LoadSchedule.LOW_LOAD_CONNECTIONS_PER_SYSTEM_NAME);
    }

    private int intFromField(JTextField field, String fieldName, int max) throws IllegalArgumentException {
        return this.intFromField(field, fieldName, max, null);
    }

    private int intFromField(JTextField field, String fieldName, int max, String maxFieldName) throws IllegalArgumentException {
        String value = field.getText();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String maxMessage = maxFieldName == null ? "" : " and may not exceed " + maxFieldName;
            throw new IllegalArgumentException(String.format("Invalid value for %s:  Must be an integer between 1 and %d%s.", fieldName, max, maxMessage));
        }
    }

    public Date getLowLoadStartTime() {
        return (Date)this.lowLoadStartTimeSpinner.getModel().getValue();
    }

    public Date getLowLoadEndTime() {
        return (Date)this.lowLoadEndTimeSpinner.getModel().getValue();
    }

    public boolean isLowLoadEnabled() {
        return this.lowLoadRadio.isSelected();
    }

    private void enableLowLoadUIComponents(boolean enabled) {
        if (!this.bothSchedulesEnabled) {
            GUIHelper.enableComponent(this.lowLoadPanel, enabled);
            this.lowLoadTitle.setTitleColor(enabled ? GUIHelper.ENABLED_TITLE_COLOR : GUIHelper.DISABLED_TITLE_COLOR);
        }
    }

    public void enablePanel(boolean enabled) {
        GUIHelper.enableComponent(this, enabled);
        if (enabled) {
            this.enableLowLoadUIComponents(this.lowLoadRadio.isSelected());
        }
    }

    public static void main(String[] args) {
        LoadSchedulePanel p = new LoadSchedulePanel(null, LoadSchedule.getDefaultLoadSchedule(), true);
        JFrame f = new JFrame();
        f.add(p);
        f.pack();
        f.setLocation(100, 800);
        f.setSize(new Dimension(800, 500));
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setVisible(true);
    }
}

