/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.panels;

import com.archivas.clienttools.arcmover.gui.panels.FixedHeightPanel;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.config.HCPMoverConstants;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class LoggingSettingsPanel
extends JPanel {
    public static Logger LOG = Logger.getLogger(LoggingSettingsPanel.class.getName());
    private JPanel successPanel;
    private TitledBorder successLoggingTitle = new TitledBorder("Success Logging");
    private JRadioButton successRadioNone = new JRadioButton("No logging");
    private JRadioButton successRadioPeriodic = new JRadioButton("Log a summary every ");
    private JRadioButton successRadioAll = new JRadioButton("Log every file");
    private JTextField successPeriodInput = new JTextField();
    private JLabel successPeriodInputLabel = new JLabel(" seconds (1 to 3600)");
    private JPanel failurePanel;
    private TitledBorder failureLoggingTitle = new TitledBorder("Failure Logging");
    private JRadioButton failureRadioNone = new JRadioButton("No logging");
    private JRadioButton failureRadioPeriodic = new JRadioButton("Log a summary every ");
    private JRadioButton failureRadioAll = new JRadioButton("Log every file");
    private JTextField failurePeriodInput = new JTextField();
    private JLabel failurePeriodInputLabel = new JLabel(" seconds (1 to 3600)");

    public LoggingSettingsPanel(HCPMoverConstants.TriState successMode, int successPeriodSeconds, HCPMoverConstants.TriState failureMode, int failurePeriodSeconds) {
        this.successPeriodInput.setText(Integer.toString(successPeriodSeconds));
        this.failurePeriodInput.setText(Integer.toString(failurePeriodSeconds));
        switch (successMode) {
            case YES: {
                this.successRadioAll.setSelected(true);
                break;
            }
            case NO: {
                this.successRadioNone.setSelected(true);
                break;
            }
            default: {
                this.successRadioPeriodic.setSelected(true);
            }
        }
        switch (failureMode) {
            case YES: {
                this.failureRadioAll.setSelected(true);
                break;
            }
            case NO: {
                this.failureRadioNone.setSelected(true);
                break;
            }
            default: {
                this.failureRadioPeriodic.setSelected(true);
            }
        }
        this.layoutGuiComponents();
    }

    private void layoutGuiComponents() {
        FixedHeightPanel p = null;
        FixedHeightPanel loggingPanel = new FixedHeightPanel();
        loggingPanel.setLayout(new BoxLayout(loggingPanel, 1));
        ButtonGroup successButtonGroup = new ButtonGroup();
        successButtonGroup.add(this.successRadioNone);
        successButtonGroup.add(this.successRadioPeriodic);
        successButtonGroup.add(this.successRadioAll);
        this.successPanel = new JPanel();
        this.successPanel.setLayout(new BoxLayout(this.successPanel, 1));
        this.successPanel.setBorder(new CompoundBorder(this.successLoggingTitle, new EmptyBorder(12, 12, 12, 12)));
        p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.successRadioNone);
        p.add(Box.createHorizontalGlue());
        this.successPanel.add(p);
        p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.successRadioPeriodic);
        p.add(this.successPeriodInput);
        p.add(this.successPeriodInputLabel);
        p.add(Box.createHorizontalGlue());
        this.successPanel.add(p);
        p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.successRadioAll);
        p.add(Box.createHorizontalGlue());
        this.successPanel.add(p);
        ActionListener successRadioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggingSettingsPanel.this.displaySuccessPeriodInput(LoggingSettingsPanel.this.successRadioPeriodic.isSelected());
            }
        };
        this.successRadioNone.addActionListener(successRadioListener);
        this.successRadioPeriodic.addActionListener(successRadioListener);
        this.successRadioAll.addActionListener(successRadioListener);
        ButtonGroup failureButtonGroup = new ButtonGroup();
        failureButtonGroup.add(this.failureRadioNone);
        failureButtonGroup.add(this.failureRadioPeriodic);
        failureButtonGroup.add(this.failureRadioAll);
        this.failurePanel = new JPanel();
        this.failurePanel.setLayout(new BoxLayout(this.failurePanel, 1));
        this.failurePanel.setBorder(new CompoundBorder(this.failureLoggingTitle, new EmptyBorder(12, 12, 12, 12)));
        p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.failureRadioNone);
        p.add(Box.createHorizontalGlue());
        this.failurePanel.add(p);
        p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.failureRadioPeriodic);
        p.add(this.failurePeriodInput);
        p.add(this.failurePeriodInputLabel);
        p.add(Box.createHorizontalGlue());
        this.failurePanel.add(p);
        p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.failureRadioAll);
        p.add(Box.createHorizontalGlue());
        this.failurePanel.add(p);
        ActionListener failureRadioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggingSettingsPanel.this.displayFailurePeriodInput(LoggingSettingsPanel.this.failureRadioPeriodic.isSelected());
            }
        };
        this.failureRadioNone.addActionListener(failureRadioListener);
        this.failureRadioPeriodic.addActionListener(failureRadioListener);
        this.failureRadioAll.addActionListener(failureRadioListener);
        loggingPanel.add(this.successPanel);
        loggingPanel.add(Box.createVerticalStrut(25));
        loggingPanel.add(this.failurePanel);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(25, 25, 25, 25));
        this.add(loggingPanel);
        this.displaySuccessPeriodInput(this.successRadioPeriodic.isSelected());
        this.displayFailurePeriodInput(this.failureRadioPeriodic.isSelected());
    }

    private void displayFailurePeriodInput(boolean shouldDisplay) {
        this.failurePeriodInput.setEditable(shouldDisplay);
    }

    private void displaySuccessPeriodInput(boolean shouldDisplay) {
        this.successPeriodInput.setEditable(shouldDisplay);
    }

    public void enablePanel(boolean enabled) {
        GUIHelper.enableComponent(this, enabled);
    }

    public int getSuccessPeriod() {
        String str = this.successPeriodInput.getText();
        int value = 60;
        try {
            value = str == null ? 60 : Integer.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (value < 1 || value > 3600) {
            value = 60;
        }
        return value;
    }

    public int getFailurePeriod() {
        String str = this.failurePeriodInput.getText();
        int value = 60;
        try {
            value = str == null ? 60 : Integer.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (value < 1 || value > 3600) {
            value = 60;
        }
        return value;
    }

    public HCPMoverConstants.TriState getSuccessLoggingMode() {
        if (this.successRadioNone.isSelected()) {
            return HCPMoverConstants.TriState.NO;
        }
        if (this.successRadioAll.isSelected()) {
            return HCPMoverConstants.TriState.YES;
        }
        return HCPMoverConstants.TriState.DEFAULT;
    }

    public HCPMoverConstants.TriState getFailureLoggingMode() {
        if (this.failureRadioNone.isSelected()) {
            return HCPMoverConstants.TriState.NO;
        }
        if (this.failureRadioAll.isSelected()) {
            return HCPMoverConstants.TriState.YES;
        }
        return HCPMoverConstants.TriState.DEFAULT;
    }
}

