/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.panels;

import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.archivas.clienttools.arcmover.gui.panels.CustomMetadataPanel;
import com.archivas.clienttools.arcmover.gui.panels.FixedHeightPanel;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthButton;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.model.StructuredMetadata;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public abstract class MetadataPanel
extends JPanel {
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final Logger LOG = Logger.getLogger(CustomMetadataPanel.class.getName());
    private static final String ERROR_DIALOG_TITLE = "Error reading file";
    private static final int MAX_CM_STRING_LENGTH = 32672;
    private long maxCmdLength = Math.min(HCPMoverProperties.CM_MAX_IN_MEMORY_SIZE.getAsLong(), 32672L);
    private String fileTooBigMsg = "The file is too big.  The file must not be larger than " + this.maxCmdLength + " bytes.";
    private JLabel fileLabel = new JLabel("File");
    private JTextField fileName = new JTextField();
    private JButton fileLoadButton = new JButton("Choose File");
    private TitledBorder cmdAreaTitle;
    private JTextArea cmdArea;
    private JButton loadButton;
    private JRadioButton cmUnchangedRadio;
    private JRadioButton cmFromFileRadio;
    private JRadioButton cmFromStringRadio;
    private JobDialog jobDialog;
    private String title;
    private boolean lowerCaseTitle;
    private boolean pluralizeTitle;

    public MetadataPanel(JobDialog jobDialog, String title, boolean useIngestSettings) {
        this(jobDialog, title, useIngestSettings, true, false);
    }

    public MetadataPanel(JobDialog jobDialog, String title, boolean useIngestSettings, boolean lowerCaseTitle, boolean pluralizeTitle) {
        this.jobDialog = jobDialog;
        this.title = title;
        this.lowerCaseTitle = lowerCaseTitle;
        this.pluralizeTitle = pluralizeTitle;
        this.cmdAreaTitle = new TitledBorder(title);
        this.cmUnchangedRadio = new JRadioButton(String.format("Do not %s %s", useIngestSettings ? "set" : "change", lowerCaseTitle ? title.toLowerCase() : title));
        this.cmFromFileRadio = new JRadioButton(String.format("Read %s from a file when the job runs", lowerCaseTitle ? title.toLowerCase() : title));
        this.cmFromStringRadio = new JRadioButton(String.format("Use %s text entered below", lowerCaseTitle ? title.toLowerCase() : title));
        this.initGuiComponents(useIngestSettings);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.cmUnchangedRadio);
        bg.add(this.cmFromFileRadio);
        bg.add(this.cmFromStringRadio);
        ActionListener radioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetadataPanel.this.enablePanel(MetadataPanel.this.cmFromFileRadio.isEnabled());
                MetadataPanel.this.fieldChanged();
            }
        };
        this.cmUnchangedRadio.addActionListener(radioListener);
        this.cmFromFileRadio.addActionListener(radioListener);
        this.cmFromStringRadio.addActionListener(radioListener);
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MetadataPanel.this.fieldChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MetadataPanel.this.fieldChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MetadataPanel.this.fieldChanged();
            }
        };
        this.fileName.getDocument().addDocumentListener(docListener);
        this.cmdArea.getDocument().addDocumentListener(docListener);
        this.fileLoadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetadataPanel.this.onFileLoad();
            }
        });
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetadataPanel.this.onLoad();
            }
        });
        this.cmUnchangedRadio.setSelected(true);
        this.enablePanel(true);
    }

    private void initGuiComponents(boolean useIngestSettings) {
        String displayedTitle;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        FixedHeightPanel p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.cmUnchangedRadio);
        p.add(Box.createHorizontalGlue());
        this.add(p);
        this.add(Box.createVerticalStrut(5));
        p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.cmFromFileRadio);
        p.add(Box.createHorizontalGlue());
        this.add(p);
        FixedHeightPanel labelPanel = new FixedHeightPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(Box.createHorizontalStrut(25));
        String string = displayedTitle = this.lowerCaseTitle ? this.title.toLowerCase() : this.title;
        if (this.pluralizeTitle) {
            displayedTitle = displayedTitle + "s";
        }
        JLabel label = new JLabel(String.format("This option may be used for %s larger than %d bytes", displayedTitle, this.maxCmdLength));
        label.setEnabled(false);
        labelPanel.add(label);
        labelPanel.add(Box.createHorizontalGlue());
        this.add(labelPanel);
        this.add(Box.createVerticalStrut(5));
        FixedHeightPanel filePanel = new FixedHeightPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 0));
        filePanel.add(Box.createHorizontalStrut(25));
        filePanel.add(this.fileLabel);
        filePanel.add(Box.createHorizontalStrut(12));
        filePanel.add(this.fileName);
        filePanel.add(Box.createHorizontalStrut(25));
        filePanel.add(Box.createHorizontalGlue());
        filePanel.add(this.fileLoadButton);
        this.add(filePanel);
        this.add(Box.createVerticalStrut(12));
        p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.cmFromStringRadio);
        p.add(Box.createHorizontalGlue());
        this.add(p);
        labelPanel = new FixedHeightPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(Box.createHorizontalStrut(25));
        label = new JLabel(String.format("This option may only be used for %s smaller than or equal to %d bytes", displayedTitle, this.maxCmdLength));
        label.setEnabled(false);
        labelPanel.add(label);
        labelPanel.add(Box.createHorizontalGlue());
        this.add(labelPanel);
        if (!useIngestSettings) {
            labelPanel = new FixedHeightPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 0));
            labelPanel.add(Box.createHorizontalStrut(25));
            label = new JLabel(String.format("If this option is selected but no value is provided, then the existing %s will be deleted", displayedTitle));
            label.setEnabled(false);
            labelPanel.add(label);
            labelPanel.add(Box.createHorizontalGlue());
            this.add(labelPanel);
        }
        this.add(Box.createVerticalStrut(5));
        JPanel cmdEntryPanel = new JPanel();
        cmdEntryPanel.setLayout(new BoxLayout(cmdEntryPanel, 1));
        cmdEntryPanel.setBorder(new CompoundBorder(new EmptyBorder(0, 25, 0, 0), new CompoundBorder(this.cmdAreaTitle, new EmptyBorder(12, 12, 12, 12))));
        this.cmdArea = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this.cmdArea);
        cmdEntryPanel.add(scrollPane);
        cmdEntryPanel.add(Box.createVerticalStrut(12));
        this.loadButton = new FixedWidthButton("Load", 100);
        FixedHeightPanel buttonPanel = new FixedHeightPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.loadButton);
        cmdEntryPanel.add(buttonPanel);
        this.add(cmdEntryPanel);
    }

    private void fieldChanged() {
        if (this.jobDialog != null) {
            this.jobDialog.fieldChanged();
        }
    }

    protected abstract String getLoadPath();

    protected abstract void setLoadPath(String var1);

    private void onFileLoad() {
        String loadPath = this.getLoadPath();
        JFileChooser fd = new JFileChooser(loadPath);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(".xml files", "xml");
        fd.setFileFilter(filter);
        int retVal = fd.showOpenDialog(this);
        if (retVal == 0) {
            File f = fd.getSelectedFile();
            this.fileName.setText(f.getAbsolutePath());
            this.setLoadPath(f.getParent());
        }
    }

    private void onLoad() {
        String loadPath = this.getLoadPath();
        JFileChooser fd = new JFileChooser(loadPath);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(".xml files", "xml");
        fd.setFileFilter(filter);
        int retVal = fd.showOpenDialog(this);
        if (retVal == 0) {
            try {
                String line;
                File f = fd.getSelectedFile();
                if (f.length() > this.maxCmdLength) {
                    JOptionPane.showMessageDialog(this, this.fileTooBigMsg, ERROR_DIALOG_TITLE, 0);
                    return;
                }
                BufferedReader reader = new BufferedReader(new FileReader(f));
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append(NEWLINE);
                    if ((long)sb.length() <= this.maxCmdLength) continue;
                    JOptionPane.showMessageDialog(this, this.fileTooBigMsg, ERROR_DIALOG_TITLE, 0);
                    return;
                }
                this.cmdArea.setText(sb.toString());
            }
            catch (Exception e) {
                String msg = DBUtils.getErrorMessage("An error occurred reading the file", e);
                LOG.warning(msg);
                GUIHelper.showMessageDialog(this, msg, ERROR_DIALOG_TITLE, 0);
            }
            this.setLoadPath(fd.getSelectedFile().getParent());
        }
    }

    protected abstract StructuredMetadata createMetadata(StructuredMetadata.Form var1, String var2);

    protected StructuredMetadata getMetadata() {
        StructuredMetadata ret = null;
        if (this.cmFromStringRadio.isSelected()) {
            String cmString = this.cmdArea.getText().trim();
            ret = this.createMetadata(StructuredMetadata.Form.STRING, cmString);
        } else if (this.cmFromFileRadio.isSelected()) {
            String cmFile = this.fileName.getText().trim();
            if (cmFile.length() > 0) {
                ret = this.createMetadata(StructuredMetadata.Form.FILE, cmFile);
            } else {
                throw new IllegalArgumentException("No custom metadata file specified");
            }
        }
        return ret;
    }

    protected void setMetadata(StructuredMetadata cm) {
        if (cm == null) {
            this.cmUnchangedRadio.setSelected(true);
        } else {
            switch (cm.getForm()) {
                case STRING: {
                    this.cmFromStringRadio.setSelected(true);
                    this.cmdArea.setText(cm.getValue());
                    break;
                }
                case FILE: {
                    this.cmFromFileRadio.setSelected(true);
                    this.fileName.setText(cm.getValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported %s form: %s", new Object[]{this.lowerCaseTitle ? this.title.toLowerCase() : this.title, cm.getForm()}));
                }
            }
        }
        this.enablePanel(this.cmFromFileRadio.isEnabled());
    }

    private void enableStringComponents(boolean enabled) {
        this.cmdArea.setEnabled(enabled);
        this.cmdAreaTitle.setTitleColor(enabled ? GUIHelper.ENABLED_TITLE_COLOR : GUIHelper.DISABLED_TITLE_COLOR);
        this.loadButton.setEnabled(enabled);
    }

    private void enableFileComponents(boolean enabled) {
        this.fileLoadButton.setEnabled(enabled);
        this.fileName.setEnabled(enabled);
        this.fileName.setEditable(enabled);
        this.fileLabel.setEnabled(enabled);
    }

    public void enablePanel(boolean enabled) {
        this.cmUnchangedRadio.setEnabled(enabled);
        this.cmFromStringRadio.setEnabled(enabled);
        this.cmFromFileRadio.setEnabled(enabled);
        this.enableStringComponents(enabled && this.cmFromStringRadio.isSelected());
        this.enableFileComponents(enabled && this.cmFromFileRadio.isSelected());
    }
}

