/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.panels;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcmover.gui.profileadapter.ProfilePanelAdapter;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

public class OpenFileThread
extends SwingWorker<File, Object> {
    private static final Logger LOG = Logger.getLogger(OpenFileThread.class.getName());
    private ArcMoverFile file;
    private ProfilePanelAdapter adapter;

    public OpenFileThread(ArcMoverFile file, ProfilePanelAdapter adapter) {
        this.file = file;
        this.adapter = adapter;
    }

    @Override
    protected File doInBackground() throws Exception {
        File tmpFile = null;
        try {
            if (this.file != null && this.file.isDeleted()) {
                GUIHelper.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(HCPDataMigrator.getInstance(), "Error opening file: Cannot open deleted version.", "Error Opening File", 0);
                    }
                }, "show error message");
            } else if (this.adapter != null) {
                tmpFile = new File(this.adapter.getFileForOpen(this.file));
            }
        }
        catch (Exception e) {
            final String errMsg = "Error opening file: " + this.file.getDisplayFileName();
            LOG.log(Level.WARNING, errMsg, e);
            GUIHelper.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(HCPDataMigrator.getInstance(), errMsg, "Error Opening File", 0);
                }
            }, "show error message");
        }
        return tmpFile;
    }

    @Override
    protected void done() {
        try {
            Desktop dt = Desktop.getDesktop();
            File f = (File)this.get();
            if (f != null) {
                dt.open(f);
            }
        }
        catch (IOException e) {
            String errMsg = "An error occurred opening the file.  Either no program could be\nfound for this file type or the program failed to open the file.";
            LOG.log(Level.WARNING, errMsg, e);
            JOptionPane.showMessageDialog(HCPDataMigrator.getInstance(), errMsg, "Error Opening File", 0);
        }
        catch (Exception e) {
            String errMsg = "An unexpected error opening the file.";
            LOG.log(Level.SEVERE, errMsg, e);
            JOptionPane.showMessageDialog(HCPDataMigrator.getInstance(), errMsg, "Error Opening File", 0);
        }
    }
}

