/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.panels;

import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.archivas.clienttools.arcmover.gui.panels.FixedHeightPanel;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJobWithMetadata;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.Owner;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OwnerPanel
extends JPanel {
    private static final String[] INGEST_OWNER_TYPES = new String[]{Owner.OwnerType.PROFILE.getUIName(), Owner.OwnerType.PUBLIC.getUIName(), Owner.OwnerType.LOCAL.getUIName(), Owner.OwnerType.EXTERNAL.getUIName()};
    private static final String[] UPDATE_OWNER_TYPES = new String[]{Owner.OwnerType.PROFILE.getUIName(), Owner.OwnerType.PUBLIC.getUIName(), Owner.OwnerType.LOCAL.getUIName(), Owner.OwnerType.EXTERNAL.getUIName(), "Leave value unchanged"};
    private JTextField localUserField = new JTextField();
    private JTextField domainField = new JTextField();
    private JTextField externalUserField = new JTextField();
    private JobDialog jobDialog;
    private JComboBox ownerTypeComboBox;
    private JPanel ownerCardPanel;
    private CardLayout ownerCardLayout;
    private final int profileUserIndex = 0;
    private final int publicUserIndex = 1;
    private final int localUserIndex = 2;
    private final int externalUserIndex = 3;
    private final int noChangeIndex = 4;

    public OwnerPanel(JobDialog jobDialog, ManagedJobWithMetadata job, boolean useIngestSettings) {
        this.jobDialog = jobDialog;
        this.layoutGuiComponents(useIngestSettings);
        FileMetadata md = job.getIngestionMetadata();
        Owner owner = md.getOwner();
        if (owner == null && useIngestSettings) {
            owner = new Owner(Owner.OwnerType.PROFILE);
        }
        this.initState(owner, useIngestSettings);
    }

    public OwnerPanel(Owner owner) {
        boolean useIngestSettings = true;
        this.layoutGuiComponents(useIngestSettings);
        this.initState(owner, useIngestSettings);
    }

    private void fieldChanged() {
        if (this.jobDialog != null) {
            this.jobDialog.fieldChanged();
        }
    }

    private void layoutGuiComponents(boolean useIngestSettings) {
        this.ownerTypeComboBox = new JComboBox();
        this.ownerTypeComboBox.setEditable(false);
        this.ownerTypeComboBox.setModel(new DefaultComboBoxModel<String>(useIngestSettings ? INGEST_OWNER_TYPES : UPDATE_OWNER_TYPES));
        this.ownerCardLayout = new CardLayout();
        this.ownerCardPanel = new JPanel(this.ownerCardLayout);
        JPanel profileOwnerPanel = this.newValuePanel("", new JLabel(""));
        this.ownerCardPanel.add(profileOwnerPanel, Owner.OwnerType.PROFILE.getUIName(), 0);
        JPanel publicOwnerPanel = this.newValuePanel("", new JLabel(""));
        this.ownerCardPanel.add(publicOwnerPanel, Owner.OwnerType.PUBLIC.getUIName(), 1);
        JPanel localUserPanel = this.newValuePanel(Owner.OwnerType.LOCAL.getUIName(), this.localUserField);
        this.ownerCardPanel.add(localUserPanel, Owner.OwnerType.LOCAL.getUIName(), 2);
        FixedHeightPanel externalUserPanel = new FixedHeightPanel();
        externalUserPanel.setLayout(new BoxLayout(externalUserPanel, 1));
        JPanel externalUserFieldPanel = this.newValuePanel("User", this.externalUserField);
        externalUserPanel.add(externalUserFieldPanel);
        externalUserPanel.add(Box.createVerticalStrut(12));
        JPanel externalDomainFieldPanel = this.newValuePanel("Domain", this.domainField);
        externalUserPanel.add(externalDomainFieldPanel);
        this.ownerCardPanel.add(externalUserPanel, Owner.OwnerType.EXTERNAL.getUIName(), 3);
        if (!useIngestSettings) {
            JPanel noChangePanel = this.newValuePanel("", new JLabel(""));
            this.ownerCardPanel.add(noChangePanel, "Leave value unchanged", 4);
        }
        JPanel labelPanel = new JPanel();
        JLabel label1 = new JLabel();
        label1.setFont(new Font(label1.getFont().getName(), 1, 14));
        label1.setText("Owner Type");
        JLabel label2 = new JLabel();
        label2.setFont(new Font(label2.getFont().getName(), label2.getFont().getStyle(), 12));
        label2.setText("These settings apply only to HCP 5.0 or later namespaces.");
        labelPanel.setLayout(new GridLayout(2, 1));
        labelPanel.add(label1);
        labelPanel.add(label2);
        JPanel ownerValuePanel = new JPanel();
        ownerValuePanel.setLayout(new BoxLayout(ownerValuePanel, 1));
        ownerValuePanel.add(labelPanel);
        ownerValuePanel.add(Box.createVerticalStrut(12));
        ownerValuePanel.add(this.ownerTypeComboBox);
        ownerValuePanel.add(Box.createVerticalStrut(12));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.ownerCardPanel);
        ownerValuePanel.add(p);
        ownerValuePanel.add(Box.createVerticalGlue());
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.add(ownerValuePanel);
        this.add(Box.createVerticalGlue());
        this.initListeners();
    }

    private void onOwnerTypeChange(ItemEvent evt) {
        this.ownerCardLayout.show(this.ownerCardPanel, (String)evt.getItem());
    }

    private void initListeners() {
        this.ownerTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OwnerPanel.this.onOwnerTypeChange(e);
                OwnerPanel.this.fieldChanged();
            }
        });
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OwnerPanel.this.fieldChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OwnerPanel.this.fieldChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                OwnerPanel.this.fieldChanged();
            }
        };
        this.localUserField.getDocument().addDocumentListener(docListener);
        this.externalUserField.getDocument().addDocumentListener(docListener);
        this.domainField.getDocument().addDocumentListener(docListener);
    }

    private JPanel newValuePanel(String title, Component c) {
        FixedHeightPanel labelPanel = new FixedHeightPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(new JLabel(title));
        labelPanel.add(Box.createHorizontalGlue());
        FixedHeightPanel componentPanel = new FixedHeightPanel();
        componentPanel.setLayout(new BoxLayout(componentPanel, 0));
        componentPanel.add(c);
        FixedHeightPanel p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(labelPanel);
        p.add(Box.createVerticalStrut(5));
        p.add(componentPanel);
        p.add(Box.createVerticalGlue());
        return p;
    }

    public void enablePanel(boolean enabled) {
        this.localUserField.setEnabled(enabled);
        this.externalUserField.setEnabled(enabled);
        this.domainField.setEnabled(enabled);
    }

    private void initState(Owner owner, boolean useIngestSettings) {
        if (owner == null) {
            if (useIngestSettings) {
                throw new IllegalStateException("Owner Combobox set to an unexpected state");
            }
            this.ownerTypeComboBox.setSelectedIndex(4);
        } else if (owner.getOwnerType() == Owner.OwnerType.PROFILE) {
            this.ownerTypeComboBox.setSelectedIndex(0);
        } else if (owner.getOwnerType() == Owner.OwnerType.PUBLIC) {
            this.ownerTypeComboBox.setSelectedIndex(1);
        } else if (owner.getOwnerType() == Owner.OwnerType.LOCAL) {
            this.localUserField.setText(owner.getOwnerName());
            this.ownerTypeComboBox.setSelectedIndex(2);
        } else if (owner.getOwnerType() == Owner.OwnerType.EXTERNAL) {
            this.externalUserField.setText(owner.getOwnerName());
            this.domainField.setText(owner.getDomain());
            this.ownerTypeComboBox.setSelectedIndex(3);
        } else {
            throw new IllegalStateException("Owner Combobox set to an unexpected state");
        }
    }

    public Owner getOwner() {
        if (this.ownerTypeComboBox.getSelectedIndex() == 0) {
            return new Owner(Owner.OwnerType.PROFILE);
        }
        if (this.ownerTypeComboBox.getSelectedIndex() == 1) {
            return new Owner(Owner.OwnerType.PUBLIC);
        }
        if (this.ownerTypeComboBox.getSelectedIndex() == 2) {
            return new Owner(this.localUserField.getText().trim());
        }
        if (this.ownerTypeComboBox.getSelectedIndex() == 3) {
            return new Owner(this.externalUserField.getText().trim(), this.domainField.getText().trim());
        }
        if (this.ownerTypeComboBox.getSelectedIndex() == 4) {
            return null;
        }
        throw new IllegalStateException("Owner Combobox set to an unexpected state");
    }
}

