/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.panels;

import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.archivas.clienttools.arcmover.gui.panels.FixedHeightPanel;
import com.archivas.clienttools.arcmover.gui.util.BoldFontLabel;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthPanel;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcmover.gui.util.PlainFontLabel;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.Retention;
import com.toedter.calendar.JDateChooser;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PoliciesPanel
extends JPanel {
    private static final String TARGET_DEFAULT_TEXT = Retention.Type.DEFAULT.uiName();
    public static final String NO_CHANGE_TEXT = "Leave value unchanged";
    private static final String[] INGEST_RETENTION_TYPES = new String[]{Retention.Type.DEFAULT.uiName(), Retention.Type.OFFSET.uiName(), Retention.Type.FIXED_DATE.uiName(), Retention.Type.SPECIAL_VALUE.uiName(), Retention.Type.RETENTION_CLASS.uiName(), Retention.Type.ADVANCED.uiName()};
    private static final String[] INGEST_RESTRICTED_RETENTION_TYPES = new String[]{Retention.Type.DEFAULT.uiName(), Retention.Type.OFFSET.uiName(), Retention.Type.FIXED_DATE.uiName(), Retention.Type.SPECIAL_VALUE.uiName(), Retention.Type.ADVANCED.uiName()};
    private static final String[] MODIFY_RETENTION_TYPES = new String[]{"Leave value unchanged", Retention.Type.OFFSET.uiName(), Retention.Type.FIXED_DATE.uiName(), Retention.Type.SPECIAL_VALUE.uiName(), Retention.Type.RETENTION_CLASS.uiName(), Retention.Type.ADVANCED.uiName()};
    private static final String[] MODIFY_RESTRICTED_RETENTION_TYPES = new String[]{"Leave value unchanged", Retention.Type.OFFSET.uiName(), Retention.Type.FIXED_DATE.uiName(), Retention.Type.SPECIAL_VALUE.uiName(), Retention.Type.ADVANCED.uiName()};
    private static final String[] SPECIAL_VALUES = new String[]{Retention.SpecialValueType.DELETION_ALLOWED.uiName(), Retention.SpecialValueType.DELETION_PROHIBITED.uiName(), Retention.SpecialValueType.INITIAL_UNSPECIFIED.uiName()};
    private boolean indexSettingsEnabled;
    private JPanel indexPanel;
    private TitledBorder indexTitle = new TitledBorder("Indexing");
    private JRadioButton indexDefaultRadio;
    private JRadioButton indexYesRadio = new JRadioButton("True");
    private JRadioButton indexNoRadio = new JRadioButton("False");
    private JRadioButton shredDefaultRadio;
    private JRadioButton shredYesRadio = new JRadioButton("True");
    private JRadioButton shredNoRadio = new JRadioButton("False");
    private JRadioButton holdDefaultRadio = new JRadioButton("Leave value unchanged");
    private JRadioButton holdYesRadio = new JRadioButton("True");
    private JRadioButton holdNoRadio = new JRadioButton("False");
    private JTextField offsetYearsField = new JTextField();
    private JTextField offsetMonthsField = new JTextField();
    private JTextField offsetDaysField = new JTextField();
    private JDateChooser dateChooserField = new JDateChooser();
    private JComboBox specialValueComboBox;
    private JTextField retentionClassField = new JTextField();
    private JTextField advancedField = new JTextField();
    private JComboBox retentionTypeComboBox;
    private CardLayout retentionCardLayout;
    private JPanel retentionCardPanel;
    private JobDialog jobDialog;

    public PoliciesPanel(JobDialog jobDialog, FileMetadata md, boolean indexSettingsEnabled, boolean supportsRetentionClasses, boolean useIngestSettings) {
        this.jobDialog = jobDialog;
        this.indexSettingsEnabled = indexSettingsEnabled;
        this.layoutGuiComponents(useIngestSettings);
        this.initState(indexSettingsEnabled, md.isSearchIndex(), md.isShred(), md.isRetentionHold(), md.getRetention(), supportsRetentionClasses, useIngestSettings);
    }

    public PoliciesPanel(boolean indexSettingsEnabled, Boolean index, Boolean shred, Boolean hold, Retention retention, boolean retentionClassesSupported) {
        boolean isIngestJob = true;
        this.layoutGuiComponents(isIngestJob);
        this.initState(indexSettingsEnabled, index, shred, hold, retention, retentionClassesSupported, isIngestJob);
    }

    private void fieldChanged() {
        if (this.jobDialog != null) {
            this.jobDialog.fieldChanged();
        }
    }

    private void layoutGuiComponents(boolean useIngestSettings) {
        String defaultLabel = useIngestSettings ? TARGET_DEFAULT_TEXT : NO_CHANGE_TEXT;
        this.indexDefaultRadio = new JRadioButton(defaultLabel);
        this.shredDefaultRadio = new JRadioButton(defaultLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.indexDefaultRadio);
        buttonGroup.add(this.indexYesRadio);
        buttonGroup.add(this.indexNoRadio);
        JPanel labelPanel = new FixedWidthPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        labelPanel.add(new PlainFontLabel("This setting applies only to HCP namespaces"));
        this.indexPanel = new JPanel();
        this.indexPanel.setLayout(new BoxLayout(this.indexPanel, 1));
        this.indexPanel.setBorder(new CompoundBorder(this.indexTitle, new EmptyBorder(5, 5, 5, 5)));
        this.indexPanel.add(labelPanel);
        this.indexPanel.add(Box.createVerticalStrut(17));
        this.indexPanel.add(this.indexDefaultRadio);
        this.indexPanel.add(this.indexYesRadio);
        this.indexPanel.add(this.indexNoRadio);
        this.indexPanel.add(Box.createVerticalGlue());
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.shredDefaultRadio);
        buttonGroup.add(this.shredYesRadio);
        buttonGroup.add(this.shredNoRadio);
        JPanel shredPanel = new JPanel();
        shredPanel.setLayout(new BoxLayout(shredPanel, 1));
        shredPanel.setBorder(new CompoundBorder(new TitledBorder("Shredding"), new EmptyBorder(5, 5, 5, 5)));
        shredPanel.add(this.shredDefaultRadio);
        shredPanel.add(this.shredYesRadio);
        shredPanel.add(this.shredNoRadio);
        shredPanel.add(Box.createVerticalGlue());
        FixedHeightPanel indexAndShredPanel = new FixedHeightPanel();
        indexAndShredPanel.setLayout(new BoxLayout(indexAndShredPanel, 0));
        indexAndShredPanel.add(this.indexPanel);
        indexAndShredPanel.add(Box.createHorizontalStrut(25));
        indexAndShredPanel.add(shredPanel);
        this.retentionTypeComboBox = new JComboBox();
        this.retentionTypeComboBox.setEditable(false);
        this.retentionCardLayout = new CardLayout();
        this.retentionCardPanel = new JPanel(this.retentionCardLayout);
        JPanel targetDefaultPanel = this.newRetentionValuePanel("", new JLabel(""));
        this.retentionCardPanel.add((Component)targetDefaultPanel, defaultLabel);
        FixedHeightPanel offsetPanel = new FixedHeightPanel();
        offsetPanel.setLayout(new BoxLayout(offsetPanel, 0));
        JPanel offsetPanel2 = new JPanel();
        GridLayout gl = new GridLayout(2, 3);
        gl.setHgap(12);
        offsetPanel2.setLayout(gl);
        offsetPanel2.add(new JLabel("Years"));
        offsetPanel2.add(new JLabel("Months"));
        offsetPanel2.add(new JLabel("Days"));
        offsetPanel2.add(this.offsetYearsField);
        offsetPanel2.add(this.offsetMonthsField);
        offsetPanel2.add(this.offsetDaysField);
        offsetPanel.add(offsetPanel2);
        this.retentionCardPanel.add((Component)offsetPanel, Retention.Type.OFFSET.uiName());
        JPanel fixedDatePanel = this.newRetentionValuePanel(Retention.Type.FIXED_DATE.uiName(), (Component)this.dateChooserField);
        this.retentionCardPanel.add((Component)fixedDatePanel, Retention.Type.FIXED_DATE.uiName());
        this.specialValueComboBox = new JComboBox<String>(SPECIAL_VALUES);
        JPanel specialValuePanel = this.newRetentionValuePanel(Retention.Type.SPECIAL_VALUE.uiName(), this.specialValueComboBox);
        this.retentionCardPanel.add((Component)specialValuePanel, Retention.Type.SPECIAL_VALUE.uiName());
        JPanel retentionClassPanel = this.newRetentionValuePanel(Retention.Type.RETENTION_CLASS.uiName(), this.retentionClassField);
        this.retentionCardPanel.add((Component)retentionClassPanel, Retention.Type.RETENTION_CLASS.uiName());
        JPanel advancedPanel = this.newRetentionValuePanel(Retention.Type.ADVANCED.uiName(), this.advancedField);
        this.retentionCardPanel.add((Component)advancedPanel, Retention.Type.ADVANCED.uiName());
        labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(new BoldFontLabel("Retention Method"));
        labelPanel.add(Box.createHorizontalGlue());
        JPanel retentionValuePanel = new JPanel();
        retentionValuePanel.setLayout(new BoxLayout(retentionValuePanel, 1));
        retentionValuePanel.add(labelPanel);
        retentionValuePanel.add(Box.createVerticalStrut(5));
        retentionValuePanel.add(this.retentionTypeComboBox);
        retentionValuePanel.add(Box.createVerticalStrut(12));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.retentionCardPanel);
        retentionValuePanel.add(p);
        retentionValuePanel.add(Box.createVerticalGlue());
        buttonGroup = new ButtonGroup();
        if (!useIngestSettings) {
            buttonGroup.add(this.holdDefaultRadio);
        }
        buttonGroup.add(this.holdYesRadio);
        buttonGroup.add(this.holdNoRadio);
        JPanel retentionHoldPanel = new JPanel();
        retentionHoldPanel.setLayout(new BoxLayout(retentionHoldPanel, 1));
        retentionHoldPanel.add(new BoldFontLabel("Hold"));
        retentionHoldPanel.add(Box.createVerticalStrut(5));
        if (!useIngestSettings) {
            retentionHoldPanel.add(this.holdDefaultRadio);
        }
        retentionHoldPanel.add(this.holdYesRadio);
        retentionHoldPanel.add(this.holdNoRadio);
        retentionHoldPanel.add(Box.createVerticalGlue());
        FixedHeightPanel retentionPanel = new FixedHeightPanel();
        retentionPanel.setLayout(new BoxLayout(retentionPanel, 0));
        retentionPanel.setBorder(new CompoundBorder(new TitledBorder("Retention"), new EmptyBorder(12, 12, 12, 12)));
        retentionPanel.add(retentionValuePanel);
        retentionPanel.add(Box.createHorizontalStrut(150));
        retentionPanel.add(retentionHoldPanel);
        retentionPanel.add(Box.createHorizontalStrut(25));
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.add(indexAndShredPanel);
        this.add(Box.createVerticalStrut(25));
        this.add(retentionPanel);
        this.add(Box.createVerticalGlue());
        this.initListeners();
    }

    private void initListeners() {
        this.retentionTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PoliciesPanel.this.onRetentionTypeChange(e);
                PoliciesPanel.this.fieldChanged();
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PoliciesPanel.this.fieldChanged();
            }
        };
        this.indexDefaultRadio.addActionListener(actionListener);
        this.indexYesRadio.addActionListener(actionListener);
        this.indexNoRadio.addActionListener(actionListener);
        this.shredDefaultRadio.addActionListener(actionListener);
        this.shredYesRadio.addActionListener(actionListener);
        this.shredNoRadio.addActionListener(actionListener);
        this.holdYesRadio.addActionListener(actionListener);
        this.holdNoRadio.addActionListener(actionListener);
        this.specialValueComboBox.addActionListener(actionListener);
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PoliciesPanel.this.fieldChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PoliciesPanel.this.fieldChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PoliciesPanel.this.fieldChanged();
            }
        };
        this.offsetYearsField.getDocument().addDocumentListener(docListener);
        this.offsetMonthsField.getDocument().addDocumentListener(docListener);
        this.offsetDaysField.getDocument().addDocumentListener(docListener);
        this.retentionClassField.getDocument().addDocumentListener(docListener);
        this.advancedField.getDocument().addDocumentListener(docListener);
        PropertyChangeListener propChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("date".equals(evt.getPropertyName())) {
                    PoliciesPanel.this.fieldChanged();
                }
            }
        };
        this.dateChooserField.getDateEditor().addPropertyChangeListener(propChangeListener);
    }

    private JPanel newRetentionValuePanel(String title, Component c) {
        FixedHeightPanel labelPanel = new FixedHeightPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(new JLabel(title));
        labelPanel.add(Box.createHorizontalGlue());
        FixedHeightPanel componentPanel = new FixedHeightPanel();
        componentPanel.setLayout(new BoxLayout(componentPanel, 0));
        componentPanel.add(c);
        FixedHeightPanel p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(labelPanel);
        p.add(Box.createVerticalStrut(5));
        p.add(componentPanel);
        p.add(Box.createVerticalGlue());
        return p;
    }

    public void enablePanel(boolean enabled) {
        this.enableIndexFields(enabled && this.indexSettingsEnabled);
        this.shredDefaultRadio.setEnabled(enabled);
        this.shredYesRadio.setEnabled(enabled);
        this.shredNoRadio.setEnabled(enabled);
        this.holdYesRadio.setEnabled(enabled);
        this.holdNoRadio.setEnabled(enabled);
        this.offsetYearsField.setEnabled(enabled);
        this.offsetMonthsField.setEnabled(enabled);
        this.offsetDaysField.setEnabled(enabled);
        this.dateChooserField.setEnabled(enabled);
        this.specialValueComboBox.setEnabled(enabled);
        this.retentionClassField.setEnabled(enabled);
        this.advancedField.setEnabled(enabled);
        this.retentionTypeComboBox.setEnabled(enabled);
    }

    private void enableIndexFields(boolean enabled) {
        GUIHelper.enableComponent(this.indexPanel, enabled);
        this.indexTitle.setTitleColor(enabled ? GUIHelper.ENABLED_TITLE_COLOR : GUIHelper.DISABLED_TITLE_COLOR);
    }

    private void initState(boolean indexSettingsEnabled, Boolean index, Boolean shred, Boolean hold, Retention retention, boolean retentionClassesSupported, boolean useIngestSettings) {
        this.enableIndexFields(indexSettingsEnabled);
        if (indexSettingsEnabled) {
            if (index == null) {
                this.indexDefaultRadio.setSelected(true);
            } else if (index.booleanValue()) {
                this.indexYesRadio.setSelected(true);
            } else {
                this.indexNoRadio.setSelected(true);
            }
        }
        if (shred == null) {
            this.shredDefaultRadio.setSelected(true);
        } else if (shred.booleanValue()) {
            this.shredYesRadio.setSelected(true);
        } else {
            this.shredNoRadio.setSelected(true);
        }
        if (!useIngestSettings && hold == null) {
            this.holdDefaultRadio.setSelected(true);
        } else if (hold != null && hold.booleanValue()) {
            this.holdYesRadio.setSelected(true);
        } else {
            this.holdNoRadio.setSelected(true);
        }
        if (retentionClassesSupported) {
            if (useIngestSettings) {
                this.retentionTypeComboBox.setModel(new DefaultComboBoxModel<String>(INGEST_RETENTION_TYPES));
            } else {
                this.retentionTypeComboBox.setModel(new DefaultComboBoxModel<String>(MODIFY_RETENTION_TYPES));
            }
        } else if (useIngestSettings) {
            this.retentionTypeComboBox.setModel(new DefaultComboBoxModel<String>(INGEST_RESTRICTED_RETENTION_TYPES));
        } else {
            this.retentionTypeComboBox.setModel(new DefaultComboBoxModel<String>(MODIFY_RESTRICTED_RETENTION_TYPES));
        }
        if (retention != null) {
            Retention.Type retentionType = retention.getType();
            this.retentionTypeComboBox.setSelectedItem(retentionType.uiName());
            switch (retentionType) {
                default: {
                    break;
                }
                case SPECIAL_VALUE: {
                    this.specialValueComboBox.setSelectedItem(retention.getUIValue());
                    break;
                }
                case FIXED_DATE: {
                    this.dateChooserField.setDate(retention.getDate());
                    break;
                }
                case OFFSET: {
                    this.offsetYearsField.setText("" + retention.getYears());
                    this.offsetMonthsField.setText("" + retention.getMonths());
                    this.offsetDaysField.setText("" + retention.getDays());
                    break;
                }
                case RETENTION_CLASS: {
                    this.retentionClassField.setText(retention.getUIValue());
                    break;
                }
                case ADVANCED: {
                    this.advancedField.setText(retention.getUIValue());
                }
            }
        }
    }

    private void onRetentionTypeChange(ItemEvent evt) {
        this.retentionCardLayout.show(this.retentionCardPanel, (String)evt.getItem());
    }

    public Retention getRetention() throws IllegalArgumentException {
        Retention retention;
        String selectedRetentionStr = (String)this.retentionTypeComboBox.getSelectedItem();
        Retention.Type type = NO_CHANGE_TEXT.equals(selectedRetentionStr) ? Retention.Type.DEFAULT : Retention.Type.fromUIName(selectedRetentionStr);
        block0 : switch (type) {
            default: {
                retention = Retention.DEFAULT;
                break;
            }
            case SPECIAL_VALUE: {
                Retention.SpecialValueType svType = Retention.SpecialValueType.fromUIName((String)this.specialValueComboBox.getSelectedItem());
                switch (svType) {
                    default: {
                        retention = Retention.DELETION_ALLOWED;
                        break block0;
                    }
                    case DELETION_PROHIBITED: {
                        retention = Retention.DELETION_PROHIBITED;
                        break block0;
                    }
                    case INITIAL_UNSPECIFIED: 
                }
                retention = Retention.INITIAL_UNSPECIFIED;
                break;
            }
            case FIXED_DATE: {
                Date date = this.dateChooserField.getDate();
                if (date == null) {
                    throw new IllegalArgumentException("You must enter a valid date for fixed date retention.");
                }
                retention = Retention.fromFixedDate(date);
                break;
            }
            case OFFSET: {
                retention = this.getOffsetRetention();
                break;
            }
            case RETENTION_CLASS: {
                String className = this.retentionClassField.getText().trim();
                if (className.length() == 0) {
                    throw new IllegalArgumentException("You must enter a retention class name.");
                }
                retention = Retention.fromRetentionClass(className);
                break;
            }
            case ADVANCED: {
                String advancedRetStr = this.advancedField.getText().trim();
                if (advancedRetStr.length() == 0) {
                    throw new IllegalArgumentException("You must enter an advanced retention string.");
                }
                retention = Retention.createAdvanced(this.advancedField.getText());
            }
        }
        return retention;
    }

    private Retention getOffsetRetention() throws IllegalArgumentException {
        int years = PoliciesPanel.offsetToInt(this.offsetYearsField.getText(), "Years");
        int months = PoliciesPanel.offsetToInt(this.offsetMonthsField.getText(), "Months");
        int days = PoliciesPanel.offsetToInt(this.offsetDaysField.getText(), "Days");
        if (years == 0 && months == 0 && days == 0) {
            throw new IllegalArgumentException("At least one of the offset retention values (Years, Months, Days) must be a positive integer");
        }
        if (years < 0 || months < 0 || days < 0) {
            throw new IllegalArgumentException("The offset retention values (Years, Months, Days) may not be negative values");
        }
        return Retention.fromOffset(years, months, days);
    }

    private static int offsetToInt(String val, String fieldName) throws IllegalArgumentException {
        if (val == null || val.trim().equals("")) {
            return 0;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            String msg = "The retention offset " + fieldName + " value is invalid.  It must be an integer";
            throw new IllegalArgumentException(msg);
        }
    }

    public Boolean getShred() {
        if (this.shredYesRadio.isSelected()) {
            return Boolean.TRUE;
        }
        if (this.shredNoRadio.isSelected()) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Boolean getIndex() {
        if (this.indexYesRadio.isSelected()) {
            return Boolean.TRUE;
        }
        if (this.indexNoRadio.isSelected()) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Boolean getHold() {
        if (this.holdYesRadio.isSelected()) {
            return Boolean.TRUE;
        }
        if (this.holdNoRadio.isSelected()) {
            return Boolean.FALSE;
        }
        return null;
    }
}

