/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.panels;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcmover.gui.HistoryManager;
import com.archivas.clienttools.arcmover.gui.JobAlreadyOpenException;
import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.archivas.clienttools.arcmover.gui.MoverTransferHandler;
import com.archivas.clienttools.arcmover.gui.panels.FixedHeightPanel;
import com.archivas.clienttools.arcmover.gui.panels.OpenFileThread;
import com.archivas.clienttools.arcmover.gui.profileadapter.Hcp3AuthNamepaceProfilePanelAdapter;
import com.archivas.clienttools.arcmover.gui.profileadapter.ProfilePanelAdapter;
import com.archivas.clienttools.arcmover.gui.ssl.SSLCertificateDialog;
import com.archivas.clienttools.arcmover.gui.util.FileListTable;
import com.archivas.clienttools.arcmover.gui.util.FileListTableModel;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.api.ArcMoverEngine;
import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.api.jobs.DeleteJob;
import com.archivas.clienttools.arcutils.api.jobs.SetMetadataJob;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterLiteralException;
import com.archivas.clienttools.arcutils.model.ArcDeleteFile;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcMoverFileDefaultComparator;
import com.archivas.clienttools.arcutils.model.ArcMoverVersionedFileComparator;
import com.archivas.clienttools.arcutils.model.ArcSetMetadataFile;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.FileSystemProfile;
import com.archivas.clienttools.arcutils.profile.HCAPProfile;
import com.archivas.clienttools.arcutils.profile.ProfileManager;
import com.archivas.clienttools.arcutils.profile.ProfileType;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.JTableHeader;

public class ProfilePanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(ProfilePanel.class.getName());
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String VERSION_PREFIX = "Versions for: ";
    public static final int UI_FIRST_BATCH_SIZE = HCPMoverProperties.UI_FIRST_BATCH_SIZE.getAsInt();
    private static final String BROWSE_LFS_TEXT = "Browse Local File System";
    private FileListTableModel fileListModel;
    private FileListTable fileList;
    private JScrollPane fileListScrollPane;
    private JButton refreshButton;
    private JComboBox pathCombo;
    private PathComboActionListener pathComboActionListener;
    private ProfileComboBoxModel profileModel;
    private JComboBox profileSelectionCombo;
    private JButton upDirectoryButton;
    private JButton browseDirectoryButton;
    private JButton sslButton;
    private JButton homeDirectoryButton;
    private ArcMoverEngine arcMoverEngine = ArcMoverFactory.getInstance();
    private ArcMoverDirectory currentDir;
    private ArcMoverFile selectedFile = null;
    private boolean selectionIsReadOnly = false;
    private boolean forceRefresh = false;
    private JPopupMenu rightClickMenu = new JPopupMenu();
    private JMenuItem openMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem setMetadataMenuItem;
    private JMenuItem renameMenuItem;
    private JMenuItem refreshMenuItem;
    private JMenuItem mkdirMenuItem;
    private JMenuItem browseMenuItem;
    private JMenuItem propertiesMenuItem;
    private int lockCount = 0;
    public static String LOCK_PROPERTY = "locked";

    private void subSetEnabled(boolean enabled) {
        if (!SwingUtilities.isEventDispatchThread()) {
            String errMsg = "subSetEnabled is not on the EDT but it should be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        this.enableDragAndDrop(enabled);
        GUIHelper.enableComponent(this, enabled);
        this.setEnabled(true);
        this.sslButton.setEnabled(enabled && this.profileModel.getProfileAdapter() != null && this.profileModel.getProfileAdapter().getSSLCertChain() != null);
        this.browseDirectoryButton.setEnabled(enabled && this.getSelectedProfile().getType() == ProfileType.FILESYSTEM);
        JTableHeader header = this.fileList.getTableHeader();
        if (header != null) {
            header.setResizingAllowed(enabled);
        }
    }

    public boolean isLocked() {
        return this.lockCount > 0;
    }

    private void lock() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String errMsg = "lock is not on the EDT but it should be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        ++this.lockCount;
        this.updateLockState();
        if (this.lockCount == 1) {
            this.firePropertyChange(LOCK_PROPERTY, false, true);
        }
    }

    private void unlock() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String errMsg = "unlock is not on the EDT but it should be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        --this.lockCount;
        if (this.lockCount < 0) {
            String errMsg = "lockCount is less than zero: " + this.lockCount;
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        this.updateLockState();
        if (this.lockCount == 0) {
            this.firePropertyChange(LOCK_PROPERTY, true, false);
        }
    }

    private void updateLockState() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String errMsg = "updateLockState is not on the EDT but it should be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        boolean locked = this.isLocked();
        if (locked) {
            this.setCursor(HCPDataMigrator.waitCursor);
        }
        this.subSetEnabled(!locked);
        if (!locked) {
            this.setCursor(null);
        }
    }

    public ProfilePanel() {
        this.initGuiComponents();
        this.initializeMouseListener();
        this.initializeActionListeners();
        this.initializeAddressBar();
        this.enableDragAndDrop(true);
        this.initializeRightClickMenu();
    }

    private void initGuiComponents() {
        this.fileListModel = new FileListTableModel();
        this.fileList = new FileListTable(this.fileListModel);
        this.fileList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ProfilePanel.this.openSelectedFile();
                    e.consume();
                }
            }
        });
        this.fileList.setAutoCreateColumnsFromModel(true);
        this.fileList.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        this.fileList.setFillsViewportHeight(true);
        this.fileList.setGridColor(new Color(-1));
        this.fileListScrollPane = new JScrollPane(this.fileList);
        this.fileListScrollPane.setAutoscrolls(false);
        this.fileListScrollPane.setBackground(UIManager.getColor("TableHeader.background"));
        this.fileListScrollPane.setPreferredSize(new Dimension(100, 128));
        this.fileListScrollPane.setEnabled(false);
        JToolBar toolBar1 = new JToolBar();
        toolBar1.setBorderPainted(false);
        toolBar1.setFloatable(false);
        toolBar1.setRollover(true);
        toolBar1.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.homeDirectoryButton = new JButton();
        this.homeDirectoryButton.setHorizontalAlignment(2);
        this.homeDirectoryButton.setIcon(GUIHelper.HOME_ICON);
        this.homeDirectoryButton.setMargin(new Insets(3, 3, 3, 3));
        this.homeDirectoryButton.setText("");
        this.homeDirectoryButton.setToolTipText("Go to home directory");
        this.homeDirectoryButton.setEnabled(false);
        toolBar1.add(this.homeDirectoryButton);
        this.refreshButton = new JButton();
        this.refreshButton.setHorizontalAlignment(2);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/images/refresh.gif")));
        this.refreshButton.setMargin(new Insets(3, 3, 3, 3));
        this.refreshButton.setText("");
        this.refreshButton.setToolTipText("Refresh current directory listing");
        this.refreshButton.setEnabled(false);
        toolBar1.add(this.refreshButton);
        this.upDirectoryButton = new JButton();
        this.upDirectoryButton.setHideActionText(false);
        this.upDirectoryButton.setHorizontalAlignment(2);
        this.upDirectoryButton.setIcon(GUIHelper.UP_DIR_ICON);
        this.upDirectoryButton.setMargin(new Insets(3, 3, 3, 3));
        this.upDirectoryButton.setToolTipText("Up");
        this.upDirectoryButton.setEnabled(false);
        toolBar1.add(this.upDirectoryButton);
        this.browseDirectoryButton = new JButton();
        this.browseDirectoryButton.setHideActionText(false);
        this.browseDirectoryButton.setHorizontalAlignment(2);
        this.browseDirectoryButton.setIcon(GUIHelper.DIRECTORY_ICON);
        this.browseDirectoryButton.setMargin(new Insets(3, 3, 3, 3));
        this.browseDirectoryButton.setToolTipText(BROWSE_LFS_TEXT);
        this.browseDirectoryButton.setEnabled(false);
        toolBar1.add(this.browseDirectoryButton);
        this.profileModel = new ProfileComboBoxModel();
        this.profileSelectionCombo = new JComboBox(this.profileModel);
        this.profileSelectionCombo.setEnabled(false);
        this.profileSelectionCombo.setToolTipText("Select a namespace profile");
        this.profileSelectionCombo.setPrototypeDisplayValue("#");
        this.pathCombo = new JComboBox();
        this.pathCombo.setEditable(false);
        this.pathCombo.setEnabled(false);
        this.pathCombo.setToolTipText("Current directory path");
        this.pathCombo.setPrototypeDisplayValue("#");
        this.sslButton = new JButton();
        this.sslButton.setAlignmentY(0.0f);
        this.sslButton.setBorderPainted(false);
        this.sslButton.setHorizontalAlignment(2);
        this.sslButton.setHorizontalTextPosition(11);
        this.sslButton.setIcon(new ImageIcon(this.getClass().getResource("/images/lockedstate.gif")));
        this.sslButton.setMargin(new Insets(0, 0, 0, 0));
        this.sslButton.setMaximumSize(new Dimension(20, 20));
        this.sslButton.setMinimumSize(new Dimension(20, 20));
        this.sslButton.setPreferredSize(new Dimension(20, 20));
        this.sslButton.setText("");
        this.sslButton.setToolTipText("View certificate");
        this.sslButton.setEnabled(false);
        FixedHeightPanel profileAndToolbarPanel = new FixedHeightPanel();
        profileAndToolbarPanel.setLayout(new BoxLayout(profileAndToolbarPanel, 0));
        profileAndToolbarPanel.add(this.profileSelectionCombo);
        profileAndToolbarPanel.add(Box.createHorizontalStrut(25));
        profileAndToolbarPanel.add(toolBar1);
        FixedHeightPanel pathPanel = new FixedHeightPanel();
        pathPanel.setLayout(new BoxLayout(pathPanel, 0));
        this.pathCombo.setAlignmentY(0.5f);
        pathPanel.add(this.pathCombo);
        pathPanel.add(Box.createHorizontalStrut(5));
        this.sslButton.setAlignmentY(0.5f);
        pathPanel.add(this.sslButton);
        this.setLayout(new BoxLayout(this, 1));
        this.add(profileAndToolbarPanel);
        this.add(Box.createVerticalStrut(5));
        this.add(pathPanel);
        this.add(Box.createVerticalStrut(5));
        this.add(this.fileListScrollPane);
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
    }

    public void setFileFont(Font newFont) {
        this.pathCombo.setFont(newFont);
        this.fileList.setFileFont(newFont);
        this.repaint();
    }

    public Font getFileFont() {
        return this.fileList.getFont();
    }

    public void enableDragAndDrop(boolean flag) {
        flag = flag && !this.isSelectionReadOnly();
        MoverTransferHandler moveTransferHandler = new MoverTransferHandler(this);
        this.fileList.setTransferHandler(moveTransferHandler);
        this.fileList.setDragEnabled(true);
        this.fileList.setDropMode(DropMode.INSERT_ROWS);
        moveTransferHandler.setDropEnabled(flag);
    }

    private void initializeMouseListener() {
        this.fileList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProfilePanel.this.onFileListSelectionChangedAction(e);
            }
        });
        this.fileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ProfilePanel.this.onFileListMouseClicked(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ProfilePanel.this.onFileListMouseClicked(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ProfilePanel.this.onFileListMouseDoubleClicked();
                }
            }
        });
    }

    private void updateSelectedFile() {
        int selection = this.fileList.getSelectedRow();
        this.selectedFile = selection >= 0 ? this.fileListModel.getFileAt(selection) : null;
    }

    private void onFileListSelectionChangedAction(ListSelectionEvent evt) {
        try {
            this.updateSelectedFile();
            if (this.selectedFile != null) {
                HCPDataMigrator.getInstance().selectionFromPanel(this);
            }
            HCPDataMigrator.getInstance().updateLockable();
            this.updateRightClickMenu();
        }
        catch (Exception e) {
            String msg = DBUtils.getErrorMessage("An error occurred selecting file", e);
            LOG.log(Level.WARNING, msg, e);
            GUIHelper.showMessageDialog(this, msg, "Error Selecting File", 0);
        }
    }

    private void initializeRightClickMenu() {
        this.openMenuItem = new JMenuItem("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProfilePanel.this.setCursor(HCPDataMigrator.waitCursor);
                    ProfilePanel.this.openSelectedRow();
                }
                finally {
                    ProfilePanel.this.setCursor(null);
                }
            }
        });
        this.rightClickMenu.add(this.openMenuItem);
        this.rightClickMenu.addSeparator();
        this.deleteMenuItem = new JMenuItem("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProfilePanel.this.setCursor(HCPDataMigrator.waitCursor);
                    ProfilePanel.this.deleteSelectedRows();
                }
                finally {
                    ProfilePanel.this.setCursor(null);
                }
            }
        });
        this.rightClickMenu.add(this.deleteMenuItem);
        this.setMetadataMenuItem = new JMenuItem("Set Metadata");
        this.setMetadataMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProfilePanel.this.setCursor(HCPDataMigrator.waitCursor);
                    ProfilePanel.this.setMetadataOnSelectedRows();
                }
                finally {
                    ProfilePanel.this.setCursor(null);
                }
            }
        });
        this.rightClickMenu.add(this.setMetadataMenuItem);
        this.renameMenuItem = new JMenuItem("Rename");
        this.renameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProfilePanel.this.setCursor(HCPDataMigrator.waitCursor);
                    ProfilePanel.this.renameSelectedRow();
                }
                finally {
                    ProfilePanel.this.setCursor(null);
                }
            }
        });
        this.rightClickMenu.add(this.renameMenuItem);
        this.rightClickMenu.addSeparator();
        this.refreshMenuItem = new JMenuItem("Refresh");
        this.refreshMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel.this.refreshPathAndFileList();
            }
        });
        this.rightClickMenu.add(this.refreshMenuItem);
        this.mkdirMenuItem = new JMenuItem("New Directory");
        this.mkdirMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel.this.mkdirAction();
            }
        });
        this.rightClickMenu.add(this.mkdirMenuItem);
        this.browseMenuItem = new JMenuItem(BROWSE_LFS_TEXT);
        this.browseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel.this.setPathToBrowseDirectory();
            }
        });
        this.rightClickMenu.add(this.browseMenuItem);
        this.rightClickMenu.addSeparator();
        this.propertiesMenuItem = new JMenuItem("Properties");
        this.propertiesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProfilePanel.this.setCursor(HCPDataMigrator.waitCursor);
                    ProfilePanel.this.displaySelectedObjectProperties();
                }
                finally {
                    ProfilePanel.this.setCursor(null);
                }
            }
        });
        this.rightClickMenu.add(this.propertiesMenuItem);
    }

    public boolean supportsOpenAction(ArcMoverFile file, boolean single) {
        ProfilePanelAdapter profileAdapter = this.profileModel.getProfileAdapter();
        return this.supportsOpenAction(file, single, profileAdapter);
    }

    public boolean supportsDeleteAction(ArcMoverFile file, boolean single) {
        ProfilePanelAdapter profileAdapter = this.profileModel.getProfileAdapter();
        return this.supportsDeleteAction(file, single, profileAdapter);
    }

    public boolean supportsSetMetadataAction(ArcMoverFile file, boolean single) {
        ProfilePanelAdapter profileAdapter = this.profileModel.getProfileAdapter();
        return this.supportsSetMetadataAction(file, single, profileAdapter);
    }

    public boolean supportsRenameAction(ArcMoverFile file, boolean single) {
        ProfilePanelAdapter profileAdapter = this.profileModel.getProfileAdapter();
        return this.supportsRenameAction(file, single, profileAdapter);
    }

    public boolean supportsRefreshAction(ArcMoverFile file, boolean single) {
        ProfilePanelAdapter profileAdapter = this.profileModel.getProfileAdapter();
        return this.supportsRefreshAction(file, single, profileAdapter);
    }

    public boolean supportsMkdirAction(ArcMoverFile file, boolean single) {
        ProfilePanelAdapter profileAdapter = this.profileModel.getProfileAdapter();
        return this.supportsMkdirAction(file, single, profileAdapter);
    }

    public boolean supportsPropertiesAction(ArcMoverFile file, boolean single) {
        ProfilePanelAdapter profileAdapter = this.profileModel.getProfileAdapter();
        return this.supportsPropertiesAction(file, single, profileAdapter);
    }

    private boolean supportsOpenAction(ArcMoverFile file, boolean single, ProfilePanelAdapter profileAdapter) {
        return profileAdapter != null && profileAdapter.supportsOpenAction(file, single);
    }

    private boolean supportsDeleteAction(ArcMoverFile file, boolean single, ProfilePanelAdapter profileAdapter) {
        return profileAdapter != null && profileAdapter.supportsDeleteAction(file, single);
    }

    private boolean supportsSetMetadataAction(ArcMoverFile file, boolean single, ProfilePanelAdapter profileAdapter) {
        return profileAdapter != null && profileAdapter.supportsSetMetadataAction(file, single);
    }

    private boolean supportsRenameAction(ArcMoverFile file, boolean single, ProfilePanelAdapter profileAdapter) {
        return profileAdapter != null && profileAdapter.supportsRenameAction(file, single);
    }

    private boolean supportsRefreshAction(ArcMoverFile file, boolean single, ProfilePanelAdapter profileAdapter) {
        return profileAdapter != null && profileAdapter.supportsRefreshAction(file, single);
    }

    private boolean supportsMkdirAction(ArcMoverFile file, boolean single, ProfilePanelAdapter profileAdapter) {
        return profileAdapter != null && profileAdapter.supportsMkdirAction(file, single);
    }

    private boolean supportsPropertiesAction(ArcMoverFile file, boolean single, ProfilePanelAdapter profileAdapter) {
        return profileAdapter != null && profileAdapter.supportsPropertiesAction(file, single);
    }

    private void updateRightClickMenu() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String errMsg = "updateRightClickMenu is not on the EDT but it should be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        ProfilePanelAdapter profileAdapter = this.profileModel.getProfileAdapter();
        if (profileAdapter != null) {
            boolean single = this.getSelectedRowCount() == 1;
            this.openMenuItem.setEnabled(this.supportsOpenAction(this.selectedFile, single, profileAdapter));
            boolean showDelete = !this.currentDir.isVersionList() && this.supportsDeleteAction(this.selectedFile, single, profileAdapter) && !JobDialog.isOpen();
            this.deleteMenuItem.setEnabled(showDelete);
            boolean showSetMetadata = !this.currentDir.isVersionList() && this.supportsSetMetadataAction(this.selectedFile, single, profileAdapter) && !JobDialog.isOpen();
            this.setMetadataMenuItem.setEnabled(showSetMetadata);
            boolean showRename = this.supportsRenameAction(this.selectedFile, single, profileAdapter) && !JobDialog.isOpen();
            this.renameMenuItem.setEnabled(showRename);
            this.refreshMenuItem.setEnabled(this.supportsRefreshAction(this.selectedFile, single, profileAdapter));
            boolean showMkdir = !this.currentDir.isVersionList() && this.supportsMkdirAction(this.selectedFile, single, profileAdapter);
            this.mkdirMenuItem.setEnabled(showMkdir);
            this.propertiesMenuItem.setEnabled(this.supportsPropertiesAction(this.selectedFile, single, profileAdapter));
        }
        this.browseMenuItem.setEnabled(FileSystemProfile.LOCAL_FILESYSTEM_PROFILE == this.getSelectedProfile());
    }

    private void initializeActionListeners() {
        this.upDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel.this.setPathAndFileListUpDirectory();
            }
        });
        this.homeDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel.this.setPathAndFileListToHomeDirectory();
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel.this.refreshPathAndFileList();
            }
        });
        this.browseDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel.this.setPathToBrowseDirectory();
            }
        });
        this.profileSelectionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilePanel.this.onProfileSelected();
            }
        });
        this.sslButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ProfilePanel.this.setCursor(HCPDataMigrator.waitCursor);
                    ProfilePanel.this.showSSLCert();
                }
                finally {
                    ProfilePanel.this.setCursor(null);
                }
            }
        });
    }

    private String browseDirectory() {
        if (this.getSelectedProfile() != FileSystemProfile.LOCAL_FILESYSTEM_PROFILE) {
            return null;
        }
        String loadPath = this.currentDir.getPath();
        JFileChooser chooser = new JFileChooser(loadPath);
        chooser.setFileSelectionMode(1);
        int retVal = chooser.showOpenDialog(this);
        if (retVal == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private void setPathToBrowseDirectory() {
        try {
            String path = this.browseDirectory();
            if (path != null) {
                this.setPathAndFileListToDirectory(path);
            }
        }
        catch (Exception e) {
            String msg = DBUtils.getErrorMessage("An error occurred selecting a directory", e);
            LOG.warning(msg);
            GUIHelper.showMessageDialog(this, msg, "Error Selecting Directory", 0);
        }
    }

    private void onProfileSelected() {
        this.lock();
        new SetProfileWorker().execute();
    }

    private void setProfile() {
        AbstractProfileBase profile = this.profileModel.getSelectedProfile();
        ProfilePanelAdapter profileAdapter = this.profileModel.getProfileAdapter();
        String[] paths = HistoryManager.openHistory(profile);
        try {
            if (!ArcMoverFactory.getInstance().testConnection(profile)) {
                throw new IllegalStateException(String.format("Cannot connect to profile %s.", profile.getName()));
            }
            if (paths.length == 0) {
                paths = new String[]{profileAdapter.getHomeDirectory().getPath()};
            }
            String path = paths[0];
            boolean tryHome = false;
            ArcMoverDirectory dir = null;
            try {
                List<String> fileListColumns = profileAdapter.getFileListColumns();
                path = this.stripVersioningIfUnsupported(path);
                boolean isVersioned = this.isVersioned(path);
                if (isVersioned) {
                    dir = profileAdapter.getVersions(this.filePath(path));
                    fileListColumns = ((Hcp3AuthNamepaceProfilePanelAdapter)profileAdapter).getVersionListColumns();
                } else {
                    dir = profileAdapter.getDirectory(path);
                }
                this.setFileListToDirectory(dir, fileListColumns);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "An error occurred opening directory " + path + " on profile " + profile.getName(), e);
                Throwable rootCause = e;
                while (rootCause.getCause() != null) {
                    rootCause = rootCause.getCause();
                }
                if (rootCause instanceof SSLPeerUnverifiedException) {
                    throw e;
                }
                tryHome = true;
            }
            if (tryHome) {
                String badPath = path;
                dir = profileAdapter.getHomeDirectory();
                path = dir.getPath();
                this.setFileListToDirectory(dir, profileAdapter.getFileListColumns());
                HistoryManager.removeFromHistory(profile, badPath);
                paths = HistoryManager.addToHistory(profile, path);
            }
            this.setCurrent(dir, path, paths, profile);
            this.profileSelectionCombo.setToolTipText(profile.getName());
            HCPDataMigrator.getInstance().saveSelectedProfile(this, profile.getName());
        }
        catch (Exception e) {
            String msg = "An error occurred opening profile " + profile.getName();
            Throwable rootCause = e;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            if (rootCause instanceof StorageAdapterLiteralException) {
                Integer statusCode = ((StorageAdapterLiteralException)rootCause).getStatusCode();
                if (statusCode != null && statusCode == 403) {
                    switch (profile.getType()) {
                        case HCP60: 
                        case HCP50: 
                        case HCP: {
                            msg = msg + ": Access denied, please check that the proper protocols are enabled on the namespace and that the user has the correct permissions";
                            break;
                        }
                        case HCAP2: 
                        case HCP_DEFAULT: {
                            msg = msg + ": Access denied, please check that the proper protocols are enabled";
                            break;
                        }
                        default: {
                            msg = msg + ": " + rootCause.getMessage();
                            break;
                        }
                    }
                } else {
                    msg = msg + ": " + rootCause.getMessage();
                }
            } else if (rootCause instanceof SSLPeerUnverifiedException) {
                msg = String.format("SSL certificate is not trusted for profile %s.", profile.getName());
            }
            AbstractProfileBase currentProfile = this.pathComboActionListener.getCurrentProfile();
            if (currentProfile == null || currentProfile == profile) {
                currentProfile = FileSystemProfile.LOCAL_FILESYSTEM_PROFILE;
            }
            final AbstractProfileBase currentProfileR = currentProfile;
            GUIHelper.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ProfilePanel.this.profileSelectionCombo.setSelectedItem(currentProfileR);
                }
            }, "reset the current profile after an error");
            GUIHelper.showMessageDialog(this, msg, "Error Opening Profile", 0);
            LOG.log(Level.SEVERE, msg, e);
        }
    }

    private void setCurrent(final ArcMoverDirectory dir, final String path, final String[] paths, final AbstractProfileBase profile) {
        if (SwingUtilities.isEventDispatchThread()) {
            String errMsg = "setCurrent is on the EDT but it should not be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        GUIHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ProfilePanel.this.setCurrentAux(dir, path, paths, profile);
            }
        }, "set current state");
    }

    private void setCurrentAux(ArcMoverDirectory dir, String path, String[] paths, AbstractProfileBase profile) {
        if (!SwingUtilities.isEventDispatchThread()) {
            String errMsg = "setCurrentAux is not on the EDT but it should be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        if (this.getSelectedProfile() == FileSystemProfile.LOCAL_FILESYSTEM_PROFILE) {
            String[] pathsWithBrowse = new String[paths.length + 1];
            pathsWithBrowse[0] = BROWSE_LFS_TEXT;
            System.arraycopy(paths, 0, pathsWithBrowse, 1, paths.length);
            paths = pathsWithBrowse;
        }
        this.pathCombo.setModel(new DefaultComboBoxModel<String>(paths));
        this.pathCombo.setEditable(true);
        this.currentDir = dir;
        this.pathComboActionListener.setCurrentPath(path);
        this.pathComboActionListener.setCurrentProfile(profile);
        profile.setDisplayPath(path);
        this.forceRefresh = false;
        this.pathCombo.setSelectedItem(path);
        this.pathCombo.setToolTipText(profile.decode(path));
        HCPDataMigrator.getInstance().updateLockable();
        this.updateRightClickMenu();
    }

    private void setPathAndFileListUpDirectory() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String errMsg = "setPathAndFileListUpDirectory is not on the EDT but it should be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        try {
            ArcMoverDirectory parent = this.currentDir.getParent();
            if (parent != null) {
                this.setPathAndFileListToDirectory(parent.getPath());
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, "An error occurred opening directory.  See logs for more information.", "Error Opening Directory", 0);
            LOG.log(Level.WARNING, "An error occurred getting a directory listing: " + e1.toString(), e1);
        }
    }

    private void setPathAndFileListToHomeDirectory() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String errMsg = "setPathAndFileListToHomeDirectory is not on the EDT but it should be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        try {
            ProfilePanelAdapter profileAdapter = this.profileModel.getProfileAdapter();
            this.setPathAndFileListToDirectory(profileAdapter.getHomeDirectory().getPath());
        }
        catch (Exception e) {
            String errMsg = DBUtils.getErrorMessage("An error occurred opening home directory", e);
            GUIHelper.showMessageDialog(this, errMsg, "Error Opening Directory", 0);
            LOG.log(Level.WARNING, "An error occurred getting the home directory listing: " + e.toString(), e);
        }
    }

    public void refreshPathAndFileList() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String errMsg = "refreshPathAndFileList is not on the EDT but it should be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        try {
            this.forceRefresh = true;
            if (this.currentDir.isVersionList()) {
                this.setPathAndFileListToDirectory(this.versionPath(this.currentDir));
            } else {
                this.setPathAndFileListToDirectory(this.currentDir.getPath());
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, "An error occurred refreshing the directory listing.  See logs for more information.", "Error Reloading Directory", 0);
            LOG.log(Level.WARNING, "An error occurred refreshing a directory listing: " + e1.toString(), e1);
        }
    }

    private void setPathAndFileListToDirectory(String path) {
        if (!SwingUtilities.isEventDispatchThread()) {
            String errMsg = "setPathAndFileListToDirectory is not on the EDT but it should be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        this.pathCombo.setSelectedItem(path);
    }

    private void setFileListToDirectory(ArcMoverDirectory dir, List<String> colsToDisplay) throws Exception {
        if (SwingUtilities.isEventDispatchThread()) {
            String errMsg = "setFileListToDirectory is on the EDT but it should not be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        List<ArcMoverFile> files = dir.getFileList(UI_FIRST_BATCH_SIZE);
        int badElementCnt = dir.getFileListBadElementCnt();
        ArrayList<ArcMoverFile> sortedDirs = new ArrayList<ArcMoverFile>();
        ArrayList<ArcMoverFile> sortedFiles = new ArrayList<ArcMoverFile>();
        ArrayList<ArcMoverFile> sortedSymlinks = new ArrayList<ArcMoverFile>();
        ArcMoverFile mostRecentVersion = null;
        boolean isVersionList = dir.isVersionList();
        for (ArcMoverFile f : files) {
            if (f.isDirectory()) {
                sortedDirs.add(f);
                continue;
            }
            if (f.isSymlink()) {
                sortedSymlinks.add(f);
                continue;
            }
            if (mostRecentVersion == null) {
                if (f.getMetadata().hasVersionNumber()) {
                    mostRecentVersion = f;
                }
            } else if (isVersionList && f.getMetadata().hasVersionNumber()) {
                mostRecentVersion.setLatestVersion(false);
                if (f.getMetadata().getVersionNumber() > mostRecentVersion.getMetadata().getVersionNumber()) {
                    mostRecentVersion = f;
                }
            }
            sortedFiles.add(f);
        }
        if (mostRecentVersion != null) {
            mostRecentVersion.setLatestVersion(true);
        }
        Collections.sort(sortedDirs);
        Collections.sort(sortedSymlinks);
        if (isVersionList) {
            Collections.sort(sortedFiles, ArcMoverVersionedFileComparator.getInstance());
        } else {
            Collections.sort(sortedFiles, ArcMoverFileDefaultComparator.getInstance());
        }
        files.clear();
        files.addAll(sortedDirs);
        files.addAll(sortedSymlinks);
        files.addAll(sortedFiles);
        GUIHelper.invokeAndWait(this.getFileListRunner(colsToDisplay, files, isVersionList, badElementCnt, dir.getPath()), "get file list");
    }

    private void setFileList(List<String> colsToDisplay, List<ArcMoverFile> files, boolean isVersionList, int badElementCnt, String dirPath) {
        this.fileListModel = new FileListTableModel(new ArrayList<String>(colsToDisplay));
        this.fileList.setModel(this.fileListModel);
        this.fileList.setColumnCellRenderers();
        this.fileList.setListData(new ArrayList<ArcMoverFile>(files));
        if (isVersionList) {
            this.fileList.setSelectionMode(0);
        } else {
            this.fileList.setSelectionMode(2);
        }
        if (badElementCnt > 0) {
            String errMsg = String.format("Warning: omitted %d unsupported filename(s) in directory listing for %s", badElementCnt, this.profileModel.getSelectedProfile().decode(dirPath));
            LOG.log(Level.WARNING, errMsg);
            if (HCPMoverProperties.DISPLAY_WARNINGS_FOR_BAD_ELEMENTS_IN_DIRECTORY_LISTINGS.getAsBoolean()) {
                GUIHelper.showMessageDialog(this, errMsg, "", 2);
            }
        }
    }

    private Runnable getFileListRunner(final List<String> colsToDisplay, final List<ArcMoverFile> files, final boolean isVersionList, final int badElementCnt, final String dirPath) {
        return new Runnable(){

            @Override
            public void run() {
                ProfilePanel.this.setFileList(colsToDisplay, files, isVersionList, badElementCnt, dirPath);
            }
        };
    }

    protected void initializeAddressBar() {
        this.pathComboActionListener = new PathComboActionListener();
        this.pathCombo.addActionListener(this.pathComboActionListener);
        this.pathCombo.setRenderer(new PathComboBoxRenderer());
        this.pathCombo.setEditor(new PathComboBoxEditor());
    }

    public void refreshProfiles() {
        this.profileModel.loadProfiles();
    }

    public void setSelectedProfile(AbstractProfileBase profile) {
        this.profileSelectionCombo.setSelectedItem(profile);
    }

    public AbstractProfileBase getSelectedProfile() {
        return this.profileModel.getSelectedProfile();
    }

    public ArcMoverDirectory getCurrentDirectory() {
        return this.currentDir;
    }

    public ArcMoverFile getFileAt(int row) {
        ArcMoverFile moverFile = null;
        try {
            moverFile = this.fileListModel.getFileAt(row);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return moverFile;
    }

    public void resizeFileList() {
        GUIHelper.autoResizeColWidth(this.fileList);
    }

    public void clearSelection() {
        this.fileList.clearSelection();
    }

    public ArcMoverFile[] getSelectedFiles() {
        int[] rows = this.fileList.getSelectedRows();
        ArcMoverFile[] files = new ArcMoverFile[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            files[i] = this.fileListModel.getFileAt(rows[i]);
        }
        return files;
    }

    public int getSelectedRowCount() {
        return this.fileList.getSelectedRowCount();
    }

    public int getNonDeletedSelectedFileCount() {
        int count = 0;
        for (int i : this.fileList.getSelectedRows()) {
            ArcMoverFile file = this.fileListModel.getFileAt(i);
            if (file.isDeleted()) continue;
            ++count;
        }
        return count;
    }

    private void onFileListMouseClicked(MouseEvent evt) {
        try {
            if (evt.isPopupTrigger()) {
                this.updateSelectedFile();
                this.updateRightClickMenu();
                this.rightClickMenu.show(this.fileList, evt.getX(), evt.getY());
            }
        }
        catch (Exception e1) {
            String msg = "Unexpected error showing right-click menu";
            LOG.log(Level.WARNING, msg, e1);
            JOptionPane.showMessageDialog(this, msg, "Error", 0);
        }
    }

    protected void openSelectedFile() {
        if (!SwingUtilities.isEventDispatchThread()) {
            String errMsg = "openSelectedFile is not on the EDT but it should be";
            IllegalStateException ex = new IllegalStateException(errMsg);
            LOG.log(Level.SEVERE, errMsg, ex);
            throw ex;
        }
        try {
            if (this.selectedFile != null) {
                if (this.selectedFile.isDirectory()) {
                    ArcMoverDirectory newDir = (ArcMoverDirectory)this.selectedFile;
                    if (!newDir.canRead()) {
                        GUIHelper.showMessageDialog(this, "An error occurred reading directory " + this.profileModel.getSelectedProfile().decode(newDir.getPath()), "Error Reading Directory", 0);
                    } else {
                        this.setPathAndFileListToDirectory(newDir.getPath());
                    }
                } else if (!this.selectedFile.isSymlink()) {
                    if (!this.selectedFile.getParent().isVersionList() && this.profileModel.getSelectedProfile().supportsVersioning()) {
                        this.setPathAndFileListToDirectory(this.versionPath(this.selectedFile));
                    } else {
                        this.openSelectedRow();
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = "Unexpected error";
            LOG.log(Level.WARNING, msg, e);
            JOptionPane.showMessageDialog(this, msg, "Error", 0);
        }
    }

    protected void onFileListMouseDoubleClicked() {
        this.updateSelectedFile();
        this.openSelectedFile();
        this.updateRightClickMenu();
    }

    private String filePath(String versionPath) {
        return versionPath.substring(VERSION_PREFIX.length());
    }

    private String versionPath(ArcMoverFile file) {
        return VERSION_PREFIX + file.getPath();
    }

    public final void openSelectedRow() {
        if (this.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "You may only open one object at a time", "", 1);
        }
        if (!this.selectedFile.isDirectory()) {
            OpenFileThread openFileThread = new OpenFileThread(this.selectedFile, this.profileModel.getProfileAdapter());
            openFileThread.execute();
        }
    }

    public final void renameSelectedRow() {
        try {
            String newFileName;
            if (this.getSelectedRowCount() != 1) {
                JOptionPane.showMessageDialog(this, "You may only rename one object at a time", "", 1);
                return;
            }
            String oldFileName = this.selectedFile.getFileName();
            String lSlug = this.selectedFile.isDirectory() ? "directory" : "file";
            String uSlug = this.selectedFile.isDirectory() ? "Directory" : "File";
            do {
                String message = String.format("New %s name", lSlug);
                String title = String.format("Rename %s", uSlug);
                newFileName = (String)JOptionPane.showInputDialog(this.getParent(), message, title, 3, null, null, this.selectedFile.getFileName());
                if (newFileName == null) {
                    LOG.info("Rename operation canceled");
                    return;
                }
                if (!newFileName.contains("/") && !newFileName.contains("\\")) continue;
                String errorMessage = String.format("Invalid %s name", lSlug);
                JOptionPane.showMessageDialog(this.getParent(), errorMessage, "Rename", 2);
                newFileName = null;
            } while (newFileName == null || newFileName.length() <= 0);
            try {
                boolean success = this.arcMoverEngine.renameTo(this.profileModel.getSelectedProfile(), this.selectedFile.getParent().getPath(), oldFileName, newFileName);
                if (!success) {
                    throw new IOException(String.format("Could not rename %s.", lSlug));
                }
                LOG.info("Renamed " + oldFileName + " to " + newFileName);
                HCPDataMigrator.getInstance().refreshMatchingPanels(this.profileModel.getSelectedProfile(), this.currentDir);
            }
            catch (Exception e1) {
                String logErrorMsg = "Could not rename " + this.selectedFile.getPath() + " to " + newFileName;
                String uiErrorMsg = DBUtils.getErrorMessage("Error renaming " + this.selectedFile.getPath(), e1);
                LOG.log(Level.WARNING, logErrorMsg, e1);
                GUIHelper.showMessageDialog(this.getParent(), uiErrorMsg, "Rename", 0);
            }
        }
        catch (RuntimeException e1) {
            LOG.log(Level.WARNING, "Unexpected Exception", e1);
            throw e1;
        }
    }

    public final void deleteSelectedRows() {
        try {
            ArcMoverFile[] selectedFiles = this.getSelectedFiles();
            if (selectedFiles.length > 0) {
                ArrayList<ArcDeleteFile> fileNameList = new ArrayList<ArcDeleteFile>();
                for (ArcMoverFile nextFile : selectedFiles) {
                    ArcDeleteFile nextDeleteFile = new ArcDeleteFile(nextFile);
                    fileNameList.add(nextDeleteFile);
                }
                DeleteJob job = new DeleteJob(this.getSelectedProfile(), fileNameList);
                job.setSourcePath(this.getCurrentDirectory().getPath());
                JobDialog.openNewJob(job);
                this.refreshPathAndFileList();
            }
        }
        catch (JobAlreadyOpenException jaoe) {
            JOptionPane.showMessageDialog(this, "Another job is already open.\nOnly one job may be open at a time.", "Error", 0);
            JobDialog.showJob();
        }
        catch (Exception e) {
            String msg = DBUtils.getErrorMessage("An error occurred deleting selected items", e);
            LOG.log(Level.WARNING, msg, e);
            GUIHelper.showMessageDialog(this, msg, "Error", 0);
        }
    }

    public final void setMetadataOnSelectedRows() {
        try {
            ArcMoverFile[] selectedFiles = this.getSelectedFiles();
            if (selectedFiles.length > 0) {
                ArrayList<ArcSetMetadataFile> fileNameList = new ArrayList<ArcSetMetadataFile>();
                for (ArcMoverFile nextFile : selectedFiles) {
                    ArcSetMetadataFile nextMdFile = new ArcSetMetadataFile(nextFile);
                    fileNameList.add(nextMdFile);
                }
                SetMetadataJob job = new SetMetadataJob(this.getSelectedProfile(), fileNameList);
                job.setSourcePath(this.getCurrentDirectory().getPath());
                JobDialog.openNewJob(job);
                this.refreshPathAndFileList();
            }
        }
        catch (JobAlreadyOpenException jaoe) {
            JOptionPane.showMessageDialog(this, "Another job is already open.\nOnly one job may be open at a time.", "Error", 0);
            JobDialog.showJob();
        }
        catch (Exception e) {
            String msg = DBUtils.getErrorMessage("An error occurred setting metadata on selected items", e);
            LOG.log(Level.WARNING, msg, e);
            GUIHelper.showMessageDialog(this, msg, "Error", 0);
        }
    }

    public void displaySelectedObjectProperties() {
        if (this.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "You may only display properties for one object at a time", "", 1);
        }
        String path = null;
        try {
            path = this.selectedFile.getPath();
            this.profileModel.getProfileAdapter().displayObjectProperties(this.selectedFile);
        }
        catch (Exception e) {
            String msg = DBUtils.getErrorMessage("An error occurred displaying properties for " + this.profileModel.getSelectedProfile().decode(path), e);
            LOG.log(Level.WARNING, msg, e);
            GUIHelper.showMessageDialog(this, msg, "Error Displaying Properties", 0);
        }
    }

    public void mkdirAction() {
        this.lock();
        new mkdirWorker().execute();
    }

    public void mkdirActionAux() {
        try {
            String newDirName;
            String newDirPath = null;
            do {
                if ((newDirName = (String)JOptionPane.showInputDialog(this.getParent(), "Name of new directory", "New Directory", 3, null, null, "directory name")) == null) {
                    LOG.info("Mkdir cancelled\n");
                    return;
                }
                ProfileType type = this.getSelectedProfile().getType();
                if (newDirName.contains("/") || type == ProfileType.FILESYSTEM && newDirName.contains(File.separator) || type == ProfileType.HCAP2 && newDirName.contains("&")) {
                    JOptionPane.showMessageDialog(this.getParent(), "Invalid directory name", "Error", 2);
                    newDirName = null;
                    continue;
                }
                String encodedDirName = newDirName;
                try {
                    encodedDirName = this.profileModel.getSelectedProfile().encode(newDirName);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.getParent(), "An error occurred encoding the directory name", "Error", 2);
                    LOG.log(Level.WARNING, String.format("An error occurred encoding directory <%s>", newDirName));
                    newDirName = null;
                    continue;
                }
                newDirPath = FileUtil.resolvePath(this.currentDir.getPath(), encodedDirName, this.profileModel.getSelectedProfile().getPathSeparator());
            } while (newDirName == null || newDirName.length() <= 0 || newDirPath == null);
            LOG.info("Creating new directory " + newDirPath);
            try {
                if (!this.arcMoverEngine.mkdir(this.profileModel.getSelectedProfile(), newDirPath)) {
                    String msg = "Could not create directory: Permission Denied";
                    throw new IOException(msg);
                }
                ArcMoverDirectory dir = this.profileModel.getProfileAdapter().getDirectory(newDirPath);
                GUIHelper.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ProfilePanel.this.refreshPathAndFileList();
                        HCPDataMigrator.getInstance().refreshMatchingPanels(ProfilePanel.this.profileModel.getSelectedProfile(), ProfilePanel.this.currentDir);
                    }
                }, "refresh after creating new directory");
            }
            catch (Exception e) {
                String uiErrorMsg;
                String logErrorMsg;
                if (e instanceof StorageAdapterException) {
                    logErrorMsg = e.getMessage();
                    uiErrorMsg = e.getMessage();
                } else {
                    logErrorMsg = "Could not create directory: " + newDirPath;
                    uiErrorMsg = DBUtils.getErrorMessage("Error creating directory " + this.profileModel.getSelectedProfile().decode(newDirPath), e);
                }
                LOG.log(Level.WARNING, logErrorMsg, e);
                GUIHelper.showMessageDialog(this.getParent(), uiErrorMsg, "Create Directory Error", 0);
            }
        }
        catch (RuntimeException e1) {
            LOG.log(Level.WARNING, "Unexpected Exception", e1);
            throw e1;
        }
    }

    private void showSSLCert() {
        new SSLCertificateDialog((HCAPProfile)this.getSelectedProfile()).setVisible(true);
    }

    public ArcMoverFile getSelectedFile() {
        return this.selectedFile;
    }

    public boolean isSelectionReadOnly() {
        return this.selectionIsReadOnly || this.currentDir != null && this.currentDir.isVersionList();
    }

    private boolean isVersioned(String path) {
        return path.startsWith(VERSION_PREFIX);
    }

    private String stripVersioningIfUnsupported(String path) throws StorageAdapterException {
        boolean supportsVersioning;
        boolean isVersioned = this.isVersioned(path);
        boolean bl = supportsVersioning = isVersioned && this.getSelectedProfile().supportsVersioning();
        if (isVersioned && !supportsVersioning) {
            path = path.substring(VERSION_PREFIX.length(), path.lastIndexOf(47) + 1);
        }
        return path;
    }

    private void setPath(String newPath, final String oldPath) {
        block9: {
            ProfilePanelAdapter adapter = this.profileModel.getProfileAdapter();
            try {
                ArcMoverDirectory dir = null;
                List<String> fileListColumns = adapter.getFileListColumns();
                newPath = this.stripVersioningIfUnsupported(newPath);
                boolean isVersioned = this.isVersioned(newPath);
                if (isVersioned) {
                    dir = adapter.getVersions(this.filePath(newPath));
                    fileListColumns = ((Hcp3AuthNamepaceProfilePanelAdapter)adapter).getVersionListColumns();
                } else {
                    dir = adapter.getDirectory(newPath);
                }
                this.setFileListToDirectory(dir, fileListColumns);
                AbstractProfileBase selectedProfile = this.profileModel.getSelectedProfile();
                String[] paths = HistoryManager.addToHistory(selectedProfile, newPath);
                this.setCurrent(dir, newPath, paths, selectedProfile);
            }
            catch (Exception e) {
                String msg = "An error occurred reading directory " + this.profileModel.getSelectedProfile().decode(newPath);
                if (e instanceof StorageAdapterLiteralException) {
                    msg = DBUtils.getErrorMessage(msg, e);
                }
                LOG.log(Level.WARNING, msg, e);
                GUIHelper.showMessageDialog(this, msg, "Error Reading Directory", 0);
                String[] paths = HistoryManager.removeFromHistory(this.profileModel.getSelectedProfile(), newPath);
                ArcMoverDirectory homeDir = null;
                boolean retreat = true;
                try {
                    homeDir = adapter.getHomeDirectory();
                }
                catch (Exception ie) {
                    LOG.log(Level.WARNING, "Could not determine home directory", e);
                    retreat = false;
                    GUIHelper.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ProfilePanel.this.profileSelectionCombo.setSelectedItem(FileSystemProfile.LOCAL_FILESYSTEM_PROFILE);
                        }
                    }, "change to the local file system profile");
                }
                if (!retreat) break block9;
                final String homePath = homeDir.getPath();
                if (oldPath.equals(newPath) && oldPath.equals(homePath)) {
                    this.forceRefresh = true;
                    GUIHelper.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ProfilePanel.this.profileSelectionCombo.setSelectedItem(FileSystemProfile.LOCAL_FILESYSTEM_PROFILE);
                        }
                    }, "change to the local file system profile");
                }
                if (oldPath.equals(newPath)) {
                    this.setCurrent(homeDir, homePath, paths, this.getSelectedProfile());
                    this.forceRefresh = true;
                    GUIHelper.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ProfilePanel.this.pathCombo.setSelectedItem(homePath);
                        }
                    }, "navigate to home directory");
                }
                this.forceRefresh = true;
                GUIHelper.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ProfilePanel.this.pathCombo.setSelectedItem(oldPath);
                    }
                }, "return to previous directory");
            }
        }
    }

    private class ProfileComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private List<AbstractProfileBase> profiles;
        private AbstractProfileBase selectedProfile;
        private ProfilePanelAdapter selectedAdapter;
        private List<ProfilePanelAdapter> adapters;

        public ProfileComboBoxModel() {
            this.loadProfiles();
        }

        public void loadProfiles() {
            AbstractProfileBase oldProfile = this.selectedProfile;
            this.selectedProfile = null;
            this.selectedAdapter = null;
            this.profiles = ProfileManager.getProfiles();
            this.profiles.add(0, FileSystemProfile.LOCAL_FILESYSTEM_PROFILE);
            this.adapters = new ArrayList<ProfilePanelAdapter>(this.profiles.size());
            for (AbstractProfileBase profile : this.profiles) {
                ProfilePanelAdapter adapter = profile.makeAdapter();
                this.adapters.add(adapter);
                if (!profile.equals(oldProfile)) continue;
                this.selectedProfile = profile;
                this.selectedAdapter = adapter;
            }
            if (this.selectedProfile == null) {
                this.selectedProfile = this.profiles.get(0);
                this.selectedAdapter = this.adapters.get(0);
            }
            this.setSelectedItem(this.selectedProfile);
            this.fireContentsChanged(this, 0, this.profiles.size());
        }

        @Override
        public int getSize() {
            return this.profiles.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.profiles.get(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            boolean foundProfile = false;
            for (int i = 0; i < this.profiles.size(); ++i) {
                if (!this.profiles.get(i).equals(anItem)) continue;
                this.selectedProfile = this.profiles.get(i);
                this.selectedAdapter = this.adapters.get(i);
                foundProfile = true;
                break;
            }
            if (!foundProfile) {
                throw new RuntimeException("Profile " + anItem + " not found in list");
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedProfile;
        }

        public AbstractProfileBase getSelectedProfile() {
            return this.selectedProfile;
        }

        public ProfilePanelAdapter getProfileAdapter() {
            return this.selectedAdapter;
        }
    }

    class SetPathWorker
    extends SwingWorker {
        String newPath;
        String oldPath;

        public SetPathWorker(String newPath, String oldPath) {
            this.newPath = newPath;
            this.oldPath = oldPath;
        }

        @Override
        protected void done() {
            ProfilePanel.this.unlock();
        }

        protected Object doInBackground() throws Exception {
            ProfilePanel.this.setPath(this.newPath, this.oldPath);
            return null;
        }
    }

    class PathComboBoxEditor
    implements ComboBoxEditor {
        private JTextField editField = new JTextField("", 9);
        private String valueToReturn;

        public PathComboBoxEditor() {
            this.editField.setBorder(null);
            this.editField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String path = PathComboBoxEditor.this.editField.getText().trim();
                    if (ProfilePanel.this.isVersioned(path)) {
                        PathComboBoxEditor.this.valueToReturn = ProfilePanel.VERSION_PREFIX + ProfilePanel.this.getSelectedProfile().encode(path.substring(ProfilePanel.VERSION_PREFIX.length()));
                    } else {
                        PathComboBoxEditor.this.valueToReturn = ProfilePanel.this.getSelectedProfile().encode(path);
                    }
                    ProfilePanel.this.pathCombo.setSelectedItem(PathComboBoxEditor.this.valueToReturn);
                }
            });
        }

        @Override
        public Component getEditorComponent() {
            return this.editField;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject != null) {
                this.valueToReturn = anObject.toString();
                this.editField.setText(ProfilePanel.this.getSelectedProfile().decode(this.valueToReturn));
            }
        }

        @Override
        public Object getItem() {
            return this.valueToReturn;
        }

        @Override
        public void selectAll() {
            this.editField.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.editField.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.editField.removeActionListener(l);
        }
    }

    class PathComboBoxRenderer
    extends BasicComboBoxRenderer {
        PathComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null && ProfilePanel.this.getSelectedProfile() != null) {
                value = ProfilePanel.this.getSelectedProfile().decode((String)value);
            }
            JComponent comp = (JComponent)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            comp.setToolTipText(String.valueOf(value));
            return comp;
        }
    }

    class PathComboActionListener
    implements ActionListener {
        private static final String CHANGE_COMMAND = "comboBoxChanged";
        private String currentPath = null;
        private AbstractProfileBase currentProfile = null;

        PathComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(CHANGE_COMMAND)) {
                String newPath = null;
                if (ProfilePanel.this.getSelectedProfile() == FileSystemProfile.LOCAL_FILESYSTEM_PROFILE && ProfilePanel.this.pathCombo.getSelectedIndex() == 0 && ProfilePanel.BROWSE_LFS_TEXT.equals(ProfilePanel.this.pathCombo.getSelectedItem())) {
                    newPath = ProfilePanel.this.browseDirectory();
                    ProfilePanel.this.forceRefresh = true;
                    if (newPath == null) {
                        newPath = this.currentPath;
                    }
                } else {
                    newPath = (String)ProfilePanel.this.pathCombo.getSelectedItem();
                }
                if (!ProfilePanel.this.forceRefresh && this.currentPath != null && this.currentPath.equals(newPath) && ProfilePanel.this.profileModel.getSelectedProfile() != null && ProfilePanel.this.profileModel.getSelectedProfile().equals(this.currentProfile)) {
                    return;
                }
                ProfilePanel.this.lock();
                new SetPathWorker(newPath, this.currentPath).execute();
            }
        }

        public void setCurrentPath(String path) {
            this.currentPath = path;
        }

        public void setCurrentProfile(AbstractProfileBase profile) {
            this.currentProfile = profile;
        }

        public AbstractProfileBase getCurrentProfile() {
            return this.currentProfile;
        }
    }

    class mkdirWorker
    extends SwingWorker {
        mkdirWorker() {
        }

        protected Object doInBackground() throws Exception {
            ProfilePanel.this.mkdirActionAux();
            return null;
        }

        @Override
        protected void done() {
            ProfilePanel.this.unlock();
        }
    }

    class SetProfileWorker
    extends SwingWorker {
        SetProfileWorker() {
        }

        protected Object doInBackground() throws Exception {
            try {
                ProfilePanel.this.setProfile();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error during setProfile", e);
            }
            return null;
        }

        @Override
        protected void done() {
            ProfilePanel.this.unlock();
        }
    }
}

