/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.panels;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class SplashPanel
extends JPanel {
    private static final Font TITLE_FONT = new Font("SansSerif", 1, 25);
    private static final Font SUBTITLE_FONT = new Font("SansSerif", 1, 20);
    private static final Font VERSION_FONT = new Font("SansSerif", 0, 11);
    private static final Color TITLE_COLOR = new Color(0xFFFFFF);
    private static final Color SUBTITLE_COLOR = new Color(16570049);
    private static final Color VERSION_COLOR = new Color(0xFFFFFF);
    private Image img;
    private String version;

    public SplashPanel(String img) {
        this(new ImageIcon(img).getImage());
    }

    public SplashPanel(Image img) {
        this.img = img;
        Dimension size = new Dimension(img.getWidth(null), img.getHeight(null));
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setSize(size);
        this.setLayout(null);
        this.version = HCPDataMigrator.class.getPackage().getSpecificationVersion();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int x = 30;
        g.drawImage(this.img, 0, 0, null);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(TITLE_FONT);
        g2d.setColor(TITLE_COLOR);
        g2d.drawString("Hitachi Content Platform", x, 60);
        g2d.setFont(SUBTITLE_FONT);
        g2d.setColor(SUBTITLE_COLOR);
        g2d.drawString("Data Migrator", x, 90);
        g2d.setFont(VERSION_FONT);
        g2d.setColor(VERSION_COLOR);
        int y = 195;
        FontMetrics fm = g2d.getFontMetrics();
        int lineHeight = fm.getHeight();
        g2d.drawString("Version: " + this.version, x, y);
        g2d.drawString("\u00a9  2013 Hitachi Data Systems Corporation.  All rights reserved.", x, y += lineHeight * 2);
    }
}

