/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.profileadapter;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcmover.gui.profileadapter.ProfilePanelAdapter;
import com.archivas.clienttools.arcmover.gui.properties.FilePropertiesDialog;
import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.profile.FileSystemProfile;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileSystemProfilePanelAdapter
implements ProfilePanelAdapter {
    public static final String NEWLINE = System.getProperty("line.separator");
    private FileSystemProfile profile;
    private List<String> fileListCols = new ArrayList<String>();

    public FileSystemProfilePanelAdapter(FileSystemProfile profile) {
        this.profile = profile;
        this.fileListCols.add("Name");
        this.fileListCols.add("Size");
        this.fileListCols.add("Modified Time");
    }

    @Override
    public ArcMoverDirectory getHomeDirectory() throws Exception {
        return this.getDirectory(System.getProperty("user.home"));
    }

    @Override
    public ArcMoverDirectory getDirectory(String path) throws Exception {
        return ArcMoverFactory.getInstance().getDirectoryListing(this.profile, path, false);
    }

    @Override
    public void displayObjectProperties(ArcMoverFile file) {
        FilePropertiesDialog d = new FilePropertiesDialog();
        d.populate(file);
        d.setTitle(file.getFileName() + " Properties");
        d.setLocationRelativeTo(HCPDataMigrator.getInstance());
        d.setVisible(true);
    }

    @Override
    public boolean supportsOpenAction(ArcMoverFile file, boolean single) {
        return single && file != null && !file.isDirectory();
    }

    @Override
    public boolean supportsDeleteAction(ArcMoverFile file, boolean single) {
        return file != null;
    }

    @Override
    public boolean supportsSetMetadataAction(ArcMoverFile file, boolean single) {
        return false;
    }

    @Override
    public boolean supportsRenameAction(ArcMoverFile file, boolean single) {
        return single && file != null;
    }

    @Override
    public boolean supportsRefreshAction(ArcMoverFile file, boolean single) {
        return file == null;
    }

    @Override
    public boolean supportsMkdirAction(ArcMoverFile file, boolean single) {
        return file == null;
    }

    @Override
    public boolean supportsPropertiesAction(ArcMoverFile file, boolean single) {
        return single && file != null;
    }

    public boolean supportsVersioning() throws Exception {
        return false;
    }

    @Override
    public ArcMoverDirectory getVersions(String path) throws Exception {
        return null;
    }

    @Override
    public String getFileForOpen(ArcMoverFile selectedFile) throws IOException, DatabaseException {
        return selectedFile.getPath();
    }

    @Override
    public SSLCertChain getSSLCertChain() {
        return null;
    }

    @Override
    public List<String> getFileListColumns() {
        return this.fileListCols;
    }
}

