/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.profileadapter;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcmover.gui.profileadapter.ProfilePanelAdapter;
import com.archivas.clienttools.arcmover.gui.properties.ObjectPropertiesDialog;
import com.archivas.clienttools.arcutils.api.ArcMoverFactory;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.jobs.CopyJob;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterMgr;
import com.archivas.clienttools.arcutils.impl.jobs.CopySingleFileAction;
import com.archivas.clienttools.arcutils.impl.jobs.FileStats;
import com.archivas.clienttools.arcutils.model.ArcCopyFile;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.profile.FileSystemProfile;
import com.archivas.clienttools.arcutils.profile.HCAPProfile;
import com.archivas.clienttools.arcutils.profile.ProfileType;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.net.SSLCertChain;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import javax.swing.JOptionPane;

public class HcapProfilePanelAdapter
implements ProfilePanelAdapter {
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final Logger LOG = Logger.getLogger(HcapProfilePanelAdapter.class.getName());
    protected HCAPProfile profile;
    private List<String> fileListCols = new ArrayList<String>();

    public HcapProfilePanelAdapter(HCAPProfile profile) {
        this.profile = profile;
        this.fileListCols.add("Name");
        this.fileListCols.add("Size");
        this.fileListCols.add("Ingested");
        this.fileListCols.add("Mode");
        this.fileListCols.add("UID");
        this.fileListCols.add("GID");
    }

    @Override
    public ArcMoverDirectory getHomeDirectory() throws Exception {
        return this.getDirectory("/");
    }

    @Override
    public ArcMoverDirectory getDirectory(String path) throws Exception {
        return ArcMoverFactory.getInstance().getDirectoryListing(this.profile, path, false);
    }

    @Override
    public void displayObjectProperties(ArcMoverFile file) {
        ProfileType profileType = this.profile.getType();
        switch (profileType) {
            case HCAP2: 
            case HCP_DEFAULT: {
                String path = file.getPath();
                try {
                    if (file.isSymlink()) break;
                    file.setMetadata(ArcMoverFactory.getInstance().getMetadata(this.profile, path, file.getFileType()));
                    break;
                }
                catch (JobException e) {
                    String logErrorMsg;
                    String uiErrorMsg;
                    path = this.profile.decode(path);
                    Throwable rootCause = e;
                    while (rootCause.getCause() != null) {
                        rootCause = rootCause.getCause();
                    }
                    if (rootCause instanceof StorageAdapterException) {
                        uiErrorMsg = rootCause.getMessage();
                        logErrorMsg = rootCause.getMessage();
                    } else if (e.getCause() instanceof FileNotFoundException) {
                        uiErrorMsg = "" + path + NEWLINE + "Could not get Metadata: Directory does not exist.";
                        logErrorMsg = "" + path + ": Could not get Metadata: Directory does not exist.";
                    } else if (rootCause instanceof UnknownHostException) {
                        uiErrorMsg = "" + path + NEWLINE + "Could not get Metadata: Host " + rootCause.getMessage() + " is not accessable";
                        logErrorMsg = "" + path + ": Could not get Metadata:  Host " + rootCause.getMessage() + " is not accessable";
                    } else {
                        uiErrorMsg = "" + path + NEWLINE + "Could not get Metadata";
                        logErrorMsg = "" + path + "Could not get Metadata";
                    }
                    if (e.getCause() instanceof SSLException) {
                        uiErrorMsg = "" + path + NEWLINE + " Could not get Metadata: SSL certificate is not trusted.";
                        logErrorMsg = "" + path + ": Could not get Metadata: SSL certificate is not trusted.";
                    }
                    LOG.log(Level.WARNING, logErrorMsg, e);
                    JOptionPane.showMessageDialog(HCPDataMigrator.getInstance(), uiErrorMsg, "Error Getting Properties", 0);
                    return;
                }
            }
        }
        try {
            ObjectPropertiesDialog d = new ObjectPropertiesDialog(this.profile, file, ArcMoverFactory.getInstance());
            d.setLocationRelativeTo(HCPDataMigrator.getInstance());
            d.setVisible(true);
        }
        catch (Exception e) {
            String errMsg = "Unexpected Exception Populating Object Properties Dialog for: " + file.getDisplayFileName();
            LOG.log(Level.WARNING, errMsg, e);
            JOptionPane.showMessageDialog(HCPDataMigrator.getInstance(), errMsg, "Error Getting Properties", 0);
        }
    }

    @Override
    public boolean supportsOpenAction(ArcMoverFile file, boolean single) {
        return single && file != null && !file.isDirectory() && !file.isDeleted();
    }

    @Override
    public boolean supportsDeleteAction(ArcMoverFile file, boolean single) {
        return file != null && !file.isVersion();
    }

    @Override
    public boolean supportsSetMetadataAction(ArcMoverFile file, boolean single) {
        return false;
    }

    @Override
    public boolean supportsRenameAction(ArcMoverFile file, boolean single) {
        return false;
    }

    @Override
    public boolean supportsRefreshAction(ArcMoverFile file, boolean single) {
        return file == null;
    }

    @Override
    public boolean supportsMkdirAction(ArcMoverFile file, boolean single) {
        return file == null;
    }

    @Override
    public boolean supportsPropertiesAction(ArcMoverFile file, boolean single) {
        return single && file != null && (file.isFile() || file.isSymlink() || !this.profile.getType().isAuthNamespace());
    }

    @Override
    public ArcMoverDirectory getVersions(String path) throws Exception {
        return null;
    }

    @Override
    public String getFileForOpen(ArcMoverFile selectedFile) throws IOException {
        ArrayList<ArcCopyFile> copyFileList = new ArrayList<ArcCopyFile>();
        String targetPath = System.getProperty("java.io.tmpdir");
        HCPDataMigrator.getInstance().setCursor(HCPDataMigrator.waitCursor);
        try {
            String filePath = selectedFile.getPath();
            String suffix = "";
            int start = filePath.lastIndexOf(46);
            int end = filePath.length();
            if (start > 0 && start < end) {
                suffix = filePath.substring(start, end);
            }
            File tmpFile = File.createTempFile("hcp", suffix);
            tmpFile.deleteOnExit();
            targetPath = tmpFile.getPath();
            ArcCopyFile copyFile = new ArcCopyFile(selectedFile, FileSystemProfile.LOCAL_FILESYSTEM_PROFILE, targetPath);
            copyFileList.add(copyFile);
            CopyJob job = new CopyJob((AbstractProfileBase)this.profile, FileSystemProfile.LOCAL_FILESYSTEM_PROFILE, (List<ArcCopyFile>)copyFileList);
            CopySingleFileAction copyFileAction = new CopySingleFileAction(job);
            StorageAdapter sourceAdapter = StorageAdapterMgr.getStorageAdapter(this.profile, null);
            long size = sourceAdapter.getFileSize(selectedFile);
            copyFile.getSourceFile().setSize(size);
            FileStats stats = new FileStats(copyFile);
            copyFileAction.processFile(stats);
        }
        catch (IOException e) {
            String errorMsg = "IOException creating temporary file for display.";
            LOG.log(Level.WARNING, errorMsg, e);
            throw new IOException(errorMsg);
        }
        catch (DatabaseException e) {
            String errorMsg = "Error getting the file from the destination.";
            LOG.log(Level.WARNING, errorMsg, e);
            throw new IOException(errorMsg);
        }
        catch (StorageAdapterException e) {
            String errorMsg = "Error getting the file from the destination.";
            LOG.log(Level.WARNING, errorMsg, e);
            throw new IOException(errorMsg);
        }
        catch (JobException e) {
            String errorMsg = "Error getting the file from the destination.";
            LOG.log(Level.WARNING, errorMsg, e);
            throw new IOException(errorMsg);
        }
        finally {
            HCPDataMigrator.getInstance().setCursor(HCPDataMigrator.normalCursor);
        }
        return targetPath;
    }

    @Override
    public SSLCertChain getSSLCertChain() {
        return this.profile.getSSLCertChain();
    }

    @Override
    public List<String> getFileListColumns() {
        return this.fileListCols;
    }
}

