/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.properties;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.utils.StringUtils;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

public class FilePropertiesDialog
extends JDialog {
    private JPanel contentPane;
    private JButton closeButton;
    private JTable propertyTable;

    public FilePropertiesDialog() {
        super(HCPDataMigrator.getInstance());
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePropertiesDialog.this.onClose();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FilePropertiesDialog.this.onClose();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePropertiesDialog.this.onClose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.setMinimumSize(new Dimension(450, 200));
    }

    private void onClose() {
        this.dispose();
    }

    public void populate(final ArcMoverFile file) {
        AbstractTableModel dataModel = new AbstractTableModel(){
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            Date modifiedTime = file.getMetadata().getModTime();
            String modifiedTimeStr;
            final String[] columnNameArray;
            final String[] valueArray;
            {
                String string = this.modifiedTimeStr = this.modifiedTime == null ? null : this.modifiedTime.toString();
                this.columnNameArray = file.isDirectory() ? new String[]{"Name", "Path", "Type", "Modified Time"} : (file.isSymlink() ? new String[]{"Name", "Path", "Type", "Symlink Target", "Modified Time"} : new String[]{"Name", "Path", "Type", "Size", "Modified Time"});
                this.valueArray = file.isDirectory() ? new String[]{file.getFileName(), file.getDisplayPath(), "Directory", this.modifiedTimeStr} : (file.isSymlink() ? new String[]{file.getFileName(), file.getDisplayPath(), file.getFileType().getDisplay(), file.getDisplaySymlinkTarget(), this.modifiedTimeStr} : new String[]{file.getFileName(), file.getDisplayPath(), "File", StringUtils.bytesToStringWithUnit(file.getSize(), this.decimalFormat), this.modifiedTimeStr});
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                if (file.isDirectory()) {
                    return 4;
                }
                return 5;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return columnIndex == 0 ? "Property" : "Value";
            }

            @Override
            public Object getValueAt(int row, int col) {
                return col == 0 ? this.columnNameArray[row] : this.valueArray[row];
            }
        };
        this.propertyTable.setModel(dataModel);
    }

    public static void main(String[] args) {
        FilePropertiesDialog dialog = new FilePropertiesDialog();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new FormLayout("fill:max(d;4dlu):noGrow,left:150dlu:grow,fill:d:noGrow,fill:50dlu:noGrow,fill:max(d;4dlu):noGrow,fill:d:noGrow", "top:110px:grow,top:m:noGrow,top:4dlu:noGrow,top:15dlu:noGrow,top:4dlu:noGrow"));
        this.contentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new FormLayout("fill:max(d;4px):noGrow", "center:d:noGrow"));
        CellConstraints cc = new CellConstraints();
        this.contentPane.add((Component)panel1, cc.xyw(2, 2, 5));
        JScrollPane scrollPane1 = new JScrollPane();
        this.contentPane.add((Component)scrollPane1, cc.xyw(2, 1, 3, CellConstraints.FILL, CellConstraints.FILL));
        this.propertyTable = new JTable();
        this.propertyTable.setCellSelectionEnabled(true);
        this.propertyTable.setFillsViewportHeight(true);
        this.propertyTable.setRowSelectionAllowed(true);
        scrollPane1.setViewportView(this.propertyTable);
        this.closeButton = new JButton();
        this.closeButton.setText("Close");
        this.contentPane.add((Component)this.closeButton, cc.xy(4, 4, CellConstraints.FILL, CellConstraints.FILL));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

