/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.properties;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.api.ArcMoverEngine;
import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.model.ACLMetadata;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.CustomMetadataTooLargeException;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.Owner;
import com.archivas.clienttools.arcutils.model.Retention;
import com.archivas.clienttools.arcutils.model.StructuredMetadata;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.StringUtils;
import com.archivas.clienttools.arcutils.utils.XMLValidator;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class ObjectPropertiesDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(ObjectPropertiesDialog.class.getName());
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.00");
    private JPanel contentPane;
    private JButton closeButton;
    private JTable systemMetadataTable;
    private JTabbedPane propertiesTabs;
    private JTextPane customMetadataText;
    private JScrollPane cMetadataTab;
    private JButton saveButton;
    protected JScrollPane sMetadataTab;
    private ArcMoverEngine engine;
    private AbstractProfileBase profile;
    private ArcMoverFile currentFile;
    private JTextPane aclText;
    private JScrollPane cACLTab;
    private boolean hasCustomMetadata;
    private String savedCustomMetadata;
    private boolean hasACL = false;
    private String savedACL;

    private ObjectPropertiesDialog() {
        this.$$$setupUI$$$();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    public ObjectPropertiesDialog(AbstractProfileBase profile, ArcMoverFile file, ArcMoverEngine engine) throws StorageAdapterException {
        super(HCPDataMigrator.getInstance());
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.setTitle(file.getDisplayFileName() + " Properties");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPropertiesDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ObjectPropertiesDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPropertiesDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPropertiesDialog.this.onSave();
            }
        });
        this.setMinimumSize(new Dimension(550, 350));
        this.profile = profile;
        this.populate(file, engine);
    }

    private void onCancel() {
        String typeString = null;
        if (this.customMetadataEdited() && this.aclEdited()) {
            typeString = "metadata";
        } else if (this.customMetadataEdited()) {
            typeString = "custom metadata";
        } else if (this.aclEdited()) {
            typeString = "acl";
        }
        if (typeString != null) {
            int changeMetadata = JOptionPane.showConfirmDialog(this, String.format("The %s has been edited and not yet saved.\nAre you sure you want to close without saving?", typeString), "", 0);
            if (changeMetadata == 0) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new FormLayout("left:4dlu:noGrow,left:250dlu:grow,left:5dlu:noGrow", "center:4dlu:noGrow,center:150dlu:grow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow"));
        this.propertiesTabs = new JTabbedPane();
        this.propertiesTabs.setToolTipText("Core Metadata");
        CellConstraints cc = new CellConstraints();
        this.contentPane.add((Component)this.propertiesTabs, cc.xy(2, 2, CellConstraints.FILL, CellConstraints.FILL));
        this.sMetadataTab = new JScrollPane();
        this.sMetadataTab.setToolTipText("Filesystem Metadata");
        this.propertiesTabs.addTab("System Metadata", this.sMetadataTab);
        this.sMetadataTab.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null));
        this.systemMetadataTable = new JTable();
        this.systemMetadataTable.setCellSelectionEnabled(true);
        this.systemMetadataTable.setFillsViewportHeight(true);
        this.sMetadataTab.setViewportView(this.systemMetadataTable);
        this.cMetadataTab = new JScrollPane();
        this.cMetadataTab.setToolTipText("Custom Metadata");
        this.propertiesTabs.addTab("Custom Metadata", this.cMetadataTab);
        this.cMetadataTab.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null));
        this.customMetadataText = new JTextPane();
        this.customMetadataText.setEditable(true);
        this.customMetadataText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.cMetadataTab.setViewportView(this.customMetadataText);
        this.cACLTab = new JScrollPane();
        this.cACLTab.setToolTipText("ACL");
        this.propertiesTabs.addTab("ACL", this.cACLTab);
        this.cACLTab.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null));
        this.aclText = new JTextPane();
        this.aclText.setEditable(true);
        this.aclText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.cACLTab.setViewportView(this.aclText);
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new FormLayout("fill:50dlu:noGrow,left:4dlu:noGrow,fill:max(d;4px):grow,left:4dlu:noGrow,fill:50dlu:noGrow", "center:15dlu:noGrow"));
        this.contentPane.add((Component)panel1, cc.xy(2, 4, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.closeButton = new JButton();
        this.closeButton.setHorizontalAlignment(0);
        this.closeButton.setText("Close");
        panel1.add((Component)this.closeButton, cc.xy(5, 1, CellConstraints.FILL, CellConstraints.FILL));
        this.saveButton = new JButton();
        this.saveButton.setText("Save");
        panel1.add((Component)this.saveButton, cc.xy(1, 1));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    protected TableModel getSystemMetadataTableModel(ArcMoverFile file) throws StorageAdapterException {
        return new SystemTableModel(file);
    }

    private void populate(ArcMoverFile file, ArcMoverEngine engine) throws StorageAdapterException {
        FileMetadata baseMetadata = file.getMetadata();
        LOG.finest("Loading ArcMoverFile=" + file.toDetailString());
        LOG.finest("Loading ArcMetadata=" + (baseMetadata == null ? "null" : baseMetadata.toString()));
        this.currentFile = file;
        this.engine = engine;
        TableModel systemMetadataModel = this.getSystemMetadataTableModel(file);
        this.systemMetadataTable.setModel(systemMetadataModel);
        GUIHelper.autoResizeColWidth(this.systemMetadataTable);
        this.saveButton.setEnabled(false);
        if (!file.isDirectory() && !file.isSymlink() && baseMetadata != null) {
            this.propertiesTabs.addTab("Custom Metadata", this.cMetadataTab);
            this.cMetadataTab.setVisible(true);
            String customMetadataTextValue = "";
            if (baseMetadata.hasDefaultCustomMetadata()) {
                try {
                    Long version = null;
                    if (file.isVersion()) {
                        version = baseMetadata.getVersionNumber();
                    }
                    customMetadataTextValue = file.getCustomMetadata().getStringValue(this.profile, version);
                }
                catch (Exception e) {
                    Exception rootCause = null;
                    Throwable th = e;
                    while (th != null) {
                        rootCause = th;
                        if ((th = th.getCause()) == null) continue;
                        rootCause = th;
                    }
                    if (rootCause != null && rootCause instanceof CustomMetadataTooLargeException) {
                        customMetadataTextValue = "Custom metadata too large to display";
                    }
                    LOG.log(Level.WARNING, "Error getting custom metadata for " + file.getPath() + ": " + e.getMessage(), e);
                    customMetadataTextValue = "Error getting custom metadata";
                }
            }
            this.hasCustomMetadata = !customMetadataTextValue.isEmpty();
            this.customMetadataText.setText(customMetadataTextValue);
            this.savedCustomMetadata = customMetadataTextValue;
            this.customMetadataText.setEditable(!file.isVersion());
            this.customMetadataText.setOpaque(!file.isVersion());
            this.customMetadataText.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ObjectPropertiesDialog.this.updateButtonStates();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ObjectPropertiesDialog.this.updateButtonStates();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ObjectPropertiesDialog.this.updateButtonStates();
                }
            });
            if (file.isVersion()) {
                this.customMetadataText.setForeground(Color.GRAY);
            }
            if (this.profile.supportsACLs()) {
                this.propertiesTabs.addTab("ACL", this.cACLTab);
                this.cACLTab.setVisible(true);
                this.aclText.setEditable(true);
                this.aclText.setOpaque(true);
                String aclTextValue = "";
                if (baseMetadata.hasACL().booleanValue()) {
                    try {
                        long unUsedVersion = 0L;
                        aclTextValue = baseMetadata.getACL().getStringValue(this.profile, unUsedVersion);
                    }
                    catch (JobException e) {
                        LOG.log(Level.WARNING, "Error getting acl for " + file.getPath() + ": " + e.getMessage(), e);
                        aclTextValue = "Error getting acl";
                    }
                }
                this.hasACL = !aclTextValue.isEmpty();
                this.aclText.setText(aclTextValue);
                this.savedACL = aclTextValue;
                this.aclText.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        ObjectPropertiesDialog.this.updateButtonStates();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        ObjectPropertiesDialog.this.updateButtonStates();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        ObjectPropertiesDialog.this.updateButtonStates();
                    }
                });
            } else {
                this.cACLTab.setVisible(false);
                this.propertiesTabs.remove(this.cACLTab);
            }
            this.propertiesTabs.setSelectedComponent(this.cMetadataTab);
        } else {
            this.cMetadataTab.setVisible(false);
            this.propertiesTabs.remove(this.cMetadataTab);
            this.cACLTab.setVisible(false);
            this.propertiesTabs.remove(this.cACLTab);
        }
        this.propertiesTabs.setSelectedComponent(this.sMetadataTab);
    }

    private void updateButtonStates() {
        this.saveButton.setEnabled(!this.currentFile.isVersion() && (this.customMetadataEdited() || this.aclEdited()));
    }

    private boolean customMetadataEdited() {
        return this.savedCustomMetadata != null && !this.savedCustomMetadata.trim().equals(this.customMetadataText.getText().trim());
    }

    private boolean aclEdited() {
        return this.savedACL != null && !this.savedACL.trim().equals(this.aclText.getText().trim());
    }

    private void onSave() {
        Boolean changingCM = null;
        try {
            if (this.profile != null) {
                String typeString;
                String newCMetadataText = this.customMetadataText.getText().trim();
                boolean deletingCM = newCMetadataText.isEmpty();
                String newACLTextString = this.aclText.getText().trim();
                boolean deletingACL = newACLTextString.isEmpty();
                if (this.customMetadataEdited() && this.aclEdited()) {
                    typeString = "Metadata";
                } else if (this.aclEdited()) {
                    typeString = "ACL";
                } else if (this.customMetadataEdited()) {
                    typeString = "custom metadata";
                } else {
                    throw new IllegalStateException("Saving Object Properties when neither custom metadata nor acls have changed");
                }
                String actionString = deletingACL && deletingCM ? "Delete" : "Modify";
                int changeMetadata = JOptionPane.showConfirmDialog(this, String.format("Are you sure you want to %s the %s?", actionString.toLowerCase(), typeString.toLowerCase()), String.format("%s %s", actionString, typeString), 0);
                if (changeMetadata == 0) {
                    String msg;
                    if (this.customMetadataEdited()) {
                        changingCM = true;
                        if (newCMetadataText.length() > 32672) {
                            msg = "XML string too long";
                            JOptionPane.showMessageDialog(this, msg, "Error", 0);
                        } else if (deletingCM) {
                            if (this.hasCustomMetadata) {
                                this.engine.deleteCustomMetadata(this.profile, this.currentFile.getPath());
                                this.hasCustomMetadata = false;
                                this.savedCustomMetadata = "";
                            }
                            HCPDataMigrator.getInstance().refreshMatchingPanels(this.profile, this.currentFile.getParent());
                        } else if (!this.profile.isValidateCustomMetadata() || XMLValidator.isValid(newCMetadataText)) {
                            this.engine.setCustomMetadata(this.profile, this.currentFile.getPath(), newCMetadataText);
                            this.hasCustomMetadata = true;
                            this.savedCustomMetadata = newCMetadataText;
                            HCPDataMigrator.getInstance().refreshMatchingPanels(this.profile, this.currentFile.getParent());
                        } else {
                            msg = "Invalid XML in Custom Metadata";
                            JOptionPane.showMessageDialog(this, msg, "Error", 0);
                        }
                    }
                    if (this.aclEdited()) {
                        changingCM = false;
                        if (deletingACL) {
                            if (this.hasACL) {
                                this.engine.deleteACL(this.profile, this.currentFile.getPath());
                                this.hasACL = false;
                                this.savedACL = "";
                            }
                        } else if (XMLValidator.isValid(newACLTextString)) {
                            ACLMetadata acl = new ACLMetadata(StructuredMetadata.Form.STRING, newACLTextString);
                            this.engine.setACL(this.profile, this.currentFile.getPath(), acl);
                            this.hasACL = true;
                            this.savedACL = newACLTextString;
                            HCPDataMigrator.getInstance().refreshMatchingPanels(this.profile, this.currentFile.getParent());
                        } else {
                            msg = "Invalid XML in ACL";
                            JOptionPane.showMessageDialog(this, msg, "Error", 0);
                        }
                    }
                }
            }
        }
        catch (JobException e) {
            String msg;
            Throwable cause = e.getCause();
            if (cause instanceof StorageAdapterException) {
                msg = cause.getMessage();
                if (msg.indexOf("403 ") == 0) {
                    if (changingCM != null && changingCM.booleanValue()) {
                        this.customMetadataText.setText(this.savedCustomMetadata);
                    } else if (changingCM != null && !changingCM.booleanValue()) {
                        this.aclText.setText(this.savedACL);
                    }
                }
            } else {
                msg = "Unexpected Error";
            }
            LOG.log(Level.WARNING, msg, e);
            GUIHelper.showMessageDialog(this, msg, "Error", 0);
        }
        this.updateButtonStates();
    }

    public static void main(String[] args) {
        ObjectPropertiesDialog dialog = new ObjectPropertiesDialog();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }

    private class SystemTableModel
    extends AbstractTableModel {
        List<String> keys = new ArrayList<String>();
        List<Object> values = new ArrayList<Object>();

        private SystemTableModel(ArcMoverFile file) throws StorageAdapterException {
            this.keys.add("Name");
            this.values.add(file.getDisplayFileName());
            this.keys.add("Path");
            this.values.add(file.getDisplayPath());
            this.keys.add("Type");
            this.values.add(file.getFileType().getDisplay());
            String symlinkTarget = file.getDisplaySymlinkTarget();
            if (symlinkTarget != null) {
                this.keys.add("Symlink Target");
                this.values.add(symlinkTarget);
            }
            if (file.isFile()) {
                this.keys.add("Size");
                this.values.add(StringUtils.bytesToStringWithUnit(file.getSize(), decimalFormat));
            }
            if (file.getMetadata().hasCreationTime()) {
                this.keys.add("Ingested Time");
                this.values.add(file.getMetadata().getCreationTime());
            }
            if (file.getMetadata().hasDpl()) {
                this.keys.add("DPL");
                this.values.add(file.getMetadata().getDpl());
            }
            if (file.getMetadata().hasHashScheme()) {
                this.keys.add("Hash Algorithm");
                this.values.add(file.getMetadata().getHashScheme());
            }
            if (file.getMetadata().hasHashValue()) {
                this.keys.add("Hash Value");
                this.values.add(file.getMetadata().getHashValue());
            }
            if (file.getMetadata().hasSearchIndex()) {
                this.keys.add("Index");
                this.values.add(file.getMetadata().isSearchIndex());
            }
            if (file.getMetadata().hasShred()) {
                this.keys.add("Shred");
                this.values.add(file.getMetadata().isShred());
            }
            if (file.getMetadata().hasRetention()) {
                Retention retention = file.getMetadata().getRetention();
                this.keys.add("Retention Value");
                if (retention.getType() == Retention.Type.FIXED_DATE) {
                    this.values.add(retention.getDate());
                } else {
                    this.values.add(retention.getUIValue());
                }
                if (retention.getType() == Retention.Type.RETENTION_CLASS && !retention.getClassName().equals("")) {
                    this.keys.add("Retention Class");
                    this.values.add(retention.getClassName());
                }
            }
            if (file.getMetadata().hasRetentionHold()) {
                this.keys.add("Hold");
                this.values.add(file.getMetadata().isRetentionHold());
            }
            if (file.getMetadata().hasCtime()) {
                this.keys.add("Changed Time (ctime)");
                this.values.add(file.getMetadata().getCtime());
            }
            if (file.getMetadata().hasModTime()) {
                this.keys.add("Modified Time (mtime)");
                this.values.add(file.getMetadata().getModTime());
            }
            if (file.getMetadata().hasAccessTime()) {
                this.keys.add("Accessed Time (atime)");
                this.values.add(file.getMetadata().getAccessTime());
            }
            if (file.getMetadata().hasUid()) {
                this.keys.add("UID");
                this.values.add(file.getMetadata().getUid());
            }
            if (file.getMetadata().hasGid()) {
                this.keys.add("GID");
                this.values.add(file.getMetadata().getGid());
            }
            if (file.getMetadata().hasFileMode()) {
                this.keys.add("Permissions");
                this.values.add(file.getMetadata().getFileModeForUnixLsDisplay());
            }
            if (file.getMetadata().hasDirMode()) {
                this.keys.add("Permissions");
                this.values.add(file.getMetadata().getDirModeForUnixLsDisplay());
            }
            if (file.getMetadata().hasVersionNumber()) {
                this.keys.add("Version");
                this.values.add(file.getMetadata().getVersionNumber());
            }
            if (file.getMetadata().hasReplicated()) {
                this.keys.add("Replicated");
                this.values.add(file.getMetadata().isReplicated());
            }
            if (file.getMetadata().hasRestState()) {
                this.keys.add("State");
                this.values.add(file.getMetadata().getRestState());
            }
            if (file.getMetadata().hasOwner()) {
                if (file.getMetadata().getOwner().getOwnerType().equals((Object)Owner.OwnerType.LOCAL)) {
                    this.keys.add("Owner");
                    this.values.add(file.getProfile().decode(file.getMetadata().getOwner().getOwnerName()));
                } else if (file.getMetadata().getOwner().getOwnerType().equals((Object)Owner.OwnerType.EXTERNAL)) {
                    this.keys.add("Owner");
                    this.values.add(file.getProfile().decode(file.getMetadata().getOwner().getOwnerName()));
                    this.keys.add("Domain");
                    this.values.add(file.getMetadata().getOwner().getDomain());
                }
            }
            if (file.getMetadata().hasAnnotations()) {
                this.keys.add("Annotations");
                StringBuilder annotations = new StringBuilder();
                for (String annotation : file.getMetadata().getAnnotationList().keySet()) {
                    if (annotations.length() < 1) {
                        annotations.append(annotation);
                        continue;
                    }
                    annotations.append(", " + annotation);
                }
                this.values.add(annotations.toString());
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.keys.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? "Property" : "Value";
        }

        @Override
        public Object getValueAt(int row, int col) {
            return col == 0 ? this.keys.get(row) : this.values.get(row);
        }
    }
}

