/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.settings;

import com.archivas.clienttools.arcutils.config.HCPMoverConstants;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class ClusterOptionsForm
extends JPanel {
    protected JPanel archiveOptionsTab;
    protected JRadioButton indexDefaultRadio;
    protected JRadioButton indexYesRadio;
    protected JRadioButton indexNoRadio;
    protected JRadioButton shredDefaultRadio;
    protected JRadioButton shredYesRadio;
    protected JRadioButton shredNoRadio;
    protected JPanel contentPane;
    protected ButtonGroup indexFileButtonGroup;

    public ClusterOptionsForm() {
        this.$$$setupUI$$$();
        this.loadSettings();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.loadSettings();
        }
        super.setVisible(visible);
    }

    public void loadSettings() {
        this.setSearchIndexSetting(HCPMoverProperties.INDEX_MODE.getAsTriState());
        this.setShredSetting(HCPMoverProperties.SHRED_MODE.getAsTriState());
    }

    public void applySettingsAction() {
        HCPMoverProperties.INDEX_MODE.set(this.getSearchIndexSetting());
        HCPMoverProperties.SHRED_MODE.set(this.getShredSetting());
    }

    public HCPMoverConstants.TriState getSearchIndexSetting() {
        if (this.indexYesRadio.isSelected()) {
            return HCPMoverConstants.TriState.YES;
        }
        if (this.indexNoRadio.isSelected()) {
            return HCPMoverConstants.TriState.NO;
        }
        return HCPMoverConstants.TriState.DEFAULT;
    }

    public void setSearchIndexSetting(HCPMoverConstants.TriState searchIndexSetting) {
        switch (searchIndexSetting) {
            case YES: {
                this.indexYesRadio.setSelected(true);
                break;
            }
            case NO: {
                this.indexNoRadio.setSelected(true);
                break;
            }
            default: {
                this.indexDefaultRadio.setSelected(true);
            }
        }
    }

    public HCPMoverConstants.TriState getShredSetting() {
        if (this.shredYesRadio.isSelected()) {
            return HCPMoverConstants.TriState.YES;
        }
        if (this.shredNoRadio.isSelected()) {
            return HCPMoverConstants.TriState.NO;
        }
        return HCPMoverConstants.TriState.DEFAULT;
    }

    public void setShredSetting(HCPMoverConstants.TriState shredSetting) {
        switch (shredSetting) {
            case YES: {
                this.shredYesRadio.setSelected(true);
                break;
            }
            case NO: {
                this.shredNoRadio.setSelected(true);
                break;
            }
            default: {
                this.shredDefaultRadio.setSelected(true);
            }
        }
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new FormLayout("fill:d:grow", "top:d:grow"));
        this.archiveOptionsTab = new JPanel();
        this.archiveOptionsTab.setLayout((LayoutManager)new FormLayout("fill:4dlu:noGrow,fill:129px:noGrow,left:4dlu:noGrow,fill:d:grow,fill:4dlu:noGrow", "center:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,center:max(d;4px):noGrow,center:max(d;4px):noGrow,top:max(m;6dlu):noGrow,center:d:grow,top:6dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,center:max(d;4px):noGrow,center:26px:noGrow,center:4dlu:grow"));
        CellConstraints cc = new CellConstraints();
        this.contentPane.add((Component)this.archiveOptionsTab, cc.xy(1, 1));
        this.indexDefaultRadio = new JRadioButton();
        this.indexDefaultRadio.setSelected(true);
        this.indexDefaultRadio.setText("Use Namespace Default");
        this.indexDefaultRadio.setToolTipText("File(s) will be indexed based on namespace's settings");
        this.archiveOptionsTab.add((Component)this.indexDefaultRadio, cc.xyw(2, 4, 3));
        this.indexYesRadio = new JRadioButton();
        this.indexYesRadio.setText("Yes");
        this.indexYesRadio.setToolTipText("File(s) will be indexed by search engine");
        this.archiveOptionsTab.add((Component)this.indexYesRadio, cc.xyw(2, 5, 3));
        this.indexNoRadio = new JRadioButton();
        this.indexNoRadio.setText("No");
        this.indexNoRadio.setToolTipText("File(s) will not be indexed by search engine");
        this.archiveOptionsTab.add((Component)this.indexNoRadio, cc.xyw(2, 6, 3));
        JSeparator separator1 = new JSeparator();
        this.archiveOptionsTab.add((Component)separator1, cc.xyw(2, 8, 3, CellConstraints.FILL, CellConstraints.FILL));
        this.shredDefaultRadio = new JRadioButton();
        this.shredDefaultRadio.setSelected(true);
        this.shredDefaultRadio.setText("Use Namespace Default");
        this.shredDefaultRadio.setToolTipText("File(s) will be disposed of based on namespace's settings.");
        this.archiveOptionsTab.add((Component)this.shredDefaultRadio, cc.xyw(2, 12, 3));
        this.shredYesRadio = new JRadioButton();
        this.shredYesRadio.setText("Yes");
        this.shredYesRadio.setToolTipText("Shred file(s) upon delete.");
        this.archiveOptionsTab.add((Component)this.shredYesRadio, cc.xyw(2, 13, 3));
        this.shredNoRadio = new JRadioButton();
        this.shredNoRadio.setText("No");
        this.shredNoRadio.setToolTipText("File(s) will not be shred upon delete.");
        this.archiveOptionsTab.add((Component)this.shredNoRadio, cc.xyw(2, 14, 3));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:d:noGrow,left:4dlu:noGrow,left:d:noGrow,fill:max(d;4dlu):grow", "center:d:grow"));
        this.archiveOptionsTab.add((Component)panel1, cc.xyw(2, 2, 3));
        JLabel label1 = new JLabel();
        label1.setFont(new Font(label1.getFont().getName(), 1, 14));
        label1.setText("Index Files for Search");
        panel1.add((Component)label1, cc.xy(1, 1));
        JLabel label2 = new JLabel();
        label2.setText("(only available on HCP 3.0+)");
        panel1.add((Component)label2, cc.xy(4, 1));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new FormLayout("left:89px:noGrow,fill:4dlu:noGrow,left:max(m;4dlu):grow", "center:d:grow"));
        this.archiveOptionsTab.add((Component)panel2, cc.xyw(2, 10, 3));
        JLabel label3 = new JLabel();
        label3.setFont(new Font(label3.getFont().getName(), 1, 14));
        label3.setText("Shred Files on Delete");
        panel2.add((Component)label3, cc.xyw(1, 1, 3));
        this.indexFileButtonGroup = new ButtonGroup();
        this.indexFileButtonGroup.add(this.indexNoRadio);
        this.indexFileButtonGroup.add(this.indexYesRadio);
        this.indexFileButtonGroup.add(this.indexDefaultRadio);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.shredDefaultRadio);
        buttonGroup.add(this.shredYesRadio);
        buttonGroup.add(this.shredNoRadio);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

