/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.settings;

import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.archivas.clienttools.arcmover.gui.settings.PermissionsForm;
import com.archivas.clienttools.arcutils.utils.UidGidUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DefaultNamespaceSettingsForm
extends JPanel {
    protected JPanel defaultNamespaceTab;
    protected JCheckBox uidCheckbox;
    protected JTextField uidTextField;
    protected JCheckBox gidCheckbox;
    protected JCheckBox fileModeCheckbox;
    protected JCheckBox dirModeCheckbox;
    protected JTextField gidTextField;
    protected JPanel contentPane;
    protected PermissionsForm objectPermissionsForm;
    protected PermissionsForm dirPermissionsForm;
    private JobDialog jobDialog;

    public DefaultNamespaceSettingsForm(JobDialog jobDialog, String uid, String gid, int filePerms, int dirPerms) {
        this.$$$setupUI$$$();
        this.jobDialog = jobDialog;
        this.objectPermissionsForm.setJobDialog(jobDialog);
        this.dirPermissionsForm.setJobDialog(jobDialog);
        this.uidCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DefaultNamespaceSettingsForm.this.enableUIDFields(e.getStateChange() == 1);
                DefaultNamespaceSettingsForm.this.fieldChanged();
            }
        });
        this.gidCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DefaultNamespaceSettingsForm.this.enableGIDFields(e.getStateChange() == 1);
                DefaultNamespaceSettingsForm.this.fieldChanged();
            }
        });
        this.fileModeCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DefaultNamespaceSettingsForm.this.enableFilePerms(e.getStateChange() == 1);
                DefaultNamespaceSettingsForm.this.fieldChanged();
            }
        });
        this.dirModeCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DefaultNamespaceSettingsForm.this.enableDirPerms(e.getStateChange() == 1);
                DefaultNamespaceSettingsForm.this.fieldChanged();
            }
        });
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DefaultNamespaceSettingsForm.this.fieldChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DefaultNamespaceSettingsForm.this.fieldChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DefaultNamespaceSettingsForm.this.fieldChanged();
            }
        };
        this.uidTextField.getDocument().addDocumentListener(docListener);
        this.gidTextField.getDocument().addDocumentListener(docListener);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.contentPane);
        this.add(Box.createHorizontalGlue());
        this.initFields(uid, gid, filePerms, dirPerms);
    }

    private void fieldChanged() {
        if (this.jobDialog != null) {
            this.jobDialog.fieldChanged();
        }
    }

    public void enablePanel(boolean enabled) {
        this.uidCheckbox.setEnabled(enabled);
        this.uidTextField.setEnabled(enabled && this.uidCheckbox.isSelected());
        this.gidCheckbox.setEnabled(enabled);
        this.gidTextField.setEnabled(enabled && this.gidCheckbox.isSelected());
        this.fileModeCheckbox.setEnabled(enabled);
        this.enableFilePerms(enabled && this.fileModeCheckbox.isSelected());
        this.dirModeCheckbox.setEnabled(enabled);
        this.enableDirPerms(enabled && this.dirModeCheckbox.isSelected());
    }

    private void enableUIDFields(boolean enabled) {
        this.uidTextField.setEnabled(enabled);
        if (!enabled) {
            this.uidTextField.setText("");
        }
    }

    private void enableGIDFields(boolean enabled) {
        this.gidTextField.setEnabled(enabled);
        if (!enabled) {
            this.gidTextField.setText("");
        }
    }

    private void enableFilePerms(boolean enabled) {
        this.objectPermissionsForm.setEnabled(enabled);
    }

    private void enableDirPerms(boolean enabled) {
        this.dirPermissionsForm.setEnabled(enabled);
    }

    public void initFields(String uid, String gid, int filePerms, int dirPerms) {
        this.uidTextField.setText(uid);
        this.uidTextField.setEnabled(uid.trim().length() > 0);
        this.uidCheckbox.setSelected(uid.trim().length() > 0);
        this.gidTextField.setText(gid);
        this.gidTextField.setEnabled(gid.length() > 0);
        this.gidCheckbox.setSelected(gid.length() > 0);
        this.objectPermissionsForm.setPermissionsValue(filePerms > -1 ? filePerms : 0);
        this.objectPermissionsForm.setEnabled(filePerms > -1);
        this.fileModeCheckbox.setSelected(filePerms > -1);
        this.dirPermissionsForm.setPermissionsValue(dirPerms > -1 ? dirPerms : 0);
        this.dirPermissionsForm.setEnabled(dirPerms > -1);
        this.dirModeCheckbox.setSelected(dirPerms > -1);
    }

    public boolean hasUid() {
        boolean retval = false;
        if (this.uidCheckbox != null) {
            retval = this.uidCheckbox.isSelected();
        }
        return retval;
    }

    public Long getUid() throws NumberFormatException {
        return UidGidUtil.validateId(this.uidTextField.getText());
    }

    public boolean hasGid() {
        boolean retval = false;
        if (this.gidCheckbox != null) {
            retval = this.gidCheckbox.isSelected();
        }
        return retval;
    }

    public Long getGid() throws NumberFormatException {
        return UidGidUtil.validateId(this.gidTextField.getText());
    }

    public boolean hasFileMode() {
        boolean retval = false;
        if (this.fileModeCheckbox != null) {
            retval = this.fileModeCheckbox.isSelected();
        }
        return retval;
    }

    public int getFileMode() throws NumberFormatException {
        return this.objectPermissionsForm.getPermissionsValue();
    }

    public boolean hasDirMode() {
        boolean retval = false;
        if (this.dirModeCheckbox != null) {
            retval = this.dirModeCheckbox.isSelected();
        }
        return retval;
    }

    public int getDirMode() throws NumberFormatException {
        return this.dirPermissionsForm.getPermissionsValue();
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:d:grow"));
        this.defaultNamespaceTab = new JPanel();
        this.defaultNamespaceTab.setLayout((LayoutManager)new FormLayout("fill:4dlu:noGrow,fill:max(d;4px):noGrow,left:max(d;4px):noGrow,fill:max(d;4px):grow,fill:d:noGrow", "center:4dlu:noGrow,center:max(d;4px):noGrow,top:15px:noGrow,center:max(d;4px):noGrow,top:5dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(m;4px):grow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow"));
        CellConstraints cc = new CellConstraints();
        this.contentPane.add((Component)this.defaultNamespaceTab, cc.xy(1, 1, CellConstraints.DEFAULT, CellConstraints.TOP));
        JLabel label1 = new JLabel();
        label1.setFont(new Font(label1.getFont().getName(), 1, 14));
        label1.setText("POSIX Ownership and Permissions");
        this.defaultNamespaceTab.add((Component)label1, cc.xyw(2, 2, 3));
        this.uidCheckbox = new JCheckBox();
        this.uidCheckbox.setText("UID");
        this.uidCheckbox.setToolTipText("Enable setting UID");
        this.defaultNamespaceTab.add((Component)this.uidCheckbox, cc.xy(2, 6));
        this.uidTextField = new JTextField();
        this.uidTextField.setEnabled(false);
        this.uidTextField.setToolTipText("Number to set for UID");
        this.defaultNamespaceTab.add((Component)this.uidTextField, cc.xy(4, 6, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.gidCheckbox = new JCheckBox();
        this.gidCheckbox.setText("GID");
        this.gidCheckbox.setToolTipText("Enable setting GID");
        this.defaultNamespaceTab.add((Component)this.gidCheckbox, cc.xy(2, 8));
        this.fileModeCheckbox = new JCheckBox();
        this.fileModeCheckbox.setText("Object permissions");
        this.fileModeCheckbox.setToolTipText("Enable setting object permissions");
        this.defaultNamespaceTab.add((Component)this.fileModeCheckbox, cc.xy(2, 10, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.dirModeCheckbox = new JCheckBox();
        this.dirModeCheckbox.setText("Directory permissions");
        this.dirModeCheckbox.setToolTipText("Enable setting directory permissions");
        this.defaultNamespaceTab.add((Component)this.dirModeCheckbox, cc.xy(2, 12, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.gidTextField = new JTextField();
        this.gidTextField.setEnabled(false);
        this.gidTextField.setToolTipText("Number to set for GID");
        this.defaultNamespaceTab.add((Component)this.gidTextField, cc.xy(4, 8, CellConstraints.FILL, CellConstraints.DEFAULT));
        JLabel label2 = new JLabel();
        label2.setFont(new Font(label2.getFont().getName(), label2.getFont().getStyle(), 12));
        label2.setText("These settings apply only to the HCP default namespace and HCAP 2.x.");
        this.defaultNamespaceTab.add((Component)label2, cc.xyw(2, 3, 3));
        this.objectPermissionsForm = new PermissionsForm();
        this.defaultNamespaceTab.add((Component)this.objectPermissionsForm.$$$getRootComponent$$$(), cc.xy(4, 10, CellConstraints.FILL, CellConstraints.FILL));
        this.dirPermissionsForm = new PermissionsForm();
        this.defaultNamespaceTab.add((Component)this.dirPermissionsForm.$$$getRootComponent$$$(), cc.xy(4, 12, CellConstraints.FILL, CellConstraints.FILL));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

