/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.settings;

import com.archivas.clienttools.arcmover.gui.JobDialog;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PermissionsForm
extends JPanel {
    protected JPanel panel1;
    protected JTextField numberPerms;
    protected JCheckBox ownerRead;
    protected JCheckBox ownerWrite;
    protected JCheckBox ownerExecute;
    protected JCheckBox groupRead;
    protected JCheckBox groupWrite;
    protected JCheckBox groupExecute;
    protected JCheckBox otherRead;
    protected JCheckBox otherWrite;
    protected JCheckBox otherExecute;
    private JobDialog jobDialog;

    private int getPermsFromCheckboxes() {
        int perms = 0;
        if (this.ownerRead.isSelected()) {
            perms += 256;
        }
        if (this.ownerWrite.isSelected()) {
            perms += 128;
        }
        if (this.ownerExecute.isSelected()) {
            perms += 64;
        }
        if (this.groupRead.isSelected()) {
            perms += 32;
        }
        if (this.groupWrite.isSelected()) {
            perms += 16;
        }
        if (this.groupExecute.isSelected()) {
            perms += 8;
        }
        if (this.otherRead.isSelected()) {
            perms += 4;
        }
        if (this.otherWrite.isSelected()) {
            perms += 2;
        }
        if (this.otherExecute.isSelected()) {
            ++perms;
        }
        return perms;
    }

    private void setPermsToCheckboxes(int perms) {
        this.ownerRead.setSelected((perms & 0x100) > 0);
        this.ownerWrite.setSelected((perms & 0x80) > 0);
        this.ownerExecute.setSelected((perms & 0x40) > 0);
        this.groupRead.setSelected((perms & 0x20) > 0);
        this.groupWrite.setSelected((perms & 0x10) > 0);
        this.groupExecute.setSelected((perms & 8) > 0);
        this.otherRead.setSelected((perms & 4) > 0);
        this.otherWrite.setSelected((perms & 2) > 0);
        this.otherExecute.setSelected((perms & 1) > 0);
    }

    private void setPermsFieldFromCheckboxes() {
        int perms = this.getPermsFromCheckboxes();
        this.numberPerms.setText(PermissionsForm.toThreeCharOctalString(perms));
    }

    private void setCheckboxesFromPermsField() {
        try {
            int perms = Integer.parseInt(this.numberPerms.getText(), 8);
            this.setPermsToCheckboxes(perms);
        }
        catch (NumberFormatException nfe) {
            this.setPermsFieldFromCheckboxes();
            JOptionPane.showMessageDialog(this, "Permissions must be a three digit octal value", "", 0);
        }
    }

    private void onPermStringChanged() {
        this.numberPerms.setText(PermissionsForm.toThreeCharString(this.numberPerms.getText()));
        this.setCheckboxesFromPermsField();
    }

    public PermissionsForm() {
        this.$$$setupUI$$$();
        this.jobDialog = this.jobDialog;
        ActionListener checkboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermissionsForm.this.setPermsFieldFromCheckboxes();
                PermissionsForm.this.fieldChanged();
            }
        };
        this.ownerRead.addActionListener(checkboxListener);
        this.ownerWrite.addActionListener(checkboxListener);
        this.ownerExecute.addActionListener(checkboxListener);
        this.groupRead.addActionListener(checkboxListener);
        this.groupWrite.addActionListener(checkboxListener);
        this.groupExecute.addActionListener(checkboxListener);
        this.otherRead.addActionListener(checkboxListener);
        this.otherWrite.addActionListener(checkboxListener);
        this.otherExecute.addActionListener(checkboxListener);
        this.numberPerms.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PermissionsForm.this.onPermStringChanged();
            }
        });
        this.numberPerms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermissionsForm.this.onPermStringChanged();
            }
        });
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PermissionsForm.this.fieldChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PermissionsForm.this.fieldChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PermissionsForm.this.fieldChanged();
            }
        };
        this.numberPerms.getDocument().addDocumentListener(docListener);
    }

    public void setJobDialog(JobDialog jobDialog) {
        this.jobDialog = jobDialog;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.ownerExecute.setEnabled(enabled);
        this.ownerRead.setEnabled(enabled);
        this.ownerWrite.setEnabled(enabled);
        this.groupExecute.setEnabled(enabled);
        this.groupRead.setEnabled(enabled);
        this.groupWrite.setEnabled(enabled);
        this.otherExecute.setEnabled(enabled);
        this.otherWrite.setEnabled(enabled);
        this.otherRead.setEnabled(enabled);
        this.numberPerms.setEnabled(enabled);
    }

    public int getPermissionsValue() {
        return Integer.parseInt(this.numberPerms.getText());
    }

    public void setPermissionsValue(int value) {
        String newValue = "" + value;
        this.numberPerms.setText(newValue);
        this.setCheckboxesFromPermsField();
    }

    private void fieldChanged() {
        if (this.jobDialog != null) {
            this.jobDialog.fieldChanged();
        }
    }

    private static String toThreeCharOctalString(int perms) {
        String s = Integer.toOctalString(perms);
        return PermissionsForm.toThreeCharString(s);
    }

    private static String toThreeCharString(String s) {
        if ((s = s.trim()).length() > 3) {
            s = s.substring(0, 3);
        } else {
            while (s.length() < 3) {
                s = "0" + s;
            }
        }
        return s;
    }

    private void $$$setupUI$$$() {
        this.panel1 = new JPanel();
        this.panel1.setLayout((LayoutManager)new FormLayout("fill:max(m;4px):noGrow,left:4dlu:noGrow,fill:max(m;4px):noGrow,left:4dlu:noGrow,fill:max(m;4px):noGrow,left:4dlu:noGrow,fill:max(m;4px):noGrow", "center:d:noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        JLabel label1 = new JLabel();
        label1.setText("              ");
        CellConstraints cc = new CellConstraints();
        this.panel1.add((Component)label1, cc.xy(1, 1));
        JLabel label2 = new JLabel();
        label2.setText("Read");
        this.panel1.add((Component)label2, cc.xy(3, 1));
        JLabel label3 = new JLabel();
        label3.setText("Write");
        this.panel1.add((Component)label3, cc.xy(5, 1));
        JLabel label4 = new JLabel();
        label4.setText("Execute");
        this.panel1.add((Component)label4, cc.xy(7, 1));
        JLabel label5 = new JLabel();
        label5.setText("Owner");
        this.panel1.add((Component)label5, cc.xy(1, 3));
        JLabel label6 = new JLabel();
        label6.setText("Group");
        this.panel1.add((Component)label6, cc.xy(1, 5));
        JLabel label7 = new JLabel();
        label7.setText("Other");
        this.panel1.add((Component)label7, cc.xy(1, 7));
        this.ownerRead = new JCheckBox();
        this.ownerRead.setText("");
        this.panel1.add((Component)this.ownerRead, cc.xy(3, 3, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.ownerWrite = new JCheckBox();
        this.ownerWrite.setText("");
        this.panel1.add((Component)this.ownerWrite, cc.xy(5, 3, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.ownerExecute = new JCheckBox();
        this.ownerExecute.setText("");
        this.panel1.add((Component)this.ownerExecute, cc.xy(7, 3, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.groupRead = new JCheckBox();
        this.groupRead.setText("");
        this.panel1.add((Component)this.groupRead, cc.xy(3, 5, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.groupWrite = new JCheckBox();
        this.groupWrite.setText("");
        this.panel1.add((Component)this.groupWrite, cc.xy(5, 5, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.groupExecute = new JCheckBox();
        this.groupExecute.setText("");
        this.panel1.add((Component)this.groupExecute, cc.xy(7, 5, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.otherRead = new JCheckBox();
        this.otherRead.setText("");
        this.panel1.add((Component)this.otherRead, cc.xy(3, 7, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.otherWrite = new JCheckBox();
        this.otherWrite.setText("");
        this.panel1.add((Component)this.otherWrite, cc.xy(5, 7, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.otherExecute = new JCheckBox();
        this.otherExecute.setText("");
        this.panel1.add((Component)this.otherExecute, cc.xy(7, 7, CellConstraints.CENTER, CellConstraints.DEFAULT));
        JLabel label8 = new JLabel();
        label8.setText("Numeric code");
        this.panel1.add((Component)label8, cc.xyw(1, 9, 5));
        this.numberPerms = new JTextField();
        this.panel1.add((Component)this.numberPerms, cc.xy(7, 9, CellConstraints.FILL, CellConstraints.DEFAULT));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel1;
    }
}

