/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.settings;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcmover.gui.panels.LoadSchedulePanel;
import com.archivas.clienttools.arcmover.gui.panels.LoggingSettingsPanel;
import com.archivas.clienttools.arcmover.gui.panels.OwnerPanel;
import com.archivas.clienttools.arcmover.gui.panels.PoliciesPanel;
import com.archivas.clienttools.arcmover.gui.settings.DefaultNamespaceSettingsForm;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthButton;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcutils.config.HCPMoverConstants;
import com.archivas.clienttools.arcutils.config.HCPMoverProperties;
import com.archivas.clienttools.arcutils.impl.jobs.FailureProgressLogger;
import com.archivas.clienttools.arcutils.impl.jobs.SuccessProgressLogger;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.model.Owner;
import com.archivas.clienttools.arcutils.model.Retention;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class PreferencesDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(PreferencesDialog.class.getName());
    private PoliciesPanel policiesPanel;
    private OwnerPanel ownerPanel;
    private DefaultNamespaceSettingsForm posixPanel;
    private LoadSchedulePanel loadSchedulePanel;
    private LoggingSettingsPanel loggingSettingsPanel;
    private JButton applyButton;
    private JButton okButton;
    private JButton cancelButton;

    public PreferencesDialog() {
        super(HCPDataMigrator.getInstance());
        this.setModal(true);
        this.setTitle("Preferences");
        this.layoutGuiComponents();
        this.setupListeners();
        this.pack();
    }

    private void layoutGuiComponents() {
        JTabbedPane tabbedPane = new JTabbedPane();
        Retention retention = Retention.fromProperties(Retention.Type.fromUIName(HCPMoverProperties.RETENTION_TYPE.get()), HCPMoverProperties.RETENTION_USER_INPUT.get(), HCPMoverProperties.RETENTION_HCAP_VALUE.get());
        this.policiesPanel = new PoliciesPanel(true, HCPMoverProperties.INDEX_MODE.getAsTriState().toBoolean(), HCPMoverProperties.SHRED_MODE.getAsTriState().toBoolean(), HCPMoverProperties.RETENTION_HOLD_MODE.getAsTriState().toBoolean(), retention, true);
        tabbedPane.addTab("Policies", this.policiesPanel);
        String uid = HCPMoverProperties.PERMISSIONS_UID.get();
        String gid = HCPMoverProperties.PERMISSIONS_GID.get();
        int fileMode = HCPMoverProperties.PERMISSIONS_FILE_MODE.getAsInt(-1);
        int dirMode = HCPMoverProperties.PERMISSIONS_DIR_MODE.getAsInt(-1);
        this.posixPanel = new DefaultNamespaceSettingsForm(null, uid, gid, fileMode, dirMode);
        tabbedPane.addTab("POSIX Metadata", this.posixPanel);
        this.ownerPanel = new OwnerPanel(Owner.createFromStringRepresentation(HCPMoverProperties.OWNER.get()));
        tabbedPane.addTab("Owner", this.ownerPanel);
        this.loadSchedulePanel = new LoadSchedulePanel(null, LoadSchedule.getDefaultLoadSchedule(), true);
        tabbedPane.add("Load Schedule", this.loadSchedulePanel);
        this.loggingSettingsPanel = new LoggingSettingsPanel(HCPMoverProperties.LOGGING_SUCCESS_MODE.getAsTriState(), HCPMoverProperties.LOGGING_SUCCESS_PERIOD.getAsInt(), HCPMoverProperties.LOGGING_FAILURE_MODE.getAsTriState(), HCPMoverProperties.LOGGING_FAILURE_PERIOD.getAsInt());
        tabbedPane.add("Logging Settings", this.loggingSettingsPanel);
        this.applyButton = new FixedWidthButton("Apply", 100);
        this.okButton = new FixedWidthButton("OK", 100);
        this.cancelButton = new FixedWidthButton("Cancel", 100);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.applyButton);
        buttonPanel.add(Box.createHorizontalStrut(12));
        buttonPanel.add(this.okButton);
        buttonPanel.add(Box.createHorizontalStrut(12));
        buttonPanel.add(this.cancelButton);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new EmptyBorder(12, 12, 12, 12));
        p.add(tabbedPane);
        p.add(Box.createVerticalStrut(25));
        p.add(buttonPanel);
        p.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.getContentPane().add(p);
    }

    private void setupListeners() {
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.onApply();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.onOk();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PreferencesDialog.this.onCancel();
            }
        });
    }

    private void onOk() {
        if (this.onApply()) {
            this.dispose();
        }
    }

    private boolean onApply() {
        boolean success = false;
        try {
            Retention ret = this.policiesPanel.getRetention();
            HCPMoverProperties.RETENTION_TYPE.set(ret.getType().uiName());
            HCPMoverProperties.RETENTION_USER_INPUT.set(ret.getUIValue());
            HCPMoverProperties.RETENTION_HCAP_VALUE.set(ret.getHCAPValue());
            HCPMoverProperties.SHRED_MODE.set(this.policiesPanel.getShred());
            HCPMoverProperties.INDEX_MODE.set(this.policiesPanel.getIndex());
            HCPMoverProperties.RETENTION_HOLD_MODE.set(this.policiesPanel.getHold());
            HCPMoverProperties.OWNER.set(this.ownerPanel.getOwner().createStringRepresentation());
            HCPMoverProperties.PERMISSIONS_UID.set(this.posixPanel.hasUid() ? "" + this.posixPanel.getUid() : "");
            HCPMoverProperties.PERMISSIONS_GID.set(this.posixPanel.hasGid() ? "" + this.posixPanel.getGid() : "");
            HCPMoverProperties.PERMISSIONS_FILE_MODE.set(this.posixPanel.hasFileMode() ? this.posixPanel.getFileMode() : -1);
            HCPMoverProperties.PERMISSIONS_DIR_MODE.set(this.posixPanel.hasDirMode() ? this.posixPanel.getDirMode() : -1);
            LoadSchedule.setDefaultLoadSchedule(this.loadSchedulePanel.getLoadSchedule());
            HCPMoverProperties.LOGGING_SUCCESS_MODE.set(this.loggingSettingsPanel.getSuccessLoggingMode());
            HCPMoverProperties.LOGGING_SUCCESS_PERIOD.set(this.loggingSettingsPanel.getSuccessPeriod());
            HCPMoverProperties.LOGGING_FAILURE_MODE.set(this.loggingSettingsPanel.getFailureLoggingMode());
            HCPMoverProperties.LOGGING_FAILURE_PERIOD.set(this.loggingSettingsPanel.getFailurePeriod());
            SuccessProgressLogger successProgressLogger = SuccessProgressLogger.getInstance();
            if (this.loggingSettingsPanel.getSuccessLoggingMode() == HCPMoverConstants.TriState.NO) {
                successProgressLogger.disableLogging();
            } else if (this.loggingSettingsPanel.getSuccessLoggingMode() == HCPMoverConstants.TriState.YES) {
                successProgressLogger.setLogAll(true);
            } else {
                successProgressLogger.setLogIntervalSeconds(this.loggingSettingsPanel.getSuccessPeriod());
            }
            FailureProgressLogger failureProgressLogger = FailureProgressLogger.getInstance();
            if (this.loggingSettingsPanel.getFailureLoggingMode() == HCPMoverConstants.TriState.NO) {
                failureProgressLogger.disableLogging();
            } else if (this.loggingSettingsPanel.getFailureLoggingMode() == HCPMoverConstants.TriState.YES) {
                failureProgressLogger.setLogAll(true);
            } else {
                failureProgressLogger.setLogIntervalSeconds(this.loggingSettingsPanel.getFailurePeriod());
            }
            HCPMoverProperties.persist();
            success = true;
        }
        catch (IllegalArgumentException iae) {
            GUIHelper.showMessageDialog(this, iae.getMessage(), "Error Saving Preferences", 0);
        }
        catch (Exception e) {
            String msg = DBUtils.getErrorMessage("An error occurred saving preferences", e);
            GUIHelper.showMessageDialog(this, msg, "Error Saving Preferences", 0);
            LOG.log(Level.WARNING, msg, e);
        }
        return success;
    }

    private void onCancel() {
        this.dispose();
    }

    public static void main(String[] args) {
        PreferencesDialog d = new PreferencesDialog();
        d.setVisible(true);
    }
}

