/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.ssl;

import com.archivas.clienttools.arcmover.gui.ssl.SSLCertificateForm;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class SSLCertificateAllowDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(SSLCertificateAllowDialog.class.getName());
    private AbstractProfileBase moverProfile;
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    protected SSLCertificateForm sslCertificateForm;
    protected JLabel issuedToCommonNameLabel;
    protected JLabel issuedByCommonNameLabel;
    protected JLabel validDateRangeLabel;
    protected JTextArea detailsTextArea;
    protected JLabel md5FingerprintLabel;
    protected JLabel issuedToOrganizationLabel;
    protected JLabel issuedByOrganizationLabel;
    protected JLabel issuedToOrganizationalUnitLabel;
    protected JLabel issuedByOrganizationalUnitLabel;
    protected JLabel serialNumberLabel;
    protected JLabel shaFingerprintLabel;
    protected JLabel validityLabel;
    protected SSLCertificateCallback.AllowSSLCert allowCert = SSLCertificateCallback.AllowSSLCert.NO;

    public SSLCertificateAllowDialog(AbstractProfileBase moverProfile) {
        this.$$$setupUI$$$();
        this.moverProfile = moverProfile;
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.setIconImage(SSLCertificateForm.sslFrameIcon.getImage());
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSLCertificateAllowDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSLCertificateAllowDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SSLCertificateAllowDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSLCertificateAllowDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.pack();
    }

    private void onOK() {
        try {
            this.allowCert = SSLCertificateCallback.AllowSSLCert.NO;
            if (this.sslCertificateForm.getPermStoreCertCheckBox() != null) {
                this.allowCert = this.sslCertificateForm.getPermStoreCertCheckBox().isSelected() ? SSLCertificateCallback.AllowSSLCert.PERMANENTLY_SAVE : SSLCertificateCallback.AllowSSLCert.THIS_SESSION_ONLY;
            }
        }
        catch (Exception e1) {
            String msg = "Unexpected Error";
            LOG.log(Level.WARNING, msg, e1);
            JOptionPane.showMessageDialog(this, msg, "Error", 0);
        }
        finally {
            this.dispose();
        }
    }

    private void onCancel() {
        try {
            this.allowCert = SSLCertificateCallback.AllowSSLCert.NO;
        }
        catch (Exception e1) {
            String msg = "Unexpected Error";
            LOG.log(Level.WARNING, msg, e1);
            JOptionPane.showMessageDialog(this, msg, "Error", 0);
        }
        finally {
            this.dispose();
        }
    }

    public SSLCertificateCallback.AllowSSLCert getAllowCert() {
        return this.allowCert;
    }

    public void setAllowCert(SSLCertificateCallback.AllowSSLCert allowCert) {
        this.allowCert = allowCert;
    }

    public AbstractProfileBase getMoverProfile() {
        return this.moverProfile;
    }

    public void setMoverProfile(AbstractProfileBase profile) {
        this.moverProfile = profile;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.sslCertificateForm.setSSLCertChain(this.getMoverProfile().getSSLCertChain());
            this.sslCertificateForm.setPermStoreCertCheckBoxVisible(true);
            this.sslCertificateForm.setPermStoreCertCheckBoxEnabled(true);
            this.pack();
        }
        super.setVisible(visible);
    }

    public void setWarningText(String text) {
        this.sslCertificateForm.setOtherWarningsText(text);
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new FormLayout("fill:4dlu:noGrow,fill:d:grow,fill:4dlu:noGrow", "center:4dlu:noGrow,center:d:grow,top:4dlu:noGrow,center:max(d;15dlu):noGrow,center:4dlu:noGrow"));
        this.contentPane.setMinimumSize(new Dimension(300, 300));
        this.contentPane.setPreferredSize(new Dimension(500, 500));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new FormLayout("fill:d:grow,left:4dlu:noGrow,fill:max(d;50dlu):noGrow,left:4dlu:noGrow,fill:max(d;50dlu):noGrow", "center:d:grow"));
        panel1.setPreferredSize(new Dimension(300, 24));
        CellConstraints cc = new CellConstraints();
        this.contentPane.add((Component)panel1, cc.xy(2, 4));
        this.buttonOK = new JButton();
        this.buttonOK.setText("Confirm Security Exception");
        this.buttonOK.setToolTipText("Accept this cerficate");
        panel1.add((Component)this.buttonOK, cc.xy(3, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("Cancel");
        panel1.add((Component)this.buttonCancel, cc.xy(5, 1));
        this.sslCertificateForm = new SSLCertificateForm();
        this.contentPane.add((Component)this.sslCertificateForm.$$$getRootComponent$$$(), cc.xy(2, 2, CellConstraints.FILL, CellConstraints.FILL));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

