/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.util;

import com.archivas.clienttools.arcutils.config.ConfigurationException;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DialogDimensionProperties {
    public static Logger LOG = Logger.getLogger(DialogDimensionProperties.class.getName());
    private final String key;
    public int width;
    public int height;

    public DialogDimensionProperties(String key, int defaultWidth, int defaultHeight) {
        this.key = key;
        this.width = ConfigurationHelper.getIntegerProperty("gui." + key + ".width", defaultWidth);
        this.height = ConfigurationHelper.getIntegerProperty("gui." + key + ".height", defaultHeight);
    }

    public synchronized void persist() {
        try {
            ConfigurationHelper.setUserProperty("gui." + this.key + ".width", Integer.toString(this.width));
            ConfigurationHelper.setUserProperty("gui." + this.key + ".height", Integer.toString(this.height));
        }
        catch (ConfigurationException e) {
            LOG.log(Level.WARNING, "An error occurred persisting dialog dimensions: " + e.getMessage(), e);
        }
    }
}

