/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.util;

import com.archivas.clienttools.arcmover.gui.util.AbstractFileListCellRenderer;
import com.archivas.clienttools.arcmover.gui.util.FileListTable;
import com.archivas.clienttools.arcmover.gui.util.FileNameCellRenderer;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import java.awt.Color;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class FileHasCustomMetadataCellRenderer
extends AbstractFileListCellRenderer {
    private static final Logger LOG = Logger.getLogger(FileHasCustomMetadataCellRenderer.class.getName());
    public static final String EMPTYSTR = "";
    public static final String PADDING = " ";

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int rowIndex, int colIndex) {
        JComponent c = null;
        try {
            ArcMoverFile file = this.getFileAt(table, rowIndex);
            c = this.renderFileHasCustomMetadata(table, file, isSelected, cellHasFocus, rowIndex, colIndex);
            c.setToolTipText(FileNameCellRenderer.toolTipString(file, ((FileListTable)table).getModel().getColumnNames()));
            if (table.isEnabled()) {
                c.setEnabled(true);
            } else {
                c.setEnabled(false);
            }
            if (file.getMetadata() != null && file.getMetadata().hasRestState()) {
                String state = file.getMetadata().getRestState();
                if (!"deleted".equals(state)) {
                    c.setEnabled(true);
                } else {
                    c.setEnabled(false);
                }
            }
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
        return c;
    }

    protected JComponent renderFileHasCustomMetadata(JTable table, ArcMoverFile file, boolean isSelected, boolean cellHasFocus, int rowIndex, int colIndex) {
        JComponent c = null;
        JCheckBox checkBox = null;
        DefaultTableCellRenderer label = new DefaultTableCellRenderer();
        if (file != null && file.getMetadata() != null && file.getMetadata().hasCustomMetadata()) {
            checkBox = new JCheckBox();
            checkBox.setHorizontalAlignment(0);
            if (isSelected) {
                checkBox.setBackground(table.getSelectionBackground());
            } else {
                checkBox.setBackground(Color.WHITE);
            }
            checkBox.setSelected(file.getMetadata().getCustomMetadata().isLoad());
            checkBox.requestFocus(cellHasFocus);
            c = checkBox;
        } else {
            label.getTableCellRendererComponent(table, EMPTYSTR, isSelected, cellHasFocus, rowIndex, colIndex);
            c = label;
        }
        return c;
    }
}

