/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.util;

import com.archivas.clienttools.arcmover.gui.util.FileNameCellRenderer;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.UIManager;

public class FileListCellRenderer
extends DefaultListCellRenderer {
    public static final String EMPTYSTR = "";
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.00");

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        ArcMoverFile file;
        String displayValue = null;
        if (value instanceof ArcMoverFile) {
            file = (ArcMoverFile)value;
        } else if (value instanceof ArcProcessFile) {
            file = ((ArcProcessFile)value).getSourceArcMoverFile();
        } else {
            return this;
        }
        ArcMoverDirectory parentDir = file.getParent();
        if (parentDir != null && parentDir.isVersionList() && file.getMetadata() != null) {
            String ctime = EMPTYSTR;
            if (file.getMetadata().getCreationTime() != null) {
                ctime = formatter.format(file.getMetadata().getCreationTime());
            }
            displayValue = ctime + " - " + file.getMetadata().getVersionNumber();
        } else {
            displayValue = file.getDisplayFileName();
        }
        super.getListCellRendererComponent((JList<?>)list, displayValue, index, false, false);
        if (file.isDirectory()) {
            this.setIcon(UIManager.getIcon("FileView.directoryIcon"));
        } else if (file.isSymlink()) {
            this.setIcon(new ImageIcon(this.getClass().getResource("/images/symlink16x16.png")));
        } else {
            this.setIcon(UIManager.getIcon("FileView.fileIcon"));
        }
        this.setToolTipText(FileNameCellRenderer.toolTipString(file));
        return this;
    }
}

