/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.util;

import com.archivas.clienttools.arcmover.gui.util.BooleanCellRenderer;
import com.archivas.clienttools.arcmover.gui.util.EncodedStringCellRenderer;
import com.archivas.clienttools.arcmover.gui.util.FileLastModifiedTimeCellRenderer;
import com.archivas.clienttools.arcmover.gui.util.FileListTableModel;
import com.archivas.clienttools.arcmover.gui.util.FileNameCellRenderer;
import com.archivas.clienttools.arcmover.gui.util.FileSizeCellRenderer;
import com.archivas.clienttools.arcmover.gui.util.GUIHelper;
import com.archivas.clienttools.arcmover.gui.util.StringCellRenderer;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class FileListTable
extends JTable {
    private Font fileFont;

    public FileListTable(FileListTableModel dm) {
        super(dm);
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(2);
        this.setDropMode(DropMode.INSERT_ROWS);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setBackground(Color.WHITE);
        this.setFillsViewportHeight(true);
        this.setGridColor(new Color(-1));
        this.setAutoResizeMode(0);
    }

    public void setColumnCellRenderers() {
        this.setColumnCellRenderer("Name", new FileNameCellRenderer(this.fileFont));
        this.setColumnCellRenderer("Version", new StringCellRenderer());
        this.setColumnCellRenderer("Size", new FileSizeCellRenderer());
        this.setColumnCellRenderer("Modified Time", new FileLastModifiedTimeCellRenderer());
        this.setColumnCellRenderer("Ingested", new FileLastModifiedTimeCellRenderer());
        this.setColumnCellRenderer("CM", new BooleanCellRenderer());
        this.setColumnCellRenderer("Retention", new StringCellRenderer());
        this.setColumnCellRenderer("Shred", new BooleanCellRenderer());
        this.setColumnCellRenderer("Index", new BooleanCellRenderer());
        this.setColumnCellRenderer("Hold", new BooleanCellRenderer());
        this.setColumnCellRenderer("ACL", new BooleanCellRenderer());
        this.setColumnCellRenderer("Owner", new EncodedStringCellRenderer(this.fileFont));
        this.setColumnCellRenderer("Domain", new StringCellRenderer());
    }

    private void setColumnCellRenderer(String colName, TableCellRenderer r) {
        try {
            this.getColumn(colName).setCellRenderer(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setListData(List<ArcMoverFile> fileList) {
        this.getModel().setFileList(fileList);
        GUIHelper.autoResizeColWidth(this);
    }

    @Override
    public FileListTableModel getModel() {
        return (FileListTableModel)super.getModel();
    }

    public void setFileFont(Font f) {
        this.fileFont = f;
        this.setColumnCellRenderer("Name", new FileNameCellRenderer(this.fileFont));
        this.setColumnCellRenderer("Owner", new EncodedStringCellRenderer(this.fileFont));
    }
}

