/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.util;

import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.Owner;
import com.archivas.clienttools.arcutils.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class FileListTableModel
extends AbstractTableModel {
    List<ArcMoverFile> fileList = null;
    public static final String EMPTYSTR = "";
    public static final String COL_NAME = "Name";
    public static final String COL_VERSION = "Version";
    public static final String COL_SIZE = "Size";
    public static final String COL_MTIME = "Modified Time";
    public static final String COL_INGESTED = "Ingested";
    public static final String COL_HAS_CM = "CM";
    public static final String COL_HAS_ACL = "ACL";
    public static final String COL_MODE = "Mode";
    public static final String COL_UID = "UID";
    public static final String COL_GID = "GID";
    public static final String COL_RETENTION_STRING = "Retention";
    public static final String COL_RETENTION_HOLD = "Hold";
    public static final String COL_SHRED = "Shred";
    public static final String COL_INDEX = "Index";
    public static final String COL_OWNER = "Owner";
    public static final String COL_DOMAIN = "Domain";
    private List<String> columnNameList = new ArrayList<String>();
    private List<Class> columnClassList = new ArrayList<Class>();

    public FileListTableModel() {
    }

    public FileListTableModel(List<String> columns) {
        for (String col : columns) {
            if (COL_NAME.equals(col)) {
                this.columnNameList.add(col);
                this.columnClassList.add(ArcMoverFile.class);
                continue;
            }
            if (COL_SIZE.equals(col)) {
                this.columnNameList.add(col);
                this.columnClassList.add(String.class);
                continue;
            }
            if (COL_MTIME.equals(col) || COL_INGESTED.equals(col)) {
                this.columnNameList.add(col);
                this.columnClassList.add(Date.class);
                continue;
            }
            if (COL_HAS_CM.equals(col) || COL_HAS_ACL.equals(col) || COL_SHRED.equals(col) || COL_INDEX.equals(col) || COL_RETENTION_HOLD.equals(col)) {
                this.columnNameList.add(col);
                this.columnClassList.add(Boolean.class);
                continue;
            }
            if (COL_MODE.equals(col) || COL_RETENTION_STRING.equals(col) || COL_OWNER.equals(col) || COL_DOMAIN.equals(col)) {
                this.columnNameList.add(col);
                this.columnClassList.add(String.class);
                continue;
            }
            if (COL_UID.equals(col) || COL_GID.equals(col)) {
                this.columnNameList.add(col);
                this.columnClassList.add(Integer.class);
                continue;
            }
            if (COL_VERSION.equals(col)) {
                this.columnNameList.add(col);
                this.columnClassList.add(Long.class);
                continue;
            }
            throw new RuntimeException("Unrecognized column " + col);
        }
    }

    public List<String> getColumnNames() {
        return this.columnNameList;
    }

    public List<ArcMoverFile> getFileList() {
        return this.fileList;
    }

    public void setFileList(List<ArcMoverFile> fileList) {
        this.fileList = fileList;
    }

    @Override
    public int getColumnCount() {
        return this.columnNameList.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClassList.get(columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNameList.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        int cnt = 0;
        if (this.getFileList() != null) {
            cnt = this.getFileList().size();
        }
        return cnt;
    }

    @Override
    public Object getValueAt(int row, int col) {
        ArcMoverFile moverFile;
        try {
            moverFile = this.getFileList().get(row);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        if (moverFile == null) {
            return null;
        }
        Object ret = null;
        String colName = this.columnNameList.get(col);
        if (COL_NAME.equals(colName)) {
            ret = moverFile;
        } else if (COL_VERSION.equals(colName)) {
            ret = moverFile.getMetadata().getVersionNumber();
        } else if (COL_SIZE.equals(colName)) {
            ret = StringUtils.bytesToStringWithUnit(moverFile.getSize());
        } else if (COL_MTIME.equals(colName)) {
            ret = FileListTableModel.getModTime(moverFile);
        } else if (COL_INGESTED.equals(colName)) {
            ret = moverFile.getMetadata().getCreationTime();
        } else if (COL_HAS_CM.equals(colName)) {
            if (!moverFile.isDirectory()) {
                ret = moverFile.getMetadata().hasCustomMetadata();
            }
        } else if (COL_HAS_ACL.equals(colName)) {
            if (!moverFile.isDirectory()) {
                ret = moverFile.getMetadata().hasACL();
            }
        } else if (COL_MODE.equals(colName)) {
            ret = moverFile.isDirectory() ? moverFile.getMetadata().getDirModeForUnixLsDisplay() : moverFile.getMetadata().getFileModeForUnixLsDisplay();
        } else if (COL_UID.equals(colName)) {
            ret = moverFile.getMetadata().getUid();
        } else if (COL_GID.equals(colName)) {
            ret = moverFile.getMetadata().getGid();
        } else if (COL_RETENTION_STRING.equals(colName)) {
            ret = FileListTableModel.getRetentionString(moverFile);
        } else if (COL_RETENTION_HOLD.equals(colName)) {
            ret = moverFile.getMetadata().isRetentionHold();
        } else if (COL_SHRED.equals(colName)) {
            ret = moverFile.getMetadata().isShred();
        } else if (COL_INDEX.equals(colName)) {
            ret = moverFile.getMetadata().isSearchIndex();
        } else if (COL_OWNER.equals(colName)) {
            if (moverFile.getMetadata().getOwner() != null && (moverFile.getMetadata().getOwner().getOwnerType().equals((Object)Owner.OwnerType.EXTERNAL) || moverFile.getMetadata().getOwner().getOwnerType().equals((Object)Owner.OwnerType.LOCAL))) {
                ret = moverFile.getMetadata().getOwner().getOwnerName();
            }
        } else if (COL_DOMAIN.equals(colName)) {
            if (moverFile.getMetadata().getOwner() != null && moverFile.getMetadata().getOwner().getOwnerType().equals((Object)Owner.OwnerType.EXTERNAL)) {
                ret = moverFile.getMetadata().getOwner().getDomain();
            }
        } else {
            throw new RuntimeException("Unrecognized column " + colName);
        }
        return ret;
    }

    public static Date getModTime(ArcMoverFile moverFile) {
        Date d = moverFile.getMetadata().getModTime();
        if (d == null) {
            d = moverFile.getMetadata().getCreationTime();
        }
        return d;
    }

    public static String getRetentionString(ArcMoverFile moverFile) {
        String ret = EMPTYSTR;
        if (moverFile != null && moverFile.getMetadata() != null && moverFile.getMetadata().getRetention() != null) {
            ret = moverFile.getMetadata().getRetention().getUIValue();
        }
        return ret;
    }

    public ArcMoverFile getFileAt(int row) {
        return this.fileList.get(row);
    }
}

