/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.util;

import com.archivas.clienttools.arcmover.gui.util.FileListTable;
import com.archivas.clienttools.arcmover.gui.util.FileListTableModel;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.Owner;
import com.archivas.clienttools.arcutils.utils.StringUtils;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class FileNameCellRenderer
extends DefaultTableCellRenderer {
    private static final Logger LOG = Logger.getLogger(FileNameCellRenderer.class.getName());
    public static final String EMPTYSTR = "";
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private static final DecimalFormat decimalFormat = new DecimalFormat("0");
    public static final String PADDING = " ";
    private Font fileFont;

    public FileNameCellRenderer(Font f) {
        this.fileFont = f;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int rowIndex, int colIndex) {
        try {
            String state;
            ArcMoverFile file;
            if (value instanceof ArcMoverFile) {
                file = (ArcMoverFile)value;
            } else if (value instanceof ArcProcessFile) {
                file = ((ArcProcessFile)value).getSourceArcMoverFile();
            } else {
                return this;
            }
            this.renderFileName(table, file, isSelected, cellHasFocus, rowIndex, colIndex);
            this.setToolTipText(FileNameCellRenderer.toolTipString(file, ((FileListTable)table).getModel().getColumnNames()));
            boolean enabled = table.isEnabled();
            if (file.getMetadata() != null && file.getMetadata().hasRestState() && ("deleted".equals(state = file.getMetadata().getRestState()) || !file.isLatestVersion())) {
                enabled = false;
            }
            this.setEnabled(enabled);
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
        return this;
    }

    protected void renderFileName(JTable table, ArcMoverFile file, boolean isSelected, boolean cellHasFocus, int rowIndex, int colIndex) {
        if (file != null) {
            String displayValue = PADDING + file.getDisplayFileName() + PADDING;
            Component renderer = super.getTableCellRendererComponent(table, displayValue, isSelected, cellHasFocus, rowIndex, colIndex);
            renderer.setFont(this.fileFont);
            if (file.isDirectory()) {
                this.setIcon(UIManager.getIcon("FileView.directoryIcon"));
            } else if (file.isSymlink()) {
                this.setIcon(new ImageIcon(this.getClass().getResource("/images/symlink16x16.png")));
            } else {
                this.setIcon(UIManager.getIcon("FileView.fileIcon"));
            }
            this.setToolTipText(FileNameCellRenderer.toolTipString(file, ((FileListTable)table).getModel().getColumnNames()));
        }
    }

    public static String toolTipString(ArcMoverFile file) {
        List<String> columns = file.getProfile().makeAdapter().getFileListColumns();
        return FileNameCellRenderer.toolTipString(file, columns);
    }

    public static String toolTipString(ArcMoverFile file, List<String> columns) {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append(file.getDisplayFileName());
        FileMetadata metadata = file.getMetadata();
        if (columns != null && metadata != null) {
            for (String column : columns) {
                if ("Version".equals(column) && metadata.hasVersionNumber()) {
                    toolTip.append(", ").append(column).append(": ");
                    toolTip.append(metadata.getVersionNumber());
                    continue;
                }
                if ("Size".equals(column) && file.isFile()) {
                    toolTip.append(", ").append(column).append(": ");
                    toolTip.append(StringUtils.bytesToStringWithUnit(file.getSize(), decimalFormat));
                    continue;
                }
                if ("Modified Time".equals(column) && metadata.hasModTime()) {
                    toolTip.append(", ").append(column).append(": ");
                    toolTip.append(metadata.getModTime());
                    continue;
                }
                if ("Ingested".equals(column) && (metadata.hasModTime() || metadata.hasCreationTime())) {
                    toolTip.append(", ").append(column).append(": ");
                    toolTip.append(FileListTableModel.getModTime(file));
                    continue;
                }
                if ("CM".equals(column)) {
                    toolTip.append(", ").append(column).append(": ");
                    toolTip.append(metadata.hasCustomMetadata());
                    continue;
                }
                if ("ACL".equals(column)) {
                    toolTip.append(", ").append(column).append(": ");
                    toolTip.append(metadata.hasACL());
                    continue;
                }
                if ("Shred".equals(column) && metadata.hasShred()) {
                    toolTip.append(", ").append(column).append(": ");
                    toolTip.append(metadata.isShred());
                    continue;
                }
                if ("Index".equals(column) && metadata.hasSearchIndex()) {
                    toolTip.append(", ").append(column).append(": ");
                    toolTip.append(metadata.isSearchIndex());
                    continue;
                }
                if ("Hold".equals(column) && metadata.hasRetentionHold()) {
                    toolTip.append(", ").append(column).append(": ");
                    toolTip.append(metadata.isRetentionHold());
                    continue;
                }
                if ("Mode".equals(column) && (file.isDirectory() && metadata.hasDirMode() || file.isFile() && metadata.hasFileMode())) {
                    toolTip.append(", ").append(column).append(": ");
                    if (file.isDirectory()) {
                        toolTip.append(metadata.getDirModeForUnixLsDisplay());
                        continue;
                    }
                    toolTip.append(metadata.getFileModeForUnixLsDisplay());
                    continue;
                }
                if ("Retention".equals(column) && metadata.hasRetention()) {
                    toolTip.append(", ").append(column).append(": ");
                    toolTip.append(metadata.getRetention().getUIValue());
                    continue;
                }
                if ("UID".equals(column) && metadata.hasUid()) {
                    toolTip.append(", ").append(column).append(": ");
                    toolTip.append(metadata.getUid());
                    continue;
                }
                if ("GID".equals(column) && metadata.hasGid()) {
                    toolTip.append(", ").append(column).append(": ");
                    toolTip.append(metadata.getGid());
                    continue;
                }
                if ("Owner".equals(column) && metadata.hasOwner() && (metadata.getOwner().getOwnerType().equals((Object)Owner.OwnerType.EXTERNAL) || metadata.getOwner().getOwnerType().equals((Object)Owner.OwnerType.LOCAL))) {
                    toolTip.append(", ").append(column).append(": ");
                    toolTip.append(metadata.getOwner().getOwnerName());
                    continue;
                }
                if (!"Domain".equals(column) || !metadata.hasOwner() || !metadata.getOwner().getOwnerType().equals((Object)Owner.OwnerType.EXTERNAL)) continue;
                toolTip.append(", ").append(column).append(": ");
                toolTip.append(metadata.getOwner().getDomain());
            }
        }
        return toolTip.toString();
    }
}

