/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.util;

import com.archivas.clienttools.arcmover.gui.util.AbstractFileListCellRenderer;
import com.archivas.clienttools.arcmover.gui.util.FileListTable;
import com.archivas.clienttools.arcmover.gui.util.FileNameCellRenderer;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import com.archivas.clienttools.arcutils.utils.StringUtils;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;

public class FileSizeCellRenderer
extends AbstractFileListCellRenderer {
    private static final Logger LOG = Logger.getLogger(FileNameCellRenderer.class.getName());
    public static final String EMPTYSTR = "";
    public static final String PADDING = " ";

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int rowIndex, int colIndex) {
        try {
            ArcMoverFile file = this.getFileAt(table, rowIndex);
            this.renderFileSize(table, file, isSelected, cellHasFocus, rowIndex, colIndex);
            this.setToolTipText(FileNameCellRenderer.toolTipString(file, ((FileListTable)table).getModel().getColumnNames()));
            if (table.isEnabled()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            if (file.getMetadata() != null && file.getMetadata().hasRestState()) {
                String state = file.getMetadata().getRestState();
                if (!"deleted".equals(state)) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
        return this;
    }

    protected void renderFileSize(JTable table, ArcMoverFile file, boolean isSelected, boolean cellHasFocus, int rowIndex, int colIndex) {
        String displayValue = null;
        if (file != null && file.isFile()) {
            displayValue = PADDING + StringUtils.bytesToStringWithUnit(Math.max(0L, file.getSize())) + PADDING;
        }
        this.setHorizontalAlignment(4);
        super.getTableCellRendererComponent(table, displayValue, isSelected, cellHasFocus, rowIndex, colIndex);
    }
}

