/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.util;

import com.archivas.clienttools.arcmover.gui.HCPDataMigrator;
import com.archivas.clienttools.arcmover.gui.panels.FixedHeightPanel;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthGroup;
import com.archivas.clienttools.arcmover.gui.util.FixedWidthPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GUIHelper {
    private static final String CLASS_FULL_NAME = HCPDataMigrator.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    public static final Color ENABLED_TITLE_COLOR = new TitledBorder("").getTitleColor();
    public static final Color DISABLED_TITLE_COLOR = Color.GRAY;
    public static final Icon DELETE_ICON = new ImageIcon(HCPDataMigrator.class.getClassLoader().getResource("images/delete.gif"));
    public static final Icon REFRESH_ICON = new ImageIcon(HCPDataMigrator.class.getClassLoader().getResource("images/refresh.gif"));
    public static final Icon NEW_DIR_ICON = UIManager.getIcon("FileChooser.newFolderIcon");
    public static final Icon UP_DIR_ICON = UIManager.getIcon("FileChooser.upFolderIcon");
    public static final Icon HOME_ICON = UIManager.getIcon("FileChooser.homeFolderIcon");
    public static final Icon OPEN_DIR = UIManager.getIcon("Tree.openIcon");
    public static final Icon FILE_ICON = UIManager.getIcon("FileView.fileIcon");
    public static final Icon DIRECTORY_ICON = UIManager.getIcon("FileView.directoryIcon");

    public static void centerDialog(Component baseElement, Component elementToCenter) {
        Point p = baseElement.getLocation();
        Dimension d = baseElement.getSize();
        Dimension dialogSize = elementToCenter.getSize();
        int x = (int)(p.getX() + (d.getWidth() / 2.0 - dialogSize.getWidth() / 2.0));
        int y = (int)(p.getY() + (d.getHeight() / 2.0 - dialogSize.getHeight() / 2.0));
        elementToCenter.setLocation(x, y);
    }

    public static void centerDialog(Component baseElement, Window elementToCenter) {
        elementToCenter.setLocationRelativeTo(baseElement);
    }

    public static int autoResizeColWidthNoFill(JTable table) {
        int totalWidth = 0;
        int headerWidth = 0;
        table.setAutoResizeMode(0);
        int margin = 5;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int vColIndex = i;
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
            TableColumn col = colModel.getColumn(vColIndex);
            int width = 0;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            headerWidth = width = comp.getPreferredSize().width;
            for (int r = 0; r < table.getRowCount(); ++r) {
                renderer = table.getCellRenderer(r, vColIndex);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            width += 2 * margin;
            width = Math.max(width, headerWidth + 20);
            col.setPreferredWidth(width);
            totalWidth += width;
        }
        ((DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        table.getTableHeader().setReorderingAllowed(false);
        return totalWidth;
    }

    public static JTable autoResizeColWidth(JTable table) {
        double availableWidth;
        int totalWidth = GUIHelper.autoResizeColWidthNoFill(table);
        if ((double)totalWidth >= (availableWidth = (double)table.getParent().getWidth())) {
            return table;
        }
        double increaseBy = availableWidth / (double)totalWidth;
        int newTotalWidth = 0;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int oldWidth;
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
            TableColumn col = colModel.getColumn(i);
            int newWidth = oldWidth = col.getPreferredWidth();
            if (i < table.getColumnCount() - 1) {
                double width = newWidth;
                newWidth = (int)(width * increaseBy);
            } else {
                newWidth = (int)availableWidth - newTotalWidth;
            }
            col.setPreferredWidth(newWidth);
            newTotalWidth += newWidth;
        }
        return table;
    }

    public static JTable autoResizeColWidth(JTable table, int extraSpaceToColumn) {
        int availableWidth;
        if (extraSpaceToColumn < 0 || extraSpaceToColumn >= table.getColumnCount()) {
            throw new IllegalArgumentException("Illegal Column index.  Table " + table.getName() + " has " + table.getColumnCount() + " columns.  Can't set extra space to column " + extraSpaceToColumn);
        }
        int totalWidth = GUIHelper.autoResizeColWidthNoFill(table);
        if (totalWidth >= (availableWidth = table.getParent().getWidth())) {
            return table;
        }
        int increaseBy = availableWidth - totalWidth;
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(extraSpaceToColumn);
        int oldWidth = col.getPreferredWidth();
        col.setPreferredWidth(oldWidth + increaseBy);
        return table;
    }

    public static void enableComponent(Component c, boolean enabled) {
        c.setEnabled(enabled);
        if (c instanceof Container && !(c instanceof JComboBox)) {
            Component[] components;
            for (Component comp : components = ((Container)c).getComponents()) {
                GUIHelper.enableComponent(comp, enabled);
            }
        }
    }

    public static FixedHeightPanel createFixedHeightPanel(JComponent component, boolean addGlue) {
        FixedHeightPanel p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new FixedWidthPanel());
        p.add(component);
        if (addGlue) {
            p.add(Box.createHorizontalGlue());
        }
        return p;
    }

    public static FixedHeightPanel createNameValuePairPanel(Component name, Component value, FixedWidthGroup nameGroup, boolean addGlue) {
        FixedHeightPanel p = new FixedHeightPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new FixedWidthPanel(nameGroup, name));
        p.add(Box.createHorizontalStrut(5));
        p.add(value);
        if (addGlue) {
            p.add(Box.createHorizontalGlue());
        }
        return p;
    }

    public static FixedHeightPanel createNameValuePairPanel(String name, Component value, FixedWidthGroup nameGroup, boolean addGlue) {
        return GUIHelper.createNameValuePairPanel(new JLabel(name), value, nameGroup, addGlue);
    }

    public static boolean invokeAndWait(Runnable runner, String action) {
        boolean success = false;
        try {
            SwingUtilities.invokeAndWait(runner);
            success = true;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not " + action, e);
        }
        return success;
    }

    public static void showMessageDialog(Component parentComponent, String message, String title, int messageType) throws HeadlessException {
        JScrollPane sp = GUIHelper.getMessageScrollPane(message);
        JOptionPane.showMessageDialog(parentComponent, sp, title, messageType);
    }

    private static JScrollPane getMessageScrollPane(String message) {
        JTextArea ta = new JTextArea(message);
        ta.setBorder(new EmptyBorder(0, 0, 0, 0));
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setCaretPosition(0);
        ta.setEditable(false);
        JScrollPane sp = new JScrollPane(ta);
        sp.setBorder(new EmptyBorder(5, 5, 5, 5));
        if (message.length() < 100) {
            sp.setPreferredSize(new Dimension(400, 50));
        } else {
            sp.setPreferredSize(new Dimension(400, 100));
        }
        return sp;
    }

    public static void showMessageDialog(final long msToShowMsg, Component parentComponent, boolean completelyCoverParent, String message, String title, int messageType) {
        JScrollPane sp = GUIHelper.getMessageScrollPane(message);
        JOptionPane pane = new JOptionPane(sp, messageType);
        final JDialog dialog = pane.createDialog(parentComponent, title);
        if (completelyCoverParent) {
            dialog.setMinimumSize(parentComponent.getSize());
            dialog.setLocationRelativeTo(parentComponent);
        }
        dialog.setModal(true);
        if (msToShowMsg > 0L) {
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                public Object doInBackground() {
                    long end = System.currentTimeMillis() + msToShowMsg;
                    do {
                        try {
                            Thread.sleep(end - System.currentTimeMillis());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    } while (System.currentTimeMillis() < end);
                    return null;
                }

                @Override
                protected void done() {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            };
            worker.execute();
        }
        dialog.setVisible(true);
        dialog.dispose();
    }
}

