/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcmover.gui.util;

import com.archivas.clienttools.arcmover.gui.util.AbstractFileListCellRenderer;
import com.archivas.clienttools.arcmover.gui.util.FileListTable;
import com.archivas.clienttools.arcmover.gui.util.FileNameCellRenderer;
import com.archivas.clienttools.arcutils.model.ArcMoverFile;
import java.awt.Component;
import java.awt.Font;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;

public class StringCellRenderer
extends AbstractFileListCellRenderer {
    private static final Logger LOG = Logger.getLogger(StringCellRenderer.class.getName());
    public static final String EMPTYSTR = "";
    public static final String PADDING = " ";
    private Font fileFont;

    public StringCellRenderer(Font f) {
        this.fileFont = f;
    }

    public StringCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int rowIndex, int colIndex) {
        try {
            String displayValue = PADDING + (value == null ? EMPTYSTR : value.toString()) + PADDING;
            super.getTableCellRendererComponent(table, displayValue, isSelected, cellHasFocus, rowIndex, colIndex);
            ArcMoverFile file = this.getFileAt(table, rowIndex);
            this.setToolTipText(FileNameCellRenderer.toolTipString(file, ((FileListTable)table).getModel().getColumnNames()));
            if (table.isEnabled()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            if (file.getMetadata() != null && file.getMetadata().hasRestState()) {
                String state = file.getMetadata().getRestState();
                if (!"deleted".equals(state)) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
            if (this.fileFont != null) {
                this.setFont(this.fileFont);
            }
        }
        catch (RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected Exception", e);
            throw e;
        }
        return this;
    }
}

