/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.api;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.JobNotFoundException;
import com.archivas.clienttools.arcutils.api.ManagedJobStats;
import com.archivas.clienttools.arcutils.api.TooManyQueuedJobsException;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJobSummary;
import com.archivas.clienttools.arcutils.impl.adapter.ConnectionTestException;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapter;
import com.archivas.clienttools.arcutils.impl.adapter.StorageAdapterException;
import com.archivas.clienttools.arcutils.impl.jobs.ManagedJobImpl;
import com.archivas.clienttools.arcutils.model.ACLMetadata;
import com.archivas.clienttools.arcutils.model.ArcMoverDirectory;
import com.archivas.clienttools.arcutils.model.FileMetadata;
import com.archivas.clienttools.arcutils.model.FileType;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.io.InputStream;
import java.util.List;

public interface ArcMoverEngine {
    public List<ManagedJobSummary> getAllManagedJobs() throws DatabaseException;

    public ManagedJobImpl createManagedJob(ManagedJob var1) throws JobException;

    public void modifyManagedJob(JobId var1, ManagedJob var2) throws JobException;

    public void modifyManagedJobName(JobId var1, String var2) throws JobException;

    public void modifyManagedJobLoadSchedule(JobId var1, LoadSchedule var2) throws JobException;

    public void removeManagedJob(JobId var1, ManagedJob.Type var2) throws JobException;

    public ManagedJobImpl loadManagedJob(JobId var1, ManagedJob.Type var2) throws JobException;

    public ManagedJobImpl startManagedJob(ManagedJobImpl var1) throws JobException, TooManyQueuedJobsException;

    public void stopManagedJob(ManagedJobImpl var1) throws JobException;

    public void cancelManagedJob(ManagedJobImpl var1) throws JobException;

    public ManagedJobImpl.JobDetails getManagedJobDetails(ManagedJobImpl var1, boolean var2) throws JobNotFoundException;

    public ManagedJobStats getManagedJobStats(ManagedJobImpl var1) throws JobNotFoundException;

    public ArcMoverDirectory getDirectoryListing(StorageAdapter var1, String var2, boolean var3) throws JobException;

    public ArcMoverDirectory getDirectoryListing(AbstractProfileBase var1, String var2, boolean var3) throws JobException;

    public ArcMoverDirectory getVersionListing(AbstractProfileBase var1, String var2) throws JobException;

    public boolean isVersioningEnabled(AbstractProfileBase var1) throws StorageAdapterException;

    public boolean testConnection(AbstractProfileBase var1) throws ConnectionTestException;

    public FileMetadata getMetadata(AbstractProfileBase var1, String var2, FileType var3) throws JobException;

    public String getCustomMetadata(AbstractProfileBase var1, String var2, Long var3, FileType var4) throws JobException;

    public InputStream getCustomMetadataStream(AbstractProfileBase var1, String var2, Long var3, FileType var4, StorageAdapter var5) throws JobException;

    public InputStream getCustomMetadataStream(AbstractProfileBase var1, String var2, Long var3, FileType var4, StorageAdapter var5, String var6) throws JobException;

    public void setCustomMetadata(AbstractProfileBase var1, String var2, String var3) throws JobException;

    public void deleteCustomMetadata(AbstractProfileBase var1, String var2) throws JobException;

    public void setACL(AbstractProfileBase var1, String var2, ACLMetadata var3) throws JobException;

    public void deleteACL(AbstractProfileBase var1, String var2) throws JobException;

    public boolean mkdir(AbstractProfileBase var1, String var2) throws JobException;

    public boolean renameTo(AbstractProfileBase var1, String var2, String var3, String var4) throws JobException;
}

