/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.api;

import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.JobStatus;
import java.io.Serializable;
import java.util.Date;

public class JobStats
implements Serializable,
Cloneable {
    private JobId jobId;
    private JobStatus status = JobStatus.NOT_STARTED;
    private long estimatedTimeLeftMs = -1L;
    private Date statsGenerationTime = new Date();
    private Date startTime;
    private Date endTime;
    private long runTimeMs;
    private Throwable jobException;

    protected JobStats() {
    }

    public JobStats(JobId jobId, JobStatus status, long estimatedTimeLeftMs, Date startTime, Date endTime, long runTimeMs, Throwable jobException) {
        this.statsGenerationTime = new Date();
        this.jobId = jobId;
        this.status = status;
        this.estimatedTimeLeftMs = estimatedTimeLeftMs;
        this.startTime = startTime;
        this.endTime = endTime;
        this.runTimeMs = runTimeMs;
        this.jobException = jobException;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            JobStats clone = (JobStats)super.clone();
            clone.jobId = null;
            if (this.jobId != null) {
                clone.jobId = (JobId)this.jobId.clone();
            }
            clone.statsGenerationTime = null;
            if (this.statsGenerationTime != null) {
                clone.statsGenerationTime = (Date)this.statsGenerationTime.clone();
            }
            clone.endTime = null;
            if (this.endTime != null) {
                clone.endTime = (Date)this.endTime.clone();
            }
            clone.jobException = this.jobException;
            return clone;
        }
        catch (Exception e) {
            String msg = this.getClass().getName() + " could not be cloned.";
            CloneNotSupportedException e2 = new CloneNotSupportedException(msg);
            e2.initCause(e);
            throw e2;
        }
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public void setJobId(JobId jobId) {
        this.jobId = jobId;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public Date getStatsGenerationTime() {
        return this.statsGenerationTime;
    }

    public long getEstimatedTimeLeftMs() {
        return this.estimatedTimeLeftMs;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public long getRunTimeMs() {
        return this.runTimeMs;
    }

    public Throwable getJobException() {
        return this.jobException;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JobStats");
        sb.append("{jobId=").append(this.jobId);
        sb.append(", status=").append((Object)this.status);
        sb.append(", estimatedTimeLeftMs=").append(this.estimatedTimeLeftMs);
        sb.append(", statsGenerationTime=").append(this.statsGenerationTime);
        sb.append(", startTime=").append(this.startTime);
        sb.append(", endTime=").append(this.endTime);
        sb.append(", runTimeMs=").append(this.runTimeMs);
        if (this.jobException != null) {
            sb.append(", exception=").append(this.jobException);
        }
        sb.append('}');
        return sb.toString();
    }
}

