/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.api;

import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.JobStats;
import com.archivas.clienttools.arcutils.api.JobStatus;
import com.archivas.clienttools.arcutils.utils.StringUtils;
import java.util.Date;

public class ManagedJobStats
extends JobStats
implements Cloneable {
    private boolean findFinished = false;
    private long discoveredObjectCount;
    private long totalObjectCount;
    private long completedObjectCount = 0L;
    private long erroredObjectCount = 0L;
    private long erroredDirCount = 0L;
    private long totalBytes;
    private long completedBytes = 0L;
    private long erroredBytes = 0L;
    private long transferredBytes = 0L;
    private long averageThroughput = 0L;
    private double currentThroughputBytes = 0.0;
    private double currentThroughputCnt = 0.0;
    private Date findStartTime;
    private Date findEndTime;
    private long statsTime;

    public ManagedJobStats() {
    }

    public ManagedJobStats(JobId jobId, JobStatus status, long estimatedTimeLeftMs, Date startTime, Date endTime, long runTimeMs, Throwable jobException, boolean findFinished, long discoveredObjectCount, long totalObjectCount, long completedObjectCount, long erroredObjectCount, long erroredDirCount, long totalBytes, long completedBytes, long erroredBytes, long averageThroughput, double currentThroughputBytes, double currentThroughputCnt, Date findStartTime, Date findEndTime, long transferredBytes) {
        super(jobId, status, estimatedTimeLeftMs, startTime, endTime, runTimeMs, jobException);
        this.statsTime = System.currentTimeMillis();
        this.findFinished = findFinished;
        this.discoveredObjectCount = discoveredObjectCount;
        this.totalObjectCount = totalObjectCount;
        this.completedObjectCount = completedObjectCount;
        this.erroredObjectCount = erroredObjectCount;
        this.erroredDirCount = erroredDirCount;
        this.totalBytes = totalBytes;
        this.completedBytes = completedBytes;
        this.erroredBytes = erroredBytes;
        this.transferredBytes = transferredBytes;
        this.averageThroughput = averageThroughput;
        this.currentThroughputBytes = currentThroughputBytes;
        this.currentThroughputCnt = currentThroughputCnt;
        this.findStartTime = findStartTime;
        this.findEndTime = findEndTime;
    }

    public ManagedJobStats(Date startTime, Date endTime, long runTimeMs, long discoveredObjectCount, long totalObjectCount, long completedObjectCount, long erroredObjectCount, long erroredDirCount, long totalBytes, long completedBytes, long erroredBytes) {
        super(null, null, -1L, startTime, endTime, runTimeMs, null);
        this.discoveredObjectCount = discoveredObjectCount;
        this.totalObjectCount = totalObjectCount;
        this.completedObjectCount = completedObjectCount;
        this.erroredObjectCount = erroredObjectCount;
        this.erroredDirCount = erroredDirCount;
        this.totalBytes = totalBytes;
        this.completedBytes = completedBytes;
        this.erroredBytes = erroredBytes;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            ManagedJobStats clone = (ManagedJobStats)super.clone();
            clone.findStartTime = null;
            if (this.findStartTime != null) {
                clone.findStartTime = (Date)this.findStartTime.clone();
            }
            clone.findEndTime = null;
            if (this.findEndTime != null) {
                clone.findEndTime = (Date)this.findEndTime.clone();
            }
            return clone;
        }
        catch (Exception e) {
            String msg = this.getClass().getName() + " could not be cloned.";
            CloneNotSupportedException e2 = new CloneNotSupportedException(msg);
            e2.initCause(e);
            throw e2;
        }
    }

    public boolean isFindFinished() {
        return this.findFinished;
    }

    public long getDiscoveredObjectCount() {
        return this.discoveredObjectCount;
    }

    public long getTotalObjectCount() {
        return this.totalObjectCount;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedObjectCount() {
        return this.completedObjectCount;
    }

    public long getErroredObjectCount() {
        return this.erroredObjectCount;
    }

    public long getErroredDirCount() {
        return this.erroredDirCount;
    }

    public boolean areErrors() {
        return this.erroredObjectCount + this.erroredDirCount > 0L;
    }

    public long getTotalBytesInKB() {
        long kb = 0L;
        long size = this.getTotalBytes();
        if (size > 0L) {
            kb = Math.max(1L, size / 1024L);
        }
        return kb;
    }

    public long getCopyableBytes() {
        return this.totalBytes;
    }

    public long getCopyableBytesInKB() {
        long kb = 0L;
        long size = this.getCopyableBytes();
        if (size > 0L) {
            kb = Math.max(1L, size / 1024L);
        }
        return kb;
    }

    public long getCopyableBytesInMB() {
        long mb = 0L;
        long size = this.getTotalBytesInKB();
        if (size > 0L) {
            mb = Math.max(1L, size / 1024L);
        }
        return mb;
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public void setCompletedBytes(long completedBytes) {
        this.completedBytes = completedBytes;
    }

    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    public long getCompletedBytesInKB() {
        long kb = 0L;
        long size = this.getCompletedBytes();
        if (size > 0L) {
            kb = Math.max(1L, size / 1024L);
        }
        return kb;
    }

    public long getCompletedBytesInMB() {
        long mb = 0L;
        long size = this.getCompletedBytesInKB();
        if (size > 0L) {
            mb = Math.max(1L, size / 1024L);
        }
        return mb;
    }

    public long getErroredBytes() {
        return this.erroredBytes;
    }

    public void setErroredBytes(long erroredBytes) {
        this.erroredBytes = erroredBytes;
    }

    public long getErroredBytesInKB() {
        long kb = 0L;
        long size = this.getErroredBytes();
        if (size > 0L) {
            kb = Math.max(1L, size / 1024L);
        }
        return kb;
    }

    public long getErroredBytesInMB() {
        long mb = 0L;
        long size = this.getErroredBytes();
        if (size > 0L) {
            mb = Math.max(1L, size / (long)Math.pow(1024.0, 2.0));
        }
        return mb;
    }

    public long getAverageThroughput() {
        return this.averageThroughput;
    }

    public double getCurrentThroughputBytes() {
        return this.currentThroughputBytes;
    }

    public double getCurrentThroughputCnt() {
        return this.currentThroughputCnt;
    }

    public Date getFindStartTime() {
        return this.findStartTime;
    }

    public Date getFindEndTime() {
        return this.findEndTime;
    }

    public long getStatsTime() {
        return this.statsTime;
    }

    public long getAverageOperationRate() {
        long cnt = this.getTotalObjectCount();
        long time = this.getRunTimeMs();
        if (cnt < 1L) {
            return 0L;
        }
        if (time < 1L) {
            return 0L;
        }
        time = Math.max(1L, time / 1000L);
        return cnt / time;
    }

    public long getEstimatedPercentComplete() {
        float total = this.getTotalBytes();
        if (total < 1.0f) {
            total = 1.0f;
        }
        float finished = this.getCompletedBytes() + this.getErroredBytes();
        return Math.round(finished * 100.0f / total);
    }

    public long getEstimatedSecondsRemaining() {
        long throughput = this.getAverageThroughput();
        if (throughput < 1L) {
            throughput = 1L;
        }
        return this.getBytesRemaining() / (throughput * 1024L);
    }

    public String getEstimatedTimeRemaining() {
        return StringUtils.secondsToStringWithUnits(this.getEstimatedSecondsRemaining());
    }

    public long getObjectsRemaining() {
        return this.getTotalObjectCount() - this.getCompletedObjectCount() - this.getErroredObjectCount();
    }

    public long getBytesRemaining() {
        return this.getTotalBytes() - this.getCompletedBytes() - this.getErroredBytes();
    }

    public int getPercentObjectsCompleted() {
        long total = this.getTotalObjectCount();
        long completed = this.getCompletedObjectCount();
        int percent = 0;
        if (total > 0L && completed > 0L) {
            percent = (int)(completed * 100L / total);
        }
        return percent;
    }

    public int getPercentBytesCompleted() {
        long total = this.getTotalBytes();
        long completed = this.getCompletedBytes();
        int percent = 0;
        if (total > 0L && completed > 0L) {
            percent = (int)(completed * 100L / total);
        }
        return percent;
    }

    public String getRunTime() {
        return StringUtils.secondsToStringWithUnits((double)this.getRunTimeMs() / 1000.0);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedJobStats");
        sb.append("{findFinished=").append(this.findFinished);
        sb.append(", discoveredObjectCount=").append(this.discoveredObjectCount);
        sb.append(", totalObjectCount=").append(this.totalObjectCount);
        sb.append(", completedObjectCount=").append(this.completedObjectCount);
        sb.append(", erroredObjectCount=").append(this.erroredObjectCount);
        sb.append(", erroredDirCount=").append(this.erroredDirCount);
        sb.append(", totalBytes=").append(this.totalBytes);
        sb.append(", completedBytes=").append(this.completedBytes);
        sb.append(", erroredBytes=").append(this.erroredBytes);
        sb.append(", averageThroughput=").append(this.averageThroughput);
        sb.append(", currentThroughput=").append(this.currentThroughputBytes);
        sb.append(", findStartTime=").append(this.findStartTime);
        sb.append(", findEndTime=").append(this.findEndTime);
        sb.append(", isFindFinished=").append(this.isFindFinished());
        sb.append(", objectsRemaining=").append(this.getObjectsRemaining());
        sb.append(", bytesRemaining=").append(this.getBytesRemaining());
        sb.append('}');
        return sb.toString();
    }
}

