/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.api.jobs;

import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.api.jobs.ManagedJobWithMetadata;
import com.archivas.clienttools.arcutils.model.ArcCopyFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.io.File;
import java.util.List;

public class CopyJob
extends ManagedJobWithMetadata<ArcCopyFile> {
    private boolean ignoreConflicts;

    public CopyJob(AbstractProfileBase sourceProfile, AbstractProfileBase targetProfile, List<ArcCopyFile> initialDiscoveryList) throws DatabaseException {
        super(sourceProfile, targetProfile, initialDiscoveryList);
    }

    public CopyJob(AbstractProfileBase sourceProfile, AbstractProfileBase targetProfile, File file) {
        super(sourceProfile, targetProfile, file);
    }

    public CopyJob() {
    }

    @Override
    public void initFilesForDBCreate() {
        for (ArcProcessFile processFile : this.getInitialDiscoveryList()) {
            ArcCopyFile file = (ArcCopyFile)processFile;
            if (null != this.ingestionMetadata.getUid()) {
                file.getIngestionMetadata().setUid(this.ingestionMetadata.getUid());
            }
            if (null != this.ingestionMetadata.getGid()) {
                file.getIngestionMetadata().setGid(this.ingestionMetadata.getGid());
            }
            if (null != this.ingestionMetadata.getDirMode()) {
                file.getIngestionMetadata().setDirMode(this.ingestionMetadata.getDirMode());
            }
            if (null != this.ingestionMetadata.getFileMode()) {
                file.getIngestionMetadata().setFileMode(this.ingestionMetadata.getFileMode());
            }
            if (null != this.ingestionMetadata.getRetention()) {
                file.getIngestionMetadata().setRetention(this.ingestionMetadata.getRetention());
            }
            if (null != this.ingestionMetadata.isShred()) {
                file.getIngestionMetadata().setShred(this.ingestionMetadata.isShred());
            }
            if (null != this.ingestionMetadata.isSearchIndex()) {
                file.getIngestionMetadata().setSearchIndex(this.ingestionMetadata.isSearchIndex());
            }
            if (null != this.ingestionMetadata.isRetentionHold()) {
                file.getIngestionMetadata().setRetentionHold(this.ingestionMetadata.isRetentionHold());
            }
            if (null != this.ingestionMetadata.getOwner()) {
                file.getIngestionMetadata().setOwner(this.ingestionMetadata.getOwner());
            }
            if (null != this.ingestionMetadata.getACL()) {
                file.getIngestionMetadata().setACL(this.ingestionMetadata.getACL());
            }
            if (null == this.ingestionMetadata.getCustomMetadata()) continue;
            file.getIngestionMetadata().setCustomMetadata(this.ingestionMetadata.getCustomMetadata());
        }
    }

    @Override
    public ManagedJob.Type getJobType() {
        return ManagedJob.Type.COPY;
    }

    public boolean ignoreConflicts() {
        return this.ignoreConflicts;
    }

    public void setIgnoreConflicts(boolean val) {
        this.ignoreConflicts = val;
    }
}

