/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.api.jobs;

import com.archivas.clienttools.arcutils.api.jobs.ManagedJob;
import com.archivas.clienttools.arcutils.model.ArcDeleteFile;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.net.SSLCertificateCallback;
import java.io.File;
import java.util.List;

public class DeleteJob
extends ManagedJob {
    SSLCertificateCallback sourceSSLExceptionCallback = null;
    private Operation operation = Operation.DELETE;
    private String reason;

    public DeleteJob(AbstractProfileBase sourceProfile, List<ArcDeleteFile> initialDiscoveryList) throws DatabaseException {
        super(sourceProfile, null, initialDiscoveryList);
    }

    public DeleteJob(AbstractProfileBase sourceProfile, File file) {
        super(sourceProfile, null, file);
    }

    public DeleteJob() {
    }

    public void setOperation(Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Null operation");
        }
        this.operation = operation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public SSLCertificateCallback getSourceSSLExceptionCallback() {
        return this.sourceSSLExceptionCallback;
    }

    public void setSourceSSLExceptionCallback(SSLCertificateCallback sourceSSLExceptionCallback) {
        this.sourceSSLExceptionCallback = sourceSSLExceptionCallback;
    }

    protected void initFileForDBCreate(ArcProcessFile file) {
    }

    @Override
    public ManagedJob.Type getJobType() {
        return ManagedJob.Type.DELETE;
    }

    @Override
    public void initFilesForDBCreate() {
    }

    public static enum Operation {
        DELETE(false, "delete"),
        PURGE(false, "purge"),
        PRIVILEGED_DELETE(true, "privileged-delete"),
        PRIVILEGED_PURGE(true, "privileged-purge");

        private boolean isPrivilegedOperation;
        private String stringValue;

        private Operation(boolean isPrivilegedOperation, String stringValue) {
            this.isPrivilegedOperation = isPrivilegedOperation;
            this.stringValue = stringValue;
        }

        public boolean isPrivilegedOperation() {
            return this.isPrivilegedOperation;
        }

        public String getStringRepresentation() {
            return this.stringValue;
        }

        public static Operation getFromString(String str) {
            Operation result = null;
            if (DELETE.getStringRepresentation().equals(str)) {
                result = DELETE;
            } else if (PURGE.getStringRepresentation().equals(str)) {
                result = PURGE;
            } else if (PRIVILEGED_DELETE.getStringRepresentation().equals(str)) {
                result = PRIVILEGED_DELETE;
            } else if (PRIVILEGED_PURGE.getStringRepresentation().equals(str)) {
                result = PRIVILEGED_PURGE;
            } else {
                String errorMsg = String.format("String provided does not match a supported operation.  Supported operations are: %s, %s, %s, %s.", DELETE.getStringRepresentation(), PURGE.getStringRepresentation(), PRIVILEGED_DELETE.getStringRepresentation(), PRIVILEGED_PURGE.getStringRepresentation());
                throw new IllegalArgumentException(errorMsg);
            }
            return result;
        }
    }
}

