/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.api.jobs;

import com.archivas.clienttools.arcutils.api.jobs.JobSpec;
import com.archivas.clienttools.arcutils.model.ArcProcessFile;
import com.archivas.clienttools.arcutils.model.LoadSchedule;
import com.archivas.clienttools.arcutils.profile.AbstractProfileBase;
import com.archivas.clienttools.arcutils.utils.FileUtil;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class ManagedJob
extends JobSpec {
    protected static final Logger LOG = Logger.getLogger(ManagedJob.class.getName());
    private String userDefinedJobName;
    private String internalJobName;
    private AbstractProfileBase sourceProfile;
    private AbstractProfileBase targetProfile;
    private String sourcePath = "";
    private String targetPath = "";
    private List<ArcProcessFile> initialDiscoveryList = new ArrayList<ArcProcessFile>();
    protected final Object initialDataLock = new Object();
    private String jobDefinitionFile;
    private LoadSchedule loadSchedule = null;
    public static int MAXIMUM_JOB_NAME_LENGTH = 128;

    protected ManagedJob(AbstractProfileBase sourceProfile, AbstractProfileBase targetProfile, List<? extends ArcProcessFile> initialDiscoveryList) throws DatabaseException {
        this.sourceProfile = sourceProfile;
        this.targetProfile = targetProfile;
        this.initialDiscoveryList.addAll(initialDiscoveryList);
        this.loadSchedule = LoadSchedule.getDefaultLoadSchedule();
    }

    protected ManagedJob(AbstractProfileBase sourceProfile, AbstractProfileBase targetProfile, File file) {
        this.sourceProfile = sourceProfile;
        this.targetProfile = targetProfile;
        this.jobDefinitionFile = file.getAbsolutePath();
        this.loadSchedule = LoadSchedule.getDefaultLoadSchedule();
    }

    protected ManagedJob() {
    }

    public List<ArcProcessFile> getInitialDiscoveryList() {
        return this.initialDiscoveryList;
    }

    public void setInitialDiscoveryList(List<ArcProcessFile> initialDiscoveryList) {
        this.initialDiscoveryList = initialDiscoveryList;
    }

    public String getFileName() {
        return this.jobDefinitionFile;
    }

    public void getFileName(String name) {
        this.jobDefinitionFile = name;
    }

    public String getUserDefinedJobName() {
        return this.userDefinedJobName;
    }

    public void setUserDefinedJobName(String jobName) {
        if (jobName != null && jobName.length() > MAXIMUM_JOB_NAME_LENGTH) {
            throw new IllegalArgumentException(String.format("Job name must not exceed %d characters.", MAXIMUM_JOB_NAME_LENGTH));
        }
        this.userDefinedJobName = jobName;
    }

    public void setInternalJobName(String jobName) {
        this.internalJobName = jobName;
    }

    public String getJobName() {
        String name = this.internalJobName;
        if (this.userDefinedJobName != null) {
            name = this.userDefinedJobName;
        }
        return name;
    }

    public File getListFile() {
        return this.jobDefinitionFile == null ? null : new File(this.jobDefinitionFile);
    }

    public void setListFile(File file) {
        this.jobDefinitionFile = file.getAbsolutePath();
    }

    public AbstractProfileBase getSourceProfile() {
        return this.sourceProfile;
    }

    public void setSourceProfile(AbstractProfileBase profile) {
        this.sourceProfile = profile;
    }

    public AbstractProfileBase getTargetProfile() {
        return this.targetProfile;
    }

    public void setTargetProfile(AbstractProfileBase profile) {
        this.targetProfile = profile;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        String path;
        this.sourcePath = path = FileUtil.converWindowsPathToUnix(sourcePath, this.sourceProfile.getPathSeparator());
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        String path;
        this.targetPath = path = FileUtil.converWindowsPathToUnix(targetPath, this.targetProfile.getPathSeparator());
    }

    public LoadSchedule getLoadSchedule() {
        return this.loadSchedule;
    }

    public void setLoadSchedule(LoadSchedule loadSchedule) throws IllegalArgumentException {
        loadSchedule.validate();
        this.loadSchedule = loadSchedule;
        LOG.warning("Load Schedule changed");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("type=").append(this.getJobType().getUiName());
        sb.append(", name=\"").append(this.getJobName()).append("\"");
        sb.append(", sourceProfile=\"").append(this.sourceProfile).append('\"');
        sb.append(", sourcePath=\"").append(this.sourcePath).append('\"');
        if (this.getJobType().hasTarget()) {
            sb.append(", destinationProfile=\"").append(this.targetProfile).append('\"');
            sb.append(", destinationPath=\"").append(this.targetPath).append('\"');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String toDetailString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{sourcePath='").append(this.sourcePath).append('\'');
        sb.append(", destinationPath='").append(this.targetPath).append('\'');
        sb.append(", loadSchedule=").append(this.loadSchedule);
        sb.append('}');
        return sb.toString();
    }

    public abstract void initFilesForDBCreate();

    public abstract Type getJobType();

    public static enum Type {
        COPY("Copy", true),
        DELETE("Delete", false),
        SET_METADATA("Metadata", false);

        private String uiName;
        private boolean hasTarget;

        private Type(String uiName, boolean hasTarget) {
            this.uiName = uiName;
            this.hasTarget = hasTarget;
        }

        public String getUiName() {
            return this.uiName;
        }

        public boolean hasTarget() {
            return this.hasTarget;
        }
    }
}

