/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.config;

import com.archivas.clienttools.arcutils.config.ConfigurationException;
import com.archivas.clienttools.arcutils.utils.database.DBUtils;
import com.archivas.clienttools.arcutils.utils.database.DatabaseException;
import com.archivas.clienttools.arcutils.utils.database.DatabaseResourceManager;
import com.archivas.clienttools.arcutils.utils.database.NonFatalDatabaseException;
import com.archivas.clienttools.arcutils.utils.net.UrlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileSystemView;

public class ConfigurationHelper {
    public static final String PACKAGE_NAME = ConfigurationHelper.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = ConfigurationHelper.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    public static final String HCPDM_HOME_DIRECTORY;
    public static final String USER_CONFIG_DIRECTORY;
    public static final String DEFAULT_PROPS_FILE = "hcpdm.properties";
    public static final String SYSTEM_PROPS_FILE;
    public static final String USER_PROPS_FILE;
    public static final String SINGLE_INSTANCE_LOCK_FILE;
    public static final String MAX_RETRIES = "managedJob.maxRetries";
    public static final String THREAD_REFRESH_INTERVAL = "managedJob.threadRefreshIntervalMS";
    private static final Object propsLock;
    private Properties defaultProperties;
    private Properties systemProperties;
    private Properties userProperties;
    private static ConfigurationHelper configurationHelper;

    protected ConfigurationHelper() {
        this.loadProperties();
    }

    public static ConfigurationHelper getInstance() {
        return configurationHelper;
    }

    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    public Properties getEffectiveProperties() {
        Properties props = new Properties();
        if (this.getDefaultProperties() != null) {
            props.putAll((Map<?, ?>)this.getDefaultProperties());
        }
        if (this.getSystemProperties() != null) {
            props.putAll((Map<?, ?>)this.getSystemProperties());
        }
        if (this.getUserProperties() != null) {
            props.putAll((Map<?, ?>)this.getUserProperties());
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadDefaultProperties() {
        Object object = propsLock;
        synchronized (object) {
            this.defaultProperties = new Properties();
            ClassLoader cl = ConfigurationHelper.class.getClassLoader();
            try {
                InputStream inputStream = cl.getResourceAsStream(DEFAULT_PROPS_FILE);
                this.defaultProperties.load(inputStream);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Could not load default properties from classloader: hcpdm.properties", e);
                this.defaultProperties = null;
            }
            return this.defaultProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadSystemProperties() {
        Object object = propsLock;
        synchronized (object) {
            this.systemProperties = new Properties();
            String applicationHomeDir = null;
            String propsFilePath = null;
            try {
                applicationHomeDir = System.getProperty("application_home_dir");
                propsFilePath = applicationHomeDir + System.getProperty("file.separator") + SYSTEM_PROPS_FILE;
                FileInputStream inputStream = new FileInputStream(propsFilePath);
                this.systemProperties.load(inputStream);
            }
            catch (FileNotFoundException e) {
                LOG.log(Level.INFO, "System properties file not found at : " + propsFilePath);
                this.systemProperties = null;
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Could not load system properties from filesystem: " + propsFilePath, e);
                this.systemProperties = null;
            }
            return this.systemProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemProperties(Properties systemProps) {
        Object object = propsLock;
        synchronized (object) {
            this.systemProperties = systemProps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadUserProperties() {
        Object object = propsLock;
        synchronized (object) {
            this.userProperties = new Properties();
            String userPropsFileName = null;
            try {
                userPropsFileName = ConfigurationHelper.getUserPropsFileName();
                FileInputStream inputStream = new FileInputStream(userPropsFileName);
                this.userProperties.load(inputStream);
                LOG.log(Level.INFO, "Using user properties file: " + userPropsFileName);
            }
            catch (FileNotFoundException e) {
                LOG.log(Level.INFO, "User properties not found at : " + userPropsFileName);
                this.userProperties = null;
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Could not load user properties from filesystem: " + userPropsFileName, e);
                this.userProperties = null;
            }
            return this.userProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUserProperties() {
        Object object = propsLock;
        synchronized (object) {
            this.userProperties = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() {
        Object object = propsLock;
        synchronized (object) {
            this.defaultProperties = this.loadDefaultProperties();
            this.systemProperties = this.loadSystemProperties();
            this.userProperties = this.loadUserProperties();
        }
        LOG.log(Level.CONFIG, this.toDetailString());
    }

    public String toDetailString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Property List: User Properties").append(System.getProperty("line.separator"));
        if (this.getUserProperties() == null || this.getUserProperties().size() < 1) {
            sb.append("    NONE").append(System.getProperty("line.separator"));
        } else {
            for (Map.Entry<Object, Object> entry : this.getUserProperties().entrySet()) {
                sb.append("    ").append(entry.getKey());
                sb.append("=").append(entry.getValue());
                sb.append(System.getProperty("line.separator"));
            }
        }
        sb.append("Property List: System Properties").append(System.getProperty("line.separator"));
        if (this.getSystemProperties() == null || this.getSystemProperties().size() < 1) {
            sb.append("    NONE").append(System.getProperty("line.separator"));
        } else {
            for (Map.Entry<Object, Object> entry : this.getSystemProperties().entrySet()) {
                sb.append("    ").append(entry.getKey());
                sb.append("=").append(entry.getValue());
                sb.append(System.getProperty("line.separator"));
            }
        }
        sb.append("Property List: Default Properties").append(System.getProperty("line.separator"));
        if (this.getDefaultProperties() == null || this.getDefaultProperties().size() < 1) {
            sb.append("    NONE").append(System.getProperty("line.separator"));
        } else {
            for (Map.Entry<Object, Object> entry : this.getDefaultProperties().entrySet()) {
                sb.append("    ").append(entry.getKey());
                sb.append("=").append(entry.getValue());
                sb.append(System.getProperty("line.separator"));
            }
        }
        sb.append("Property List: Effective Properties").append(System.getProperty("line.separator"));
        if (this.getEffectiveProperties() == null || this.getEffectiveProperties().size() < 1) {
            sb.append("    NONE").append(System.getProperty("line.separator"));
        } else {
            for (Map.Entry<Object, Object> entry : this.getEffectiveProperties().entrySet()) {
                sb.append("    ").append(entry.getKey());
                sb.append("=").append(entry.getValue());
                sb.append(System.getProperty("line.separator"));
            }
        }
        return sb.toString();
    }

    public static Object getProperty(String key, Object defaultVal) {
        Object retval = ConfigurationHelper.getUnexpandedProperty(key, defaultVal);
        try {
            if (retval instanceof String) {
                String stringVal = (String)retval;
                if (stringVal.indexOf("\\$ARCMOVER\\.USERDIR") >= 0) {
                    stringVal = stringVal.replaceAll("\\$ARCMOVER\\.USERDIR", System.getProperty("user.dir"));
                }
                if (stringVal.indexOf("\\$ARCMOVER\\.USERHOME") >= 0) {
                    stringVal = stringVal.replaceAll("\\$ARCMOVER\\.USERHOME", System.getProperty("user.home"));
                }
                if (stringVal.indexOf("\\$ARCMOVER\\.DEFAULTUSERDIR") >= 0) {
                    stringVal = stringVal.replaceAll("\\$ARCMOVER\\.DEFAULTUSERDIR", FileSystemView.getFileSystemView().getDefaultDirectory().toURI().toString());
                }
                retval = stringVal;
            }
        }
        catch (Exception e) {
            String msg = "Exception expanding configuration variables for key=" + key + ".  Using unexpanded value=" + retval;
            LOG.log(Level.WARNING, msg, e);
        }
        return retval;
    }

    public static Object getUnexpandedProperty(String key, Object defaultVal) {
        String propertyValue;
        Properties props = ConfigurationHelper.getInstance().getUserProperties();
        if (props != null && (propertyValue = props.getProperty(key)) != null) {
            return propertyValue;
        }
        props = ConfigurationHelper.getInstance().getSystemProperties();
        if (props != null && (propertyValue = ConfigurationHelper.getInstance().getSystemProperties().getProperty(key)) != null) {
            return propertyValue;
        }
        props = ConfigurationHelper.getInstance().getDefaultProperties();
        if (props != null && (propertyValue = ConfigurationHelper.getInstance().getDefaultProperties().getProperty(key)) != null) {
            return propertyValue;
        }
        return defaultVal;
    }

    public static Object getProperty(String key) {
        return ConfigurationHelper.getProperty(key, null);
    }

    public static Properties getPropertiesWithPrefix(String prefix) {
        Properties props = new Properties();
        Properties effectiveProps = ConfigurationHelper.getInstance().getEffectiveProperties();
        for (Map.Entry<Object, Object> entry : effectiveProps.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            props.put(key, entry.getValue());
        }
        return props;
    }

    public static List<String> getPropertyNamesWithPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        Properties p = ConfigurationHelper.getInstance().getEffectiveProperties();
        for (String string : p.keySet()) {
            if (!string.startsWith(prefix)) continue;
            list.add(string);
        }
        return list;
    }

    public static String getStringProperty(String key, String defaultVal) {
        String retval = null;
        Object propertyValue = ConfigurationHelper.getProperty(key);
        if (propertyValue == null) {
            retval = defaultVal;
        } else {
            try {
                retval = (String)propertyValue;
            }
            catch (ClassCastException e) {
                String msg = "Read configuration property {0} = {1}, but it was the wrong type. Expected {2} but got {3}.";
                Object[] objs = new Object[]{key, propertyValue, retval.getClass().getName(), String.class.getName()};
                LOG.log(Level.WARNING, MessageFormat.format(msg, objs), e);
                throw e;
            }
        }
        return retval;
    }

    public static int getIntegerProperty(String key, int defaultVal) {
        Integer retval;
        String propertyValue = ConfigurationHelper.getStringProperty(key, null);
        if (propertyValue == null || propertyValue.trim().length() < 1) {
            retval = defaultVal;
        } else {
            try {
                retval = Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException e) {
                String msg = "Read configuration property {0} = {1}, but could not convert it to type {2}.";
                Object[] objs = new Object[]{key, propertyValue, Integer.class.getName()};
                LOG.log(Level.WARNING, MessageFormat.format(msg, objs), e);
                throw e;
            }
        }
        return retval;
    }

    public static long getLongProperty(String key, long defaultVal) {
        Long retval;
        String propertyValue = ConfigurationHelper.getStringProperty(key, null);
        if (propertyValue == null || propertyValue.trim().length() < 1) {
            retval = defaultVal;
        } else {
            try {
                retval = Long.parseLong(propertyValue);
            }
            catch (NumberFormatException e) {
                String msg = "Read configuration property {0} = {1}, but could not convert it to type {2}.";
                Object[] objs = new Object[]{key, propertyValue, Long.class.getName()};
                LOG.log(Level.WARNING, MessageFormat.format(msg, objs), e);
                throw e;
            }
        }
        return retval;
    }

    public static boolean getBooleanProperty(String key, boolean defaultVal) {
        String propertyValue = ConfigurationHelper.getStringProperty(key, null);
        Boolean retval = propertyValue == null ? Boolean.valueOf(defaultVal) : Boolean.valueOf(propertyValue);
        return retval;
    }

    public static URL getUrlProperty(String key, URL defaultVal) throws MalformedURLException {
        URL retval;
        String propertyValue = ConfigurationHelper.getStringProperty(key, null);
        if (propertyValue == null || propertyValue.trim().length() < 1) {
            retval = defaultVal;
        } else {
            try {
                retval = UrlUtils.makeURL("", propertyValue);
            }
            catch (MalformedURLException e) {
                String msg = "Read configuration property {0} = {1}, but could not convert it to type {2}.";
                Object[] objs = new Object[]{key, propertyValue, URL.class.getName()};
                LOG.log(Level.WARNING, MessageFormat.format(msg, objs), e);
                throw e;
            }
        }
        return retval;
    }

    public static Class getClassProperty(String key, Class defaultVal) {
        Class<?> retval;
        String propertyValue = ConfigurationHelper.getStringProperty(key, null);
        if (propertyValue == null || propertyValue.trim().length() < 1) {
            retval = defaultVal;
        } else {
            try {
                retval = Class.forName(propertyValue);
            }
            catch (Exception e) {
                retval = defaultVal;
            }
        }
        return retval;
    }

    public static Object getInstanceOfClassProperty(String key, Object defaultVal) {
        Object retval;
        Class propertyValue = ConfigurationHelper.getClassProperty(key, null);
        if (propertyValue == null) {
            retval = defaultVal;
        } else {
            try {
                retval = propertyValue.newInstance();
            }
            catch (Exception e) {
                retval = defaultVal;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserProperty(String key, String value) throws ConfigurationException {
        Object object = propsLock;
        synchronized (object) {
            Properties userProperties = ConfigurationHelper.getInstance().getUserProperties();
            if (userProperties == null) {
                ConfigurationHelper.getInstance().userProperties = userProperties = new Properties();
            }
            userProperties.setProperty(key, value);
            File userPropsFile = ConfigurationHelper.getUserPropertiesFile();
            try {
                FileOutputStream outputStream = new FileOutputStream(userPropsFile);
                userProperties.store(outputStream, "");
                LOG.log(Level.INFO, "User properties written to: " + userPropsFile);
            }
            catch (IOException e) {
                String msg = "Could not write user properties to: " + userPropsFile;
                throw new ConfigurationException(msg, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserProperties(Map<String, String> properties) throws ConfigurationException {
        Object object = propsLock;
        synchronized (object) {
            Properties userProperties = ConfigurationHelper.getInstance().getUserProperties();
            if (userProperties == null) {
                ConfigurationHelper.getInstance().userProperties = userProperties = new Properties();
            }
            userProperties.putAll(properties);
            ConfigurationHelper.writeUserProperties(userProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserProperties(Properties properties) throws ConfigurationException {
        Object object = propsLock;
        synchronized (object) {
            Properties userProperties = ConfigurationHelper.getInstance().getUserProperties();
            if (userProperties == null) {
                ConfigurationHelper.getInstance().userProperties = userProperties = new Properties();
            }
            userProperties.putAll((Map<?, ?>)properties);
            ConfigurationHelper.writeUserProperties(userProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUserProperties(Set<String> propNames) throws ConfigurationException {
        Object object = propsLock;
        synchronized (object) {
            Properties userProperties = ConfigurationHelper.getInstance().getUserProperties();
            if (userProperties == null) {
                ConfigurationHelper.getInstance().userProperties = userProperties = new Properties();
            }
            for (String propName : propNames) {
                userProperties.remove(propName);
            }
            ConfigurationHelper.writeUserProperties(userProperties);
        }
    }

    private static void writeUserProperties(Properties userProperties) throws ConfigurationException {
        FileOutputStream outputStream = null;
        File userPropsFile = ConfigurationHelper.getUserPropertiesFile();
        try {
            outputStream = new FileOutputStream(userPropsFile);
            userProperties.store(outputStream, "");
            LOG.log(Level.INFO, "User properties written to: " + userPropsFile);
        }
        catch (IOException e) {
            String msg = "Could not write user properties to: " + userPropsFile;
            throw new ConfigurationException(msg, e);
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void setSystemProperty(String key, String value) {
        throw new UnsupportedOperationException("Setting System properties is not supported.");
    }

    public static void setDefaultProperty(String key, String value) {
        throw new UnsupportedOperationException("Setting System properties is not supported.");
    }

    protected static File getUserPropertiesFile() throws ConfigurationException {
        String userPropsFileName = ConfigurationHelper.getUserPropsFileName();
        File userPropsFile = new File(userPropsFileName);
        File userPropsDir = userPropsFile.getParentFile();
        if (!userPropsDir.exists() && !userPropsDir.mkdirs()) {
            String msg = "Cannot create directory for User Properties: " + userPropsDir;
            throw new ConfigurationException(msg);
        }
        if (userPropsDir.exists() && !userPropsDir.isDirectory()) {
            String msg = "Cannot create User Properties file: " + userPropsFileName + "   Path is not a directory: " + userPropsDir;
            throw new ConfigurationException(msg);
        }
        if (userPropsFile.exists() && !userPropsFile.canWrite()) {
            String msg = "Cannot write to User Properties file: " + userPropsFileName + ". Check the permissions.";
            throw new ConfigurationException(msg);
        }
        return userPropsFile;
    }

    public static void validateLaunchOK() {
        try {
            ConfigurationHelper.validateLaunchOK(true);
        }
        catch (Exception e) {
            String msg = DBUtils.getErrorMessage("A fatal error occurred", e);
            LOG.log(Level.SEVERE, msg, e);
            System.err.println(msg);
            System.exit(-1);
        }
    }

    public static void validateLaunchOK(boolean upgrade) throws Exception {
        ConfigurationHelper.setupLogging();
        ConfigurationHelper.testUTF8Support();
        ConfigurationHelper.validateSingleDMInstance();
        if (upgrade) {
            ConfigurationHelper.doUpgrade();
        }
    }

    private static void setupLogging() {
        try {
            Logger apacheLogger = Logger.getLogger("org.apache");
            if (apacheLogger.getLevel() == null || apacheLogger.getLevel().intValue() < Level.WARNING.intValue()) {
                apacheLogger.setLevel(Level.WARNING);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error setting logger level on apache logger!", e);
        }
    }

    private static void testUTF8Support() {
        try {
            if (!Charset.isSupported("UTF-8")) {
                LOG.log(Level.WARNING, "UTF-8 Encoder not available.  Please consult the Java internationalization documentation.");
            }
        }
        catch (IllegalCharsetNameException e) {
            LOG.log(Level.WARNING, "UTF-8 Encoder not available.  Please consult the Java internationalization documentation.", e);
        }
    }

    private static void validateSingleDMInstance() {
        final File file = new File(ConfigurationHelper.getSingleInstanceLockFileName());
        try {
            final RandomAccessFile lockFile = new RandomAccessFile(file, "rw");
            final FileLock fileLock = lockFile.getChannel().tryLock();
            if (fileLock != null) {
                String msg = ManagementFactory.getRuntimeMXBean().getName();
                lockFile.writeChars(msg);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            fileLock.release();
                            lockFile.close();
                            file.delete();
                        }
                        catch (Exception e) {
                            LOG.log(Level.SEVERE, "Unable to remove lock file: " + file.getAbsolutePath(), e);
                        }
                    }
                });
                return;
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unable to create and/or lock file: " + file.getAbsolutePath(), e);
        }
        throw new IllegalStateException(String.format("An instance of %s is already running.", "HCP Data Migrator"));
    }

    private static void doUpgrade() throws DatabaseException {
        int compare = DatabaseResourceManager.compareCurrentVersionToDbVersion();
        if (compare != 0) {
            if (compare < 0) {
                throw new IllegalStateException(String.format("The %1$s database has already been upgraded to a more recent version than is supported by this version of %1$s.  Please use a more recent version of %1$s.", "HCP Data Migrator"));
            }
            System.out.print("Upgrading database ... ");
            System.out.flush();
            try {
                DatabaseResourceManager.upgradeDatabase();
            }
            catch (NonFatalDatabaseException e) {
                String msg = DBUtils.getErrorMessage("A partial error occurred upgrading the database", e);
                msg = msg + "\n\nOne or more saved jobs may not be usable.";
                LOG.log(Level.WARNING, msg, e);
                System.err.println(msg);
            }
            System.out.println("done upgrading database");
        }
    }

    private static String getUserPropsFileName() {
        String homedir = System.getProperty("user.home");
        String result = MessageFormat.format(USER_PROPS_FILE, homedir);
        String dirName = MessageFormat.format(HCPDM_HOME_DIRECTORY, homedir);
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return result;
    }

    private static String getSingleInstanceLockFileName() {
        String homedir = System.getProperty("user.home");
        String result = MessageFormat.format(SINGLE_INSTANCE_LOCK_FILE, homedir);
        String dirName = MessageFormat.format(HCPDM_HOME_DIRECTORY, homedir);
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return result;
    }

    static {
        USER_CONFIG_DIRECTORY = HCPDM_HOME_DIRECTORY = MessageFormat.format("{0}{1}.hds{1}hcp-dm{1}", "{0}", File.separator);
        SYSTEM_PROPS_FILE = MessageFormat.format("config{0}hcpdm.properties", File.separator);
        USER_PROPS_FILE = USER_CONFIG_DIRECTORY + "hcpdm-user.properties";
        SINGLE_INSTANCE_LOCK_FILE = USER_CONFIG_DIRECTORY + "hcpdm.lock";
        propsLock = new Object();
        configurationHelper = new ConfigurationHelper();
    }
}

