/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.config;

import com.archivas.clienttools.arcutils.config.ConfigurationException;
import com.archivas.clienttools.arcutils.config.ConfigurationHelper;
import com.archivas.clienttools.arcutils.config.HCPMoverConstants;
import com.archivas.clienttools.arcutils.model.Retention;
import com.archivas.clienttools.arcutils.utils.database.LifeCycleBasedCachedTableIterator;
import com.archivas.clienttools.arcutils.utils.net.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HCPMoverProperties {
    private static final Logger LOG = Logger.getLogger(HCPMoverProperties.class.getName());
    public static final HCPMoverProperty ROOT_DB_DIR = new HCPMoverProperty("rootDBDir", System.getProperty("user.home"));
    public static final HCPMoverProperty PERMISSIONS_DIR_MODE = new HCPMoverProperty("archiveSetting.permissions.dirMode", "");
    public static final HCPMoverProperty PERMISSIONS_FILE_MODE = new HCPMoverProperty("archiveSetting.permissions.fileMode", "");
    public static final HCPMoverProperty PERMISSIONS_UID = new HCPMoverProperty("archiveSetting.permissions.uid", "");
    public static final HCPMoverProperty PERMISSIONS_GID = new HCPMoverProperty("archiveSetting.permissions.gid", "");
    public static final HCPMoverProperty RETENTION_TYPE = new HCPMoverProperty("archiveSetting.retentionType", Retention.Type.DEFAULT.uiName());
    public static final HCPMoverProperty RETENTION_USER_INPUT = new HCPMoverProperty("archiveSetting.retentionUserInput", "");
    public static final HCPMoverProperty RETENTION_HCAP_VALUE = new HCPMoverProperty("archiveSetting.retentionHCAPValue", "");
    public static final HCPMoverProperty RETENTION_HOLD_MODE = new HCPMoverProperty("archiveSetting.retentionHoldMode", HCPMoverConstants.TriState.DEFAULT.toString());
    public static final HCPMoverProperty SHRED_MODE = new HCPMoverProperty("archiveSetting.shredMode", HCPMoverConstants.TriState.DEFAULT.toString());
    public static final HCPMoverProperty INDEX_MODE = new HCPMoverProperty("archiveSetting.indexMode", HCPMoverConstants.TriState.DEFAULT.toString());
    public static final HCPMoverProperty OWNER = new HCPMoverProperty("archiveSetting.owner", "");
    public static final HCPMoverProperty MAXTHREADS_FILESYSTEM = new HCPMoverProperty("normalLoad.maxThreadsFilesystem", "512");
    public static final HCPMoverProperty MAX_LOAD_MAXTHREADS = new HCPMoverProperty("load.maxAllowedThreads", "1000");
    public static final HCPMoverProperty MAX_LOAD_MAXTHREADS_PER_NODE = new HCPMoverProperty("load.maxAllowedThreadsPerNode", "100");
    public static final HCPMoverProperty NORMAL_LOAD_MAXTHREADS = new HCPMoverProperty("normalLoad.maxThreads", "");
    public static final HCPMoverProperty NORMAL_LOAD_MAXTHREADS_PER_NODE = new HCPMoverProperty("normalLoad.maxThreadsPerNode", "");
    public static final HCPMoverProperty LOW_LOAD_MAXTHREADS = new HCPMoverProperty("lowLoad.maxThreads", "");
    public static final HCPMoverProperty LOW_LOAD_MAXTHREADS_PER_NODE = new HCPMoverProperty("lowLoad.maxThreadsPerNode", "");
    public static final HCPMoverProperty LOW_LOAD_ENABLED = new HCPMoverProperty("lowLoad.enabled", "");
    public static final HCPMoverProperty LOW_LOAD_START_TIME = new HCPMoverProperty("lowLoad.startTime", "");
    public static final HCPMoverProperty LOW_LOAD_END_TIME = new HCPMoverProperty("lowLoad.endTime", "");
    public static final HCPMoverProperty DIR_LIST_METADATA_THRESHOLD_26 = new HCPMoverProperty("directoryList.loadMetadataWithList.threshold.26", "");
    public static final HCPMoverProperty DIR_LIST_METADATA_THRESHOLD_30_DEFAULTNS = new HCPMoverProperty("directoryList.loadMetadataWithList.threshold.30DefaultNamespace", "");
    public static final HCPMoverProperty CHECKPOINT_FREQUENCY_MILLIS = new HCPMoverProperty("checkpoint.frequency_millis", "");
    public static final HCPMoverProperty CHECKPOINT_FREQUENCY_FILES = new HCPMoverProperty("checkpoint.file_count", "");
    public static final HCPMoverProperty ENABLE_MONITOR_THREAD = new HCPMoverProperty("memory.monitor.thread.debug.enabled", "");
    public static final HCPMoverProperty FIND_FILES_THREADS = new HCPMoverProperty("findFiles.maxThreads", "");
    public static final HCPMoverProperty FIND_FILES_BATCH_SIZE = new HCPMoverProperty("findFiles.batch.size", "5000");
    public static final HCPMoverProperty PROCESS_FILES_BATCH_SIZE = new HCPMoverProperty("processFiles.batch.size", "5000");
    public static final HCPMoverProperty POSTPROCESS_FILES_BATCH_SIZE = new HCPMoverProperty("postProcessFiles.batch.size", "5000");
    public static final HCPMoverProperty PREPROCESS_FILES_BATCH_SIZE = new HCPMoverProperty("preProcessFiles.batch.size", "5000");
    public static final HCPMoverProperty CM_LOAD_LAST_DIRECTORY = new HCPMoverProperty("customMetadata.load.path", "");
    public static final HCPMoverProperty ACL_LOAD_LAST_DIRECTORY = new HCPMoverProperty("acl.load.path", "");
    public static final HCPMoverProperty CM_MAX_IN_MEMORY_SIZE = new HCPMoverProperty("customMetadata.max_in_memory_size", "1048576");
    public static final HCPMoverProperty IMPORT_JOB_LAST_DIRECTORY = new HCPMoverProperty("import_job.path", "");
    public static final HCPMoverProperty UI_FIRST_BATCH_SIZE = new HCPMoverProperty("ui.first.batch.size", "");
    public static final HCPMoverProperty LOGGING_SUCCESS_MODE = new HCPMoverProperty("logging.success.mode", HCPMoverConstants.TriState.DEFAULT.toString());
    public static final HCPMoverProperty LOGGING_SUCCESS_PERIOD = new HCPMoverProperty("logging.success.period", Integer.toString(60));
    public static final HCPMoverProperty LOGGING_FAILURE_MODE = new HCPMoverProperty("logging.failure.mode", HCPMoverConstants.TriState.DEFAULT.toString());
    public static final HCPMoverProperty LOGGING_FAILURE_PERIOD = new HCPMoverProperty("logging.failure.period", Integer.toString(60));
    public static final HCPMoverProperty CLI_WIDTH = new HCPMoverProperty("cli.help.message.width", Integer.toString(120));
    public static final HCPMoverProperty CLI_OVERRIDE_MD = new HCPMoverProperty("cli.override_metadata", "false");
    public static final HCPMoverProperty TRANSFER_DIR_METADATA = new HCPMoverProperty("metadata.transfer_dir_metadata", "true");
    public static final HCPMoverProperty CONNECTION_TIMEOUT_MILLIS = new HCPMoverProperty("http.connection_timeout.millis", "30000");
    public static final HCPMoverProperty SOCKET_TIMEOUT_MILLIS = new HCPMoverProperty("http.socket_timeout.millis", "120000");
    public static final HCPMoverProperty CONNECTION_TEST_TIMEOUT_OVERRIDE_MS = new HCPMoverProperty("http.connection_timeout.test.millis", "10000");
    public static final HCPMoverProperty DERBY_LOG_STATEMENTS = new HCPMoverProperty("derby.language.logStatementText", "false");
    public static final HCPMoverProperty DERBY_LOG_QUERY_PLAN = new HCPMoverProperty("derby.language.logQueryPlan", "false");
    public static final HCPMoverProperty DB_LIFE_CYCLE_UPDATE_METHOD = new HCPMoverProperty("db.life_cycle.update_method", LifeCycleBasedCachedTableIterator.UpdateMethod.INDEX_COLS.toString());
    public static final HCPMoverProperty DB_LIFE_CYCLE_REVERSE_ORDER_DO_SORT = new HCPMoverProperty("db.life_cycle.reverse_order.sort", "false");
    public static final HCPMoverProperty DB_LIFE_CYCLE_USE_SIMPLE_INDEX = new HCPMoverProperty("db.life_cycle.use_simple_index", "false");
    public static final HCPMoverProperty DB_CONNECTION_TRACKING = new HCPMoverProperty("db.connection_tracking", "false");
    public static HCPMoverProperty LAST_COPY_JOB_RUN = new HCPMoverProperty("job.copy.last_job", "");
    public static HCPMoverProperty LAST_DELETE_JOB_RUN = new HCPMoverProperty("job.delete.last_job", "");
    public static HCPMoverProperty LAST_METADATA_JOB_RUN = new HCPMoverProperty("job.metadata.last_job", "");
    public static final HCPMoverProperty HTTP_RETRY_FAILURE_WAIT = new HCPMoverProperty("http.retry.wait_time_ms", "30000");
    public static final HCPMoverProperty DISPLAY_WARNINGS_FOR_BAD_ELEMENTS_IN_DIRECTORY_LISTINGS = new HCPMoverProperty("gui.dir_listings.display_warnings", "true");
    public static final HCPMoverProperty PAUSE_WAIT_MILLIS = new HCPMoverProperty("job.pause_wait.millis", "5000");
    public static final HCPMoverProperty FONT_FAMILY = new HCPMoverProperty("gui.font_family", "Dialog");
    public static final HCPMoverProperty FONT_SIZE = new HCPMoverProperty("gui.font_size", "12");
    public static final HCPMoverProperty TOOLBAR_VISIBLE = new HCPMoverProperty("gui.toolbar_visible", "false");
    private static Properties modifiedProperties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void persist() {
        try {
            Properties properties = modifiedProperties;
            synchronized (properties) {
                ConfigurationHelper.setUserProperties(modifiedProperties);
                modifiedProperties.clear();
            }
        }
        catch (ConfigurationException e) {
            LOG.log(Level.WARNING, "Error saving user properties: " + e.getMessage(), e);
        }
    }

    public static class HCPMoverProperty {
        private final String key;
        private final String defaultValue;
        private String value;

        private HCPMoverProperty(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public synchronized String get() {
            if (this.value == null) {
                this.value = ConfigurationHelper.getStringProperty(this.key, this.defaultValue);
            }
            return this.value;
        }

        public synchronized URL getAsURL() throws MalformedURLException {
            return UrlUtils.makeURL("", this.get());
        }

        public synchronized int getAsInt() {
            String val = this.get();
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException(this.key + " = " + val);
            }
        }

        public synchronized int getAsInt(int defaultValue) {
            int value = defaultValue;
            try {
                value = Integer.parseInt(this.get());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return value;
        }

        public synchronized long getAsLong() {
            return Long.parseLong(this.get());
        }

        public synchronized long getAsLong(long defaultValue) {
            long value = defaultValue;
            try {
                value = Long.parseLong(this.get());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return value;
        }

        public synchronized boolean getAsBoolean() {
            return Boolean.valueOf(this.get());
        }

        public synchronized HCPMoverConstants.TriState getAsTriState() {
            HCPMoverConstants.TriState retval = HCPMoverConstants.TriState.DEFAULT;
            try {
                retval = HCPMoverConstants.TriState.valueOf(this.get());
            }
            catch (IllegalArgumentException e) {
                LOG.log(Level.WARNING, "Could not parse value for TriState: `" + this.get() + "`", e);
            }
            return retval;
        }

        public synchronized void set(Boolean newValue) {
            HCPMoverConstants.TriState triState = null;
            triState = newValue == null ? HCPMoverConstants.TriState.DEFAULT : (newValue != false ? HCPMoverConstants.TriState.YES : HCPMoverConstants.TriState.NO);
            this.set(triState);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void set(HCPMoverConstants.TriState newValue) {
            if (newValue == null) {
                this.value = this.defaultValue;
                LOG.log(Level.WARNING, "Attempted to set Property " + this.key + " to NULL.  Using defalut value `" + this.defaultValue + "` instead.");
            } else {
                this.value = newValue.toString();
            }
            Properties properties = modifiedProperties;
            synchronized (properties) {
                modifiedProperties.setProperty(this.key, this.value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void set(String newValue) {
            this.value = newValue;
            Properties properties = modifiedProperties;
            synchronized (properties) {
                modifiedProperties.setProperty(this.key, this.value);
            }
        }

        public synchronized void set(int newValue) {
            this.set(Integer.toString(newValue));
        }

        public synchronized void set(boolean newValue) {
            this.set(newValue ? "True" : "False");
        }
    }
}

