/*
 * Decompiled with CFR 0.152.
 */
package com.archivas.clienttools.arcutils.impl;

import com.archivas.clienttools.arcutils.api.JobException;
import com.archivas.clienttools.arcutils.api.JobId;
import com.archivas.clienttools.arcutils.api.JobStats;
import com.archivas.clienttools.arcutils.api.JobStatus;
import com.archivas.clienttools.arcutils.api.jobs.DeleteCustomMetadataJob;
import com.archivas.clienttools.arcutils.api.jobs.DirectoryListingJob;
import com.archivas.clienttools.arcutils.api.jobs.GetCustomMetadataJob;
import com.archivas.clienttools.arcutils.api.jobs.GetCustomMetadataStreamJob;
import com.archivas.clienttools.arcutils.api.jobs.GetMetadataJob;
import com.archivas.clienttools.arcutils.api.jobs.GetSSLCertJob;
import com.archivas.clienttools.arcutils.api.jobs.JobSpec;
import com.archivas.clienttools.arcutils.api.jobs.MkdirJob;
import com.archivas.clienttools.arcutils.api.jobs.RenameJob;
import com.archivas.clienttools.arcutils.api.jobs.SetCustomMetadataJob;
import com.archivas.clienttools.arcutils.api.jobs.VersionListingJob;
import com.archivas.clienttools.arcutils.impl.jobs.DeleteCustomMetadataJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.DirectoryListingJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.GetCustomMetadataJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.GetCustomMetadataStreamJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.GetMetadataJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.GetSSLCertJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.MkdirJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.RenameJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.SetCustomMetadataJobImpl;
import com.archivas.clienttools.arcutils.impl.jobs.VersionListingJobImpl;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

public abstract class JobImpl {
    public static final String PACKAGE_NAME = JobImpl.class.getPackage().getName();
    public static final String CLASS_FULL_NAME = JobImpl.class.getName();
    public static final String CLASS_NAME = CLASS_FULL_NAME.substring(PACKAGE_NAME.length() + 1);
    public static Logger LOG = Logger.getLogger(CLASS_FULL_NAME);
    private JobId jobId;
    private JobSpec jobSpec;
    protected final Object statusLock = new Object();
    private volatile JobStatus status = JobStatus.NOT_STARTED;
    private JobStats stats;
    private String jobName;
    private Date startTime;
    private Date endTime;
    private long estimatedTimeLeftMs = -1L;
    private Throwable jobException = null;
    private LinkedBlockingQueue<JobImpl> statusQueue = new LinkedBlockingQueue();

    protected JobImpl(JobId jobId, JobSpec jobSpec) {
        this.jobId = jobId;
        this.jobSpec = jobSpec;
    }

    public static JobImpl getInstance(JobSpec jobSpec) throws JobException {
        JobImpl jobImpl;
        if (jobSpec == null) {
            throw new IllegalArgumentException("jobSpec cannot be null.");
        }
        JobId jobId = new JobId();
        if (jobSpec instanceof RenameJob) {
            jobImpl = new RenameJobImpl(jobId, jobSpec);
        } else if (jobSpec instanceof MkdirJob) {
            jobImpl = new MkdirJobImpl(jobId, jobSpec);
        } else if (jobSpec instanceof VersionListingJob) {
            jobImpl = new VersionListingJobImpl(jobId, jobSpec);
        } else if (jobSpec instanceof DirectoryListingJob) {
            jobImpl = new DirectoryListingJobImpl(jobId, jobSpec);
        } else if (jobSpec instanceof GetSSLCertJob) {
            jobImpl = new GetSSLCertJobImpl(jobId, jobSpec);
        } else if (jobSpec instanceof GetMetadataJob) {
            jobImpl = new GetMetadataJobImpl(jobId, jobSpec);
        } else if (jobSpec instanceof GetCustomMetadataStreamJob) {
            jobImpl = new GetCustomMetadataStreamJobImpl(jobId, jobSpec);
        } else if (jobSpec instanceof GetCustomMetadataJob) {
            jobImpl = new GetCustomMetadataJobImpl(jobId, jobSpec);
        } else if (jobSpec instanceof SetCustomMetadataJob) {
            jobImpl = new SetCustomMetadataJobImpl(jobId, jobSpec);
        } else if (jobSpec instanceof DeleteCustomMetadataJob) {
            jobImpl = new DeleteCustomMetadataJobImpl(jobId, jobSpec);
        } else {
            String msg = "Could not find JobImpl class for JobSpec of type " + jobSpec.getClass().getName();
            throw new JobException(null, msg);
        }
        return jobImpl;
    }

    public void setStatusQueue(LinkedBlockingQueue<JobImpl> statusQueue) {
        this.statusQueue = statusQueue;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    protected void setJobId(JobId jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String name) {
        this.jobName = name;
    }

    public JobSpec getJobSpec() {
        return this.jobSpec;
    }

    public void setJobSpec(JobSpec jobSpec) {
        this.jobSpec = jobSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobStatus getStatus() {
        Object object = this.statusLock;
        synchronized (object) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(JobStatus status) throws JobException {
        Object object = this.statusLock;
        synchronized (object) {
            this.status = status;
            this.statusQueue.add(this);
        }
    }

    public JobStats getStats() {
        return this.stats;
    }

    protected void setStats(JobStats stats) {
        this.stats = stats;
    }

    public Object getResult() {
        return null;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public long getRunTimeMs() {
        Date startTime = this.getStartTime();
        Date endTime = this.getEndTime();
        long ret = startTime == null ? 0L : (endTime == null ? System.currentTimeMillis() - this.getStartTime().getTime() : endTime.getTime() - this.getStartTime().getTime());
        System.out.println("JobImpl.getRunTimeMs() got startTime = " + startTime + ", end time = " + endTime + ", run time = " + ret);
        return ret;
    }

    public long getEstimatedTimeLeftMs() {
        return this.estimatedTimeLeftMs;
    }

    public void setEstimatedTimeLeftMs(long estimatedTimeLeftMs) {
        this.estimatedTimeLeftMs = estimatedTimeLeftMs;
    }

    public Throwable getJobException() {
        return this.jobException;
    }

    public void setJobException(Throwable jobException) {
        this.jobException = jobException;
    }

    protected void start() throws JobException {
        try {
            this.setStatus(JobStatus.RUNNING);
            this.runJob();
            if (JobStatus.RUNNING.equals((Object)this.getStatus())) {
                this.setStatus(JobStatus.COMPLETED);
            }
        }
        catch (JobException e) {
            this.setStatus(JobStatus.FAILED);
            throw e;
        }
        catch (Exception e) {
            this.setStatus(JobStatus.FAILED);
            throw new JobException(this.getJobId(), (Throwable)e);
        }
    }

    protected void pause() throws JobException {
        String msg = this.getClass().getName() + " doesn't support pause()";
        throw new UnsupportedOperationException(msg);
    }

    protected void resume() throws JobException {
        String msg = this.getClass().getName() + " doesn't support resume()";
        throw new UnsupportedOperationException(msg);
    }

    protected void cancel() throws JobException {
        String msg = this.getClass().getName() + " doesn't support cancel()";
        throw new UnsupportedOperationException(msg);
    }

    protected void stop(boolean abortActiveTransfer) throws JobException {
        String msg = this.getClass().getName() + " doesn't support stop()";
        throw new UnsupportedOperationException(msg);
    }

    protected abstract void runJob() throws JobException;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JobImpl");
        sb.append("{jobId=").append(this.jobId);
        sb.append(", status=").append((Object)this.status);
        sb.append(", jobSpec=").append(this.jobSpec);
        sb.append('}');
        return sb.toString();
    }

    public boolean validateJob() throws JobException {
        return true;
    }
}

